/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.Draw;
import base.BasePlayer.Launcher;
import base.BasePlayer.Main;
import base.BasePlayer.ProxySettings;
import base.BasePlayer.SteppedComboBox;
import base.BasePlayer.VariantHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Settings
extends JPanel
implements ActionListener,
ChangeListener,
MouseListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static JSlider insertSizeSlider = new JSlider(0, 10000);
    private static JLabel insertLabel = new JLabel("Maximum insert size: 1000");
    private static JLabel readLabel = new JLabel("Read options");
    private static Dimension mindimension = new Dimension(200, 15);
    private static JLabel depthLimitLabel;
    private static JLabel coverageDistanceLabel;
    private static JSlider depthLimitSlide;
    private static JSlider rSlider;
    private static JSlider gSlider;
    private static JSlider bSlider;
    static JSlider graySlider;
    static JSlider alphaSlider;
    static SteppedComboBox fontlist;
    static SteppedComboBox varDrawList;
    static SteppedComboBox wallPaperList;
    static DefaultComboBoxModel<String> fontModel;
    static DefaultComboBoxModel<String> varModel;
    static DefaultComboBoxModel<String> wallpapers;
    static HashMap<String, Image> imageHash;
    private static JSlider mappingQuality;
    private static JSlider baseQuality;
    private static JLabel mappingLabel;
    private static JLabel baseLabel;
    private static JLabel reloadReads;
    static Image wallpaper;
    private static JLabel rLabel;
    private static JLabel gLabel;
    private static JLabel bLabel;
    private static JLabel backLabel;
    static JFrame frame;
    private static JCheckBox softclips;
    private static JPanel readPanel;
    private static JPanel varPanel;
    private static JPanel generalPanel;
    private static JPanel appearancePanel;
    private static JTabbedPane tabPanel;
    private static JButton colorButton;
    static HashMap<String, Integer> settings;
    private static JLabel windowLabel;
    private static JLabel bigFileLabel;
    private static JTextField coverageDistanceField;
    private static JTextField bigFileField;
    private static JTextField windowField;
    static int readDrawDistance;
    static int coverageDrawDistance;
    static int coverageAlleleFreq;
    static int windowSize;
    static int readDepthLimit;
    static int softClips;
    static int mappingQ;
    static int insertSize;
    static int baseQ;
    static Color frameColor;
    String userDir;
    static JCheckBox bold;
    static JColorChooser colorchooser;
    static boolean constr;
    static int selectedVarDraw;

    static {
        coverageDistanceLabel = new JLabel("Coverage draw distance (bp):");
        depthLimitSlide = new JSlider(1, 10000);
        rSlider = new JSlider(60, 255);
        gSlider = new JSlider(60, 255);
        bSlider = new JSlider(60, 255);
        graySlider = new JSlider(0, 255);
        alphaSlider = new JSlider(0, 255);
        imageHash = new HashMap();
        mappingQuality = new JSlider(0, 60);
        baseQuality = new JSlider(0, 60);
        mappingLabel = new JLabel("Mapping quality: 10");
        baseLabel = new JLabel("Base quality: 10");
        reloadReads = new JLabel("Click here to reload reads");
        wallpaper = null;
        rLabel = new JLabel("Red: ");
        gLabel = new JLabel("Green: ");
        bLabel = new JLabel("Blue: ");
        backLabel = new JLabel("Gray: ");
        frame = new JFrame("Settings");
        softclips = new JCheckBox("Show bases in softclips");
        readPanel = new JPanel(new GridBagLayout());
        varPanel = new JPanel(new GridBagLayout());
        generalPanel = new JPanel(new GridBagLayout());
        appearancePanel = new JPanel(new GridBagLayout());
        tabPanel = new JTabbedPane(2);
        colorButton = new JButton("Select color");
        windowLabel = new JLabel("Processing window size (bp):");
        bigFileLabel = new JLabel("Big file size for tracks (MB):");
        coverageDistanceField = new JTextField("");
        bigFileField = new JTextField("");
        windowField = new JTextField("");
        frameColor = new Color(188, 188, 178);
        bold = new JCheckBox("Bold");
        colorchooser = new JColorChooser();
        constr = true;
        selectedVarDraw = 0;
    }

    public Settings() {
        super(new GridBagLayout());
        try {
            this.setBackground(Color.black);
            windowLabel.setToolTipText("Window size for processing large vcf and bed files.");
            bigFileLabel.setToolTipText("Maximum file size for chromosomal level drawing.");
            depthLimitLabel = new JLabel("");
            String[] sizes = new String[]{"8", "10", "12", "14", "16", "18", "20", "22", "24"};
            fontModel = new DefaultComboBoxModel<String>(sizes);
            fontlist = new SteppedComboBox((ComboBoxModel<String>)fontModel);
            fontlist.addActionListener(this);
            fontlist.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
            fontlist.setBackground(Color.white);
            fontlist.setEditable(true);
            fontlist.setSelectedItem("" + Main.defaultFontSize);
            constr = false;
            String[] varTypes = new String[]{"Coverage", "Allelic fraction", "Quality", "GQ", "Calls"};
            this.userDir = Main.userDir;
            if (this.userDir == null) {
                this.userDir = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent().replace("%20", " ");
            }
            try {
                File[] wallpaperfiles = new File(String.valueOf(this.userDir) + "/additions/background/").listFiles();
                ArrayList<String> images = new ArrayList<String>();
                images.add("None");
                int i = 0;
                while (i < wallpaperfiles.length) {
                    try {
                        String mimetype = new MimetypesFileTypeMap().getContentType(wallpaperfiles[i]);
                        String type = mimetype.split("/")[0];
                        if (type.equals("image")) {
                            images.add(wallpaperfiles[i].getName());
                            imageHash.put(wallpaperfiles[i].getName(), ImageIO.read(wallpaperfiles[i]));
                        }
                    }
                    catch (Exception mimetype) {
                        // empty catch block
                    }
                    ++i;
                }
                String[] imagearray = new String[images.size()];
                int i2 = 0;
                while (i2 < imagearray.length) {
                    imagearray[i2] = (String)images.get(i2);
                    ++i2;
                }
                wallpapers = new DefaultComboBoxModel<String>(imagearray);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (wallpapers != null) {
                wallPaperList = new SteppedComboBox((ComboBoxModel<String>)wallpapers);
                wallPaperList.addActionListener(this);
            }
            varModel = new DefaultComboBoxModel<String>(varTypes);
            varDrawList = new SteppedComboBox((ComboBoxModel<String>)varModel);
            varDrawList.addActionListener(this);
            varDrawList.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
            reloadReads.setForeground(Color.red);
            reloadReads.setVisible(false);
            reloadReads.setMinimumSize(mindimension);
            reloadReads.addMouseListener(this);
            insertSizeSlider.setMinimumSize(mindimension);
            readPanel.add(insertSizeSlider);
            insertSizeSlider.setOpaque(false);
            mappingQuality.setMinimumSize(mindimension);
            mappingQuality.setOpaque(false);
            baseQuality.setOpaque(false);
            baseQuality.setMinimumSize(mindimension);
            insertSizeSlider.addChangeListener(this);
            mappingQuality.addChangeListener(this);
            baseQuality.addChangeListener(this);
            depthLimitSlide.addChangeListener(this);
            depthLimitSlide.setOpaque(false);
            softclips.addActionListener(this);
            softclips.setOpaque(false);
            alphaSlider.addChangeListener(this);
            alphaSlider.addMouseListener(this);
            depthLimitLabel.setMinimumSize(mindimension);
            graySlider.addChangeListener(this);
            graySlider.addMouseListener(this);
            rSlider.addChangeListener(this);
            gSlider.addChangeListener(this);
            bSlider.addChangeListener(this);
            Settings.setValues();
            if (Launcher.alphaValue > 0) {
                alphaSlider.setValue(Launcher.alphaValue);
            }
            if (Launcher.wallpaperIndex > 0 && Launcher.wallpaperIndex < wallPaperList.getItemCount()) {
                wallPaperList.setSelectedIndex(Launcher.wallpaperIndex);
            }
            graySlider.setOpaque(false);
            rSlider.setOpaque(false);
            gSlider.setOpaque(false);
            bSlider.setOpaque(false);
            colorButton.setPreferredSize(new Dimension(Main.buttonWidth, Main.buttonHeight));
            colorButton.addActionListener(this);
            coverageDistanceField.addKeyListener(this);
            bigFileField.addKeyListener(this);
            windowField.addKeyListener(this);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 18;
            c.insets = new Insets(2, 0, 0, 30);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            readLabel.setName("header");
            readPanel.add((Component)readLabel, c);
            c.gridx = 1;
            readPanel.add((Component)reloadReads, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            readPanel.add((Component)new JSeparator(), c);
            ++c.gridy;
            c.gridwidth = 1;
            readPanel.add((Component)insertSizeSlider, c);
            c.gridx = 1;
            readPanel.add((Component)insertLabel, c);
            ++c.gridy;
            c.gridx = 0;
            readPanel.add((Component)mappingQuality, c);
            c.gridx = 1;
            readPanel.add((Component)mappingLabel, c);
            c.gridx = 0;
            ++c.gridy;
            readPanel.add((Component)baseQuality, c);
            c.gridx = 1;
            readPanel.add((Component)baseLabel, c);
            c.gridx = 0;
            ++c.gridy;
            readPanel.add((Component)depthLimitSlide, c);
            c.gridx = 1;
            readPanel.add((Component)depthLimitLabel, c);
            c.gridx = 0;
            ++c.gridy;
            readPanel.add((Component)softclips, c);
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            readPanel.add((Component)new JLabel(), c);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 3;
            JLabel appearLabel = new JLabel("Appearance");
            appearLabel.setName("header");
            appearancePanel.add((Component)appearLabel, c);
            ++c.gridy;
            appearancePanel.add((Component)new JSeparator(), c);
            ++c.gridy;
            c.gridwidth = 1;
            appearancePanel.add((Component)new JLabel("Font size: "), c);
            c.gridx = 1;
            bold.setOpaque(false);
            bold.addActionListener(this);
            appearancePanel.add((Component)bold, c);
            c.gridx = 2;
            appearancePanel.add((Component)fontlist, c);
            c.gridwidth = 3;
            c.gridx = 0;
            ++c.gridy;
            appearancePanel.add((Component)new JSeparator(), c);
            ++c.gridy;
            JLabel backlabel = new JLabel("Background color");
            JLabel sidelabel = new JLabel("Sidebar color");
            c.gridwidth = 1;
            backlabel.setName("header");
            sidelabel.setName("header");
            appearancePanel.add((Component)backlabel, c);
            ++c.gridy;
            appearancePanel.add((Component)graySlider, c);
            c.gridx = 2;
            appearancePanel.add((Component)backLabel, c);
            c.gridx = 0;
            ++c.gridy;
            appearancePanel.add((Component)sidelabel, c);
            ++c.gridy;
            appearancePanel.add((Component)rSlider, c);
            c.gridx = 2;
            appearancePanel.add((Component)rLabel, c);
            ++c.gridy;
            c.gridx = 0;
            appearancePanel.add((Component)gSlider, c);
            c.gridx = 2;
            appearancePanel.add((Component)gLabel, c);
            ++c.gridy;
            c.gridx = 0;
            appearancePanel.add((Component)bSlider, c);
            c.gridx = 2;
            appearancePanel.add((Component)bLabel, c);
            c.gridx = 0;
            ++c.gridy;
            appearancePanel.add((Component)wallPaperList, c);
            ++c.gridy;
            appearancePanel.add((Component)alphaSlider, c);
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            appearancePanel.add((Component)new JLabel(""), c);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            JLabel generalLabel = new JLabel("General options");
            generalLabel.setName("header");
            generalPanel.add((Component)generalLabel, c);
            ++c.gridy;
            c.gridwidth = 2;
            generalPanel.add((Component)new JSeparator(), c);
            c.gridwidth = 1;
            c.fill = 2;
            ++c.gridy;
            c.gridx = 0;
            generalPanel.add((Component)coverageDistanceLabel, c);
            c.gridx = 1;
            generalPanel.add((Component)coverageDistanceField, c);
            ++c.gridy;
            c.gridx = 0;
            generalPanel.add((Component)windowLabel, c);
            c.gridx = 1;
            generalPanel.add((Component)windowField, c);
            c.gridx = 0;
            ++c.gridy;
            generalPanel.add((Component)bigFileLabel, c);
            c.gridx = 1;
            generalPanel.add((Component)bigFileField, c);
            c.gridx = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            generalPanel.add((Component)new JLabel(), c);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            JLabel varLabel = new JLabel("Variant options");
            varLabel.setName("header");
            varPanel.add((Component)varLabel, c);
            ++c.gridy;
            c.gridwidth = 2;
            varPanel.add((Component)new JSeparator(), c);
            c.gridwidth = 1;
            varPanel.add((Component)new JLabel("Variant height by: "), c);
            c.gridx = 1;
            varDrawList.setBackground(Color.white);
            varPanel.add((Component)varDrawList, c);
            c.gridx = 0;
            c.weightx = 1.0;
            ++c.gridy;
            c.weighty = 1.0;
            c.gridwidth = 0;
            varPanel.add((Component)new JLabel(), c);
            tabPanel.add("General", generalPanel);
            tabPanel.add("Variants", varPanel);
            tabPanel.add("Reads", readPanel);
            tabPanel.add("Appearance", appearancePanel);
            if (Main.proxysettings == null) {
                tabPanel.add("Proxy", new ProxySettings());
            } else {
                tabPanel.add("Proxy", Main.proxysettings);
            }
            this.add(tabPanel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Settings.setFonts(Main.menuFont);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(frameColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    static void setFonts(Font menuFont) {
        JPanel panel = null;
        tabPanel.setFont(menuFont);
        if (Main.drawCanvas == null) {
            return;
        }
        int i = 0;
        while (i < tabPanel.getComponentCount()) {
            if (tabPanel.getComponent(i) instanceof JPanel) {
                panel = (JPanel)tabPanel.getComponent(i);
                int c = 0;
                while (c < panel.getComponentCount()) {
                    if (panel.getComponent(c).getName() != null) {
                        panel.getComponent(c).setFont(Main.menuFontBold.deriveFont((float)(Main.defaultFontSize + 2)));
                    } else {
                        panel.getComponent(c).setFont(menuFont);
                    }
                    ++c;
                }
            }
            ++i;
        }
        frame.pack();
        panel = null;
    }

    static void setValues() {
        if (settings == null) {
            settings = new HashMap();
            settings.put("readDrawDistance", 60000);
            settings.put("baseQ", 10);
            settings.put("readDepthLimit", 1000);
            settings.put("coverageDrawDistance", 1000000);
            settings.put("coverageAlleleFreq", 1);
            settings.put("windowSize", 1000000);
            settings.put("bigFile", 200);
            settings.put("rValue", 228);
            settings.put("gValue", 228);
            settings.put("bValue", 218);
            settings.put("alphaValue", 0);
            settings.put("insertSize", 1000);
            settings.put("mappingQuality", 10);
            settings.put("softClips", 0);
            settings.put("wallpaper", 0);
        }
        baseQ = settings.get("baseQ");
        readDrawDistance = settings.get("readDrawDistance");
        coverageDrawDistance = settings.get("coverageDrawDistance");
        coverageAlleleFreq = settings.get("coverageAlleleFreq");
        coverageDistanceField.setText("" + settings.get("coverageDrawDistance"));
        bigFileField.setText("" + settings.get("bigFile"));
        depthLimitLabel.setText("Read depth limit: " + settings.get("readDepthLimit"));
        windowField.setText("" + settings.get("windowSize"));
        baseQuality.setValue(settings.get("baseQ"));
        if (settings.get("rValue") == null) {
            settings.put("rValue", 228);
            settings.put("gValue", 228);
            settings.put("bValue", 218);
        }
        rSlider.setValue(settings.get("rValue"));
        gSlider.setValue(settings.get("gValue"));
        bSlider.setValue(settings.get("bValue"));
        rLabel.setText("Red: " + rSlider.getValue());
        gLabel.setText("Green: " + gSlider.getValue());
        bLabel.setText("Blue: " + bSlider.getValue());
        insertSizeSlider.setValue(settings.get("insertSize"));
        mappingQuality.setValue(settings.get("mappingQuality"));
        mappingQ = settings.get("mappingQuality");
        depthLimitSlide.setValue(settings.get("readDepthLimit"));
        insertLabel.setText("Maximum insert size: " + settings.get("insertSize"));
        windowSize = settings.get("windowSize");
        readDepthLimit = settings.get("readDepthLimit");
        softClips = settings.get("softClips");
        if (softClips == 1) {
            softclips.setSelected(true);
        }
        reloadReads.setVisible(false);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(false);
        if (Main.userDir == null) {
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        } else {
            frame.setDefaultCloseOperation(1);
            frame.setVisible(false);
        }
        JFrame.setDefaultLookAndFeelDecorated(false);
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        Settings newContentPane = new Settings();
        newContentPane.setOpaque(false);
        frame.setContentPane(newContentPane);
        frame.pack();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Settings.createAndShowGUI();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == bold) {
            Main.setFonts();
        } else if (event.getSource() == softclips) {
            if (softclips.isSelected()) {
                softClips = 1;
                settings.put("softClips", 1);
            } else {
                softClips = 0;
                settings.put("softClips", 0);
            }
            reloadReads.setVisible(true);
            return;
        }
        if (event.getSource() == fontlist && !constr) {
            if (event.getActionCommand().equals("comboBoxEdited")) {
                try {
                    Main.defaultFontSize = Integer.parseInt(fontlist.getSelectedItem().toString().trim());
                    Main.setFonts();
                    Main.writeToConfig("fontSize=" + Main.defaultFontSize);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (event.getActionCommand().equals("comboBoxChanged")) {
                Main.defaultFontSize = Integer.parseInt(fontlist.getSelectedItem().toString());
                if (Main.drawCanvas != null) {
                    Main.setFonts();
                }
                Main.writeToConfig("fontSize=" + Main.defaultFontSize);
            }
            return;
        }
        if (event.getSource() == varDrawList) {
            if (event.getActionCommand().equals("comboBoxChanged")) {
                selectedVarDraw = varDrawList.getSelectedIndex();
                switch (selectedVarDraw) {
                    case 0: {
                        VariantHandler.maxSlideValue = VariantHandler.maxCoverageSlider.getValue();
                        break;
                    }
                    case 1: {
                        VariantHandler.maxSlideValue = (float)VariantHandler.callSlider.getUpperValue() / 100.0f;
                        break;
                    }
                    case 4: {
                        VariantHandler.maxSlideValue = VariantHandler.maxCoverageSlider.getValue();
                    }
                }
                Main.chromosomeDropdown.setSelectedIndex(Main.selectedChrom);
            }
            return;
        }
        if (event.getSource() == wallPaperList && event.getActionCommand().equals("comboBoxChanged")) {
            int selectedIndex = wallPaperList.getSelectedIndex();
            if (selectedIndex == 0) {
                wallpaper = null;
                Draw.backColor = new Color(graySlider.getValue(), graySlider.getValue(), graySlider.getValue());
                if (settings != null) {
                    settings.put("wallpaper", 0);
                }
                Main.writeToConfig("wallpaper=0");
            } else {
                wallpaper = imageHash.get(((String)wallPaperList.getItemAt(selectedIndex)).toString());
                if (settings != null) {
                    settings.put("wallpaper", selectedIndex);
                }
                Draw.backColor = new Color(graySlider.getValue(), graySlider.getValue(), graySlider.getValue(), alphaSlider.getValue());
                Main.writeToConfig("wallpaper=" + selectedIndex);
            }
            if (Main.drawCanvas != null) {
                Main.drawCanvas.repaint();
                Main.chromDraw.repaint();
                Main.bedCanvas.repaint();
                Main.controlDraw.repaint();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == insertSizeSlider) {
            insertLabel.setText("Maximum insert size: " + insertSizeSlider.getValue());
            insertSize = insertSizeSlider.getValue();
            settings.put("insertSize", insertSizeSlider.getValue());
            reloadReads.setVisible(true);
            return;
        }
        if (event.getSource() == graySlider) {
            Draw.backColor = wallpaper == null ? new Color(graySlider.getValue(), graySlider.getValue(), graySlider.getValue()) : new Color(graySlider.getValue(), graySlider.getValue(), graySlider.getValue(), alphaSlider.getValue());
            if (settings != null) {
                settings.put("backValue", graySlider.getValue());
            }
            backLabel.setText("Gray: " + graySlider.getValue());
            if (Main.drawCanvas != null) {
                Main.drawCanvas.repaint();
                Main.chromDraw.repaint();
                Main.bedCanvas.repaint();
                Main.controlDraw.repaint();
            }
        } else if (event.getSource() == alphaSlider) {
            if (wallpaper != null) {
                Draw.backColor = new Color(graySlider.getValue(), graySlider.getValue(), graySlider.getValue(), alphaSlider.getValue());
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.repaint();
                    Main.chromDraw.repaint();
                    Main.bedCanvas.repaint();
                    Main.controlDraw.repaint();
                }
            }
            if (settings != null) {
                settings.put("alphaValue", alphaSlider.getValue());
            }
        } else if (event.getSource() == rSlider || event.getSource() == gSlider || event.getSource() == bSlider) {
            rLabel.setText("Red: " + rSlider.getValue());
            gLabel.setText("Green: " + gSlider.getValue());
            bLabel.setText("Blue: " + bSlider.getValue());
            Draw.sidecolor = new Color(rSlider.getValue(), gSlider.getValue(), bSlider.getValue());
            if (VariantHandler.frame != null) {
                VariantHandler.backColor = new Color(rSlider.getValue(), gSlider.getValue(), bSlider.getValue());
                VariantHandler.adder.setForeground(Draw.sidecolor);
                VariantHandler.adder2.setForeground(Draw.sidecolor);
                VariantHandler.adder3.setForeground(Draw.sidecolor);
                VariantHandler.adder4.setForeground(Draw.sidecolor);
            }
            if (event.getSource() == rSlider) {
                settings.put("rValue", rSlider.getValue());
            } else if (event.getSource() == gSlider) {
                settings.put("gValue", gSlider.getValue());
            } else {
                settings.put("bValue", bSlider.getValue());
            }
            appearancePanel.setBackground(Draw.sidecolor);
            if (Main.drawCanvas != null) {
                Main.drawCanvas.repaint();
                Main.chromDraw.repaint();
                Main.bedCanvas.repaint();
                Main.panel.setBackground(new Color(Draw.sidecolor.getRed() - 40, Draw.sidecolor.getGreen() - 40, Draw.sidecolor.getBlue() - 40));
                Main.chrompan.setBackground(Draw.sidecolor);
                Main.setbut.setBackground(Main.panel.getBackground());
                Main.panel.revalidate();
                if (VariantHandler.frame != null) {
                    VariantHandler.frame.getContentPane().setBackground(new Color(Draw.sidecolor.getRed() - 40, Draw.sidecolor.getGreen() - 40, Draw.sidecolor.getBlue() - 40));
                    VariantHandler.filterpanel.setBackground(VariantHandler.backColor);
                    VariantHandler.filterpanel.revalidate();
                    VariantHandler.aminopanel.setBackground(VariantHandler.backColor);
                    VariantHandler.aminopanel.revalidate();
                    VariantHandler.comparepanel.setBackground(VariantHandler.backColor);
                    VariantHandler.comparepanel.revalidate();
                    VariantHandler.tabs.setBackground(VariantHandler.backColor);
                    VariantHandler.tabs.revalidate();
                }
            }
        }
        if (event.getSource() == mappingQuality) {
            mappingLabel.setText("Mapping quality: " + mappingQuality.getValue());
            mappingQ = mappingQuality.getValue();
            settings.put("mappingQuality", mappingQuality.getValue());
            Draw.updateReads = true;
            if (Main.drawCanvas != null) {
                Main.drawCanvas.repaint();
            }
            return;
        }
        if (event.getSource() == baseQuality) {
            settings.put("baseQ", baseQuality.getValue());
            baseLabel.setText("Base quality: " + baseQuality.getValue());
            baseQ = baseQuality.getValue();
            Draw.updateReads = true;
            if (Main.drawCanvas != null) {
                Main.drawCanvas.repaint();
            }
            return;
        }
        if (event.getSource() == depthLimitSlide) {
            settings.put("readDepthLimit", depthLimitSlide.getValue());
            readDepthLimit = depthLimitSlide.getValue();
            depthLimitLabel.setText("Read depth limit: " + depthLimitSlide.getValue());
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (event.getSource() == reloadReads && this.getCursor().getType() != 12) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (event.getSource() == reloadReads && this.getCursor().getType() != 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.getSource() == reloadReads) {
            Main.drawCanvas.clearReads();
            int i = 0;
            while (i < Main.drawCanvas.splits.size()) {
                Main.drawCanvas.splits.get((int)i).updateReads = true;
                Main.drawCanvas.drawReads(Main.drawCanvas.splits.get(i));
                ++i;
            }
            Main.drawCanvas.repaint();
            reloadReads.setForeground(Color.black);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.getSource() == reloadReads) {
            reloadReads.setVisible(false);
            reloadReads.setForeground(Color.red);
        } else if (event.getSource() == graySlider) {
            Main.writeToConfig("backColor=" + graySlider.getValue());
        } else if (event.getSource() == alphaSlider) {
            Main.writeToConfig("alphaValue=" + alphaSlider.getValue());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == coverageDistanceField) {
            try {
                settings.put("coverageDrawDistance", Integer.parseInt(coverageDistanceField.getText()));
                coverageDrawDistance = Integer.parseInt(coverageDistanceField.getText());
            }
            catch (Exception ex) {
                settings.put("coverageDrawDistance", Integer.MAX_VALUE);
                coverageDrawDistance = Integer.MAX_VALUE;
            }
        } else if (e.getSource() == windowField) {
            try {
                settings.put("windowSize", Integer.parseInt(windowField.getText()));
                windowSize = Integer.parseInt(windowField.getText());
            }
            catch (Exception ex) {
                settings.put("windowSize", Integer.MAX_VALUE);
                windowSize = Integer.MAX_VALUE;
            }
        } else if (e.getSource() == bigFileField) {
            try {
                settings.put("bigFile", Integer.parseInt(bigFileField.getText()));
                int i = 0;
                while (i < Main.bedCanvas.bedTrack.size()) {
                    Main.bedCanvas.bedTrack.get((int)i).small = Main.bedCanvas.bedTrack.get((int)i).file.length() / 0x100000L < (long)settings.get("bigFile").intValue();
                    ++i;
                }
            }
            catch (Exception ex) {
                settings.put("bigFile", 200);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

