/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class MultisampleFilter {
    static Hashtable<String, Long[]> chromIndex = new Hashtable();
    private static byte[] seqresult;
    private static StringBuffer seqBuffer;
    private static RandomAccessFile chromo;
    private static String resString;
    private static long headerLen;
    private static RandomAccessFile infile;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Give bam file/directory and reference file");
            System.out.println("Example: zcat samples/sample.vcf.gz | java -jar MultisampleFilter.jar bamfile/directory ref/hs37d5.fa > results/sample.vcf");
        } else {
            String bamdir = args[0];
            String reffile = args[1];
            MultisampleFilter.setChromDrop(reffile);
            MultisampleFilter.somaticOrNot(bamdir);
        }
    }

    public static void somaticOrNot(String bamDir) {
        try {
            String line;
            List<File> bamList = Collections.synchronizedList(new ArrayList());
            File bam = new File(bamDir);
            File[] bams = null;
            bams = bam.isDirectory() ? bam.listFiles() : new File[]{bam};
            File[] fileArray = bams;
            int n = bams.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getAbsolutePath().endsWith(".bam")) {
                    bamList.add(file);
                }
                ++n2;
            }
            String chrom = "";
            String base = "";
            String[] split = null;
            int pos = 0;
            int bloodCount = 0;
            boolean infoFound = false;
            boolean setheader = true;
            ArrayList<String> headerList = new ArrayList<String>();
            InputStreamReader isReader = new InputStreamReader(System.in);
            BufferedReader bufReader = new BufferedReader(isReader);
            while ((line = bufReader.readLine()) != null) {
                if (line.startsWith("#")) {
                    if (line.startsWith("##INFO")) {
                        infoFound = true;
                    }
                    if (line.contains("flanks")) {
                        String[] blood = line.split("\\s+");
                        bloodCount = Integer.parseInt(blood[blood.length - 3]);
                    }
                    headerList.add(line.trim());
                    continue;
                }
                if (headerList.size() > 0) {
                    int i = 0;
                    while (i < headerList.size()) {
                        if (infoFound && ((String)headerList.get(i)).startsWith("##INFO") && setheader) {
                            System.out.println("##INFO=<ID=FILTER,Number=.,Type=String,Description=\"20bp flanks around variation and variant reads/coverage in " + (bamList.size() + bloodCount) + " blood samples\">");
                            setheader = false;
                            infoFound = true;
                        }
                        if (!infoFound) {
                            if (headerList.size() == 1) {
                                System.out.println("##INFO=<ID=FILTER,Number=.,Type=String,Description=\"20bp flanks around variation and variant reads/coverage in " + (bamList.size() + bloodCount) + " blood samples\">");
                                infoFound = true;
                            } else if (i == 1) {
                                System.out.println("##INFO=<ID=FILTER,Number=.,Type=String,Description=\"20bp flanks around variation and variant reads/coverage in " + (bamList.size() + bloodCount) + " blood samples\">");
                                infoFound = true;
                            }
                        }
                        System.out.println((String)headerList.get(i));
                        ++i;
                    }
                    headerList.clear();
                }
                if (!(split = line.split("\\t"))[0].equals(chrom)) {
                    chrom = split[0];
                    headerLen = chromIndex.get(chrom)[0];
                }
                pos = Integer.parseInt(split[1]);
                if (split[3].length() > 1) {
                    base = "DEL" + (split[3].length() - 1);
                    pos = Integer.parseInt(split[1]) + 1;
                } else if (split[4].length() > 1) {
                    base = "INS" + (split[4].length() - 1);
                    pos = Integer.parseInt(split[1]) + 1;
                } else {
                    base = split[4];
                }
                if (split[7].contains("FILTER=")) {
                    String filterfield = "";
                    String infofield = "";
                    String[] infoSplit = split[7].split(";");
                    int i = 0;
                    while (i < infoSplit.length) {
                        if (infoSplit[i].startsWith("FILTER=")) {
                            filterfield = infoSplit[i];
                        } else {
                            infofield = String.valueOf(infofield) + infoSplit[i] + ";";
                        }
                        ++i;
                    }
                    System.out.print(String.valueOf(split[0]) + "\t" + split[1] + "\t" + split[2] + "\t" + split[3] + "\t" + split[4] + "\t" + split[5] + "\t" + split[6] + "\t" + infofield + filterfield);
                } else {
                    String seq = MultisampleFilter.getSeq(pos - 10, pos + 11, infile);
                    String error = "";
                    String foxog = "";
                    if (seq.substring(9, 12).equals("CTC") && base.equals("C") || seq.substring(9, 12).equals("GAG") && base.equals("G")) {
                        error = "errorCCC";
                    }
                    if (seq.substring(9, 12).equals("CCG") && base.equals("A") || seq.substring(9, 12).equals("CGG") && base.equals("T")) {
                        foxog = "FOXOG";
                    }
                    String errors = "";
                    if (error.length() > 0) {
                        errors = ";errorCCC";
                    } else if (foxog.length() > 0) {
                        errors = ";FOXOG";
                    }
                    seq = String.valueOf(seq.substring(0, 10).toLowerCase()) + seq.substring(10, 11) + seq.substring(11, 21).toLowerCase();
                    System.out.print(String.valueOf(split[0]) + "\t" + split[1] + "\t" + split[2] + "\t" + split[3] + "\t" + split[4] + "\t" + split[5] + "\t" + split[6] + "\t" + split[7] + errors + ";FILTER=" + seq);
                }
                int i = 0;
                while (i < bamList.size()) {
                    String result = MultisampleFilter.checkReads(chrom, pos, base, (File)bamList.get(i));
                    System.out.print("," + result);
                    ++i;
                }
                i = 8;
                while (i < split.length) {
                    System.out.print("\t" + split[i]);
                    ++i;
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String checkReads(String chromString, int pos, String variation, File bamfile) {
        int refcount;
        int altcount;
        block24: {
            CigarElement cigar = null;
            SAMRecord samRecord = null;
            try {
                String chrom = chromString;
                SamReader inputSam = SamReaderFactory.make().open(bamfile);
                samRecord = new SAMRecord(inputSam.getFileHeader());
                int start = pos - 200;
                int end = pos + 200;
                SAMRecordIterator ite = inputSam.queryOverlapping(chrom, start, end);
                int poscount = 0;
                int readPos = 0;
                int position = 0;
                String base = variation;
                altcount = 0;
                refcount = 0;
                while (ite.hasNext() && ite != null) {
                    samRecord = (SAMRecord)ite.next();
                    if (samRecord.getUnclippedEnd() < pos) continue;
                    if (samRecord.getUnclippedStart() > pos) break;
                    position = 0;
                    poscount = 0;
                    if (samRecord.getCigar().numCigarElements() > 1) {
                        if (base.length() > 1) {
                            if (samRecord.getCigarString().contains("I") || samRecord.getCigarString().contains("D")) {
                                ++altcount;
                            } else {
                                ++refcount;
                            }
                        } else {
                            cigar = null;
                            int k = 0;
                            while (k < samRecord.getCigar().numCigarElements()) {
                                cigar = samRecord.getCigar().getCigarElement(k);
                                if (samRecord.getUnclippedStart() + position <= pos) {
                                    if (cigar.getOperator().compareTo(CigarOperator.MATCH_OR_MISMATCH) == 0) {
                                        position += cigar.getLength();
                                    } else if (cigar.getOperator().compareTo(CigarOperator.DELETION) == 0) {
                                        position += cigar.getLength();
                                        poscount -= cigar.getLength();
                                    } else if (cigar.getOperator().compareTo(CigarOperator.INSERTION) == 0) {
                                        poscount += cigar.getLength();
                                    } else if (cigar.getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                                        position += cigar.getLength() + 1;
                                    }
                                    ++k;
                                    continue;
                                }
                                break;
                            }
                        }
                    } else if (base.length() > 1) {
                        ++refcount;
                    }
                    if (base.length() != 1) continue;
                    readPos = pos - samRecord.getUnclippedStart() + poscount;
                    try {
                        base = Character.toString(samRecord.getReadString().charAt(readPos));
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (base.equals(variation)) {
                        ++altcount;
                        continue;
                    }
                    ++refcount;
                }
                inputSam.close();
                if (refcount != 0 || altcount != 0) break block24;
                return "0/0";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        return String.valueOf(altcount) + "/" + (altcount + refcount);
    }

    public static void heterogeneity(File multivcf) {
        try {
            String line;
            List<File> bamList = Collections.synchronizedList(new ArrayList());
            String[] locus = new String[]{};
            String samples = "";
            File[] addDir = multivcf.getParentFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".bam");
                }
            });
            String outfile = String.valueOf(multivcf.getCanonicalPath().replace(".vcf.gz", "")) + ".tsv";
            BufferedWriter writer = new BufferedWriter(new FileWriter(outfile));
            String chrom = "";
            String base = "";
            String basetemp = "";
            StringBuffer header = new StringBuffer("");
            StringBuffer row = new StringBuffer("");
            String[] split = null;
            boolean postemp = false;
            int pos = 0;
            boolean samplecount = false;
            boolean windowLength = false;
            boolean chromcounter = false;
            GZIPInputStream gzip = null;
            BufferedReader reader = null;
            try {
                gzip = new GZIPInputStream(new FileInputStream(multivcf));
                reader = new BufferedReader(new InputStreamReader(gzip));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean setheader = true;
            while ((line = reader.readLine()) != null) {
                int i;
                if (setheader) {
                    if (line.startsWith("##")) continue;
                    if (line.startsWith("#CHROM")) {
                        split = line.split("\t");
                        header.append(String.valueOf(split[0]) + "\t" + split[1] + "\t" + split[2] + "\t" + split[3] + "\t" + split[4] + "\t" + split[5]);
                        i = 0;
                        while (i < split.length - 9) {
                            header.append("\t" + split[9 + i]);
                            File[] fileArray = addDir;
                            int n = addDir.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File file = fileArray[n2];
                                if (split[9 + i].contains(file.getName().subSequence(0, file.getName().indexOf(".")))) {
                                    bamList.add(file);
                                }
                                ++n2;
                            }
                            ++i;
                        }
                        writer.write(String.valueOf(header.toString()) + "\n");
                        setheader = false;
                        continue;
                    }
                }
                split = line.split("\t");
                pos = Integer.parseInt(split[1]);
                chrom = split[0];
                if (split[3].length() > 1) {
                    base = "DEL" + (split[3].length() - 1);
                    pos = Integer.parseInt(split[1]) + 1;
                } else if (split[4].length() > 1) {
                    base = "INS" + (split[4].length() - 1);
                    pos = Integer.parseInt(split[1]) + 1;
                } else {
                    base = split[4];
                }
                row = new StringBuffer(String.valueOf(split[0]) + "\t" + split[1] + "\t" + split[2] + "\t" + split[3] + "\t" + split[4] + "\t" + split[5]);
                i = 0;
                while (i < split.length - 9) {
                    if (split[9 + i].equals("0/0")) {
                        String result = MultisampleFilter.checkReads(chrom, pos, base, (File)bamList.get(i));
                        row.append("\t" + result);
                    } else {
                        row.append("\t" + split[9 + i].split(":")[2]);
                    }
                    ++i;
                }
                writer.write(String.valueOf(row.toString()) + "\n");
                System.out.println(row.toString());
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void setChromDrop(String dir) {
        try {
            String line;
            File chromindex = null;
            infile = new RandomAccessFile(new File(dir), "r");
            List chromnamevector = Collections.synchronizedList(new ArrayList());
            chromindex = new File(String.valueOf(dir) + ".fai");
            BufferedReader reader = new BufferedReader(new FileReader(chromindex));
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\t");
                Long[] add = new Long[]{Long.parseLong(split[2]), Long.parseLong(split[1]), Long.parseLong(split[3])};
                chromIndex.put(split[0], add);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getSeq(int start, int end, RandomAccessFile seqchrom) {
        try {
            seqresult = new byte[end - start + 100];
            if (seqresult.length > 30000) {
                return "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        seqBuffer = new StringBuffer();
        chromo = seqchrom;
        try {
            if (headerLen + (long)start + (long)(start / 60) - 1L >= seqchrom.length() - (long)seqresult.length) {
                seqresult = new byte[(int)(seqchrom.length() - (headerLen + (long)start + (long)(start / 60) - 1L)) - 1];
            }
            chromo.seek(headerLen + (long)start + (long)(start / 60) - 1L);
            chromo.readFully(seqresult);
            if (seqresult[0] == 10) {
                chromo.seek(headerLen + (long)(start - 1) + (long)(start / 60) - 1L);
                seqchrom.readFully(seqresult);
            }
            int i = 0;
            while (i < seqresult.length) {
                if (seqresult[i] != 10) {
                    seqBuffer.append((char)seqresult[i]);
                }
                if ((resString = seqBuffer.toString().toUpperCase()).length() < end - start) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resString.length() < end - start) {
            return "";
        }
        return resString.substring(0, end - start);
    }
}

