/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.AddGenome;
import base.BasePlayer.BEDCodecMod;
import base.BasePlayer.BedNode;
import base.BasePlayer.BedTrack;
import base.BasePlayer.ChromDraw;
import base.BasePlayer.ControlFile;
import base.BasePlayer.FileRead;
import base.BasePlayer.Gene;
import base.BasePlayer.Main;
import base.BasePlayer.OWNCodec;
import base.BasePlayer.ReadNode;
import base.BasePlayer.ReferenceSeq;
import base.BasePlayer.SampleNode;
import base.BasePlayer.Settings;
import base.BasePlayer.SplitClass;
import base.BasePlayer.VarNode;
import base.BasePlayer.VariantHandler;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.tribble.bed.BEDFeature;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderVersion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MethodLibrary {
    static String formatNumber(int number) {
        return NumberFormat.getNumberInstance(Locale.US).format(number);
    }

    static HashMap<String, Integer> mapChrnameToIndex(SAMFileHeader header) {
        HashMap<String, Integer> chrresult = new HashMap<String, Integer>();
        SAMSequenceDictionary dict = header.getSequenceDictionary();
        List<SAMSequenceRecord> chrs = dict.getSequences();
        String chr = "";
        int i = 0;
        while (i < chrs.size()) {
            chr = chrs.get(i).getSequenceName();
            if (Main.chromModel.getIndexOf(chr.replace("chr", "")) > -1) {
                chrresult.put(chr, Main.chromModel.getIndexOf(chr.replace("chr", "")));
            } else if (chr.replace("chr", "").equals("M")) {
                if (Main.chromModel.getIndexOf("MT") > -1) {
                    chrresult.put(chr, Main.chromModel.getIndexOf("MT"));
                }
            } else if (chr.replace("chr", "").equals("MT") && Main.chromModel.getIndexOf("M") > -1) {
                chrresult.put(chr, Main.chromModel.getIndexOf("M"));
            }
            ++i;
        }
        return chrresult;
    }

    public static void showVariantMenu(Component component, final VarNode varOverLap, SampleNode sampleOverLap, int x, int y, final String altbase) {
        JTextArea area;
        String line = "";
        ArrayList<String> annolines = new ArrayList<String>();
        if (sampleOverLap != null) {
            line = FileRead.getVCFLine(varOverLap.getChrom(), varOverLap.getPosition(), varOverLap.getPosition() + 1, sampleOverLap.getSample());
        }
        if (Main.drawCanvas.annotationOn) {
            int i = 0;
            while (i < Main.drawCanvas.sampleList.size()) {
                String annoline;
                if (Main.drawCanvas.sampleList.get((int)i).annotation && (annoline = FileRead.getVCFLine(varOverLap.getChrom(), varOverLap.getPosition(), varOverLap.getPosition() + 1, Main.drawCanvas.sampleList.get(i))) != null) {
                    annolines.add(String.valueOf(Main.drawCanvas.sampleList.get(i).getName()) + "XX" + annoline);
                }
                ++i;
            }
        }
        if (line != null && line.length() > 1) {
            JPopupMenu menu = new JPopupMenu();
            area = new JTextArea();
            JScrollPane menuscroll = new JScrollPane();
            JButton hg19 = new JButton("Show variant in VarSome (hg19)");
            area.setFont(Main.menuFont);
            menu.add(hg19);
            menu.add(menuscroll);
            area.setLineWrap(true);
            area.setWrapStyleWord(true);
            final String[] split = line.split("\t");
            hg19.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Main.gotoURL("https://varsome.com/variant/hg19/" + split[0] + "-" + split[1] + "-" + split[3] + "-" + split[4]);
                }
            });
            boolean first = true;
            if (varOverLap.getBedHits() != null) {
                int i = 0;
                while (i < varOverLap.getBedHits().size()) {
                    if (varOverLap.getBedHits().get((int)i).getTrack().selex && varOverLap.getBedHits().get(i).getTrack().getAffinityBox().isSelected()) {
                        if (first) {
                            area.append("Affinity Changes:\n");
                            first = false;
                        }
                        Main.drawCanvas.baseHover = altbase;
                        Double value = MethodLibrary.calcAffiniyChange(varOverLap, Main.drawCanvas.baseHover, varOverLap.getBedHits().get(i));
                        area.append(String.valueOf(MethodLibrary.shortName(varOverLap.getBedHits().get((int)i).name, 7)) + "=" + MethodLibrary.round(varOverLap.getBedHits().get((int)i).value, 3) + " (" + MethodLibrary.round(value, 3) + ")\n");
                    }
                    ++i;
                }
            }
            if (!first) {
                area.append("\n");
            }
            int longest = 0;
            String longestText = "";
            try {
                area.append("VCF info: " + sampleOverLap.getSample().getName() + "\n\n");
                area.append("POS: " + split[0] + ":" + split[1] + "\nID: " + split[2] + "\n");
                area.append("ALT: " + split[3] + " > " + split[4] + "\n");
                area.append("QUAL: " + split[5] + "\n");
                area.append("FILTER: " + split[6] + "\n");
                area.append("INFO:\n");
                if (split.length > 7) {
                    String[] infosplit = split[7].split(";");
                    int i = 0;
                    while (i < infosplit.length) {
                        if (longest < infosplit[i].length()) {
                            longest = infosplit[i].length();
                            longestText = infosplit[i];
                        }
                        area.append(String.valueOf(infosplit[i]) + "\n");
                        ++i;
                    }
                }
                if (annolines.size() != 0) {
                    int i = 0;
                    while (i < annolines.size()) {
                        String[] temp = ((String)annolines.get(i)).split("XX");
                        String[] annosplit = temp[1].split("\t");
                        if (annosplit.length > 7) {
                            area.append("\n" + temp[0] + "\n");
                            String[] infosplit = annosplit[7].split(";");
                            int j = 0;
                            while (j < infosplit.length) {
                                if (longest < infosplit[j].length()) {
                                    longest = infosplit[j].length();
                                    longestText = infosplit[j];
                                }
                                area.append(String.valueOf(infosplit[j]) + "\n");
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                if (split.length > 8) {
                    area.append("\nFORMAT: " + split[8] + "\n");
                }
                if (split.length > 9) {
                    int i = 9;
                    while (i < split.length) {
                        area.append(String.valueOf(split[i]) + "\n");
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            menu.setMaximumSize(new Dimension((int)((double)Main.width * 0.6), 300));
            menu.setPreferredSize(new Dimension(Main.bedCanvas.buf.getFontMetrics().stringWidth(longestText) + 100, 300));
            area.setCaretPosition(0);
            area.revalidate();
            menuscroll.getViewport().add(area);
            menu.pack();
            menu.show(component, x, y);
        } else {
            JPopupMenu menu = new JPopupMenu();
            area = new JTextArea();
            JButton hg19 = new JButton("Show variant in VarSome (hg19)");
            area.setFont(Main.menuFont);
            menu.add(hg19);
            hg19.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Main.gotoURL("https://varsome.com/variant/hg19/" + varOverLap.getChrom() + "-" + (varOverLap.getPosition() + 1) + "-" + Main.getBase.get(varOverLap.getRefBase()) + "-" + altbase);
                }
            });
            menu.pack();
            menu.show(component, x, y);
        }
    }

    public int getLongestDel(VarNode node) {
        int maxlength = 0;
        int i = 0;
        while (i < node.vars.size()) {
            if (node.vars.get(i).getKey().length() != 1 && !node.vars.get(i).getKey().startsWith("i") && node.vars.get(i).getKey().length() > maxlength) {
                maxlength = node.vars.get(i).getKey().length();
            }
            ++i;
        }
        return 0;
    }

    static BufferedImage toCompatibleImage(BufferedImage image) {
        GraphicsConfiguration gfx_config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (image.getColorModel().equals(gfx_config.getColorModel())) {
            return image;
        }
        BufferedImage new_image = gfx_config.createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics2D g2d = (Graphics2D)new_image.getGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return new_image;
    }

    static void unzip(File infile, File outfile) {
        try {
            String line;
            GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(infile));
            BufferedReader reader = new BufferedReader(new InputStreamReader(gzip));
            BufferedWriter fastaWriter = new BufferedWriter(new FileWriter(outfile));
            while ((line = reader.readLine()) != null) {
                if (fastaWriter == null) continue;
                fastaWriter.write(String.valueOf(line) + "\n");
            }
            reader.close();
            fastaWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void blockCompressAndIndex(String[] in, BlockCompressedOutputStream writer) throws IOException {
        int j = 0;
        while (j < in.length) {
            if (in[j] == null) {
                System.out.println(j);
            } else {
                writer.write(in[j].getBytes());
                if (j < in.length - 1) {
                    writer.write(9);
                }
            }
            ++j;
        }
        writer.write(10);
    }

    static void blockCompressAndIndex(File infile, File outFile, boolean deleteOnExit) throws IOException {
        String bedline;
        GZIPInputStream gzip = null;
        gzip = new GZIPInputStream(new FileInputStream(infile));
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzip));
        TabixIndexCreator indexCreator = null;
        indexCreator = new TabixIndexCreator(TabixFormat.BED);
        BlockCompressedOutputStream writer = new BlockCompressedOutputStream(outFile);
        String header = "#chrom\tstart\tend\tname\tscore\tstrand\n";
        writer.write(header.getBytes());
        long filePosition = writer.getFilePointer();
        OWNCodec bedCodec = new OWNCodec();
        while ((bedline = reader.readLine()) != null) {
            String[] line = bedline.split("\t");
            BEDFeature bed = bedCodec.decode(line);
            if (bed == null) continue;
            int j = 0;
            while (j < line.length) {
                if (line[j] == null) {
                    System.out.println(j);
                } else {
                    writer.write(line[j].getBytes());
                    if (j < line.length - 1) {
                        writer.write(9);
                    }
                }
                ++j;
            }
            writer.write(10);
            indexCreator.addFeature(bed, filePosition);
            filePosition = writer.getFilePointer();
        }
        reader.close();
        writer.flush();
        System.err.print("Indexing... ");
        File tbi = new File(String.valueOf(outFile.getCanonicalPath()) + ".tbi");
        if (tbi.exists() && tbi.isFile()) {
            System.err.println("Index file exists: " + tbi);
            tbi.delete();
        }
        Index index = indexCreator.finalizeIndex(writer.getFilePointer());
        index.writeBasedOnFeatureFile(outFile);
        writer.close();
        System.err.println("Done");
        if (deleteOnExit) {
            outFile.deleteOnExit();
            File idx = new File(String.valueOf(outFile.getAbsolutePath()) + ".tbi");
            idx.deleteOnExit();
        }
    }

    static void blockCompressAndIndexVCF(File infile, File outFile, boolean deleteOnExit) throws IOException {
        String bedline;
        GZIPInputStream gzip = null;
        gzip = new GZIPInputStream(new FileInputStream(infile));
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzip));
        TabixIndexCreator indexCreator = null;
        indexCreator = new TabixIndexCreator(TabixFormat.VCF);
        BlockCompressedOutputStream writer = new BlockCompressedOutputStream(outFile);
        long filePosition = writer.getFilePointer();
        VCFHeader vcfheader = new VCFHeader();
        VCFHeaderLine headerline = new VCFHeaderLine("format", "##fileformat=VCFv4.1");
        vcfheader.addMetaDataLine(headerline);
        VariantHandler.vcfCodec.setVCFHeader(vcfheader, VCFHeaderVersion.VCF4_1);
        while ((bedline = reader.readLine()) != null) {
            String[] line = bedline.split("\t");
            VariantContext vcf = VariantHandler.vcfCodec.decode(bedline);
            if (vcf == null) continue;
            int j = 0;
            while (j < line.length) {
                if (line[j] == null) {
                    System.out.println(j);
                } else {
                    writer.write(line[j].getBytes());
                    if (j < line.length - 1) {
                        writer.write(9);
                    }
                }
                ++j;
            }
            writer.write(10);
            indexCreator.addFeature(vcf, filePosition);
            filePosition = writer.getFilePointer();
        }
        reader.close();
        writer.flush();
        System.err.print("Indexing... ");
        File tbi = new File(String.valueOf(outFile.getCanonicalPath()) + ".tbi");
        if (tbi.exists() && tbi.isFile()) {
            System.err.println("Index file exists: " + tbi);
            tbi.delete();
        }
        Index index = indexCreator.finalizeIndex(writer.getFilePointer());
        index.writeBasedOnFeatureFile(outFile);
        writer.close();
        System.err.println("Done");
        if (deleteOnExit) {
            outFile.deleteOnExit();
            File idx = new File(String.valueOf(outFile.getAbsolutePath()) + ".tbi");
            idx.deleteOnExit();
        }
    }

    static void blockCompressAndIndex(ArrayList<String[]> in, String bgzfOut, boolean deleteOnExit, SAMSequenceDictionary dict) throws IOException {
        File outFile = new File(bgzfOut);
        TabixIndexCreator indexCreator = null;
        indexCreator = dict != null && dict.getSequences().size() > 300 ? new TabixIndexCreator(dict, TabixFormat.BED) : new TabixIndexCreator(TabixFormat.BED);
        BlockCompressedOutputStream writer = new BlockCompressedOutputStream(outFile);
        String header = "#Chrom\tGeneStart\tGeneEnd\tName\tExonCount\tStrand\tENSG\tENST\tUniProt\tCanonical\tBiotype\tCodingStart\tCodingEnd\tExonStarts\tExonEnds\tStartPhases\tDescription\n";
        writer.write(header.getBytes());
        long filePosition = writer.getFilePointer();
        OWNCodec bedCodec = new OWNCodec();
        int i = 0;
        while (i < in.size()) {
            String[] line = in.get(i);
            BEDFeature bed = bedCodec.decode(line);
            if (bed != null) {
                int j = 0;
                while (j < line.length) {
                    if (line[j] == null) {
                        System.out.println(j);
                    } else {
                        writer.write(line[j].getBytes());
                        if (j < line.length - 1) {
                            writer.write(9);
                        }
                    }
                    ++j;
                }
                if (i < in.size() - 1) {
                    writer.write(10);
                }
                indexCreator.addFeature(bed, filePosition);
                filePosition = writer.getFilePointer();
            }
            ++i;
        }
        writer.flush();
        System.err.print("Indexing... ");
        File tbi = new File(String.valueOf(bgzfOut) + ".tbi");
        if (tbi.exists() && tbi.isFile()) {
            System.err.println("Index file exists: " + tbi);
            tbi.delete();
        }
        Index index = indexCreator.finalizeIndex(writer.getFilePointer());
        index.writeBasedOnFeatureFile(outFile);
        writer.close();
        System.err.println("Done");
        if (deleteOnExit) {
            outFile.deleteOnExit();
            File idx = new File(String.valueOf(outFile.getAbsolutePath()) + ".tbi");
            idx.deleteOnExit();
        }
    }

    public static boolean isDiscordant(SAMRecord record, boolean cg) {
        if (record.getReadPairedFlag() && !record.getMateUnmappedFlag()) {
            if (record.getReferenceIndex() != record.getMateReferenceIndex()) {
                return true;
            }
            if (record.getMateNegativeStrandFlag() == record.getReadNegativeStrandFlag() && !cg) {
                return true;
            }
            if (cg && record.getMateNegativeStrandFlag() != record.getReadNegativeStrandFlag()) {
                return true;
            }
            if (Math.abs(record.getInferredInsertSize()) > Settings.insertSize) {
                return true;
            }
        }
        return false;
    }

    public static String getOverlappingGenes(int start, int end, SplitClass split) {
        if (split.getGenes().size() == 0) {
            return null;
        }
        int pointer = 0;
        Gene gene = split.getGenes().get(pointer);
        Boolean inGene = false;
        ArrayList<String> genes = new ArrayList<String>();
        while (gene.getEnd() < start) {
            if (pointer > split.getGenes().size() - 2) {
                --pointer;
                break;
            }
            gene = split.getGenes().get(++pointer);
        }
        while (end > gene.getStart()) {
            try {
                if (start >= gene.getStart() && start <= gene.getEnd() || end >= gene.getStart() && end <= gene.getEnd()) {
                    inGene = true;
                }
                if (!genes.contains(gene.getName())) {
                    genes.add(gene.getName());
                }
                if (pointer > split.getGenes().size() - 2) break;
                gene = split.getGenes().get(++pointer);
            }
            catch (Exception e) {
                System.out.println(start);
                e.printStackTrace();
                break;
            }
        }
        if (!inGene.booleanValue()) {
            if (pointer > 0) {
                gene = split.getGenes().get(--pointer);
                genes.add(gene.getName());
                ++pointer;
            }
            if (pointer < split.getGenes().size()) {
                gene = split.getGenes().get(pointer);
                genes.add(gene.getName());
            }
        }
        StringBuffer gens = new StringBuffer("");
        if (inGene.booleanValue()) {
            int i = 0;
            while (i < genes.size()) {
                if (i > 0) {
                    gens.append(",");
                }
                gens.append((String)genes.get(i));
                ++i;
            }
        } else if (genes.size() == 2) {
            gens.append(String.valueOf((String)genes.get(0)) + "..." + (String)genes.get(1));
        } else if (pointer == 0) {
            gens.append("..." + (String)genes.get(0));
        } else {
            gens.append(String.valueOf((String)genes.get(0)) + "...");
        }
        return gens.toString();
    }

    public static int getRegion(int position, SplitClass split, int pointer) {
        if (split.getGenes().size() == 0) {
            return -1;
        }
        Gene gene = split.getGenes().get(pointer);
        Boolean inGene = false;
        while (position > gene.getStart()) {
            block7: {
                ++pointer;
                if (position >= gene.getStart() && position <= gene.getEnd()) {
                    gene = null;
                    return pointer;
                }
                if (pointer <= split.getGenes().size() - 1) break block7;
                return -1;
            }
            try {
                gene = split.getGenes().get(pointer);
            }
            catch (Exception e) {
                System.out.println(position);
                e.printStackTrace();
                break;
            }
        }
        if (!inGene.booleanValue()) {
            gene = null;
            return -1;
        }
        gene = null;
        return -1;
    }

    public static int getControlBaseLength(String ref, String alt, int baselength) {
        if (ref.length() == 1) {
            return 0;
        }
        if (!alt.contains(",")) {
            return ref.length() - alt.length();
        }
        String[] altsplit = alt.split(",");
        int len = 0;
        int i = 0;
        while (i < altsplit.length) {
            String altbase = FileRead.getVariant(ref, altsplit[i]);
            if (altbase.length() >= 2 && !altbase.startsWith("i") && Character.isDigit(altbase.charAt(3)) && baselength < (len = Integer.parseInt(altbase.substring(3)))) {
                baselength = len;
            }
            ++i;
        }
        return baselength;
    }

    public static int map(int value, int low1, int high1, int low2, int high2) {
        if (high1 - low1 == 0) {
            return 0;
        }
        return low2 + (high2 - low2) * (value - low1) / (high1 - low1);
    }

    public static int getBaseLength(ArrayList<Map.Entry<String, ArrayList<SampleNode>>> vars, int baselength) {
        int len = 1;
        for (Map.Entry<String, ArrayList<SampleNode>> entry : vars) {
            if (entry.getKey().length() < 2 || entry.getKey().startsWith("i") || !Character.isDigit(entry.getKey().charAt(3)) || baselength >= (len = Integer.parseInt(entry.getKey().substring(3)))) continue;
            baselength = len;
        }
        return baselength;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return 0.0;
        }
        BigDecimal bd = new BigDecimal(value);
        if (bd.setScale(places, RoundingMode.HALF_UP).doubleValue() == 0.0) {
            return bd.setScale((int)(-Math.log10(bd.doubleValue())) + places, RoundingMode.HALF_UP).doubleValue();
        }
        return bd.setScale(places, RoundingMode.HALF_UP).doubleValue();
    }

    public static void removeHeaderColumns(Object column) {
        int j;
        int i = VariantHandler.table.geneheader.size() - 1;
        while (i > 0) {
            if (VariantHandler.table.geneheader.get(i)[0].equals(column)) {
                if (VariantHandler.table.geneheader.get(i)[0] instanceof ControlFile) {
                    VariantHandler.table.geneheader.remove(i);
                    VariantHandler.table.geneheader.remove(i);
                } else {
                    VariantHandler.table.geneheader.remove(i);
                }
                j = i;
                while (j < VariantHandler.table.geneheader.size()) {
                    VariantHandler.table.geneheader.get((int)j)[1] = (Integer)VariantHandler.table.geneheader.get(j - 1)[1] + (Integer)VariantHandler.table.geneheader.get(j - 1)[2];
                    ++j;
                }
                break;
            }
            --i;
        }
        VariantHandler.table.repaint();
        i = VariantHandler.clusterTable.geneheader.size() - 1;
        while (i > 0) {
            if (VariantHandler.clusterTable.geneheader.get(i)[0].equals(column)) {
                if (VariantHandler.clusterTable.geneheader.get(i)[0] instanceof ControlFile) {
                    VariantHandler.clusterTable.geneheader.remove(i);
                    VariantHandler.clusterTable.geneheader.remove(i);
                } else {
                    VariantHandler.clusterTable.geneheader.remove(i);
                }
                j = i;
                while (j < VariantHandler.clusterTable.geneheader.size()) {
                    VariantHandler.clusterTable.geneheader.get((int)j)[1] = (Integer)VariantHandler.clusterTable.geneheader.get(j - 1)[1] + (Integer)VariantHandler.clusterTable.geneheader.get(j - 1)[2];
                    ++j;
                }
                break;
            }
            --i;
        }
        i = VariantHandler.clusterTable.header.size() - 1;
        while (i > 0) {
            if (VariantHandler.clusterTable.header.get(i)[0].equals(column)) {
                VariantHandler.clusterTable.header.remove(i);
                j = i;
                while (j < VariantHandler.clusterTable.header.size()) {
                    VariantHandler.clusterTable.header.get((int)j)[1] = (Integer)VariantHandler.clusterTable.header.get(j - 1)[1] + (Integer)VariantHandler.clusterTable.header.get(j - 1)[2];
                    ++j;
                }
                break;
            }
            --i;
        }
        VariantHandler.clusterTable.repaint();
        int j2 = 0;
        while (j2 < VariantHandler.tables.size()) {
            int i2 = VariantHandler.tables.get((int)j2).geneheader.size() - 1;
            while (i2 > 0) {
                if (VariantHandler.tables.get((int)j2).geneheader.get(i2)[0].equals(column)) {
                    if (VariantHandler.tables.get((int)j2).geneheader.get(i2)[0] instanceof ControlFile) {
                        VariantHandler.tables.get((int)j2).geneheader.remove(i2);
                        VariantHandler.tables.get((int)j2).geneheader.remove(i2);
                    } else {
                        VariantHandler.tables.get((int)j2).geneheader.remove(i2);
                    }
                    int k = i2;
                    while (k < VariantHandler.tables.get((int)j2).geneheader.size()) {
                        VariantHandler.tables.get((int)j2).geneheader.get((int)k)[1] = (Integer)VariantHandler.tables.get((int)j2).geneheader.get(k - 1)[1] + (Integer)VariantHandler.tables.get((int)j2).geneheader.get(k - 1)[2];
                        ++k;
                    }
                    break;
                }
                --i2;
            }
            VariantHandler.tables.get(j2).revalidate();
            VariantHandler.tables.get(j2).repaint();
            ++j2;
        }
    }

    public static StringBuffer[] makeTrackArray(ArrayList<VarNode> nodes) {
        StringBuffer[] bedarray = new StringBuffer[Main.bedCanvas.bedTrack.size()];
        VarNode node = null;
        int j = 0;
        while (j < nodes.size()) {
            node = nodes.get(j);
            if (node.getBedHits() == null) {
                return null;
            }
            MethodLibrary.makeTrackArray(node, null);
            ++j;
        }
        node = null;
        return bedarray;
    }

    static String shortString(String stringi, int length) {
        if (stringi == null) {
            return "";
        }
        if (stringi.length() > length) {
            return String.valueOf(stringi.substring(0, length)) + "...";
        }
        return stringi;
    }

    public static StringBuffer[] makeTrackArray(VarNode node, String base) {
        if (node.getBedHits() == null) {
            return null;
        }
        StringBuffer[] bedarray = new StringBuffer[Main.bedCanvas.bedTrack.size()];
        int v = 0;
        while (v < node.getBedHits().size()) {
            Double value;
            if (bedarray[node.getBedHits().get((int)v).getTrack().trackIndex] == null) {
                if (base != null && node.getBedHits().get((int)v).getTrack().basecolumn != null) {
                    if (node.getBedHits().get((int)v).name.equals(base)) {
                        bedarray[node.getBedHits().get((int)v).getTrack().trackIndex] = new StringBuffer("" + MethodLibrary.round(node.getBedHits().get((int)v).value, 2));
                    }
                } else {
                    if (node.getBedHits().get((int)v).name != null && node.getBedHits().get((int)v).name.length() > 0) {
                        bedarray[node.getBedHits().get((int)v).getTrack().trackIndex] = node.getBedHits().get((int)v).name.length() > 10 ? new StringBuffer(String.valueOf(node.getBedHits().get((int)v).name.substring(0, 10)) + "...") : new StringBuffer(node.getBedHits().get((int)v).name);
                        if (node.getBedHits().get((int)v).getTrack().hasvalues) {
                            bedarray[node.getBedHits().get((int)v).getTrack().trackIndex].append("=" + MethodLibrary.round(node.getBedHits().get((int)v).value, 2));
                        }
                    } else {
                        bedarray[node.getBedHits().get((int)v).getTrack().trackIndex] = node.getBedHits().get((int)v).getTrack().hasvalues ? new StringBuffer("" + MethodLibrary.round(node.getBedHits().get((int)v).value, 2)) : new StringBuffer("hit");
                    }
                    if (node.getBedHits().get((int)v).getTrack().selex && node.getBedHits().get(v).getTrack().getAffinityBox().isSelected()) {
                        value = MethodLibrary.calcAffiniyChange(node, base, node.getBedHits().get(v));
                        bedarray[node.getBedHits().get((int)v).getTrack().trackIndex].append(">" + MethodLibrary.round(value, 3));
                    }
                }
            } else if (base != null && node.getBedHits().get((int)v).getTrack().basecolumn != null) {
                if (bedarray[node.getBedHits().get((int)v).getTrack().trackIndex] == null) {
                    bedarray[node.getBedHits().get((int)v).getTrack().trackIndex] = new StringBuffer("-");
                }
            } else {
                bedarray[node.getBedHits().get((int)v).getTrack().trackIndex].append(";");
                if (node.getBedHits().get((int)v).name != null) {
                    bedarray[node.getBedHits().get((int)v).getTrack().trackIndex].append(MethodLibrary.shortName(node.getBedHits().get((int)v).name, 10));
                    if (node.getBedHits().get((int)v).getTrack().hasvalues) {
                        bedarray[node.getBedHits().get((int)v).getTrack().trackIndex].append("=" + MethodLibrary.round(node.getBedHits().get((int)v).value, 2));
                    }
                } else if (node.getBedHits().get((int)v).getTrack().hasvalues) {
                    bedarray[node.getBedHits().get((int)v).getTrack().trackIndex].append("" + MethodLibrary.round(node.getBedHits().get((int)v).value, 2));
                } else {
                    bedarray[node.getBedHits().get((int)v).getTrack().trackIndex].append("hit");
                }
                if (node.getBedHits().get((int)v).getTrack().selex && node.getBedHits().get(v).getTrack().getAffinityBox().isSelected()) {
                    value = MethodLibrary.calcAffiniyChange(node, base, node.getBedHits().get(v));
                    bedarray[node.getBedHits().get((int)v).getTrack().trackIndex].append(">" + MethodLibrary.round(value, 3));
                }
            }
            ++v;
        }
        return bedarray;
    }

    public static String[] makeMultiAlt(String chrom, int pos, String ref, VarNode node) {
        int i;
        int longestdel = 0;
        String[] result = new String[2];
        int i2 = 0;
        while (i2 < node.vars.size()) {
            if (node.vars.get(i2).getKey().startsWith("del")) {
                if (node.vars.get(i2).getKey().matches("del\\d+")) {
                    int len = Integer.parseInt(node.vars.get(i2).getKey().substring(3));
                    if (longestdel < len) {
                        longestdel = len;
                    }
                } else if (longestdel == 0) {
                    longestdel = 1;
                }
            }
            ++i2;
        }
        StringBuffer buffer = new StringBuffer("");
        if (longestdel > 0) {
            if (Main.drawCanvas.splits.get(0).getReference() == null) {
                Main.drawCanvas.splits.get(0).setReference(new ReferenceSeq());
            }
            result[0] = new String(Main.drawCanvas.splits.get(0).getReference().getSeq(chrom, pos, pos + longestdel + 1, Main.referenceFile));
            i = 0;
            while (i < node.vars.size()) {
                if (node.vars.get(i).getKey().length() == 1) {
                    buffer.append(String.valueOf(node.vars.get(i).getKey()) + result[0].substring(1) + ",");
                } else if (node.vars.get(i).getKey().startsWith("ins")) {
                    buffer.append(String.valueOf(result[0].charAt(0)) + node.vars.get(i).getKey().substring(3) + result[0].substring(1) + ",");
                } else if (node.vars.get(i).getKey().matches("del\\d+")) {
                    int len = Integer.parseInt(node.vars.get(i).getKey().substring(3));
                    buffer.append(String.valueOf(result[0].substring(0, result[0].length() - len)) + ",");
                } else {
                    buffer.append(String.valueOf(result[0].substring(0, result[0].length() - 1)) + ",");
                }
                ++i;
            }
        } else {
            result[0] = ref;
            i = 0;
            while (i < node.vars.size()) {
                if (node.vars.get(i).getKey().length() == 1) {
                    buffer.append(String.valueOf(node.vars.get(i).getKey()) + ",");
                } else {
                    buffer.append(String.valueOf(ref) + node.vars.get(i).getKey().substring(3) + ",");
                }
                ++i;
            }
        }
        result[1] = buffer.toString();
        return result;
    }

    public static String[] makeIndelColumns(String chrom, int pos, String ref, String indel) {
        String[] result = new String[2];
        if (indel.contains("del")) {
            if (Main.drawCanvas.splits.get(0).getReference() == null) {
                Main.drawCanvas.splits.get(0).setReference(new ReferenceSeq());
            }
            if (indel.length() == 4 && !indel.matches(".*\\d+")) {
                result[0] = String.valueOf(ref) + indel.substring(3);
                result[1] = ref;
            } else {
                result[0] = new String(Main.drawCanvas.splits.get(0).getReference().getSeq(chrom, pos, pos + Integer.parseInt(indel.substring(3)) + 1, Main.referenceFile));
                result[1] = ref;
            }
        } else if (indel.length() == 4 && !indel.matches(".*\\d+")) {
            result[0] = ref;
            result[1] = String.valueOf(ref) + indel.substring(3);
        } else {
            result[0] = ref;
            result[1] = String.valueOf(ref) + indel.substring(3);
        }
        return result;
    }

    static void createVCFIndex2(File file) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            FileReader read = new FileReader(file);
            int addbyte = 1;
            int max = 10000;
            int count = 0;
            while (read.read() != 10) {
                if (read.read() == 13) {
                    addbyte = 2;
                    break;
                }
                if (count > max) break;
                ++count;
            }
            read.close();
            SAMSequenceDictionary dict = AddGenome.ReadDict(Main.ref);
            TabixIndexCreator indexCreator = new TabixIndexCreator(dict, TabixFormat.VCF);
            VCFHeader vcfheader = new VCFHeader();
            VCFHeaderLine headerline = new VCFHeaderLine("format", "##fileformat=VCFv4.1");
            vcfheader.addMetaDataLine(headerline);
            VariantHandler.vcfCodec.setVCFHeader(vcfheader, VCFHeaderVersion.VCF4_1);
            long filepointer = 0L;
            boolean cancelled = false;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith("\"") || line.length() < 10) {
                    filepointer += (long)(line.length() + addbyte);
                    continue;
                }
                VariantContext vcf = VariantHandler.vcfCodec.decode(line);
                if (!Main.drawCanvas.loading) {
                    cancelled = true;
                    break;
                }
                indexCreator.addFeature(vcf, filepointer);
                filepointer += (long)(line.length() + addbyte);
            }
            if (!cancelled) {
                Index index = indexCreator.finalizeIndex(filepointer);
                index.writeBasedOnFeatureFile(file);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static File createVCFIndex(File file) {
        block8: {
            FileInputStream testfile = new FileInputStream(file);
            BufferedInputStream testbuf = new BufferedInputStream(testfile);
            boolean ok = BlockCompressedInputStream.isValidFile(testbuf);
            testbuf.close();
            testfile.close();
            if (ok) break block8;
            if (JOptionPane.showConfirmDialog(Main.drawScroll, "File is not bgzipped, want to bgzip it now?", "Bgzipped?", 0, 3) == 0) {
                Main.drawCanvas.loadingtext = "Bgzipping and creating index for " + file.getName();
                MethodLibrary.blockCompressAndIndexVCF(file, new File(file.getCanonicalPath().replace(".vcf.gz", "_bgzip.vcf.gz")), false);
                return new File(file.getCanonicalPath().replace(".vcf.gz", "_bgzip.vcf.gz"));
            }
            return null;
        }
        try {
            String line;
            BlockCompressedInputStream reader = new BlockCompressedInputStream(file);
            SAMSequenceDictionary dict = AddGenome.ReadDict(Main.ref);
            TabixIndexCreator indexCreator = new TabixIndexCreator(dict, TabixFormat.VCF);
            VCFHeader vcfheader = new VCFHeader();
            VCFHeaderLine headerline = new VCFHeaderLine("format", "##fileformat=VCFv4.1");
            vcfheader.addMetaDataLine(headerline);
            VariantHandler.vcfCodec.setVCFHeader(vcfheader, VCFHeaderVersion.VCF4_1);
            long filepointer = 0L;
            boolean cancelled = false;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    filepointer = reader.getFilePointer();
                    continue;
                }
                VariantContext vcf = VariantHandler.vcfCodec.decode(line);
                if (!Main.drawCanvas.loading) {
                    cancelled = true;
                    break;
                }
                indexCreator.addFeature(vcf, filepointer);
                filepointer = reader.getFilePointer();
            }
            if (!cancelled) {
                Index index = indexCreator.finalizeIndex(filepointer);
                index.writeBasedOnFeatureFile(file);
            }
            reader.close();
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.showError(e.getMessage(), "Error");
            return null;
        }
    }

    static void createBEDIndex(File file) {
        try {
            String line;
            BlockCompressedInputStream reader = new BlockCompressedInputStream(file);
            SAMSequenceDictionary dict = AddGenome.ReadDict(Main.ref);
            TabixIndexCreator indexCreator = new TabixIndexCreator(dict, TabixFormat.BED);
            BEDCodecMod bedCodec = new BEDCodecMod();
            long filepointer = 0L;
            boolean cancelled = false;
            while ((line = reader.readLine()) != null) {
                try {
                    if (line.startsWith("#")) {
                        filepointer = reader.getFilePointer();
                        continue;
                    }
                    BEDFeature bed = bedCodec.decode(line);
                    indexCreator.addFeature(bed, filepointer);
                    filepointer = reader.getFilePointer();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (!cancelled) {
                Index index = indexCreator.finalizeIndex(filepointer);
                index.writeBasedOnFeatureFile(file);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void createBEDIndex2(File file) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            FileReader read = new FileReader(file);
            int addbyte = 1;
            int max = 10000;
            int count = 0;
            while (read.read() != 10) {
                if (read.read() == 13) {
                    addbyte = 2;
                    break;
                }
                if (count > max) break;
                ++count;
            }
            read.close();
            SAMSequenceDictionary dict = AddGenome.ReadDict(Main.ref);
            TabixIndexCreator indexCreator = new TabixIndexCreator(dict, TabixFormat.BED);
            BEDCodecMod bedCodec = new BEDCodecMod();
            long filepointer = 0L;
            boolean cancelled = false;
            boolean isChr = false;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                try {
                    BEDFeature bed;
                    if (line.startsWith("#") || line.startsWith("track")) {
                        filepointer += (long)(line.length() + addbyte);
                        continue;
                    }
                    if (first) {
                        if (line.startsWith("chr")) {
                            isChr = true;
                        }
                        first = false;
                    }
                    if (isChr) {
                        try {
                            bed = bedCodec.decode(line.substring(3));
                            indexCreator.addFeature(bed, filepointer);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        try {
                            bed = bedCodec.decode(line);
                            indexCreator.addFeature(bed, filepointer);
                        }
                        catch (Exception e) {
                            filepointer += (long)(line.length() + addbyte);
                            continue;
                        }
                    }
                    filepointer += (long)(line.length() + addbyte);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    break;
                }
            }
            if (!cancelled) {
                Index index = indexCreator.finalizeIndex(filepointer);
                index.writeBasedOnFeatureFile(file);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String shortName(String line, int maxlength) {
        if (line.length() > maxlength) {
            return String.valueOf(line.substring(0, maxlength)) + "...";
        }
        return line;
    }

    public static void addHeaderColumns(Object column) {
        if (Main.bedCanvas.bedTrack.size() == 0 || column instanceof BedTrack) {
            Object[] obj = new Object[]{column, (Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[1] + (Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[2], 100};
            VariantHandler.table.geneheader.add(obj);
            obj = new Object[]{column, (Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[1] + (Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[2], 100};
            VariantHandler.clusterTable.geneheader.add(obj);
            int i = 0;
            while (i < VariantHandler.tables.size()) {
                if (VariantHandler.tables.get((int)i).bedtrack.equals(column)) {
                    int j = 0;
                    while (j < VariantHandler.tables.size() - 1) {
                        obj = new Object[]{VariantHandler.tables.get((int)j).bedtrack, (Integer)VariantHandler.tables.get((int)i).geneheader.get(VariantHandler.tables.get((int)i).geneheader.size() - 1)[1] + (Integer)VariantHandler.tables.get((int)i).geneheader.get(VariantHandler.tables.get((int)i).geneheader.size() - 1)[2], 100};
                        VariantHandler.tables.get((int)i).geneheader.add(obj);
                        ++j;
                    }
                } else {
                    obj = new Object[]{column, (Integer)VariantHandler.tables.get((int)i).geneheader.get(VariantHandler.tables.get((int)i).geneheader.size() - 1)[1] + (Integer)VariantHandler.tables.get((int)i).geneheader.get(VariantHandler.tables.get((int)i).geneheader.size() - 1)[2], 100};
                    VariantHandler.tables.get((int)i).geneheader.add(obj);
                    if (column instanceof ControlFile) {
                        obj = new Object[]{"OR", (Integer)VariantHandler.tables.get((int)i).geneheader.get(VariantHandler.tables.get((int)i).geneheader.size() - 1)[1] + (Integer)VariantHandler.tables.get((int)i).geneheader.get(VariantHandler.tables.get((int)i).geneheader.size() - 1)[2], 100};
                        VariantHandler.tables.get((int)i).geneheader.add(obj);
                    }
                }
                ++i;
            }
            if (column instanceof ControlFile) {
                obj = new Object[]{"OR", (Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[1] + (Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[2], 100};
                VariantHandler.table.geneheader.add(obj);
                obj = new Object[]{"OR", (Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[1] + (Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[2], 100};
                VariantHandler.clusterTable.geneheader.add(obj);
            } else {
                obj = new Object[]{column, (Integer)VariantHandler.clusterTable.header.get(VariantHandler.clusterTable.header.size() - 1)[1] + (Integer)VariantHandler.clusterTable.header.get(VariantHandler.clusterTable.header.size() - 1)[2], 100};
                VariantHandler.clusterTable.header.add(obj);
                if ((Integer)obj[1] + (Integer)obj[2] > VariantHandler.clusterTable.getWidth() && VariantHandler.clusterTable.bufImage.getWidth() < (Integer)obj[1] + (Integer)obj[2]) {
                    VariantHandler.clusterTable.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(VariantHandler.clusterTable.width * 2, VariantHandler.clusterTable.height, 2));
                    VariantHandler.clusterTable.buf = (Graphics2D)VariantHandler.clusterTable.bufImage.getGraphics();
                }
                VariantHandler.clusterTable.setPreferredSize(new Dimension((Integer)obj[1] + (Integer)obj[2], VariantHandler.clusterTable.getHeight()));
                VariantHandler.clusterTable.revalidate();
            }
        } else {
            int j;
            Object[] obj;
            int i = VariantHandler.table.geneheader.size() - 2;
            while (i > 0) {
                if (!(VariantHandler.table.geneheader.get(i)[0] instanceof BedTrack)) {
                    obj = new Object[]{column, (Integer)VariantHandler.table.geneheader.get(i)[1] + (Integer)VariantHandler.table.geneheader.get(i)[2], 100};
                    VariantHandler.table.geneheader.add(i + 1, obj);
                    obj = new Object[]{"OR", (Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[1] + (Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[2], 100};
                    VariantHandler.table.geneheader.add(i + 2, obj);
                    j = i;
                    while (j < VariantHandler.table.geneheader.size()) {
                        VariantHandler.table.geneheader.get((int)j)[1] = (Integer)VariantHandler.table.geneheader.get(j - 1)[1] + (Integer)VariantHandler.table.geneheader.get(j - 1)[2];
                        ++j;
                    }
                    break;
                }
                --i;
            }
            i = VariantHandler.clusterTable.geneheader.size() - 2;
            while (i > 0) {
                if (!(VariantHandler.clusterTable.geneheader.get(i)[0] instanceof BedTrack)) {
                    obj = new Object[]{column, (Integer)VariantHandler.clusterTable.geneheader.get(i)[1] + (Integer)VariantHandler.clusterTable.geneheader.get(i)[2], 100};
                    VariantHandler.clusterTable.geneheader.add(i + 1, obj);
                    obj = new Object[]{"OR", (Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[1] + (Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[2], 100};
                    VariantHandler.clusterTable.geneheader.add(i + 2, obj);
                    j = i;
                    while (j < VariantHandler.clusterTable.geneheader.size()) {
                        VariantHandler.clusterTable.geneheader.get((int)j)[1] = (Integer)VariantHandler.clusterTable.geneheader.get(j - 1)[1] + (Integer)VariantHandler.clusterTable.geneheader.get(j - 1)[2];
                        ++j;
                    }
                    break;
                }
                --i;
            }
            int t = 0;
            while (t < VariantHandler.tables.size()) {
                int i2 = VariantHandler.tables.get((int)t).geneheader.size() - 2;
                while (i2 > 0) {
                    if (!(VariantHandler.tables.get((int)t).geneheader.get(i2)[0] instanceof BedTrack)) {
                        Object[] obj2 = new Object[]{column, (Integer)VariantHandler.tables.get((int)t).geneheader.get(i2)[1] + (Integer)VariantHandler.tables.get((int)t).geneheader.get(i2)[2], 100};
                        VariantHandler.tables.get((int)t).geneheader.add(i2 + 1, obj2);
                        obj2 = new Object[]{"OR", (Integer)VariantHandler.tables.get((int)t).geneheader.get(i2 + 1)[1] + (Integer)VariantHandler.tables.get((int)t).geneheader.get(i2 + 1)[2], 100};
                        VariantHandler.tables.get((int)t).geneheader.add(i2 + 2, obj2);
                        int j2 = i2;
                        while (j2 < VariantHandler.tables.get((int)t).geneheader.size()) {
                            VariantHandler.tables.get((int)t).geneheader.get((int)j2)[1] = (Integer)VariantHandler.tables.get((int)t).geneheader.get(j2 - 1)[1] + (Integer)VariantHandler.tables.get((int)t).geneheader.get(j2 - 1)[2];
                            ++j2;
                        }
                        if ((Integer)VariantHandler.tables.get((int)t).geneheader.get(VariantHandler.tables.get((int)t).geneheader.size() - 1)[1] + (Integer)VariantHandler.tables.get((int)t).geneheader.get(VariantHandler.tables.get((int)t).geneheader.size() - 1)[2] > VariantHandler.tables.get(t).getWidth()) {
                            if (VariantHandler.tables.get((int)t).bufImage.getWidth() < (Integer)VariantHandler.tables.get((int)t).geneheader.get(VariantHandler.tables.get((int)t).geneheader.size() - 1)[1] + (Integer)VariantHandler.tables.get((int)t).geneheader.get(VariantHandler.tables.get((int)t).geneheader.size() - 1)[2]) {
                                VariantHandler.tables.get((int)t).bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(VariantHandler.tables.get((int)t).width * 2, VariantHandler.tables.get((int)t).height, 2));
                                VariantHandler.tables.get((int)t).buf = (Graphics2D)VariantHandler.tables.get((int)t).bufImage.getGraphics();
                            }
                            VariantHandler.tables.get(t).setPreferredSize(new Dimension((Integer)VariantHandler.tables.get((int)t).geneheader.get(VariantHandler.tables.get((int)t).geneheader.size() - 1)[1] + (Integer)VariantHandler.tables.get((int)t).geneheader.get(VariantHandler.tables.get((int)t).geneheader.size() - 1)[2], VariantHandler.tables.get(t).getHeight()));
                        }
                        VariantHandler.tables.get(t).revalidate();
                        VariantHandler.tables.get(t).repaint();
                        break;
                    }
                    --i2;
                }
                ++t;
            }
        }
        if ((Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[1] + (Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[2] > VariantHandler.table.getWidth()) {
            if (VariantHandler.table.bufImage.getWidth() < (Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[1] + (Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[2]) {
                VariantHandler.table.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(VariantHandler.table.width * 2, VariantHandler.table.height, 2));
                VariantHandler.table.buf = (Graphics2D)VariantHandler.table.bufImage.getGraphics();
            }
            VariantHandler.table.setPreferredSize(new Dimension((Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[1] + (Integer)VariantHandler.table.geneheader.get(VariantHandler.table.geneheader.size() - 1)[2], VariantHandler.table.getHeight()));
        }
        if ((Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[1] + (Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[2] > VariantHandler.clusterTable.getWidth()) {
            if (VariantHandler.clusterTable.bufImage.getWidth() < (Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[1] + (Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[2]) {
                VariantHandler.clusterTable.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(VariantHandler.clusterTable.width * 2, VariantHandler.clusterTable.height, 2));
                VariantHandler.clusterTable.buf = (Graphics2D)VariantHandler.clusterTable.bufImage.getGraphics();
            }
            VariantHandler.clusterTable.setPreferredSize(new Dimension((Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[1] + (Integer)VariantHandler.clusterTable.geneheader.get(VariantHandler.clusterTable.geneheader.size() - 1)[2], VariantHandler.clusterTable.getHeight()));
        }
        VariantHandler.table.revalidate();
        VariantHandler.table.repaint();
        VariantHandler.clusterTable.revalidate();
        VariantHandler.clusterTable.repaint();
    }

    public static int[][] reverseMatrix(int[][] matrix) {
        int[][] newMatrix = new int[4][matrix[0].length];
        int pointer = 0;
        int i = matrix[0].length - 1;
        while (i >= 0) {
            newMatrix[3][pointer] = matrix[0][i];
            newMatrix[2][pointer] = matrix[1][i];
            newMatrix[1][pointer] = matrix[2][i];
            newMatrix[0][pointer] = matrix[3][i];
            ++pointer;
            --i;
        }
        return newMatrix;
    }

    public static String reverseComplement(String string) {
        StringBuffer newstringBuffer = new StringBuffer();
        int i = string.length() - 1;
        while (i >= 0) {
            if (string.charAt(i) == 'A') {
                newstringBuffer.append('T');
            } else if (string.charAt(i) == 'C') {
                newstringBuffer.append('G');
            } else if (string.charAt(i) == 'G') {
                newstringBuffer.append('C');
            } else if (string.charAt(i) == 'T') {
                newstringBuffer.append('A');
            } else if (string.charAt(i) == 'N') {
                newstringBuffer.append('N');
            }
            --i;
        }
        return newstringBuffer.toString();
    }

    public static String getStrand(boolean value) {
        if (value) {
            return "+";
        }
        return "-";
    }

    public static String aminoEffect(String amino) {
        if (amino.length() < 4) {
            return "";
        }
        if (!amino.contains(";")) {
            if (!amino.contains("UTR") && (amino.contains("fs") || amino.length() == 7 && amino.startsWith("Met1") && !amino.substring(4).equals("Met") || amino.contains("spl"))) {
                return "nonsense";
            }
            if (amino.length() > 6 && amino.substring(0, 3).equals(amino.substring(amino.length() - 3))) {
                return "synonymous";
            }
            if (amino.contains("UTR")) {
                return "UTR";
            }
            if (amino.contains("Stop")) {
                if (amino.startsWith("Stop") && amino.endsWith("Stop")) {
                    return "synonymous";
                }
                return "nonsense";
            }
            if (!(amino.contains("UTR") || amino.contains("intro") || !amino.contains("if") && amino.substring(0, 3).equals(amino.substring(amino.length() - 3)))) {
                return "missense";
            }
            return "intronic";
        }
        if (amino.contains("fs") || amino.contains("spl") || amino.matches(".*Met1\\D+.*") && !amino.matches(".*Met1Met.*")) {
            return "nonsense";
        }
        String[] aminoTable = amino.split(";");
        boolean syn = false;
        boolean utr = amino.contains("UTR");
        boolean nonsense = false;
        int i = 0;
        while (i < aminoTable.length) {
            if (!syn && aminoTable[i].substring(0, 3).equals(aminoTable[i].substring(aminoTable[i].length() - 3))) {
                syn = true;
            } else {
                if (amino.contains("Stop")) {
                    if (amino.startsWith("Stop") && amino.endsWith("Stop")) {
                        syn = true;
                    } else {
                        return "nonsense";
                    }
                }
                if (!(aminoTable[i].contains("UTR") || aminoTable[i].contains("intro") || !aminoTable[i].contains("if") && aminoTable[i].substring(0, 3).equals(aminoTable[i].substring(aminoTable[i].length() - 3)))) {
                    return "missense";
                }
            }
            ++i;
        }
        if (nonsense) {
            return "nonsense";
        }
        if (syn) {
            return "synonymous";
        }
        if (utr) {
            return "UTR";
        }
        return "intronic";
    }

    static Double calcAffiniyChange(VarNode node, String alt, BedNode bednode) {
        if (alt == null || alt.length() > 1) {
            return 0.0;
        }
        if (bednode.getTrack().selex) {
            int index = node.getPosition() - bednode.getPosition();
            if (index < 0) {
                return 0.0;
            }
            int[][] matrix = null;
            matrix = bednode.forward != false ? Main.SELEXhash.get(bednode.id) : MethodLibrary.reverseMatrix(Main.SELEXhash.get(bednode.id));
            double sum = matrix[0][index] + matrix[1][index] + matrix[2][index] + matrix[3][index];
            Double value = (double)matrix[Main.baseMap.get(node.getRefBase()) - 1][index] / sum;
            double mutatedvalue = (double)matrix[Main.baseMap.get((byte)alt.charAt(0)) - 1][index] / sum;
            value = value * Math.log(value / Main.background.get(node.getRefBase()));
            if (mutatedvalue != 0.0) {
                mutatedvalue *= Math.log(mutatedvalue / Main.background.get((byte)alt.charAt(0)));
            }
            return mutatedvalue - value;
        }
        return 0.0;
    }

    static String getAminoAcid(String codon) {
        return ChromDraw.aminoacids.get(codon);
    }

    public static class BEDSorter
    implements Comparator<String[]> {
        @Override
        public int compare(String[] o1, String[] o2) {
            String[] f1 = o1;
            String[] f2 = o2;
            int retStatus = 0;
            retStatus = Integer.parseInt(f1[0]) < Integer.parseInt(f2[0]) ? -1 : (Integer.parseInt(f1[0]) > Integer.parseInt(f2[0]) ? 1 : (Integer.parseInt(f1[1]) < Integer.parseInt(f2[1]) ? -1 : (Integer.parseInt(f1[1]) > Integer.parseInt(f2[1]) ? 1 : (Integer.parseInt(f1[2]) < Integer.parseInt(f2[2]) ? -1 : (Integer.parseInt(f1[2]) > Integer.parseInt(f2[2]) ? 1 : 0)))));
            return retStatus;
        }
    }

    public static class ChromSorter
    implements Comparator<String> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(String o1, String o2) {
            Long n1 = null;
            Long n2 = null;
            if (o1.matches("^-?\\d+$")) {
                n1 = Long.parseLong(o1);
            }
            if (o2.matches("^-?\\d+$")) {
                n2 = Long.parseLong(o2);
            }
            if (n1 != null && n2 != null) {
                if (n1 < n2) {
                    return -1;
                }
                if (n1 <= n2) return 0;
                return 1;
            }
            if (n1 == null && n2 == null) {
                if (o1.length() != o2.length()) {
                    if (o1.length() < o2.length()) {
                        return -1;
                    }
                    if (o1.length() <= o2.length()) return 0;
                    return 1;
                }
                if (o1.compareTo(o2) < 0) {
                    return -1;
                }
                if (o1.compareTo(o2) <= 0) return 0;
                return 1;
            }
            if (n1 == null) return 1;
            return -1;
        }
    }

    public static class ReadListSorter
    implements Comparator<Object[]> {
        @Override
        public int compare(Object[] o1, Object[] o2) {
            Object[] f1 = o1;
            Object[] f2 = o2;
            if ((Integer)f1[0] < (Integer)f2[0]) {
                return -1;
            }
            if ((Integer)f1[0] < (Integer)f2[0]) {
                return 1;
            }
            return 0;
        }
    }

    public static class controlsorter
    implements Comparator<SampleNode> {
        @Override
        public int compare(SampleNode s1, SampleNode s2) {
            if (s1.getControlSample().getIndex() < s2.getControlSample().getIndex()) {
                return -1;
            }
            return 1;
        }
    }

    public static class mateListSorter
    implements Comparator<ReadNode> {
        @Override
        public int compare(ReadNode o1, ReadNode o2) {
            if ((double)o1.split.offset + ((double)o1.getPosition() - o1.split.start) * o1.split.pixel < (double)o2.split.offset + ((double)o2.getPosition() - o2.split.start) * o2.split.pixel) {
                return -1;
            }
            return 1;
        }
    }

    public static class varSorter
    implements Comparator<SampleNode> {
        @Override
        public int compare(SampleNode o1, SampleNode o2) {
            if (o1.getSample() == null || o2.getSample() == null) {
                return 1;
            }
            if (o1.getSample().getIndex() < o2.getSample().getIndex()) {
                return -1;
            }
            if (o1.getSample().getIndex() > o2.getSample().getIndex()) {
                return 1;
            }
            return 0;
        }
    }
}

