/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import htsjdk.samtools.CRAMFileReader;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class CoveragePattern {
    static SamReader samFileReader;
    static CRAMFileReader CRAMReader;
    static File indexFile;
    static ReferenceSource reference;
    static RandomAccessFile referenceFile;
    static boolean CRAM;
    static Iterator<SAMRecord> bamIterator;
    static File readfile;
    private static SAMRecord samRecord;

    static {
        CRAMReader = null;
        CRAM = false;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                System.out.println("Start the script: java -jar CoveragePattern.jar bamfile.bam bedfile.bed.gz reference.fa");
                System.exit(0);
            } else {
                String line;
                reference = new ReferenceSource(new File(args[2]));
                referenceFile = new RandomAccessFile(new File(args[2]), "r");
                BufferedReader reader = null;
                GZIPInputStream gzip = null;
                readfile = new File(args[0]);
                if (args[0].endsWith(".cram")) {
                    CRAM = true;
                }
                if (args[1].endsWith(".gz")) {
                    gzip = new GZIPInputStream(new FileInputStream(args[1]));
                    reader = new BufferedReader(new InputStreamReader(gzip));
                } else {
                    reader = new BufferedReader(new FileReader(args[1]));
                }
                reader.readLine();
                int[] coverages = new int[2039];
                block4: while ((line = reader.readLine()) != null) {
                    if (line.startsWith("2")) break;
                    String[] split = line.split("\\t");
                    int start = Integer.parseInt(split[1]);
                    int end = Integer.parseInt(split[2]);
                    if (split[5].equals("-")) continue;
                    bamIterator = CoveragePattern.getBamIterator(readfile, split[0], start - 1000, end + 1000);
                    while (bamIterator != null && bamIterator.hasNext()) {
                        try {
                            int index;
                            samRecord = bamIterator.next();
                            if (samRecord.getReadUnmappedFlag() || samRecord.getReadNegativeStrandFlag() || (index = samRecord.getUnclippedStart() - start + 1000) < 0) continue;
                            if (index > 2038) continue block4;
                            int n = index;
                            coverages[n] = coverages[n] + 1;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                int i = 0;
                while (i < coverages.length) {
                    System.out.print(String.valueOf(coverages[i]) + "\t");
                    ++i;
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    static Iterator<SAMRecord> getBamIterator(File readfile, String chrom, int startpos, int endpos) {
        block12: {
            if (CoveragePattern.samFileReader != null) {
                CoveragePattern.samFileReader.close();
            }
            if (!CoveragePattern.CRAM) break block12;
            if (CoveragePattern.indexFile == null) {
                CoveragePattern.indexFile = new File(readfile + ".crai");
            }
            if ((CoveragePattern.CRAMReader = new CRAMFileReader(readfile, CoveragePattern.indexFile, (CRAMReferenceSource)CoveragePattern.reference, ValidationStringency.SILENT)) != null && !CoveragePattern.CRAMReader.hasIndex()) {
                return null;
            }
            ** GOTO lbl22
            {
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        try {
            CoveragePattern.samFileReader = SamReaderFactory.make().open(readfile);
            if (CoveragePattern.samFileReader != null && !CoveragePattern.samFileReader.hasIndex()) {
                return null;
            }
            ** GOTO lbl22
        }
        catch (Exception e) {
            e.printStackTrace();
lbl22:
            // 3 sources

            if (CoveragePattern.CRAM) {
                interval = new QueryInterval[]{new QueryInterval(CoveragePattern.CRAMReader.getFileHeader().getSequence(chrom).getSequenceIndex(), startpos, endpos)};
                value = CoveragePattern.CRAMReader.query(interval, false);
                return value;
            }
            value = null;
            try {
                value = CoveragePattern.samFileReader.queryOverlapping(chrom, startpos, endpos);
            }
            catch (SAMFormatException e) {
                e.printStackTrace();
            }
            return value;
        }
    }
}

