/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

public class ConvertExons {
    public static void main(String[] args) {
        try {
            GZIPInputStream gzip = new GZIPInputStream(new FileInputStream("X:/cg8/Ensembl-update/fetch/exons37.temp.gz"));
            BufferedWriter writer = new BufferedWriter(new FileWriter("X:/cg8/Riku/exons.txt"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(gzip));
            String transcript = "";
            String header = "#Chrom\tGeneStart\tGeneEnd\tName\tExonCount\tStrand\tENSG\tENST\tUniProt\tCanonical\tBiotype\tCodingStart\tCodingEnd\tExonStarts\tExonEnds\tStartPhases\tDescription\n";
            int exoncount = 0;
            boolean first = true;
            boolean started = false;
            String line = reader.readLine();
            String[] split = line.split("\t");
            String chrom = "";
            String uniprot = "-";
            writer.write(header);
            while (first || (line = reader.readLine()) != null) {
                if (first) {
                    transcript = split[10];
                    first = false;
                    String name = split[1];
                    chrom = split[8].matches("23") ? "X" : (split[8].matches("24") ? "Y" : (split[8].matches("25") ? "MT" : split[8]));
                    exoncount = 0;
                    String description = split[5];
                    String ensg = split[0];
                    String codingstart = "";
                    String codingend = "";
                    String strand = split[9].equals("1") ? "+" : "-";
                    String biotype = split[2];
                    String canonical = split[4].equals(transcript) ? "1" : "-";
                    started = false;
                    StringBuffer exonstarts = new StringBuffer();
                    StringBuffer exonends = new StringBuffer();
                    StringBuffer phases = new StringBuffer();
                    while (transcript.equals(split[10])) {
                        exonstarts.append(Integer.parseInt(split[12]) - 1 + ",");
                        exonends.append(Integer.parseInt(split[13]) + ",");
                        if (strand.equals("+")) {
                            if (split.length < 17) {
                                phases.append(String.valueOf(split[14]) + ",");
                            } else if (!started) {
                                phases.append("0,");
                                codingstart = "" + (Integer.parseInt(split[12]) + Integer.parseInt(split[16]) - 2);
                                codingend = "" + (Integer.parseInt(split[12]) + Integer.parseInt(split[17].replaceAll(" ", "")) - 1);
                                started = true;
                            } else if (started) {
                                phases.append(String.valueOf(split[14]) + ",");
                                codingend = "" + (Integer.parseInt(split[12]) + Integer.parseInt(split[17].replaceAll(" ", "")) - 1);
                            }
                        } else {
                            String phase = split[14];
                            if (split.length < 17) {
                                phases.append(String.valueOf(phase) + ",");
                            } else if (!started) {
                                if (phase.equals("-1")) {
                                    phases.append("0,");
                                } else {
                                    phases.append(String.valueOf(phase) + ",");
                                }
                                codingstart = "" + (Integer.parseInt(split[13]) - Integer.parseInt(split[16]));
                                started = true;
                                codingend = "" + (Integer.parseInt(split[13]) - Integer.parseInt(split[17].replaceAll(" ", "")) + 1);
                            } else if (started) {
                                phases.append("0,");
                                codingend = "" + (Integer.parseInt(split[13]) - Integer.parseInt(split[17].replaceAll(" ", "")) + 1);
                            }
                        }
                        ++exoncount;
                        line = reader.readLine();
                        if (line == null) break;
                        split = line.split("\t");
                    }
                    first = true;
                    String genestart = exonstarts.toString().split(",")[0];
                    String geneend = exonends.toString().split(",")[exonends.toString().split(",").length - 1];
                    if (codingstart.equals("")) {
                        codingstart = geneend;
                        codingend = geneend;
                    }
                    writer.write(String.valueOf(chrom) + "\t" + genestart + "\t" + geneend + "\t" + name + "\t" + exoncount + "\t" + strand + "\t" + ensg + "\t" + transcript + "\t" + uniprot + "\t" + canonical + "\t" + biotype + "\t" + codingstart + "\t" + codingend + "\t" + exonstarts + "\t" + exonends + "\t" + phases + "\t" + description + "\n");
                }
                if (line != null) continue;
            }
            writer.close();
            reader.close();
            gzip.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

