/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.ColorColumnRenderer;
import base.BasePlayer.ComboRenderer;
import base.BasePlayer.Draw;
import base.BasePlayer.EditableHeader;
import base.BasePlayer.EditableHeaderTableColumn;
import base.BasePlayer.ExternalSort;
import base.BasePlayer.FileRead;
import base.BasePlayer.Main;
import base.BasePlayer.VariantHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class BEDconvert
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    JFrame frame = new JFrame("BED converter");
    JPanel panel = new JPanel(new GridBagLayout());
    static JTable table;
    JLabel info = new JLabel("Open tab separated files for BED conversion.");
    Object[][] data = new Object[0][];
    static HashMap<Integer, Boolean> editables;
    static HashMap<String, Integer> columnValues;
    static JScrollPane tableScroll;
    static TableColumnModel columnModel;
    static File infile;
    static DefaultTableModel tablemodel;
    String[][] selectdata = new String[0][];
    static String[] items;
    Object[] headers = new Object[0];
    ArrayList<String> header = new ArrayList();
    boolean changing = false;
    ArrayList<JComboBox<String>> comboboxes = new ArrayList();
    JTableHeader tableHeader;
    JButton open = new JButton("Open");
    JButton write = new JButton("Convert");
    boolean found = false;
    boolean tableSet = false;
    ActionListener comboActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getActionCommand() == "comboBoxChanged") {
                    if (columnValues.size() == 0) {
                        return;
                    }
                    if (BEDconvert.this.changing) {
                        return;
                    }
                    JComboBox comboBox = (JComboBox)actionEvent.getSource();
                    BEDconvert.this.checkHeadSelect(comboBox);
                    BEDconvert.this.checkHeaders();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    static int addedItems;

    static {
        editables = new HashMap();
        columnValues = new HashMap();
        tableScroll = new JScrollPane();
        infile = null;
        items = new String[]{"Select", "Chromosome", "Start", "End", "Name", "Score", "Strand"};
        addedItems = 0;
    }

    void checkHeadSelect(JComboBox<String> comboBox) {
        int i = 0;
        while (i < this.comboboxes.size()) {
            if (!this.comboboxes.get(i).equals(comboBox) && !this.comboboxes.get(i).getSelectedItem().toString().equals("Editable") && this.comboboxes.get(i).getSelectedItem().toString().equals(comboBox.getSelectedItem().toString())) {
                this.changing = true;
                this.comboboxes.get(i).setSelectedIndex(0);
                EditableHeaderTableColumn col = (EditableHeaderTableColumn)table.getColumnModel().getColumn(i);
                col.setHeaderValue("Select");
                this.comboboxes.get(i).revalidate();
                this.comboboxes.get(i).repaint();
                table.revalidate();
                table.repaint();
                this.changing = false;
                break;
            }
            ++i;
        }
    }

    void checkHeaders() {
        columnValues.put("Select", -1);
        columnValues.put("Chromosome", -1);
        columnValues.put("Start", -1);
        columnValues.put("End", -1);
        columnValues.put("Name", -1);
        columnValues.put("Score", -1);
        columnValues.put("Strand", -1);
        int i = 0;
        while (i < table.getColumnModel().getColumnCount()) {
            EditableHeaderTableColumn col = (EditableHeaderTableColumn)table.getColumnModel().getColumn(i);
            columnValues.put(col.getHeaderValue().toString(), i);
            ++i;
        }
        table.revalidate();
        tableScroll.revalidate();
        table.repaint();
    }

    void setWindow() {
        try {
            JFrame.setDefaultLookAndFeelDecorated(false);
            if (VariantHandler.aminoCount == null) {
                this.frame.setVisible(true);
                this.frame.setDefaultCloseOperation(3);
            } else {
                this.frame.setVisible(false);
            }
            this.frame.setContentPane(this);
            this.frame.setResizable(true);
            this.frame.setMinimumSize(new Dimension(600, 300));
            this.createTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BEDconvert() {
        super(new GridBagLayout());
        this.setWindow();
    }

    void createTable(File file) {
        try {
            String line;
            addedItems = 0;
            int headercount = 4;
            int rows = 0;
            BufferedReader reader = null;
            GZIPInputStream gzip = null;
            tablemodel = new DefaultTableModel(this.data, new Object[]{"", "", "", ""});
            table = new JTable(tablemodel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            table.addMouseListener(this);
            columnModel = table.getColumnModel();
            table.setTableHeader(new EditableHeader(columnModel));
            if (file.getName().endsWith(".gz")) {
                try {
                    gzip = new GZIPInputStream(new FileInputStream(file));
                    reader = new BufferedReader(new InputStreamReader(gzip));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                reader = new BufferedReader(new FileReader(file));
            }
            this.comboboxes.clear();
            tablemodel.setRowCount(0);
            int rowlimit = 20;
            boolean first = true;
            this.header.clear();
            while ((line = reader.readLine()) != null) {
                int i;
                Object[] row;
                if (line.startsWith("!")) continue;
                if (line.startsWith("#") || line.startsWith("track")) {
                    if (!line.startsWith("#")) {
                        line = "#" + line;
                    }
                    this.header.add(line);
                    continue;
                }
                if (first) {
                    if (this.header.size() > 0) {
                        row = this.header.get(this.header.size() - 1).split("\t");
                        if (row.length > headercount) {
                            i = 0;
                            while (i < row.length - headercount) {
                                tablemodel.addColumn("new");
                                ++i;
                            }
                            headercount = row.length;
                        }
                        tablemodel.addRow(row);
                    }
                    first = false;
                }
                if (rows > rowlimit) break;
                row = line.split("\t");
                ++rows;
                if (row.length > headercount) {
                    i = 0;
                    while (i < row.length - headercount) {
                        tablemodel.addColumn("new");
                        ++i;
                    }
                    headercount = row.length;
                }
                tablemodel.addRow(row);
            }
            reader.close();
            if (rows == 0) {
                Main.showError("Could not find any rows in the file.", "Error");
                return;
            }
            columnModel = table.getColumnModel();
            table.setTableHeader(new EditableHeader(columnModel));
            String[] items = new String[]{"Select", "Chromosome", "Start", "End", "Name", "Score", "Strand"};
            ComboRenderer renderer = new ComboRenderer(items);
            ColorColumnRenderer columnRenderer = new ColorColumnRenderer(new Color(150, 255, 150), table);
            int i = 0;
            while (i < columnModel.getColumnCount()) {
                JComboBox<String> combo = new JComboBox<String>();
                int c = 0;
                while (c < items.length) {
                    combo.addItem(items[c]);
                    ++c;
                }
                combo.addActionListener(this.comboActionListener);
                EditableHeaderTableColumn col = (EditableHeaderTableColumn)columnModel.getColumn(i);
                col.setHeaderValue("Select");
                col.setCellRenderer(columnRenderer);
                col.setHeaderRenderer(renderer);
                col.setHeaderEditor(new DefaultCellEditor(combo));
                this.comboboxes.add(combo);
                ++i;
            }
            this.checkTable(table);
            tableScroll.getViewport().removeAll();
            tableScroll.getViewport().add(table);
            table.revalidate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void checkTable(JTable table) {
        EditableHeaderTableColumn col;
        TableColumnModel columnModel = table.getColumnModel();
        if (table.getRowCount() < 2) {
            return;
        }
        int chrindex = -1;
        int startindex = -1;
        int endindex = -1;
        int nameindex = -1;
        int scoreindex = -1;
        int strandindex = -1;
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            try {
                if (table.getValueAt(0, i).toString().contains("chr") || table.getValueAt(1, i).toString().contains("chr") || table.getValueAt(0, i).toString().contains("genoName")) {
                    chrindex = i;
                    col = (EditableHeaderTableColumn)columnModel.getColumn(i);
                    this.comboboxes.get(i).setSelectedItem("Chromosome");
                    col.setHeaderValue(this.comboboxes.get(i).getSelectedItem().toString());
                    this.checkHeadSelect(this.comboboxes.get(i));
                    break;
                }
            }
            catch (Exception e) {
                System.out.println(table.getValueAt(0, 0).toString());
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < columnModel.getColumnCount() - 1) {
            block32: {
                if (table.getValueAt(0, i + 1) != null && table.getValueAt(0, i) != null && table.getValueAt(0, i).toString().toLowerCase().contains("start") && table.getValueAt(0, i + 1).toString().toLowerCase().contains("end")) {
                    try {
                        Integer.parseInt(table.getValueAt(1, i).toString());
                        Integer.parseInt(table.getValueAt(1, i + 1).toString());
                    }
                    catch (Exception e) {
                        break block32;
                    }
                    startindex = i;
                    endindex = i + 1;
                    col = (EditableHeaderTableColumn)columnModel.getColumn(i);
                    this.comboboxes.get(i).setSelectedItem("Start");
                    this.comboboxes.get(i + 1).setSelectedItem("End");
                    col.setHeaderValue(this.comboboxes.get(i).getSelectedItem().toString());
                    col = (EditableHeaderTableColumn)columnModel.getColumn(i + 1);
                    col.setHeaderValue(this.comboboxes.get(i + 1).getSelectedItem().toString());
                    break;
                }
            }
            ++i;
        }
        if (startindex < 0 && columnModel.getColumnCount() > chrindex + 2) {
            int start = -1;
            int end = 0;
            try {
                start = Integer.parseInt(table.getValueAt(1, chrindex + 1).toString());
                end = Integer.parseInt(table.getValueAt(1, chrindex + 2).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (start > -1 && end > start) {
                startindex = chrindex + 1;
                endindex = chrindex + 2;
                EditableHeaderTableColumn col2 = (EditableHeaderTableColumn)columnModel.getColumn(startindex);
                this.comboboxes.get(startindex).setSelectedItem("Start");
                col2.setHeaderValue(this.comboboxes.get(startindex).getSelectedItem().toString());
                col2 = (EditableHeaderTableColumn)columnModel.getColumn(endindex);
                this.comboboxes.get(endindex).setSelectedItem("End");
                col2.setHeaderValue(this.comboboxes.get(endindex).getSelectedItem().toString());
            }
        }
        i = 0;
        while (i < columnModel.getColumnCount()) {
            if (table.getValueAt(0, i) != null && table.getValueAt(0, i).toString().toLowerCase().contains("name") && i != chrindex) {
                nameindex = i;
                EditableHeaderTableColumn col3 = (EditableHeaderTableColumn)columnModel.getColumn(i);
                this.comboboxes.get(i).setSelectedItem("Name");
                col3.setHeaderValue(this.comboboxes.get(i).getSelectedItem().toString());
                break;
            }
            ++i;
        }
        if (nameindex < 0 && endindex == 2 && table.getColumnCount() > 3 && table.getValueAt(1, 3) != null) {
            nameindex = 3;
            EditableHeaderTableColumn col4 = (EditableHeaderTableColumn)columnModel.getColumn(3);
            if (col4.getHeaderValue().toString().equals("Select")) {
                this.comboboxes.get(3).setSelectedItem("Name");
                col4.setHeaderValue(this.comboboxes.get(3).getSelectedItem().toString());
            }
        }
        i = 0;
        while (i < columnModel.getColumnCount()) {
            block33: {
                if (table.getValueAt(0, i) != null && table.getValueAt(0, i).toString().toLowerCase().contains("score")) {
                    try {
                        Double.parseDouble(table.getValueAt(1, i).toString());
                    }
                    catch (Exception e) {
                        break block33;
                    }
                    scoreindex = i;
                    EditableHeaderTableColumn col5 = (EditableHeaderTableColumn)columnModel.getColumn(i);
                    this.comboboxes.get(i).setSelectedItem("Score");
                    col5.setHeaderValue(this.comboboxes.get(i).getSelectedItem().toString());
                    break;
                }
            }
            ++i;
        }
        i = 0;
        while (i < columnModel.getColumnCount()) {
            if (table.getValueAt(0, i) != null && table.getValueAt(0, i).toString().toLowerCase().contains("strand") && (table.getValueAt(1, i).toString().equals("+") || table.getValueAt(1, i).toString().equals("-"))) {
                strandindex = i;
                EditableHeaderTableColumn col6 = (EditableHeaderTableColumn)columnModel.getColumn(i);
                this.comboboxes.get(i).setSelectedItem("Strand");
                col6.setHeaderValue(this.comboboxes.get(i).getSelectedItem().toString());
                break;
            }
            ++i;
        }
        if (strandindex < 0) {
            i = 0;
            while (i < columnModel.getColumnCount()) {
                if (table.getValueAt(1, i) != null && (table.getValueAt(1, i).toString().equals("+") || table.getValueAt(1, i).toString().equals("-"))) {
                    strandindex = i;
                    EditableHeaderTableColumn col7 = (EditableHeaderTableColumn)columnModel.getColumn(i);
                    this.comboboxes.get(i).setSelectedItem("Strand");
                    col7.setHeaderValue(this.comboboxes.get(i).getSelectedItem().toString());
                    break;
                }
                ++i;
            }
        }
        if (scoreindex < 0 && chrindex > -1) {
            i = 0;
            while (i < columnModel.getColumnCount()) {
                block34: {
                    if (table.getValueAt(1, i) != null) {
                        try {
                            Double.parseDouble(table.getValueAt(1, i).toString());
                        }
                        catch (Exception e) {
                            break block34;
                        }
                        EditableHeaderTableColumn col8 = (EditableHeaderTableColumn)columnModel.getColumn(i);
                        if (col8.getHeaderValue().equals("Select")) {
                            this.comboboxes.get(i).setSelectedItem("Score");
                            col8.setHeaderValue(this.comboboxes.get(i).getSelectedItem().toString());
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        this.checkHeaders();
    }

    void createTable() {
        try {
            tablemodel = new DefaultTableModel(this.data, new Object[]{"", "", "", ""});
            table = new JTable(tablemodel){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            int i = 0;
            while (i < 40) {
                tablemodel.addRow(new String[]{"", "", "", ""});
                ++i;
            }
            table.addMouseListener(this);
            columnModel = table.getColumnModel();
            table.setTableHeader(new EditableHeader(columnModel));
            this.frame.addMouseListener(this);
            ComboRenderer renderer = new ComboRenderer(items);
            ColorColumnRenderer columnRenderer = new ColorColumnRenderer(new Color(150, 255, 150), table);
            int i2 = 0;
            while (i2 < columnModel.getColumnCount()) {
                JComboBox<String> combo = new JComboBox<String>();
                int c = 0;
                while (c < items.length) {
                    combo.addItem(items[c]);
                    ++c;
                }
                combo.addActionListener(this.comboActionListener);
                EditableHeaderTableColumn col = (EditableHeaderTableColumn)columnModel.getColumn(i2);
                col.setCellRenderer(columnRenderer);
                col.setHeaderValue(combo.getItemAt(0));
                col.setHeaderRenderer(renderer);
                col.setHeaderEditor(new DefaultCellEditor(combo));
                this.comboboxes.add(combo);
                ++i2;
            }
            this.panel.setBackground(Draw.sidecolor);
            columnValues.put("Select", -1);
            columnValues.put("Chromosome", -1);
            columnValues.put("Start", -1);
            columnValues.put("End", -1);
            columnValues.put("Name", -1);
            columnValues.put("Score", -1);
            columnValues.put("Strand", -1);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 18;
            this.panel.add((Component)this.open, c);
            ++c.gridx;
            this.panel.add((Component)this.write, c);
            ++c.gridx;
            this.panel.add((Component)this.info, c);
            ++c.gridx;
            c.gridx = 0;
            this.open.addActionListener(this);
            this.write.addActionListener(this);
            this.write.setPreferredSize(Main.buttonDimension);
            this.write.setMinimumSize(Main.buttonDimension);
            this.open.setPreferredSize(Main.buttonDimension);
            this.open.setMinimumSize(Main.buttonDimension);
            ++c.gridy;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.fill = 2;
            table.setAutoResizeMode(4);
            table.setVisible(true);
            c.weighty = 1.0;
            c.fill = 1;
            tableScroll.getViewport().add(table);
            this.panel.add((Component)tableScroll, c);
            this.add((Component)this.panel, c);
            this.frame.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setFonts(Font menuFont) {
        int i = 0;
        while (i < this.panel.getComponentCount()) {
            this.panel.getComponent(i).setFont(menuFont);
            ++i;
        }
        if (table != null) {
            table.getTableHeader().setFont(menuFont);
            table.setFont(menuFont);
        }
        this.frame.pack();
    }

    public static void main(String[] args) {
        BEDconvert conv = new BEDconvert();
        conv.frame.setVisible(true);
        conv.frame.setDefaultCloseOperation(3);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.write) {
            try {
                String filename;
                File savefile = null;
                FileDialog fs = new FileDialog((Frame)this.frame, "Save BED file to...", 1);
                fs.setDirectory(Main.trackDir);
                fs.setFile("*.bed.gz");
                fs.setVisible(true);
                while ((filename = fs.getFile()) != null) {
                    savefile = new File(String.valueOf(fs.getDirectory()) + "/" + filename);
                    if (!Files.isWritable(Paths.get(savefile.getParent(), new String[0]))) {
                        Main.showError("No permission to write.", "Error", tableScroll);
                        continue;
                    }
                    if (savefile.getName().endsWith(".bed.gz")) break;
                    savefile = savefile.getName().endsWith(".bed") ? new File(String.valueOf(savefile.getCanonicalPath()) + ".gz") : new File(String.valueOf(savefile.getCanonicalPath()) + ".bed.gz");
                    break;
                }
                if (savefile != null) {
                    if (columnValues.get("Chromosome") < 0) {
                        Main.showError("Select chromosome column.", "Note", tableScroll);
                        return;
                    }
                    if (columnValues.get("Start") < 0) {
                        Main.showError("Select start position column.", "Note", tableScroll);
                        return;
                    }
                    ExternalSort.columns.clear();
                    ExternalSort.columns.add(-1);
                    ExternalSort.columns.add(-1);
                    ExternalSort.columns.add(-1);
                    ExternalSort.columns.add(-1);
                    ExternalSort.columns.add(-1);
                    ExternalSort.columns.add(-1);
                    if (columnValues.get("Strand") > -1) {
                        ExternalSort.columns.set(5, columnValues.get("Strand"));
                    } else {
                        ExternalSort.columns.remove(5);
                    }
                    if (columnValues.get("Score") > -1) {
                        ExternalSort.columns.set(4, columnValues.get("Score"));
                    } else if (ExternalSort.columns.size() == 5) {
                        ExternalSort.columns.remove(4);
                    }
                    if (columnValues.get("Name") > -1) {
                        ExternalSort.columns.set(3, columnValues.get("Name"));
                    } else if (ExternalSort.columns.size() == 4) {
                        ExternalSort.columns.remove(3);
                    }
                    ExternalSort.columns.set(0, columnValues.get("Chromosome"));
                    ExternalSort.columns.set(1, columnValues.get("Start"));
                    if (columnValues.get("End") >= 0) {
                        ExternalSort.columns.set(2, columnValues.get("End"));
                    } else {
                        ExternalSort.columns.set(2, columnValues.get("Start"));
                    }
                    ExternalSort.chrindex = columnValues.get("Chromosome");
                    ExternalSort.startindex = columnValues.get("Start");
                    Main.trackDir = savefile.getParent();
                    Main.writeToConfig("DefaultTrackDir=" + Main.trackDir);
                    OutputRunner runner2 = new OutputRunner(savefile);
                    runner2.execute();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (event.getSource() == this.open) {
            FileDialog chooser = new FileDialog((Frame)this.frame, "Choose a tab separated file", 0);
            chooser.setDirectory(Main.trackDir);
            chooser.setVisible(true);
            String filename = chooser.getFile();
            if (filename != null) {
                File addfile = new File(String.valueOf(chooser.getDirectory()) + "/" + filename);
                if (addfile.exists()) {
                    infile = addfile;
                    this.createTable(infile);
                    this.info.setText("Select correct header values for BED columns. File: " + infile.getName());
                } else {
                    Main.showError("File does not exists.", "Error", this.frame);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        EditableHeader header = (EditableHeader)table.getTableHeader();
        header.removeEditor();
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        EditableHeader header = (EditableHeader)table.getTableHeader();
        header.removeEditor();
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    class OutputRunner
    extends SwingWorker<String, Object> {
        File outfile;

        public OutputRunner(File outfile) {
            this.outfile = outfile;
        }

        @Override
        protected String doInBackground() {
            if (Main.drawCanvas != null) {
                Main.drawCanvas.loading("Converting " + this.outfile.getName());
            }
            BEDconvert.this.frame.setState(1);
            BEDconvert.this.frame.setCursor(Cursor.getPredefinedCursor(3));
            ExternalSort.processFile(infile, this.outfile);
            BEDconvert.this.frame.setCursor(Cursor.getPredefinedCursor(0));
            if (Main.drawCanvas != null) {
                Main.drawCanvas.ready("all");
            }
            BEDconvert.this.frame.setState(0);
            if (JOptionPane.showConfirmDialog(tableScroll, "Open BED file?", "Open?", 0, 3) == 0) {
                File[] bedfile = new File[]{this.outfile};
                FileRead filereader = new FileRead(bedfile);
                filereader.readBED(bedfile);
            }
            return "";
        }
    }
}

