/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BBfile.BBFileHeader;
import base.BBfile.BBTotalSummaryBlock;
import base.BBfile.BBZoomLevels;
import base.BBfile.BPTree;
import base.BBfile.BigBedIterator;
import base.BBfile.BigWigIterator;
import base.BBfile.RPChromosomeRegion;
import base.BBfile.RPTree;
import base.BBfile.ZoomLevelIterator;
import base.BasePlayer.BedTrack;
import base.BasePlayer.Main;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class BBFileReader {
    public static final long BBFILE_HEADER_OFFSET = 0L;
    private SeekableStream fis;
    private long fileOffset;
    static BBFileHeader fileHeader;
    private boolean isLowToHigh;
    private int uncompressBufSize;
    private int zoomLevelCount;
    private long zoomLevelOffset;
    private BBZoomLevels zoomLevels;
    private BBTotalSummaryBlock totalSummaryBlock;
    private long chromIDTreeOffset;
    private BPTree chromosomeIDTree;
    private long chromDataTreeOffset;
    private RPTree chromosomeDataTree;
    private String autoSql;

    public BBFileReader(String path, BedTrack track) throws IOException {
        this(path, SeekableStreamFactory.getInstance().getStreamFor(path), track);
    }

    public BBFileReader(URL path, BedTrack track) throws IOException {
        this(path.getPath(), SeekableStreamFactory.getInstance().getStreamFor(path), track);
    }

    public BBFileReader(String path, SeekableStream stream, BedTrack track) throws IOException {
        this.fis = stream;
        if (track.getFileHeader() == null) {
            this.fileOffset = 0L;
            track.setFileHeader(new BBFileHeader(path, this.fis, this.fileOffset));
        }
        Main.drawCanvas.loadbarAll = 30;
        Main.drawCanvas.loadBarSample = 30;
        fileHeader = track.getFileHeader();
        if (!fileHeader.isHeaderOK()) {
            throw new RuntimeException("Error reading BBFile header for: " + path);
        }
        this.isLowToHigh = fileHeader.isLowToHigh();
        this.uncompressBufSize = fileHeader.getUncompressBuffSize();
        this.fileOffset += 64L;
        this.zoomLevelCount = fileHeader.getZoomLevels();
        if (this.zoomLevelCount > 0) {
            this.zoomLevelOffset = this.fileOffset;
            if (track.getZoomlevels() == null) {
                track.setZoomlevels(new BBZoomLevels(this.fis, this.zoomLevelOffset, this.zoomLevelCount, this.isLowToHigh, this.uncompressBufSize));
            }
            this.zoomLevels = track.getZoomlevels();
            this.fileOffset += (long)(this.zoomLevelCount * 24);
        }
        if (!Main.drawCanvas.loading) {
            return;
        }
        Main.drawCanvas.loadbarAll = 60;
        Main.drawCanvas.loadBarSample = 60;
        long autoSqlOffset = fileHeader.getAutoSqlOffset();
        if (autoSqlOffset != 0L) {
            this.fis.seek(autoSqlOffset);
            this.autoSql = BBFileReader.readNullTerminatedString(this.fis);
        }
        this.fileOffset = fileHeader.getTotalSummaryOffset();
        if (fileHeader.getVersion() >= 2 && this.fileOffset > 0L) {
            this.totalSummaryBlock = new BBTotalSummaryBlock(this.fis, this.fileOffset, this.isLowToHigh);
            this.fileOffset += 40L;
        }
        this.chromIDTreeOffset = fileHeader.getChromosomeTreeOffset();
        if (this.chromIDTreeOffset != 0L) {
            this.fileOffset = this.chromIDTreeOffset;
            this.chromosomeIDTree = new BPTree(this.fis, this.fileOffset, this.isLowToHigh);
        }
        this.chromDataTreeOffset = fileHeader.getFullIndexOffset();
        if (this.chromDataTreeOffset != 0L) {
            this.fileOffset = this.chromDataTreeOffset;
            boolean forceDescend = false;
            this.chromosomeDataTree = new RPTree(this.fis, this.fileOffset, this.isLowToHigh, this.uncompressBufSize, forceDescend);
        }
        if (!Main.drawCanvas.loading) {
            return;
        }
        Main.drawCanvas.loadbarAll = 90;
        Main.drawCanvas.loadBarSample = 90;
        this.fileOffset = fileHeader.getFullDataOffset();
    }

    public BBFileHeader getBBFileHeader() {
        return fileHeader;
    }

    public boolean isBigBedFile() {
        return fileHeader.isBigBed();
    }

    public boolean isBigWigFile() {
        return fileHeader.isBigWig();
    }

    public boolean isLowToHigh() {
        return this.isLowToHigh;
    }

    public BBTotalSummaryBlock getTotalSummaryBlock() {
        return this.totalSummaryBlock;
    }

    public BBZoomLevels getZoomLevels() {
        return this.zoomLevels;
    }

    public ArrayList<String> getChromosomeNames() {
        ArrayList<String> chromosomeList = this.chromosomeIDTree.getChromosomeNames();
        return chromosomeList;
    }

    public String getAutoSql() {
        return this.autoSql;
    }

    public synchronized BigBedIterator getBigBedIterator(String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (!this.isBigBedFile()) {
            return null;
        }
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return new BigBedIterator();
        }
        BigBedIterator bedIterator = new BigBedIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, selectionRegion, contained);
        return bedIterator;
    }

    public synchronized BigWigIterator getBigWigIterator(String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (!this.isBigWigFile()) {
            return null;
        }
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return new BigWigIterator();
        }
        BigWigIterator wigIterator = new BigWigIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, selectionRegion, contained);
        return wigIterator;
    }

    public synchronized ZoomLevelIterator getZoomLevelIterator(int zoomLevel, String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (zoomLevel < 1 || zoomLevel > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree zoomDataTree = this.zoomLevels.getZoomLevelRPTree(zoomLevel);
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        ZoomLevelIterator zoomIterator = new ZoomLevelIterator(this.fis, this.chromosomeIDTree, zoomDataTree, zoomLevel, selectionRegion, contained);
        return zoomIterator;
    }

    public synchronized ZoomLevelIterator getZoomLevelIterator(int zoomLevel) {
        if (zoomLevel < 1 || zoomLevel > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree zoomDataTree = this.zoomLevels.getZoomLevelRPTree(zoomLevel);
        RPChromosomeRegion selectionRegion = zoomDataTree.getChromosomeBounds();
        boolean contained = true;
        ZoomLevelIterator zoomIterator = new ZoomLevelIterator(this.fis, this.chromosomeIDTree, zoomDataTree, zoomLevel, selectionRegion, contained);
        return zoomIterator;
    }

    private RPChromosomeRegion getChromosomeBounds(String startChromosome, int startBase, String endChromosome, int endBase) {
        if (startChromosome.length() > this.chromosomeIDTree.getKeySize()) {
            return null;
        }
        String startChromKey = this.chromosomeIDTree.getChromosomeKey(startChromosome);
        int startChromID = this.chromosomeIDTree.getChromosomeID(startChromKey);
        if (startChromID < 0) {
            return null;
        }
        String endChromKey = this.chromosomeIDTree.getChromosomeKey(endChromosome);
        int endChromID = this.chromosomeIDTree.getChromosomeID(endChromKey);
        if (endChromID < 0) {
            return null;
        }
        RPChromosomeRegion chromBounds = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
        return chromBounds;
    }

    private static String readNullTerminatedString(InputStream fis) throws IOException {
        byte b;
        BufferedInputStream bis = new BufferedInputStream(fis, 1000);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(100);
        while ((b = (byte)bis.read()) != 0) {
            bos.write(b);
        }
        return new String(bos.toByteArray());
    }
}

