/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;

public enum VCFHeaderVersion {
    VCF3_2("VCRv3.2", "format"),
    VCF3_3("VCFv3.3", "fileformat"),
    VCF4_0("VCFv4.0", "fileformat"),
    VCF4_1("VCFv4.1", "fileformat"),
    VCF4_2("VCFv4.2", "fileformat");

    private final String versionString;
    private final String formatString;

    private VCFHeaderVersion(String vString, String fString) {
        this.versionString = vString;
        this.formatString = fString;
    }

    public static VCFHeaderVersion toHeaderVersion(String version) {
        version = VCFHeaderVersion.clean(version);
        VCFHeaderVersion[] vCFHeaderVersionArray = VCFHeaderVersion.values();
        int n = vCFHeaderVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            VCFHeaderVersion hv = vCFHeaderVersionArray[n2];
            if (hv.versionString.equals(version)) {
                return hv;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isVersionString(String version) {
        return VCFHeaderVersion.toHeaderVersion(version) != null;
    }

    public static boolean isFormatString(String format) {
        format = VCFHeaderVersion.clean(format);
        VCFHeaderVersion[] vCFHeaderVersionArray = VCFHeaderVersion.values();
        int n = vCFHeaderVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            VCFHeaderVersion hv = vCFHeaderVersionArray[n2];
            if (hv.formatString.equals(format)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static VCFHeaderVersion getHeaderVersion(String versionLine) {
        String[] lineFields = versionLine.split("=");
        if (lineFields.length != 2 || !VCFHeaderVersion.isFormatString(lineFields[0].substring(2))) {
            throw new TribbleException.InvalidHeader(String.valueOf(versionLine) + " is not a valid VCF version line");
        }
        if (!VCFHeaderVersion.isVersionString(lineFields[1])) {
            throw new TribbleException.InvalidHeader(String.valueOf(lineFields[1]) + " is not a supported version");
        }
        return VCFHeaderVersion.toHeaderVersion(lineFields[1]);
    }

    private static String clean(String s) {
        return s.trim();
    }

    public boolean isAtLeastAsRecentAs(VCFHeaderVersion target) {
        switch (target) {
            case VCF4_2: {
                return this == VCF4_2;
            }
            case VCF4_1: {
                return this == VCF4_1 || this == VCF4_2;
            }
            case VCF4_0: {
                return this != VCF3_2 && this != VCF3_3;
            }
            case VCF3_3: {
                return this != VCF3_2;
            }
        }
        return true;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getFormatString() {
        return this.formatString;
    }
}

