/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineTranslator;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class VCFCompoundHeaderLine
extends VCFHeaderLine
implements VCFIDHeaderLine {
    private String name;
    private int count = -1;
    private VCFHeaderLineCount countType;
    private String description;
    private VCFHeaderLineType type;
    private String source;
    private String version;
    private final SupportedHeaderLineType lineType;

    @Override
    public String getID() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public VCFHeaderLineType getType() {
        return this.type;
    }

    public VCFHeaderLineCount getCountType() {
        return this.countType;
    }

    public boolean isFixedCount() {
        return this.countType == VCFHeaderLineCount.INTEGER;
    }

    public int getCount() {
        if (!this.isFixedCount()) {
            throw new TribbleException("Asking for header line count when type is not an integer");
        }
        return this.count;
    }

    public String getSource() {
        return this.source;
    }

    public String getVersion() {
        return this.version;
    }

    public int getCount(VariantContext vc) {
        switch (this.countType) {
            case INTEGER: {
                return this.count;
            }
            case UNBOUNDED: {
                return -1;
            }
            case A: {
                return vc.getNAlleles() - 1;
            }
            case R: {
                return vc.getNAlleles();
            }
            case G: {
                int ploidy = vc.getMaxPloidy(2);
                return GenotypeLikelihoods.numLikelihoods(vc.getNAlleles(), ploidy);
            }
        }
        throw new TribbleException("Unknown count type: " + (Object)((Object)this.countType));
    }

    public void setNumberToUnbounded() {
        this.countType = VCFHeaderLineCount.UNBOUNDED;
        this.count = -1;
    }

    protected VCFCompoundHeaderLine(String name, int count, VCFHeaderLineType type, String description, SupportedHeaderLineType lineType) {
        this(name, count, type, description, lineType, null, null);
    }

    protected VCFCompoundHeaderLine(String name, VCFHeaderLineCount count, VCFHeaderLineType type, String description, SupportedHeaderLineType lineType) {
        this(name, count, type, description, lineType, null, null);
    }

    protected VCFCompoundHeaderLine(String name, int count, VCFHeaderLineType type, String description, SupportedHeaderLineType lineType, String source, String version) {
        super(lineType.toString(), "");
        this.name = name;
        this.countType = VCFHeaderLineCount.INTEGER;
        this.count = count;
        this.type = type;
        this.description = description;
        this.lineType = lineType;
        this.source = source;
        this.version = version;
        this.validate();
    }

    protected VCFCompoundHeaderLine(String name, VCFHeaderLineCount count, VCFHeaderLineType type, String description, SupportedHeaderLineType lineType, String source, String version) {
        super(lineType.toString(), "");
        this.name = name;
        this.countType = count;
        this.type = type;
        this.description = description;
        this.lineType = lineType;
        this.source = source;
        this.version = version;
        this.validate();
    }

    protected VCFCompoundHeaderLine(String line, VCFHeaderVersion version, SupportedHeaderLineType lineType) {
        super(lineType.toString(), "");
        ArrayList<String> expectedTags = new ArrayList<String>(Arrays.asList("ID", "Number", "Type", "Description"));
        List<String> recommendedTags = version.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_2) ? Arrays.asList("Source", "Version") : Collections.emptyList();
        Map<String, String> mapping = VCFHeaderLineTranslator.parseLine(version, line, expectedTags, recommendedTags);
        this.name = mapping.get("ID");
        this.count = -1;
        String numberStr = mapping.get("Number");
        if (numberStr.equals("A")) {
            this.countType = VCFHeaderLineCount.A;
        } else if (numberStr.equals("R")) {
            this.countType = VCFHeaderLineCount.R;
        } else if (numberStr.equals("G")) {
            this.countType = VCFHeaderLineCount.G;
        } else if (version.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_0) && numberStr.equals(".") || !version.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_0) && numberStr.equals("-1")) {
            this.countType = VCFHeaderLineCount.UNBOUNDED;
        } else {
            this.countType = VCFHeaderLineCount.INTEGER;
            this.count = Integer.parseInt(numberStr);
        }
        if (this.count < 0 && this.countType == VCFHeaderLineCount.INTEGER) {
            throw new TribbleException.InvalidHeader("Count < 0 for fixed size VCF header field " + this.name);
        }
        try {
            this.type = VCFHeaderLineType.valueOf(mapping.get("Type"));
        }
        catch (Exception e) {
            throw new TribbleException(String.valueOf(mapping.get("Type")) + " is not a valid type in the VCF specification (note that types are case-sensitive)");
        }
        if (this.type == VCFHeaderLineType.Flag && !this.allowFlagValues()) {
            throw new IllegalArgumentException("Flag is an unsupported type for this kind of field");
        }
        this.description = mapping.get("Description");
        if (this.description == null) {
            this.description = "Not provided in original VCF header";
        }
        this.lineType = lineType;
        if (version.isAtLeastAsRecentAs(VCFHeaderVersion.VCF4_2)) {
            this.source = mapping.get("Source");
            this.version = mapping.get("Version");
        }
        this.validate();
    }

    private void validate() {
        if (this.type != VCFHeaderLineType.Flag && this.countType == VCFHeaderLineCount.INTEGER && this.count <= 0) {
            throw new IllegalArgumentException(String.format("Invalid count number, with fixed count the number should be 1 or higher: key=%s name=%s type=%s desc=%s lineType=%s count=%s", new Object[]{this.getKey(), this.name, this.type, this.description, this.lineType, this.count}));
        }
        if (this.name == null || this.type == null || this.description == null || this.lineType == null) {
            throw new IllegalArgumentException(String.format("Invalid VCFCompoundHeaderLine: key=%s name=%s type=%s desc=%s lineType=%s", new Object[]{this.getKey(), this.name, this.type, this.description, this.lineType}));
        }
        if (this.name.contains("<") || this.name.contains(">")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain angle brackets");
        }
        if (this.name.contains("=")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain an equals sign");
        }
        if (this.type == VCFHeaderLineType.Flag && this.count != 0) {
            this.count = 0;
        }
    }

    @Override
    protected String toStringEncoding() {
        Object number;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("ID", this.name);
        switch (this.countType) {
            case A: {
                number = "A";
                break;
            }
            case R: {
                number = "R";
                break;
            }
            case G: {
                number = "G";
                break;
            }
            case UNBOUNDED: {
                number = ".";
                break;
            }
            default: {
                number = this.count;
            }
        }
        map.put("Number", number);
        map.put("Type", (Object)this.type);
        map.put("Description", this.description);
        if (this.source != null) {
            map.put("Source", this.source);
        }
        if (this.version != null) {
            map.put("Version", this.version);
        }
        return String.valueOf(this.lineType.toString()) + "=" + VCFHeaderLine.toStringEncoding(map);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        VCFCompoundHeaderLine that = (VCFCompoundHeaderLine)o;
        return this.equalsExcludingDescription(that) && this.description.equals(that.description);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.count;
        result = 31 * result + (this.countType != null ? this.countType.hashCode() : 0);
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.lineType.hashCode();
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public boolean equalsExcludingDescription(VCFCompoundHeaderLine other) {
        return this.count == other.count && this.countType == other.countType && this.type == other.type && this.lineType == other.lineType && this.name.equals(other.name);
    }

    public boolean sameLineTypeAndName(VCFCompoundHeaderLine other) {
        return this.lineType == other.lineType && this.name.equals(other.name);
    }

    abstract boolean allowFlagValues();

    public void setSource(String source) {
        this.source = source;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static enum SupportedHeaderLineType {
        INFO(true),
        FORMAT(false);

        public final boolean allowFlagValues;

        private SupportedHeaderLineType(boolean flagValues) {
            this.allowFlagValues = flagValues;
        }
    }
}

