/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.bcf2;

import htsjdk.variant.bcf2.BCF2Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;

public enum BCF2Type {
    MISSING(0, 0, 0){

        @Override
        public int read(InputStream in) throws IOException {
            throw new IllegalArgumentException("Cannot read MISSING type");
        }

        @Override
        public void write(int value, OutputStream out) throws IOException {
            throw new IllegalArgumentException("Cannot write MISSING type");
        }
    }
    ,
    INT8(1, 1, -128, -127L, 127L){

        @Override
        public int read(InputStream in) throws IOException {
            return BCF2Utils.readByte(in);
        }

        @Override
        public void write(int value, OutputStream out) throws IOException {
            out.write(0xFF & value);
        }
    }
    ,
    INT16(2, 2, Short.MIN_VALUE, -32767L, 32767L){

        @Override
        public int read(InputStream in) throws IOException {
            int b2 = BCF2Utils.readByte(in) & 0xFF;
            int b1 = BCF2Utils.readByte(in) & 0xFF;
            return (short)(b1 << 8 | b2);
        }

        @Override
        public void write(int value, OutputStream out) throws IOException {
            out.write(0xFF & value);
            out.write((0xFF00 & value) >> 8);
        }
    }
    ,
    INT32(3, 4, Integer.MIN_VALUE, -2147483647L, Integer.MAX_VALUE){

        @Override
        public int read(InputStream in) throws IOException {
            int b4 = BCF2Utils.readByte(in) & 0xFF;
            int b3 = BCF2Utils.readByte(in) & 0xFF;
            int b2 = BCF2Utils.readByte(in) & 0xFF;
            int b1 = BCF2Utils.readByte(in) & 0xFF;
            return b1 << 24 | b2 << 16 | b3 << 8 | b4;
        }

        @Override
        public void write(int value, OutputStream out) throws IOException {
            out.write(0xFF & value);
            out.write((0xFF00 & value) >> 8);
            out.write((0xFF0000 & value) >> 16);
            out.write((0xFF000000 & value) >> 24);
        }
    }
    ,
    FLOAT(5, 4, 2139095041){

        @Override
        public int read(InputStream in) throws IOException {
            return INT32.read(in);
        }

        @Override
        public void write(int value, OutputStream out) throws IOException {
            INT32.write(value, out);
        }
    }
    ,
    CHAR(7, 1, 0){

        @Override
        public int read(InputStream in) throws IOException {
            return INT8.read(in);
        }

        @Override
        public void write(int value, OutputStream out) throws IOException {
            INT8.write(value, out);
        }
    };

    private final int id;
    private final Object missingJavaValue;
    private final int missingBytes;
    private final int sizeInBytes;
    private final long minValue;
    private final long maxValue;
    private static final EnumSet<BCF2Type> INTEGERS;

    static {
        INTEGERS = EnumSet.of(INT8, INT16, INT32);
    }

    private BCF2Type(int id, int sizeInBytes, int missingBytes) {
        this(id, sizeInBytes, missingBytes, 0L, 0L);
    }

    private BCF2Type(int id, int sizeInBytes, int missingBytes, long minValue, long maxValue) {
        this.id = id;
        this.sizeInBytes = sizeInBytes;
        this.missingJavaValue = null;
        this.missingBytes = missingBytes;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getID() {
        return this.id;
    }

    public final boolean withinRange(long v) {
        return v >= this.minValue && v <= this.maxValue;
    }

    public Object getMissingJavaValue() {
        return this.missingJavaValue;
    }

    public int getMissingBytes() {
        return this.missingBytes;
    }

    public boolean isMissingType() {
        return this == MISSING;
    }

    public boolean isIntegerType() {
        return INTEGERS.contains((Object)this);
    }

    public int read(InputStream in) throws IOException {
        throw new IllegalArgumentException("Not implemented");
    }

    public void write(int value, OutputStream out) throws IOException {
        throw new IllegalArgumentException("Not implemented");
    }

    /* synthetic */ BCF2Type(String string, int n, int n2, int n3, int n4, BCF2Type bCF2Type) {
        this(n2, n3, n4);
    }

    /* synthetic */ BCF2Type(String string, int n, int n2, int n3, int n4, long l, long l2, BCF2Type bCF2Type) {
        this(n2, n3, n4, l, l2);
    }
}

