/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.annotation;

public enum Strand {
    POSITIVE('+'),
    NEGATIVE('-'),
    NONE('.');

    public static final Strand FORWARD;
    public static final Strand REVERSE;
    private static final Strand[] VALUES;
    private final char charEncoding;
    private final String stringEncoding;

    static {
        FORWARD = POSITIVE;
        REVERSE = NEGATIVE;
        VALUES = Strand.values();
    }

    private Strand(char ch) {
        this.charEncoding = ch;
        this.stringEncoding = String.valueOf(this.charEncoding);
    }

    @Deprecated
    public static Strand toStrand(String encoding) {
        return Strand.decode(encoding);
    }

    public static Strand decode(char ch) {
        Strand[] strandArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            Strand value = strandArray[n2];
            if (value.charEncoding == ch) {
                return value;
            }
            ++n2;
        }
        return NONE;
    }

    public static Strand decode(String encoding) {
        if (encoding != null && encoding.length() == 1) {
            return Strand.decode(encoding.charAt(0));
        }
        return NONE;
    }

    public String encode() {
        return this.stringEncoding;
    }

    public char encodeAsChar() {
        return this.charEncoding;
    }

    public String toString() {
        return this.stringEncoding;
    }
}

