/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.AbstractLocusInfo;
import htsjdk.samtools.util.AbstractLocusIterator;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.IntervalList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SamLocusIterator
extends AbstractLocusIterator<RecordAndOffset, LocusInfo> {
    public SamLocusIterator(SamReader samReader) {
        this(samReader, null);
    }

    public SamLocusIterator(SamReader samReader, IntervalList intervalList) {
        this(samReader, intervalList, samReader.hasIndex());
    }

    public SamLocusIterator(SamReader samReader, IntervalList intervalList, boolean useIndex) {
        super(samReader, intervalList, useIndex);
    }

    @Override
    void accumulateSamRecord(SAMRecord rec) {
        int accOffset = this.getAccumulatorOffset(rec);
        int minQuality = this.getQualityScoreCutoff();
        boolean dontCheckQualities = minQuality == 0;
        byte[] baseQualities = dontCheckQualities ? null : rec.getBaseQualities();
        for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
            int readStart = alignmentBlock.getReadStart();
            int refStart = alignmentBlock.getReferenceStart();
            int blockLength = alignmentBlock.getLength();
            int i = 0;
            while (i < blockLength) {
                int readOffset = readStart + i - 1;
                if (dontCheckQualities || baseQualities.length == 0 || baseQualities[readOffset] >= minQuality) {
                    int refOffset = refStart + i - accOffset;
                    ((LocusInfo)this.accumulator.get(refOffset)).add(new RecordAndOffset(rec, readOffset));
                }
                ++i;
            }
        }
    }

    @Override
    void accumulateIndels(SAMRecord rec) {
        List<CigarElement> cigar = rec.getCigar().getCigarElements();
        int readBase = 0;
        int refBase = rec.getAlignmentStart() - this.getAccumulatorOffset(rec);
        int elementIndex = 0;
        while (elementIndex < cigar.size()) {
            CigarElement e = cigar.get(elementIndex);
            CigarOperator operator = e.getOperator();
            if (operator.equals((Object)CigarOperator.I)) {
                ((LocusInfo)this.accumulator.get(refBase - 1)).addInserted(rec, readBase);
                readBase += e.getLength();
            } else if (operator.equals((Object)CigarOperator.D)) {
                int i = 0;
                while (i < e.getLength()) {
                    ((LocusInfo)this.accumulator.get(refBase + i)).addDeleted(rec, readBase - 1);
                    ++i;
                }
                refBase += e.getLength();
            } else {
                if (operator.consumesReadBases()) {
                    readBase += e.getLength();
                }
                if (operator.consumesReferenceBases()) {
                    refBase += e.getLength();
                }
            }
            ++elementIndex;
        }
    }

    private int getAccumulatorOffset(SAMRecord rec) {
        int insOffset;
        SAMSequenceRecord ref = this.getReferenceSequence(rec.getReferenceIndex());
        int alignmentStart = rec.getAlignmentStart();
        int alignmentEnd = rec.getAlignmentEnd();
        int alignmentLength = alignmentEnd - alignmentStart;
        int n = insOffset = this.includeIndels && SamLocusIterator.startWithInsertion(rec.getCigar()) ? 1 : 0;
        if (insOffset == 1 && this.accumulator.isEmpty()) {
            this.accumulator.add(new LocusInfo(ref, alignmentStart - 1));
        }
        int i = this.accumulator.size();
        while (i <= alignmentLength + insOffset) {
            this.accumulator.add(new LocusInfo(ref, alignmentStart + i - insOffset));
            ++i;
        }
        return alignmentStart - insOffset;
    }

    @Override
    RecordAndOffset createRecordAndOffset(SAMRecord rec, int readOffset, int length, int refPos) {
        return new RecordAndOffset(rec, readOffset);
    }

    @Override
    LocusInfo createLocusInfo(SAMSequenceRecord referenceSequence, int lastPosition) {
        return new LocusInfo(referenceSequence, lastPosition);
    }

    public static final class LocusInfo
    extends AbstractLocusInfo<RecordAndOffset> {
        private List<RecordAndOffset> deletedInRecord = null;
        private List<RecordAndOffset> insertedInRecord = null;

        public LocusInfo(SAMSequenceRecord referenceSequence, int position) {
            super(referenceSequence, position);
        }

        public void addDeleted(SAMRecord read, int previousPosition) {
            if (this.deletedInRecord == null) {
                this.deletedInRecord = new ArrayList<RecordAndOffset>();
            }
            this.deletedInRecord.add(new RecordAndOffset(read, previousPosition));
        }

        public void addInserted(SAMRecord read, int firstPosition) {
            if (this.insertedInRecord == null) {
                this.insertedInRecord = new ArrayList<RecordAndOffset>();
            }
            this.insertedInRecord.add(new RecordAndOffset(read, firstPosition));
        }

        public List<RecordAndOffset> getDeletedInRecord() {
            return this.deletedInRecord == null ? Collections.emptyList() : Collections.unmodifiableList(this.deletedInRecord);
        }

        public List<RecordAndOffset> getInsertedInRecord() {
            return this.insertedInRecord == null ? Collections.emptyList() : Collections.unmodifiableList(this.insertedInRecord);
        }

        @Override
        public int size() {
            return super.size() + (this.deletedInRecord == null ? 0 : this.deletedInRecord.size());
        }

        @Override
        public boolean isEmpty() {
            return !(!this.getRecordAndOffsets().isEmpty() || this.deletedInRecord != null && !this.deletedInRecord.isEmpty() || this.insertedInRecord != null && !this.insertedInRecord.isEmpty());
        }
    }

    public static class RecordAndOffset
    extends AbstractRecordAndOffset {
        public RecordAndOffset(SAMRecord record, int offset) {
            super(record, offset);
        }
    }
}

