/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class CollectionUtil {
    public static final Comparator<Object> OBJECT_TOSTRING_COMPARATOR = (o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString());

    public static <T> List<T> makeList(T ... list) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, list);
        return result;
    }

    public static <T> Set<T> makeSet(T ... list) {
        HashSet result = new HashSet();
        Collections.addAll(result, list);
        return result;
    }

    public static <T> Collection<T> makeCollection(Iterator<T> i) {
        LinkedList<T> list = new LinkedList<T>();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    public static String join(Collection<?> items, String inBetween) {
        StringBuilder builder = new StringBuilder();
        for (Object item : items) {
            if (builder.length() > 0) {
                builder.append(inBetween);
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static <T> T getSoleElement(Collection<T> items) {
        if (items.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected a single element in %s, but found %s.", items, items.size()));
        }
        return items.iterator().next();
    }

    @Deprecated
    public static <K, V> Map<K, Collection<V>> partition(Collection<V> collection, Partitioner<V, K> p) {
        MultiMap<K, V> partitionToValues = new MultiMap<K, V>();
        for (V entry : collection) {
            partitionToValues.append(p.getPartition(entry), entry);
        }
        return partitionToValues;
    }

    public static <K, V> Map<K, Collection<V>> partition(Collection<V> collection, Function<? super V, ? extends K> keyer) {
        MultiMap<K, V> partitionToValues = new MultiMap<K, V>();
        for (V entry : collection) {
            partitionToValues.append(keyer.apply(entry), entry);
        }
        return partitionToValues;
    }

    public static class DefaultingMap<K, V>
    extends HashMap<K, V> {
        final Factory<V, K> defaultGenerator;
        final boolean injectValueOnDefault;

        public DefaultingMap(V defaultValue) {
            this(k -> defaultValue, false);
        }

        public DefaultingMap(Factory<V, K> defaultGenerator, boolean injectValueOnDefaulting) {
            this.defaultGenerator = defaultGenerator;
            this.injectValueOnDefault = injectValueOnDefaulting;
        }

        @Override
        public V get(Object key) {
            if (!this.containsKey(key)) {
                V val = this.defaultGenerator.make(key);
                if (this.injectValueOnDefault) {
                    this.put(key, val);
                }
                return val;
            }
            return super.get(key);
        }

        public static interface Factory<V, K> {
            public V make(K var1);
        }
    }

    public static class MultiMap<K, V>
    extends HashMap<K, Collection<V>> {
        public void append(K k, V v) {
            this.initializeKeyIfUninitialized(k);
            ((Collection)this.get(k)).add(v);
        }

        public void appendAll(K k, Collection<? extends V> v) {
            this.initializeKeyIfUninitialized(k);
            ((Collection)this.get(k)).addAll(v);
        }

        private void initializeKeyIfUninitialized(K k) {
            if (!this.containsKey(k)) {
                this.put(k, new LinkedList());
            }
        }
    }

    @Deprecated
    public static abstract class Partitioner<V, K> {
        public abstract K getPartition(V var1);
    }
}

