/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.Locus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AbstractLocusInfo<E extends AbstractRecordAndOffset>
implements Locus,
Locatable {
    private final SAMSequenceRecord referenceSequence;
    private final int position;
    private static final int INITIAL_LIST_SIZE = 100;
    private final List<E> recordAndOffsets = new ArrayList(100);

    public AbstractLocusInfo(SAMSequenceRecord referenceSequence, int position) {
        this.referenceSequence = referenceSequence;
        this.position = position;
    }

    public void add(E recordAndOffset) {
        this.recordAndOffsets.add(recordAndOffset);
    }

    @Override
    public int getSequenceIndex() {
        return this.referenceSequence.getSequenceIndex();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Deprecated
    public List<E> getRecordAndPositions() {
        return Collections.unmodifiableList(this.recordAndOffsets);
    }

    public List<E> getRecordAndOffsets() {
        return Collections.unmodifiableList(this.recordAndOffsets);
    }

    public String getSequenceName() {
        return this.referenceSequence.getSequenceName();
    }

    public String toString() {
        return String.valueOf(this.referenceSequence.getSequenceName()) + ":" + this.position;
    }

    public int getSequenceLength() {
        return this.referenceSequence.getSequenceLength();
    }

    public int size() {
        return this.recordAndOffsets.size();
    }

    public boolean isEmpty() {
        return this.getRecordAndOffsets().isEmpty();
    }

    @Override
    public String getContig() {
        return this.getSequenceName();
    }

    @Override
    public int getStart() {
        return this.getPosition();
    }

    @Override
    public int getEnd() {
        return this.getPosition();
    }
}

