/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.AbstractIndexedFastaSequenceFile;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.GZIIndex;
import htsjdk.samtools.util.IOUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;

public class BlockCompressedIndexedFastaSequenceFile
extends AbstractIndexedFastaSequenceFile {
    private final BlockCompressedInputStream stream;
    private final GZIIndex gzindex;

    public BlockCompressedIndexedFastaSequenceFile(Path path) throws FileNotFoundException {
        this(path, new FastaSequenceIndex(BlockCompressedIndexedFastaSequenceFile.findRequiredFastaIndexFile(path)));
    }

    public BlockCompressedIndexedFastaSequenceFile(Path path, FastaSequenceIndex index) {
        this(path, index, BlockCompressedIndexedFastaSequenceFile.loadFastaGziIndex(path));
    }

    public BlockCompressedIndexedFastaSequenceFile(Path path, FastaSequenceIndex index, GZIIndex gziIndex) {
        super(path, index);
        if (gziIndex == null) {
            throw new IllegalArgumentException("null gzi index");
        }
        BlockCompressedIndexedFastaSequenceFile.assertIsBlockCompressed(path);
        try {
            this.stream = new BlockCompressedInputStream(new SeekablePathStream(path));
            this.gzindex = gziIndex;
        }
        catch (IOException e) {
            throw new SAMException("Fasta file should be readable but is not: " + path, e);
        }
    }

    public BlockCompressedIndexedFastaSequenceFile(String source, SeekableStream in, FastaSequenceIndex index, SAMSequenceDictionary dictionary, GZIIndex gziIndex) {
        super(source, index, dictionary);
        if (gziIndex == null) {
            throw new IllegalArgumentException("null gzi index");
        }
        this.stream = new BlockCompressedInputStream(in);
        this.gzindex = gziIndex;
    }

    private static GZIIndex loadFastaGziIndex(Path path) {
        try {
            return GZIIndex.loadIndex(GZIIndex.resolveIndexNameForBgzipFile(path));
        }
        catch (IOException e) {
            throw new SAMException("Error loading GZI index for " + path, e);
        }
    }

    private static void assertIsBlockCompressed(Path path) {
        try {
            if (!IOUtil.isBlockCompressed(path, true)) {
                throw new SAMException("Invalid block-compressed Fasta file: " + path);
            }
        }
        catch (IOException e) {
            throw new SAMException("Invalid block-compressed Fasta file: " + path, e);
        }
    }

    @Override
    protected int readFromPosition(ByteBuffer buffer, long position) throws IOException {
        long oldPos = this.stream.getFilePointer();
        try {
            long virtualOffset = this.gzindex.getVirtualOffsetForSeek(position);
            this.stream.seek(virtualOffset);
            byte[] array = new byte[buffer.remaining()];
            int read = this.stream.read(array);
            buffer.put(array);
            int n = read;
            return n;
        }
        finally {
            this.stream.seek(oldPos);
        }
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

