/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

abstract class AbstractFastaSequenceFile
implements ReferenceSequenceFile {
    private final Path path;
    private final String source;
    protected SAMSequenceDictionary sequenceDictionary;

    AbstractFastaSequenceFile(File file) {
        this(IOUtil.toPath(file));
    }

    AbstractFastaSequenceFile(Path path) {
        this.path = path;
        this.source = path == null ? "unknown" : path.toAbsolutePath().toString();
        Path dictionary = AbstractFastaSequenceFile.findSequenceDictionary(path);
        if (dictionary != null) {
            IOUtil.assertFileIsReadable(dictionary);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream dictionaryIn = Files.newInputStream(dictionary, new OpenOption[0]);){
                    this.sequenceDictionary = ReferenceSequenceFileFactory.loadDictionary(dictionaryIn);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new SAMException("Could not open sequence dictionary file: " + dictionary, e);
            }
        }
    }

    AbstractFastaSequenceFile(Path path, String source, SAMSequenceDictionary sequenceDictionary) {
        this.path = path;
        this.source = source;
        this.sequenceDictionary = sequenceDictionary;
    }

    protected static File findSequenceDictionary(File file) {
        Path dictionary = AbstractFastaSequenceFile.findSequenceDictionary(IOUtil.toPath(file));
        if (dictionary == null) {
            return null;
        }
        return dictionary.toFile();
    }

    protected static Path findSequenceDictionary(Path path) {
        if (path == null) {
            return null;
        }
        Path dictionary = ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence(path);
        path.toAbsolutePath();
        if (Files.exists(dictionary, new LinkOption[0])) {
            return dictionary;
        }
        Path dictionaryExt = path.resolveSibling(String.valueOf(path.getFileName().toString()) + ".dict");
        if (Files.exists(dictionaryExt, new LinkOption[0])) {
            return dictionaryExt;
        }
        return null;
    }

    protected Path getPath() {
        return this.path;
    }

    protected String getSource() {
        return this.source;
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    protected String getAbsolutePath() {
        if (this.path == null) {
            return null;
        }
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public String toString() {
        return this.source;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public ReferenceSequence getSequence(String contig) {
        throw new UnsupportedOperationException("Index does not appear to exist for " + this.getSource() + ".  samtools faidx can be used to create an index");
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String contig, long start, long stop) {
        throw new UnsupportedOperationException("Index does not appear to exist for " + this.getSource() + ".  samtools faidx can be used to create an index");
    }
}

