/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure.block;

import htsjdk.samtools.cram.CRAMException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BlockContentType {
    FILE_HEADER(0),
    COMPRESSION_HEADER(1),
    MAPPED_SLICE(2),
    RESERVED(3),
    EXTERNAL(4),
    CORE(5);

    private final int contentTypeId;
    private static final Map<Integer, BlockContentType> ID_MAP;

    static {
        ID_MAP = Collections.unmodifiableMap(Stream.of(BlockContentType.values()).collect(Collectors.toMap(BlockContentType::getContentTypeId, Function.identity())));
    }

    private BlockContentType(int id) {
        this.contentTypeId = id;
    }

    public int getContentTypeId() {
        return this.contentTypeId;
    }

    public static BlockContentType byId(int id) {
        return Optional.ofNullable(ID_MAP.get(id)).orElseThrow(() -> new CRAMException("Could not find BlockContentType for: " + id));
    }
}

