/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import java.util.Arrays;
import java.util.Comparator;

public class SubstitutionMatrix {
    public static final byte[] BASES = new byte[]{65, 67, 71, 84, 78};
    private static final byte[] BASES_LC = new byte[]{97, 99, 103, 116, 110};
    private static final byte[] ORDER = new byte[255];
    private byte[] bytes = new byte[5];
    private final byte[][] codes = new byte[255][255];
    private final byte[][] bases = new byte[255][255];
    private static final Comparator<SubCode> comparator;

    static {
        Arrays.fill(ORDER, (byte)-1);
        SubstitutionMatrix.ORDER[65] = 0;
        SubstitutionMatrix.ORDER[67] = 1;
        SubstitutionMatrix.ORDER[71] = 2;
        SubstitutionMatrix.ORDER[84] = 3;
        SubstitutionMatrix.ORDER[78] = 4;
        comparator = new Comparator<SubCode>(){

            @Override
            public int compare(SubCode o1, SubCode o2) {
                if (o1.freq != o2.freq) {
                    return (int)(o2.freq - o1.freq);
                }
                return ORDER[o1.base] - ORDER[o2.base];
            }
        };
    }

    public SubstitutionMatrix(long[][] frequencies) {
        Object object = BASES;
        int n = BASES.length;
        int n2 = 0;
        while (n2 < n) {
            byte base = object[n2];
            this.bytes[SubstitutionMatrix.ORDER[base]] = this.rank(base, frequencies[base]);
            ++n2;
        }
        object = this.bases;
        n = this.bases.length;
        n2 = 0;
        while (n2 < n) {
            byte base = object[n2];
            Arrays.fill((byte[])base, (byte)78);
            ++n2;
        }
        int i = 0;
        while (i < BASES.length) {
            byte r = BASES[i];
            byte[] byArray = BASES;
            int n3 = BASES.length;
            int n4 = 0;
            while (n4 < n3) {
                byte b = byArray[n4];
                if (r != b) {
                    this.bases[r][this.codes[r][b]] = b;
                    this.bases[SubstitutionMatrix.BASES_LC[i]][this.codes[r][b]] = b;
                }
                ++n4;
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = "ACGTN".getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte r = byArray[n2];
            stringBuilder.append((char)r);
            stringBuilder.append(':');
            int i = 0;
            while (i < 4) {
                stringBuilder.append((char)this.bases[r][i]);
                ++i;
            }
            stringBuilder.append('\t');
            ++n2;
        }
        return stringBuilder.toString();
    }

    public SubstitutionMatrix(byte[] matrix) {
        this.bytes = matrix;
        Object object = this.bases;
        int n = this.bases.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] base = object[n2];
            Arrays.fill(base, (byte)78);
            ++n2;
        }
        this.bases[65][this.bytes[0] >> 6 & 3] = 67;
        this.bases[65][this.bytes[0] >> 4 & 3] = 71;
        this.bases[65][this.bytes[0] >> 2 & 3] = 84;
        this.bases[65][this.bytes[0] & 3] = 78;
        System.arraycopy(this.bases[65], 0, this.bases[97], 0, 4);
        this.bases[67][this.bytes[1] >> 6 & 3] = 65;
        this.bases[67][this.bytes[1] >> 4 & 3] = 71;
        this.bases[67][this.bytes[1] >> 2 & 3] = 84;
        this.bases[67][this.bytes[1] & 3] = 78;
        System.arraycopy(this.bases[67], 0, this.bases[99], 0, 4);
        this.bases[71][this.bytes[2] >> 6 & 3] = 65;
        this.bases[71][this.bytes[2] >> 4 & 3] = 67;
        this.bases[71][this.bytes[2] >> 2 & 3] = 84;
        this.bases[71][this.bytes[2] & 3] = 78;
        System.arraycopy(this.bases[71], 0, this.bases[103], 0, 4);
        this.bases[84][this.bytes[3] >> 6 & 3] = 65;
        this.bases[84][this.bytes[3] >> 4 & 3] = 67;
        this.bases[84][this.bytes[3] >> 2 & 3] = 71;
        this.bases[84][this.bytes[3] & 3] = 78;
        System.arraycopy(this.bases[84], 0, this.bases[116], 0, 4);
        this.bases[78][this.bytes[4] >> 6 & 3] = 65;
        this.bases[78][this.bytes[4] >> 4 & 3] = 67;
        this.bases[78][this.bytes[4] >> 2 & 3] = 71;
        this.bases[78][this.bytes[4] & 3] = 84;
        object = BASES;
        n = BASES.length;
        n2 = 0;
        while (n2 < n) {
            byte[] refBase = object[n2];
            int code = 0;
            while (code < 4) {
                this.codes[refBase][this.bases[refBase][code]] = code;
                code = (byte)(code + 1);
            }
            ++n2;
        }
    }

    public byte[] getEncodedMatrix() {
        return this.bytes;
    }

    private byte rank(byte refBase, long[] frequencies) {
        int base;
        SubCode[] subCodes = new SubCode[4];
        int i = 0;
        Object[] objectArray = BASES;
        int n = BASES.length;
        int n2 = 0;
        while (n2 < n) {
            base = objectArray[n2];
            if (refBase != base) {
                subCodes[i++] = new SubCode((byte)base, frequencies[base]);
            }
            ++n2;
        }
        Arrays.sort(subCodes, comparator);
        i = 0;
        while (i < subCodes.length) {
            subCodes[i].rank = (byte)i;
            i = (byte)(i + 1);
        }
        SubCode[] subCodeArray = subCodes;
        n2 = subCodes.length;
        base = 0;
        while (base < n2) {
            SubCode subCode1 = subCodeArray[base];
            subCode1.freq = 0L;
            ++base;
        }
        Arrays.sort(subCodes, comparator);
        byte rank = 0;
        objectArray = subCodes;
        int n3 = subCodes.length;
        n2 = 0;
        while (n2 < n3) {
            byte subCode = objectArray[n2];
            rank = (byte)(rank << 2);
            rank = (byte)(rank | subCode.rank);
            ++n2;
        }
        objectArray = subCodes;
        n3 = subCodes.length;
        n2 = 0;
        while (n2 < n3) {
            byte s = objectArray[n2];
            this.codes[refBase][s.base] = s.rank;
            ++n2;
        }
        return rank;
    }

    public byte code(byte refBase, byte readBase) {
        return this.codes[refBase][readBase];
    }

    public byte base(byte refBase, byte code) {
        return this.bases[refBase][code];
    }

    private static class SubCode {
        final byte base;
        long freq;
        byte rank;

        public SubCode(byte base, long freq) {
            this.base = base;
            this.freq = freq;
        }
    }
}

