/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.BinaryTagCodec;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.io.CramIntArray;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.io.LTF8;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.cram.structure.block.BlockContentType;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

class SliceIO {
    private static final Log log = Log.getInstance(SliceIO.class);

    SliceIO() {
    }

    private static Slice readSliceHeader(int major, InputStream readInputStream) {
        Block sliceHeaderBlock = Block.read(major, readInputStream);
        if (sliceHeaderBlock.getContentType() != BlockContentType.MAPPED_SLICE) {
            throw new RuntimeException("Slice Header Block expected, found:  " + sliceHeaderBlock.getContentType().name());
        }
        ByteArrayInputStream parseInputStream = new ByteArrayInputStream(sliceHeaderBlock.getUncompressedContent());
        ReferenceContext refContext = new ReferenceContext(ITF8.readUnsignedITF8(parseInputStream));
        Slice slice = new Slice(refContext);
        slice.alignmentStart = ITF8.readUnsignedITF8(parseInputStream);
        slice.alignmentSpan = ITF8.readUnsignedITF8(parseInputStream);
        slice.nofRecords = ITF8.readUnsignedITF8(parseInputStream);
        slice.globalRecordCounter = LTF8.readUnsignedLTF8(parseInputStream);
        slice.nofBlocks = ITF8.readUnsignedITF8(parseInputStream);
        slice.contentIDs = CramIntArray.array(parseInputStream);
        slice.embeddedRefBlockContentID = ITF8.readUnsignedITF8(parseInputStream);
        slice.refMD5 = new byte[16];
        InputStreamUtils.readFully(parseInputStream, slice.refMD5, 0, slice.refMD5.length);
        byte[] bytes = InputStreamUtils.readFully(parseInputStream);
        if (major >= CramVersions.CRAM_v3.major) {
            SAMBinaryTagAndValue tags = slice.sliceTags = BinaryTagCodec.readTags(bytes, 0, bytes.length, ValidationStringency.DEFAULT_STRINGENCY);
            while (tags != null) {
                log.debug(String.format("Found slice tag: %s", SAMTag.makeStringTag(tags.tag)));
                tags = tags.getNext();
            }
        }
        slice.headerBlock = sliceHeaderBlock;
        return slice;
    }

    private static byte[] createSliceHeaderBlockContent(int major, Slice slice) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ITF8.writeUnsignedITF8(slice.getReferenceContext().getSerializableId(), byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.alignmentStart, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.alignmentSpan, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.nofRecords, byteArrayOutputStream);
        LTF8.writeUnsignedLTF8(slice.globalRecordCounter, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.nofBlocks, byteArrayOutputStream);
        slice.contentIDs = new int[slice.external.size()];
        int i = 0;
        for (int id : slice.external.keySet()) {
            slice.contentIDs[i++] = id;
        }
        CramIntArray.write(slice.contentIDs, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.embeddedRefBlockContentID, byteArrayOutputStream);
        try {
            byteArrayOutputStream.write(slice.refMD5 == null ? new byte[16] : slice.refMD5);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        if (major >= CramVersions.CRAM_v3.major && slice.sliceTags != null) {
            BinaryCodec binaryCoded = new BinaryCodec(byteArrayOutputStream);
            BinaryTagCodec binaryTagCodec = new BinaryTagCodec(binaryCoded);
            SAMBinaryTagAndValue samBinaryTagAndValue = slice.sliceTags;
            do {
                log.debug("Writing slice tag: " + SAMTag.makeStringTag(samBinaryTagAndValue.tag));
                binaryTagCodec.writeTag(samBinaryTagAndValue.tag, samBinaryTagAndValue.value, samBinaryTagAndValue.isUnsignedArray());
            } while ((samBinaryTagAndValue = samBinaryTagAndValue.getNext()) != null);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void readSliceBlocks(int major, Slice slice, InputStream inputStream) {
        slice.external = new HashMap<Integer, Block>();
        int i = 0;
        while (i < slice.nofBlocks) {
            Block block = Block.read(major, inputStream);
            switch (block.getContentType()) {
                case CORE: {
                    slice.coreBlock = block;
                    break;
                }
                case EXTERNAL: {
                    if (slice.embeddedRefBlockContentID == block.getContentId()) {
                        slice.embeddedRefBlock = block;
                    }
                    slice.external.put(block.getContentId(), block);
                    break;
                }
                default: {
                    throw new RuntimeException("Not a slice block, content type id " + block.getContentType().name());
                }
            }
            ++i;
        }
    }

    public static void write(int major, Slice slice, OutputStream outputStream) {
        slice.nofBlocks = 1 + slice.external.size() + (slice.embeddedRefBlock == null ? 0 : 1);
        slice.contentIDs = new int[slice.external.size()];
        boolean i = false;
        Iterator<Integer> iterator = slice.external.keySet().iterator();
        while (iterator.hasNext()) {
            int id;
            slice.contentIDs[0] = id = iterator.next().intValue();
        }
        slice.headerBlock = Block.createRawSliceHeaderBlock(SliceIO.createSliceHeaderBlockContent(major, slice));
        slice.headerBlock.write(major, outputStream);
        slice.coreBlock.write(major, outputStream);
        for (Block block : slice.external.values()) {
            block.write(major, outputStream);
        }
    }

    public static Slice read(int major, InputStream inputStream) {
        Slice slice = SliceIO.readSliceHeader(major, inputStream);
        SliceIO.readSliceBlocks(major, slice, inputStream);
        return slice;
    }
}

