/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.CramVersionPolicies;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerHeaderIO;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SliceIO;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.cram.structure.block.BlockContentType;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ContainerIO {
    private static final Log log = Log.getInstance(ContainerIO.class);

    public static Container readContainer(Version version, InputStream inputStream) {
        Container container = ContainerIO.readContainer(version.major, inputStream);
        if (container == null) {
            CramVersionPolicies.eofNotFound(version);
            return ContainerIO.readContainer(version.major, (InputStream)new ByteArrayInputStream(CramIO.ZERO_B_EOF_MARKER));
        }
        if (container.isEOF()) {
            log.debug("EOF marker found, file/stream is complete.");
        }
        return container;
    }

    private static Container readContainer(int major, InputStream inputStream) {
        return ContainerIO.readContainer(major, inputStream, 0, Integer.MAX_VALUE);
    }

    public static Container readContainerHeader(int major, InputStream inputStream) {
        return ContainerHeaderIO.readContainerHeader(major, inputStream);
    }

    private static Container readContainer(int major, InputStream inputStream, int fromSlice, int howManySlices) {
        Container container = ContainerIO.readContainerHeader(major, inputStream);
        if (container.isEOF()) {
            return container;
        }
        container.header = CompressionHeader.read(major, inputStream);
        howManySlices = Math.min(container.landmarks.length, howManySlices);
        try {
            if (fromSlice > 0) {
                inputStream.skip(container.landmarks[fromSlice]);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        ArrayList<Slice> slices = new ArrayList<Slice>();
        int sliceCount = fromSlice;
        while (sliceCount < howManySlices - fromSlice) {
            Slice slice = SliceIO.read(major, inputStream);
            slice.index = sliceCount++;
            slices.add(slice);
        }
        container.slices = slices.toArray(new Slice[slices.size()]);
        ContainerIO.calculateSliceOffsetsAndSizes(container);
        log.debug("READ CONTAINER: " + container.toString());
        return container;
    }

    private static void calculateSliceOffsetsAndSizes(Container container) {
        if (container.slices.length == 0) {
            return;
        }
        int i = 0;
        while (i < container.slices.length - 1) {
            Slice slice = container.slices[i];
            slice.offset = container.landmarks[i];
            slice.size = container.landmarks[i + 1] - slice.offset;
            slice.containerOffset = container.offset;
            slice.index = i++;
        }
        Slice lastSlice = container.slices[container.slices.length - 1];
        lastSlice.offset = container.landmarks[container.landmarks.length - 1];
        lastSlice.size = container.containerByteSize - lastSlice.offset;
        lastSlice.containerOffset = container.offset;
        lastSlice.index = container.slices.length - 1;
    }

    public static int writeContainerHeader(int major, Container container, OutputStream outputStream) {
        return ContainerHeaderIO.writeContainerHeader(major, container, outputStream);
    }

    public static int writeContainer(Version version, Container container, OutputStream outputStream) {
        if (container.blocks != null && container.blocks.length > 0) {
            boolean isFileHeaderContainer;
            Block firstBlock = container.blocks[0];
            boolean bl = isFileHeaderContainer = firstBlock.getContentType() == BlockContentType.FILE_HEADER;
            if (isFileHeaderContainer) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                firstBlock.write(version.major, byteArrayOutputStream);
                container.containerByteSize = byteArrayOutputStream.size();
                int containerHeaderByteSize = ContainerHeaderIO.writeContainerHeader(version.major, container, outputStream);
                try {
                    outputStream.write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
                return containerHeaderByteSize + byteArrayOutputStream.size();
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        container.header.write(version, byteArrayOutputStream);
        container.blockCount = 1;
        ArrayList<Integer> landmarks = new ArrayList<Integer>();
        int i = 0;
        while (i < container.slices.length) {
            Slice slice = container.slices[i];
            landmarks.add(byteArrayOutputStream.size());
            SliceIO.write(version.major, slice, byteArrayOutputStream);
            ++container.blockCount;
            ++container.blockCount;
            if (slice.embeddedRefBlock != null) {
                ++container.blockCount;
            }
            container.blockCount += slice.external.size();
            ++i;
        }
        container.landmarks = new int[landmarks.size()];
        i = 0;
        while (i < container.landmarks.length) {
            container.landmarks[i] = (Integer)landmarks.get(i);
            ++i;
        }
        container.containerByteSize = byteArrayOutputStream.size();
        ContainerIO.calculateSliceOffsetsAndSizes(container);
        int length = ContainerHeaderIO.writeContainerHeader(version.major, container, outputStream);
        try {
            outputStream.write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        log.debug("CONTAINER WRITTEN: " + container.toString());
        return length += byteArrayOutputStream.size();
    }
}

