/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.io.CRC32OutputStream;
import htsjdk.samtools.cram.io.CramInt;
import htsjdk.samtools.cram.io.CramIntArray;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.LTF8;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ContainerHeaderIO {
    ContainerHeaderIO() {
    }

    public static Container readContainerHeader(int major, InputStream inputStream) {
        byte[] peek = new byte[4];
        try {
            int character = inputStream.read();
            if (character == -1) {
                int majorVersionForEOF = 2;
                byte[] eofMarker = major >= 3 ? CramIO.ZERO_F_EOF_MARKER : CramIO.ZERO_B_EOF_MARKER;
                Throwable throwable = null;
                Object var7_12 = null;
                try (ByteArrayInputStream eofBAIS = new ByteArrayInputStream(eofMarker);){
                    return ContainerHeaderIO.readContainerHeader(2, eofBAIS);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            peek[0] = (byte)character;
            int i = 1;
            while (i < peek.length) {
                character = inputStream.read();
                if (character == -1) {
                    throw new RuntimeException("Incomplete or broken stream.");
                }
                peek[i] = (byte)character;
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        int containerByteSize = CramInt.readInt32(peek);
        ReferenceContext refContext = new ReferenceContext(ITF8.readUnsignedITF8(inputStream));
        Container container = new Container(refContext);
        container.containerByteSize = containerByteSize;
        container.alignmentStart = ITF8.readUnsignedITF8(inputStream);
        container.alignmentSpan = ITF8.readUnsignedITF8(inputStream);
        container.nofRecords = ITF8.readUnsignedITF8(inputStream);
        container.globalRecordCounter = LTF8.readUnsignedLTF8(inputStream);
        container.bases = LTF8.readUnsignedLTF8(inputStream);
        container.blockCount = ITF8.readUnsignedITF8(inputStream);
        container.landmarks = CramIntArray.array(inputStream);
        if (major >= 3) {
            container.checksum = CramInt.readInt32(inputStream);
        }
        return container;
    }

    public static int writeContainerHeader(int major, Container container, OutputStream outputStream) {
        CRC32OutputStream crc32OutputStream = new CRC32OutputStream(outputStream);
        int length = (CramInt.writeInt32(container.containerByteSize, crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(container.getReferenceContext().getSerializableId(), crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(container.alignmentStart, crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(container.alignmentSpan, crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(container.nofRecords, crc32OutputStream) + 7) / 8;
        length += (LTF8.writeUnsignedLTF8(container.globalRecordCounter, crc32OutputStream) + 7) / 8;
        length += (LTF8.writeUnsignedLTF8(container.bases, crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(container.blockCount, crc32OutputStream) + 7) / 8;
        length += (CramIntArray.write(container.landmarks, crc32OutputStream) + 7) / 8;
        if (major >= 3) {
            try {
                outputStream.write(crc32OutputStream.getCrc32_LittleEndian());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            length += 4;
        }
        return length;
    }
}

