/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.block.Block;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Container {
    private final ReferenceContext referenceContext;
    public int containerByteSize;
    public int alignmentStart = -1;
    public int alignmentSpan = 0;
    public int nofRecords = 0;
    public long globalRecordCounter = 0L;
    public long bases = 0L;
    public int blockCount = -1;
    public int[] landmarks;
    public int checksum = 0;
    public Block[] blocks;
    public CompressionHeader header;
    public Slice[] slices;
    public long offset;

    public Container(ReferenceContext refContext) {
        this.referenceContext = refContext;
    }

    public ReferenceContext getReferenceContext() {
        return this.referenceContext;
    }

    public static Container initializeFromSlices(List<Slice> containerSlices) {
        Set sliceRefContexts = containerSlices.stream().map(Slice::getReferenceContext).collect(Collectors.toSet());
        if (sliceRefContexts.isEmpty()) {
            throw new CRAMException("Cannot construct a Container without any Slices");
        }
        if (sliceRefContexts.size() > 1) {
            throw new CRAMException("Cannot construct a Container from Slices with conflicting types or sequence IDs");
        }
        ReferenceContext commonRefContext = (ReferenceContext)sliceRefContexts.iterator().next();
        Container container = new Container(commonRefContext);
        container.slices = containerSlices.toArray(new Slice[0]);
        if (commonRefContext.isMappedSingleRef()) {
            int start = Integer.MAX_VALUE;
            int endPlusOne = Integer.MIN_VALUE;
            for (Slice slice : containerSlices) {
                start = Math.min(start, slice.alignmentStart);
                endPlusOne = Math.max(endPlusOne, slice.alignmentStart + slice.alignmentSpan);
            }
            container.alignmentStart = start;
            container.alignmentSpan = endPlusOne - start;
        } else {
            container.alignmentStart = -1;
            container.alignmentSpan = 0;
        }
        return container;
    }

    public List<CRAIEntry> getCRAIEntries() {
        return Arrays.stream(this.slices).map(Slice::getCRAIEntry).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("seqID=%s, start=%d, span=%d, records=%d, slices=%d, blocks=%d.", this.referenceContext, this.alignmentStart, this.alignmentSpan, this.nofRecords, this.slices == null ? -1 : this.slices.length, this.blockCount);
    }

    public boolean isEOF() {
        boolean v2;
        boolean v3 = this.containerByteSize == 15 && this.referenceContext.isUnmappedUnplaced() && this.alignmentStart == 4542278 && this.blockCount == 1 && this.nofRecords == 0 && (this.slices == null || this.slices.length == 0);
        boolean bl = v2 = this.containerByteSize == 11 && this.referenceContext.isUnmappedUnplaced() && this.alignmentStart == 4542278 && this.blockCount == 1 && this.nofRecords == 0 && (this.slices == null || this.slices.length == 0);
        return v3 || v2;
    }
}

