/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.DataSeries;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.cram.structure.block.BlockContentType;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CompressionHeader {
    private static final String RN_readNamesIncluded = "RN";
    private static final String AP_alignmentPositionIsDelta = "AP";
    private static final String RR_referenceRequired = "RR";
    private static final String TD_tagIdsDictionary = "TD";
    private static final String SM_substitutionMatrix = "SM";
    private static final Log log = Log.getInstance(CompressionHeader.class);
    public boolean readNamesIncluded;
    public boolean APDelta = true;
    private boolean referenceRequired = true;
    public Map<DataSeries, EncodingParams> encodingMap;
    public Map<Integer, EncodingParams> tMap;
    public final Map<Integer, ExternalCompressor> externalCompressors = new HashMap<Integer, ExternalCompressor>();
    public SubstitutionMatrix substitutionMatrix;
    public List<Integer> externalIds;
    public byte[][][] dictionary;

    private byte[][][] parseDictionary(byte[] bytes) {
        ArrayList dictionary = new ArrayList();
        int i = 0;
        while (i < bytes.length) {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            while (bytes[i] != 0) {
                arrayList.add(Arrays.copyOfRange(bytes, i, i + 3));
                i += 3;
            }
            ++i;
            dictionary.add(arrayList);
        }
        int maxWidth = 0;
        for (List list : dictionary) {
            maxWidth = Math.max(maxWidth, list.size());
        }
        byte[][][] byArrayArray = new byte[dictionary.size()][][];
        int i2 = 0;
        while (i2 < dictionary.size()) {
            List list = (List)dictionary.get(i2);
            byArrayArray[i2] = (byte[][])list.toArray((T[])new byte[list.size()][]);
            ++i2;
        }
        return byArrayArray;
    }

    private byte[] dictionaryToByteArray() {
        int size = 0;
        byte[][][] byArray = this.dictionary;
        int n = this.dictionary.length;
        int n2 = 0;
        while (n2 < n) {
            byte[][] dictionaryArrayArray;
            byte[][] byArray2 = dictionaryArrayArray = byArray[n2];
            int n3 = dictionaryArrayArray.length;
            int n4 = 0;
            while (n4 < n3) {
                byte[] dictionaryArray = byArray2[n4];
                size += dictionaryArray.length;
                ++n4;
            }
            ++size;
            ++n2;
        }
        byte[] bytes = new byte[size];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte[][][] byArray3 = this.dictionary;
        int n5 = this.dictionary.length;
        int n6 = 0;
        while (n6 < n5) {
            byte[][] dictionaryArrayArray;
            byte[][] byArray4 = dictionaryArrayArray = byArray3[n6];
            int n7 = dictionaryArrayArray.length;
            int n8 = 0;
            while (n8 < n7) {
                byte[] dictionaryArray = byArray4[n8];
                buffer.put(dictionaryArray);
                ++n8;
            }
            buffer.put((byte)0);
            ++n6;
        }
        return bytes;
    }

    public byte[][] getTagIds(int id) {
        return this.dictionary[id];
    }

    private void internalRead(InputStream is) {
        int byteSize = ITF8.readUnsignedITF8(is);
        byte[] bytes = new byte[byteSize];
        InputStreamUtils.readFully(is, bytes, 0, bytes.length);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int mapSize = ITF8.readUnsignedITF8(buffer);
        int i = 0;
        while (i < mapSize) {
            String key = new String(new byte[]{buffer.get(), buffer.get()});
            if (RN_readNamesIncluded.equals(key)) {
                this.readNamesIncluded = buffer.get() == 1;
            } else if (AP_alignmentPositionIsDelta.equals(key)) {
                this.APDelta = buffer.get() == 1;
            } else if (RR_referenceRequired.equals(key)) {
                this.referenceRequired = buffer.get() == 1;
            } else if (TD_tagIdsDictionary.equals(key)) {
                int size = ITF8.readUnsignedITF8(buffer);
                byte[] dictionaryBytes = new byte[size];
                buffer.get(dictionaryBytes);
                this.dictionary = this.parseDictionary(dictionaryBytes);
            } else if (SM_substitutionMatrix.equals(key)) {
                byte[] matrixBytes = new byte[5];
                buffer.get(matrixBytes);
                this.substitutionMatrix = new SubstitutionMatrix(matrixBytes);
            } else {
                throw new RuntimeException("Unknown preservation map key: " + key);
            }
            ++i;
        }
        byteSize = ITF8.readUnsignedITF8(is);
        bytes = new byte[byteSize];
        InputStreamUtils.readFully(is, bytes, 0, bytes.length);
        buffer = ByteBuffer.wrap(bytes);
        mapSize = ITF8.readUnsignedITF8(buffer);
        this.encodingMap = new TreeMap<DataSeries, EncodingParams>();
        i = 0;
        while (i < mapSize) {
            String dataSeriesAbbreviation = new String(new byte[]{buffer.get(), buffer.get()});
            DataSeries dataSeries = DataSeries.byCanonicalName(dataSeriesAbbreviation);
            EncodingID id = EncodingID.values()[buffer.get()];
            int paramLen = ITF8.readUnsignedITF8(buffer);
            byte[] paramBytes = new byte[paramLen];
            buffer.get(paramBytes);
            this.encodingMap.put(dataSeries, new EncodingParams(id, paramBytes));
            log.debug(String.format("FOUND ENCODING: %s, %s, %s.", dataSeries.name(), id.name(), Arrays.toString(Arrays.copyOf(paramBytes, 20))));
            ++i;
        }
        byteSize = ITF8.readUnsignedITF8(is);
        bytes = new byte[byteSize];
        InputStreamUtils.readFully(is, bytes, 0, bytes.length);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        mapSize = ITF8.readUnsignedITF8(buf);
        this.tMap = new TreeMap<Integer, EncodingParams>();
        i = 0;
        while (i < mapSize) {
            int key = ITF8.readUnsignedITF8(buf);
            EncodingID id = EncodingID.values()[buf.get()];
            int paramLen = ITF8.readUnsignedITF8(buf);
            byte[] paramBytes = new byte[paramLen];
            buf.get(paramBytes);
            this.tMap.put(key, new EncodingParams(id, paramBytes));
            ++i;
        }
    }

    public void write(Version cramVersion, OutputStream blockStream) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayOutputStream internalOutputStream = new ByteArrayOutputStream();){
                this.internalWrite(internalOutputStream);
                Block block = Block.createRawCompressionHeaderBlock(internalOutputStream.toByteArray());
                block.write(cramVersion.major, blockStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void internalWrite(OutputStream outputStream) throws IOException {
        ByteBuffer mapBuffer = ByteBuffer.allocate(102400);
        ITF8.writeUnsignedITF8(5, mapBuffer);
        mapBuffer.put(RN_readNamesIncluded.getBytes());
        mapBuffer.put((byte)(this.readNamesIncluded ? 1 : 0));
        mapBuffer.put(AP_alignmentPositionIsDelta.getBytes());
        mapBuffer.put((byte)(this.APDelta ? 1 : 0));
        mapBuffer.put(RR_referenceRequired.getBytes());
        mapBuffer.put((byte)(this.referenceRequired ? 1 : 0));
        mapBuffer.put(SM_substitutionMatrix.getBytes());
        mapBuffer.put(this.substitutionMatrix.getEncodedMatrix());
        mapBuffer.put(TD_tagIdsDictionary.getBytes());
        byte[] byArray = this.dictionaryToByteArray();
        ITF8.writeUnsignedITF8(byArray.length, mapBuffer);
        mapBuffer.put(byArray);
        mapBuffer.flip();
        byte[] byArray2 = new byte[mapBuffer.limit()];
        mapBuffer.get(byArray2);
        ITF8.writeUnsignedITF8(byArray2.length, outputStream);
        outputStream.write(byArray2);
        int size = 0;
        for (DataSeries dataSeries : this.encodingMap.keySet()) {
            if (this.encodingMap.get((Object)((Object)dataSeries)).id == EncodingID.NULL) continue;
            ++size;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(102400);
        ITF8.writeUnsignedITF8(size, byteBuffer);
        for (DataSeries dataSeries : this.encodingMap.keySet()) {
            if (this.encodingMap.get((Object)((Object)dataSeries)).id == EncodingID.NULL) continue;
            String dataSeriesAbbreviation = dataSeries.getCanonicalName();
            byteBuffer.put((byte)dataSeriesAbbreviation.charAt(0));
            byteBuffer.put((byte)dataSeriesAbbreviation.charAt(1));
            EncodingParams params = this.encodingMap.get((Object)dataSeries);
            byteBuffer.put((byte)(0xFF & params.id.getId()));
            ITF8.writeUnsignedITF8(params.params.length, byteBuffer);
            byteBuffer.put(params.params);
        }
        byteBuffer.flip();
        byte[] mapBytes2 = new byte[byteBuffer.limit()];
        byteBuffer.get(mapBytes2);
        ITF8.writeUnsignedITF8(mapBytes2.length, outputStream);
        outputStream.write(mapBytes2);
        mapBuffer = ByteBuffer.allocate(102400);
        ITF8.writeUnsignedITF8(this.tMap.size(), mapBuffer);
        for (Integer n : this.tMap.keySet()) {
            ITF8.writeUnsignedITF8((int)n, mapBuffer);
            EncodingParams params = this.tMap.get(n);
            mapBuffer.put((byte)(0xFF & params.id.getId()));
            ITF8.writeUnsignedITF8(params.params.length, mapBuffer);
            mapBuffer.put(params.params);
        }
        mapBuffer.flip();
        byte[] byArray3 = new byte[mapBuffer.limit()];
        mapBuffer.get(byArray3);
        ITF8.writeUnsignedITF8(byArray3.length, outputStream);
        outputStream.write(byArray3);
    }

    public static CompressionHeader read(int cramVersion, InputStream blockStream) {
        Block block = Block.read(cramVersion, blockStream);
        if (block.getContentType() != BlockContentType.COMPRESSION_HEADER) {
            throw new RuntimeIOException("Compression Header Block expected, found: " + block.getContentType().name());
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayInputStream internalStream = new ByteArrayInputStream(block.getUncompressedContent());){
                CompressionHeader header = new CompressionHeader();
                header.internalRead(internalStream);
                return header;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

