/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.writer;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.structure.DataSeriesType;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.ByteArrayOutputStream;
import java.util.Map;

public class DataSeriesWriter<T> {
    private final CRAMCodec<T> codec;

    public DataSeriesWriter(DataSeriesType valueType, EncodingParams params, BitOutputStream bitOutputStream, Map<Integer, ByteArrayOutputStream> outputMap) {
        CRAMEncoding encoding = EncodingFactory.createEncoding(valueType, params.id, params.params);
        this.codec = encoding.buildWriteCodec(bitOutputStream, outputMap);
    }

    void writeData(T value) {
        this.codec.write(value);
    }
}

