/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.DataSeriesReader;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Bases;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.Scores;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.DataSeries;
import htsjdk.samtools.cram.structure.DataSeriesType;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;

public class CramRecordReader {
    private final DataSeriesReader<Integer> bitFlagsCodec;
    private final DataSeriesReader<Byte> compressionBitFlagsCodec;
    private final DataSeriesReader<Integer> readLengthCodec;
    private final DataSeriesReader<Integer> alignmentStartCodec;
    private final DataSeriesReader<Integer> readGroupCodec;
    private final DataSeriesReader<byte[]> readNameCodec;
    private final DataSeriesReader<Integer> distanceToNextFragmentCodec;
    private final Map<Integer, DataSeriesReader<byte[]>> tagValueCodecs;
    private final DataSeriesReader<Integer> numberOfReadFeaturesCodec;
    private final DataSeriesReader<Integer> readFeaturePositionCodec;
    private final DataSeriesReader<Byte> readFeatureCodeCodec;
    private final DataSeriesReader<Byte> baseCodec;
    private final DataSeriesReader<Byte> qualityScoreCodec;
    private final DataSeriesReader<byte[]> qualityScoreArrayCodec;
    private final DataSeriesReader<Byte> baseSubstitutionCodec;
    private final DataSeriesReader<byte[]> insertionCodec;
    private final DataSeriesReader<byte[]> softClipCodec;
    private final DataSeriesReader<Integer> hardClipCodec;
    private final DataSeriesReader<Integer> paddingCodec;
    private final DataSeriesReader<Integer> deletionLengthCodec;
    private final DataSeriesReader<Integer> mappingScoreCodec;
    private final DataSeriesReader<Byte> mateBitFlagCodec;
    private final DataSeriesReader<Integer> mateReferenceIdCodec;
    private final DataSeriesReader<Integer> mateAlignmentStartCodec;
    private final DataSeriesReader<Integer> insertSizeCodec;
    private final DataSeriesReader<Integer> tagIdListCodec;
    private final DataSeriesReader<Integer> refIdCodec;
    private final DataSeriesReader<Integer> refSkipCodec;
    private final DataSeriesReader<byte[]> basesCodec;
    private final DataSeriesReader<byte[]> scoresCodec;
    private final Charset charset = Charset.forName("UTF8");
    private final boolean captureReadNames;
    private final byte[][][] tagIdDictionary;
    private final ReferenceContext refContext;
    protected final ValidationStringency validationStringency;
    protected final boolean APDelta;
    private final Map<DataSeries, EncodingParams> encodingMap;
    private final BitInputStream coreBlockInputStream;
    private final Map<Integer, ByteArrayInputStream> externalBlockInputMap;
    private CramCompressionRecord prevRecord;
    private int recordCounter = 0;

    public CramRecordReader(BitInputStream coreInputStream, Map<Integer, ByteArrayInputStream> externalInputMap, CompressionHeader header, ReferenceContext refContext, ValidationStringency validationStringency) {
        this.captureReadNames = header.readNamesIncluded;
        this.tagIdDictionary = header.dictionary;
        this.refContext = refContext;
        this.validationStringency = validationStringency;
        this.APDelta = header.APDelta;
        this.encodingMap = header.encodingMap;
        this.coreBlockInputStream = coreInputStream;
        this.externalBlockInputMap = externalInputMap;
        this.bitFlagsCodec = this.createDataReader(DataSeries.BF_BitFlags);
        this.compressionBitFlagsCodec = this.createDataReader(DataSeries.CF_CompressionBitFlags);
        this.readLengthCodec = this.createDataReader(DataSeries.RL_ReadLength);
        this.alignmentStartCodec = this.createDataReader(DataSeries.AP_AlignmentPositionOffset);
        this.readGroupCodec = this.createDataReader(DataSeries.RG_ReadGroup);
        this.readNameCodec = this.createDataReader(DataSeries.RN_ReadName);
        this.distanceToNextFragmentCodec = this.createDataReader(DataSeries.NF_RecordsToNextFragment);
        this.numberOfReadFeaturesCodec = this.createDataReader(DataSeries.FN_NumberOfReadFeatures);
        this.readFeaturePositionCodec = this.createDataReader(DataSeries.FP_FeaturePosition);
        this.readFeatureCodeCodec = this.createDataReader(DataSeries.FC_FeatureCode);
        this.baseCodec = this.createDataReader(DataSeries.BA_Base);
        this.qualityScoreCodec = this.createDataReader(DataSeries.QS_QualityScore);
        this.baseSubstitutionCodec = this.createDataReader(DataSeries.BS_BaseSubstitutionCode);
        this.insertionCodec = this.createDataReader(DataSeries.IN_Insertion);
        this.softClipCodec = this.createDataReader(DataSeries.SC_SoftClip);
        this.hardClipCodec = this.createDataReader(DataSeries.HC_HardClip);
        this.paddingCodec = this.createDataReader(DataSeries.PD_padding);
        this.deletionLengthCodec = this.createDataReader(DataSeries.DL_DeletionLength);
        this.mappingScoreCodec = this.createDataReader(DataSeries.MQ_MappingQualityScore);
        this.mateBitFlagCodec = this.createDataReader(DataSeries.MF_MateBitFlags);
        this.mateReferenceIdCodec = this.createDataReader(DataSeries.NS_NextFragmentReferenceSequenceID);
        this.mateAlignmentStartCodec = this.createDataReader(DataSeries.NP_NextFragmentAlignmentStart);
        this.insertSizeCodec = this.createDataReader(DataSeries.TS_InsertSize);
        this.tagIdListCodec = this.createDataReader(DataSeries.TL_TagIdList);
        this.refIdCodec = this.createDataReader(DataSeries.RI_RefId);
        this.refSkipCodec = this.createDataReader(DataSeries.RS_RefSkip);
        this.basesCodec = this.createDataReader(DataSeries.BB_bases);
        this.scoresCodec = this.createDataReader(DataSeries.QQ_scores);
        this.qualityScoreArrayCodec = new DataSeriesReader(DataSeriesType.BYTE_ARRAY, header.encodingMap.get((Object)DataSeries.QS_QualityScore), coreInputStream, externalInputMap);
        this.tagValueCodecs = header.tMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, mapEntry -> new DataSeriesReader(DataSeriesType.BYTE_ARRAY, (EncodingParams)mapEntry.getValue(), coreInputStream, externalInputMap)));
    }

    private <T> DataSeriesReader<T> createDataReader(DataSeries dataSeries) {
        if (this.encodingMap.containsKey((Object)dataSeries)) {
            return new DataSeriesReader(dataSeries.getType(), this.encodingMap.get((Object)dataSeries), this.coreBlockInputStream, this.externalBlockInputMap);
        }
        return null;
    }

    public int read(CramCompressionRecord cramRecord, int prevAlignmentStart) {
        try {
            int i;
            cramRecord.flags = this.bitFlagsCodec.readData();
            cramRecord.compressionFlags = this.compressionBitFlagsCodec.readData().byteValue();
            cramRecord.sequenceId = this.refContext.isMultiRef() ? this.refIdCodec.readData().intValue() : this.refContext.getSerializableId();
            cramRecord.readLength = this.readLengthCodec.readData();
            cramRecord.alignmentStart = this.APDelta ? prevAlignmentStart + this.alignmentStartCodec.readData() : this.alignmentStartCodec.readData();
            cramRecord.readGroupID = this.readGroupCodec.readData();
            if (this.captureReadNames) {
                cramRecord.readName = new String(this.readNameCodec.readData(), this.charset);
            }
            if (cramRecord.isDetached()) {
                cramRecord.mateFlags = this.mateBitFlagCodec.readData().byteValue();
                if (!this.captureReadNames) {
                    cramRecord.readName = new String(this.readNameCodec.readData(), this.charset);
                }
                cramRecord.mateSequenceID = this.mateReferenceIdCodec.readData();
                cramRecord.mateAlignmentStart = this.mateAlignmentStartCodec.readData();
                cramRecord.templateSize = this.insertSizeCodec.readData();
            } else if (cramRecord.isHasMateDownStream()) {
                cramRecord.recordsToNextFragment = this.distanceToNextFragmentCodec.readData();
            }
            Integer tagIdList = this.tagIdListCodec.readData();
            byte[][] ids = this.tagIdDictionary[tagIdList];
            if (ids.length > 0) {
                int tagCount = ids.length;
                cramRecord.tags = new ReadTag[tagCount];
                i = 0;
                while (i < ids.length) {
                    ReadTag tag;
                    int id = ReadTag.name3BytesToInt(ids[i]);
                    DataSeriesReader<byte[]> dataSeriesReader = this.tagValueCodecs.get(id);
                    cramRecord.tags[i] = tag = new ReadTag(id, dataSeriesReader.readData(), this.validationStringency);
                    ++i;
                }
            }
            if (!cramRecord.isSegmentUnmapped()) {
                int size = this.numberOfReadFeaturesCodec.readData();
                int prevPos = 0;
                LinkedList<ReadFeature> readFeatures = new LinkedList<ReadFeature>();
                cramRecord.readFeatures = readFeatures;
                int i2 = 0;
                while (i2 < size) {
                    int pos;
                    Byte operator = this.readFeatureCodeCodec.readData();
                    prevPos = pos = prevPos + this.readFeaturePositionCodec.readData();
                    switch (operator) {
                        case 66: {
                            ReadBase readBase = new ReadBase(pos, this.baseCodec.readData(), this.qualityScoreCodec.readData());
                            readFeatures.add(readBase);
                            break;
                        }
                        case 88: {
                            Substitution substitution = new Substitution();
                            substitution.setPosition(pos);
                            byte code = this.baseSubstitutionCodec.readData();
                            substitution.setCode(code);
                            readFeatures.add(substitution);
                            break;
                        }
                        case 73: {
                            Insertion insertion = new Insertion(pos, this.insertionCodec.readData());
                            readFeatures.add(insertion);
                            break;
                        }
                        case 83: {
                            SoftClip softClip = new SoftClip(pos, this.softClipCodec.readData());
                            readFeatures.add(softClip);
                            break;
                        }
                        case 72: {
                            HardClip hardCLip = new HardClip(pos, this.hardClipCodec.readData());
                            readFeatures.add(hardCLip);
                            break;
                        }
                        case 80: {
                            Padding padding = new Padding(pos, this.paddingCodec.readData());
                            readFeatures.add(padding);
                            break;
                        }
                        case 68: {
                            Deletion deletion = new Deletion(pos, this.deletionLengthCodec.readData());
                            readFeatures.add(deletion);
                            break;
                        }
                        case 78: {
                            RefSkip refSkip = new RefSkip(pos, this.refSkipCodec.readData());
                            readFeatures.add(refSkip);
                            break;
                        }
                        case 105: {
                            InsertBase insertBase = new InsertBase(pos, this.baseCodec.readData());
                            readFeatures.add(insertBase);
                            break;
                        }
                        case 81: {
                            BaseQualityScore baseQualityScore = new BaseQualityScore(pos, this.qualityScoreCodec.readData());
                            readFeatures.add(baseQualityScore);
                            break;
                        }
                        case 98: {
                            Bases bases = new Bases(pos, this.basesCodec.readData());
                            readFeatures.add(bases);
                            break;
                        }
                        case 113: {
                            Scores scores = new Scores(pos, this.scoresCodec.readData());
                            readFeatures.add(scores);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown read feature operator: " + operator);
                        }
                    }
                    ++i2;
                }
                cramRecord.mappingQuality = this.mappingScoreCodec.readData();
                if (cramRecord.isForcePreserveQualityScores()) {
                    cramRecord.qualityScores = this.qualityScoreArrayCodec.readDataArray(cramRecord.readLength);
                }
            } else if (cramRecord.isUnknownBases()) {
                cramRecord.readBases = SAMRecord.NULL_SEQUENCE;
                cramRecord.qualityScores = SAMRecord.NULL_QUALS;
            } else {
                byte[] bases = new byte[cramRecord.readLength];
                i = 0;
                while (i < bases.length) {
                    bases[i] = this.baseCodec.readData();
                    ++i;
                }
                cramRecord.readBases = bases;
                if (cramRecord.isForcePreserveQualityScores()) {
                    cramRecord.qualityScores = this.qualityScoreArrayCodec.readDataArray(cramRecord.readLength);
                }
            }
            ++this.recordCounter;
            this.prevRecord = cramRecord;
        }
        catch (SAMFormatException e) {
            if (this.prevRecord != null) {
                System.err.printf("Failed at record %d. Here is the previously read record: %s\n", this.recordCounter, this.prevRecord.toString());
            }
            throw e;
        }
        catch (Exception e) {
            if (this.prevRecord != null) {
                System.err.printf("Failed at record %d. Here is the previously read record: %s\n", this.recordCounter, this.prevRecord.toString());
            }
            throw new RuntimeIOException(e);
        }
        return cramRecord.alignmentStart;
    }
}

