/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.huffmanUtils;

import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanBitCode;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class HuffmanIntHelper {
    TreeMap<Integer, HuffmanBitCode> codes;
    private final int[] values;
    private final int[] bitLengths;
    private TreeMap<Integer, SortedSet<Integer>> codeBook;
    private final HuffmanBitCode[] sortedCodes;
    private final HuffmanBitCode[] sortedByValue;
    private final int[] sortedValues;
    private final int[] sortedValuesByBitCode;
    private final int[] sortedBitLensByBitCode;
    private final int[] bitCodeToValue;
    private static final Comparator<HuffmanBitCode> bitCodeComparator = new Comparator<HuffmanBitCode>(){

        @Override
        public int compare(HuffmanBitCode o1, HuffmanBitCode o2) {
            int result = o1.bitLength - o2.bitLength;
            if (result == 0) {
                return o1.bitCode - o2.bitCode;
            }
            return result;
        }
    };

    public HuffmanIntHelper(int[] values, int[] bitLengths) {
        this.values = values;
        this.bitLengths = bitLengths;
        this.buildCodeBook();
        this.buildCodes();
        ArrayList<HuffmanBitCode> list = new ArrayList<HuffmanBitCode>(this.codes.size());
        list.addAll(this.codes.values());
        Collections.sort(list, bitCodeComparator);
        this.sortedCodes = list.toArray(new HuffmanBitCode[list.size()]);
        this.sortedValues = Arrays.copyOf(values, values.length);
        Arrays.sort(this.sortedValues);
        int i = 0;
        this.sortedByValue = new HuffmanBitCode[this.sortedValues.length];
        int[] nArray = this.sortedValues;
        int n = this.sortedValues.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            this.sortedByValue[i++] = this.codes.get(value);
            ++n2;
        }
        int[] sortedBitCodes = new int[this.sortedCodes.length];
        this.sortedValuesByBitCode = new int[this.sortedCodes.length];
        this.sortedBitLensByBitCode = new int[this.sortedCodes.length];
        int maxBitCode = 0;
        int i2 = 0;
        while (i2 < sortedBitCodes.length) {
            sortedBitCodes[i2] = this.sortedCodes[i2].bitCode;
            this.sortedValuesByBitCode[i2] = this.sortedCodes[i2].value;
            this.sortedBitLensByBitCode[i2] = this.sortedCodes[i2].bitLength;
            if (maxBitCode < this.sortedCodes[i2].bitCode) {
                maxBitCode = this.sortedCodes[i2].bitCode;
            }
            ++i2;
        }
        this.bitCodeToValue = new int[maxBitCode + 1];
        Arrays.fill(this.bitCodeToValue, -1);
        i2 = 0;
        while (i2 < sortedBitCodes.length) {
            this.bitCodeToValue[this.sortedCodes[i2].bitCode] = i2;
            ++i2;
        }
    }

    private void buildCodeBook() {
        this.codeBook = new TreeMap();
        int i = 0;
        while (i < this.values.length) {
            if (this.codeBook.containsKey(this.bitLengths[i])) {
                this.codeBook.get(this.bitLengths[i]).add(this.values[i]);
            } else {
                TreeSet<Integer> entry = new TreeSet<Integer>();
                entry.add(this.values[i]);
                this.codeBook.put(this.bitLengths[i], entry);
            }
            ++i;
        }
    }

    private void buildCodes() {
        this.codes = new TreeMap();
        int codeLength = 0;
        int codeValue = -1;
        for (Integer key : this.codeBook.keySet()) {
            SortedSet<Integer> get = this.codeBook.get(key);
            int intKey = Integer.parseInt(((Object)key).toString());
            for (Integer entry : get) {
                HuffmanBitCode code = new HuffmanBitCode();
                code.bitLength = intKey;
                code.value = entry;
                ++codeValue;
                int delta = intKey - codeLength;
                code.bitCode = codeValue <<= delta;
                codeLength += delta;
                if (HuffmanIntHelper.NumberOfSetBits(codeValue) > intKey) {
                    throw new IllegalArgumentException("Symbol out of range");
                }
                this.codes.put(entry, code);
            }
        }
    }

    public final long write(BitOutputStream bitOutputStream, int value) {
        int index = Arrays.binarySearch(this.sortedValues, value);
        HuffmanBitCode code = this.sortedByValue[index];
        if (code.value != value) {
            throw new RuntimeException(String.format("Searching for %d but found %s.", value, code.toString()));
        }
        bitOutputStream.write(code.bitCode, code.bitLength);
        return code.bitLength;
    }

    public final int read(BitInputStream bitInputStream) {
        int prevLen = 0;
        int bits = 0;
        int i = 0;
        while (i < this.sortedCodes.length) {
            int length = this.sortedCodes[i].bitLength;
            bits <<= length - prevLen;
            prevLen = length;
            int index = this.bitCodeToValue[bits |= bitInputStream.readBits(length - prevLen)];
            if (index > -1 && this.sortedBitLensByBitCode[index] == length) {
                return this.sortedValuesByBitCode[index];
            }
            int j = i;
            while (this.sortedCodes[j + 1].bitLength == length && j < this.sortedCodes.length) {
                ++i;
                ++j;
            }
            ++i;
        }
        throw new RuntimeException("Not found.");
    }

    private static int NumberOfSetBits(int i) {
        i -= i >> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >> 2 & 0x33333333);
        return (i + (i >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }
}

