/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanByteCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class CanonicalHuffmanByteEncoding
extends CRAMEncoding<Byte> {
    private final byte[] values;
    private final int[] bitLengths;
    private final ByteBuffer buf;

    private CanonicalHuffmanByteEncoding(byte[] values, int[] bitLengths) {
        super(EncodingID.HUFFMAN);
        this.values = values;
        this.bitLengths = bitLengths;
        this.buf = ByteBuffer.allocate(5 * (values.length + bitLengths.length));
    }

    public static CanonicalHuffmanByteEncoding fromParams(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        int valueSize = ITF8.readUnsignedITF8(buf);
        byte[] values = new byte[valueSize];
        buf.get(values);
        int lengthSize = ITF8.readUnsignedITF8(buf);
        int[] bitLengths = new int[lengthSize];
        int i = 0;
        while (i < lengthSize) {
            bitLengths[i] = ITF8.readUnsignedITF8(buf);
            ++i;
        }
        return new CanonicalHuffmanByteEncoding(values, bitLengths);
    }

    @Override
    public byte[] toByteArray() {
        byte value;
        this.buf.clear();
        ITF8.writeUnsignedITF8(this.values.length, this.buf);
        Object[] objectArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            value = objectArray[n2];
            this.buf.put(value);
            ++n2;
        }
        ITF8.writeUnsignedITF8(this.bitLengths.length, this.buf);
        objectArray = this.bitLengths;
        n = this.bitLengths.length;
        n2 = 0;
        while (n2 < n) {
            value = objectArray[n2];
            ITF8.writeUnsignedITF8((int)value, this.buf);
            ++n2;
        }
        this.buf.flip();
        byte[] array = new byte[this.buf.limit()];
        this.buf.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Byte> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        return new CanonicalHuffmanByteCodec(coreBlockInputStream, coreBlockOutputStream, this.values, this.bitLengths);
    }
}

