/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import java.nio.ByteBuffer;

class Decoding {
    Decoding() {
    }

    static void RansDecSymbolInit(RansDecSymbol symbol, int start, int freq) {
        assert (start <= 65536);
        assert (freq <= 65536 - start);
        symbol.start = start;
        symbol.freq = freq;
    }

    private static int RansDecAdvanceStep(int r, int start, int freq, int scale_bits) {
        int mask = (1 << scale_bits) - 1;
        return freq * (r >> scale_bits) + (r & mask) - start;
    }

    static int RansDecAdvanceSymbolStep(int r, RansDecSymbol sym, int scale_bits) {
        return Decoding.RansDecAdvanceStep(r, sym.start, sym.freq, scale_bits);
    }

    static int RansDecGet(int r, int scale_bits) {
        return r & (1 << scale_bits) - 1;
    }

    static int RansDecAdvanceSymbol(int r, ByteBuffer pptr, RansDecSymbol sym, int scale_bits) {
        return Decoding.RansDecAdvance(r, pptr, sym.start, sym.freq, scale_bits);
    }

    private static int RansDecAdvance(int r, ByteBuffer pptr, int start, int freq, int scale_bits) {
        int mask = (1 << scale_bits) - 1;
        if ((r = freq * (r >> scale_bits) + (r & mask) - start) < 0x800000) {
            int b;
            while ((r = r << 8 | (b = 0xFF & pptr.get())) < 0x800000) {
            }
        }
        return r;
    }

    static int RansDecRenormalize(int r, ByteBuffer pptr) {
        if (r < 0x800000) {
            while ((r = r << 8 | 0xFF & pptr.get()) < 0x800000) {
            }
        }
        return r;
    }

    static class AriDecoder {
        final FC[] fc = new FC[256];
        byte[] R;

        AriDecoder() {
        }
    }

    static class FC {
        int F;
        int C;

        FC() {
        }
    }

    static class RansDecSymbol {
        int start;
        int freq;

        RansDecSymbol() {
        }
    }
}

