/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public enum SamIndexes {
    BAI(".bai", "BAI\u0001".getBytes()),
    CRAI(".crai", new byte[]{31, -117}),
    CSI(".csi", "CSI\u0001".getBytes());

    public final String fileNameSuffix;
    public final byte[] magic;

    private SamIndexes(String fileNameSuffix, byte[] magic) {
        this.fileNameSuffix = fileNameSuffix;
        this.magic = magic;
    }

    public static InputStream openIndexFileAsBaiOrNull(File file, SAMSequenceDictionary dictionary) throws IOException {
        return SamIndexes.openIndexUrlAsBaiOrNull(file.toURI().toURL(), dictionary);
    }

    public static InputStream openIndexUrlAsBaiOrNull(URL url, SAMSequenceDictionary dictionary) throws IOException {
        if (url.getFile().toLowerCase().endsWith(SamIndexes.BAI.fileNameSuffix.toLowerCase())) {
            return url.openStream();
        }
        if (url.getFile().toLowerCase().endsWith(SamIndexes.CRAI.fileNameSuffix.toLowerCase())) {
            return CRAIIndex.openCraiFileAsBaiStream(url.openStream(), dictionary);
        }
        if (url.getFile().toLowerCase().endsWith(SamIndexes.CSI.fileNameSuffix.toLowerCase())) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream asBaiStreamOrNull(InputStream inputStream, SAMSequenceDictionary dictionary) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        bis.mark(SamIndexes.BAI.magic.length);
        if (SamIndexes.doesStreamStartWith(bis, SamIndexes.BAI.magic)) {
            bis.reset();
            return bis;
        }
        bis.reset();
        bis.mark(SamIndexes.CRAI.magic.length);
        if (SamIndexes.doesStreamStartWith(bis, SamIndexes.CRAI.magic)) {
            bis.reset();
            return CRAIIndex.openCraiFileAsBaiStream(bis, dictionary);
        }
        bis.reset();
        bis.mark(SamIndexes.CSI.magic.length);
        if (SamIndexes.doesStreamStartWith(bis, SamIndexes.CSI.magic)) {
            bis.reset();
            return bis;
        }
        bis.reset();
        return null;
    }

    public static SeekableStream asBaiSeekableStreamOrNull(SeekableStream inputStream, SAMSequenceDictionary dictionary) throws IOException {
        SeekableBufferedStream bis = new SeekableBufferedStream(inputStream);
        bis.seek(0L);
        if (SamIndexes.doesStreamStartWith(bis, SamIndexes.BAI.magic)) {
            bis.seek(0L);
            return bis;
        }
        bis.seek(0L);
        if (SamIndexes.doesStreamStartWith(bis, SamIndexes.CRAI.magic)) {
            bis.seek(0L);
            return CRAIIndex.openCraiFileAsBaiStream(bis, dictionary);
        }
        bis.reset();
        bis.seek(0L);
        if (SamIndexes.doesStreamStartWith(bis, SamIndexes.CSI.magic)) {
            bis.seek(0L);
            return bis;
        }
        return null;
    }

    private static boolean doesStreamStartWith(InputStream is, byte[] bytes) throws IOException {
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (is.read() != (0xFF & b)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

