/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractSAMHeaderRecord;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SamFileHeaderMerger {
    private static final char[] INT_TO_BASE36 = new char[36];
    private final SAMFileHeader mergedHeader;
    private Collection<SamReader> readers;
    private final Collection<SAMFileHeader> headers;
    private int recordCounter;
    private final Map<SAMFileHeader, Map<String, String>> samReadGroupIdTranslation = new IdentityHashMap<SAMFileHeader, Map<String, String>>();
    private boolean hasReadGroupCollisions = false;
    private boolean hasProgramGroupCollisions = false;
    private final Map<SAMFileHeader, Map<String, String>> samProgramGroupIdTranslation = new IdentityHashMap<SAMFileHeader, Map<String, String>>();
    private boolean hasMergedSequenceDictionary = false;
    private final Map<SAMFileHeader, Map<Integer, Integer>> samSeqDictionaryIdTranslationViaHeader = new IdentityHashMap<SAMFileHeader, Map<Integer, Integer>>();
    private static final HeaderRecordFactory<SAMReadGroupRecord> READ_GROUP_RECORD_FACTORY;
    private static final HeaderRecordFactory<SAMProgramRecord> PROGRAM_RECORD_FACTORY;
    private static final Comparator<AbstractSAMHeaderRecord> RECORD_ID_COMPARATOR;

    static {
        int aVal = 65;
        int zeroVal = 48;
        int i = 0;
        while (i < 10) {
            SamFileHeaderMerger.INT_TO_BASE36[i] = (char)(zeroVal + i);
            ++i;
        }
        i = 0;
        while (i < 26) {
            SamFileHeaderMerger.INT_TO_BASE36[i + 10] = (char)(aVal + i);
            ++i;
        }
        READ_GROUP_RECORD_FACTORY = new HeaderRecordFactory<SAMReadGroupRecord>(){

            @Override
            public SAMReadGroupRecord createRecord(String id, SAMReadGroupRecord srcReadGroupRecord) {
                return new SAMReadGroupRecord(id, srcReadGroupRecord);
            }
        };
        PROGRAM_RECORD_FACTORY = new HeaderRecordFactory<SAMProgramRecord>(){

            @Override
            public SAMProgramRecord createRecord(String id, SAMProgramRecord srcProgramRecord) {
                return new SAMProgramRecord(id, srcProgramRecord);
            }
        };
        RECORD_ID_COMPARATOR = new Comparator<AbstractSAMHeaderRecord>(){

            @Override
            public int compare(AbstractSAMHeaderRecord o1, AbstractSAMHeaderRecord o2) {
                return o1.getId().compareTo(o2.getId());
            }
        };
    }

    @Deprecated
    public SamFileHeaderMerger(Collection<SamReader> readers, SAMFileHeader.SortOrder sortOrder) {
        this(readers, sortOrder, false);
    }

    @Deprecated
    public SamFileHeaderMerger(Collection<SamReader> readers, SAMFileHeader.SortOrder sortOrder, boolean mergeDictionaries) {
        this(sortOrder, SamFileHeaderMerger.getHeadersFromReaders(readers), mergeDictionaries);
        this.readers = readers;
    }

    public SamFileHeaderMerger(SAMFileHeader.SortOrder sortOrder, Collection<SAMFileHeader> headers, boolean mergeDictionaries) {
        SAMSequenceDictionary sequenceDictionary;
        this.headers = new LinkedHashSet<SAMFileHeader>(headers);
        this.mergedHeader = new SAMFileHeader();
        try {
            sequenceDictionary = this.getSequenceDictionary(headers);
            this.hasMergedSequenceDictionary = false;
        }
        catch (SequenceUtil.SequenceListsDifferException pe) {
            if (mergeDictionaries) {
                sequenceDictionary = this.mergeSequenceDictionaries(headers);
                this.hasMergedSequenceDictionary = true;
            }
            throw pe;
        }
        this.mergedHeader.setSequenceDictionary(sequenceDictionary);
        for (SAMProgramRecord program : this.mergeProgramGroups(headers)) {
            this.mergedHeader.addProgramRecord(program);
        }
        List<SAMReadGroupRecord> readGroups = this.mergeReadGroups(headers);
        this.mergedHeader.setReadGroups(readGroups);
        this.mergedHeader.setGroupOrder(SAMFileHeader.GroupOrder.none);
        this.mergedHeader.setSortOrder(sortOrder);
        for (SAMFileHeader header : headers) {
            for (String comment : header.getComments()) {
                this.mergedHeader.addComment(comment);
            }
        }
    }

    private static List<SAMFileHeader> getHeadersFromReaders(Collection<SamReader> readers) {
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(readers.size());
        for (SamReader reader : readers) {
            headers.add(reader.getFileHeader());
        }
        return headers;
    }

    private List<SAMReadGroupRecord> mergeReadGroups(Collection<SAMFileHeader> headers) {
        HashSet<String> idsThatAreAlreadyTaken = new HashSet<String>();
        LinkedList readGroupsToProcess = new LinkedList();
        for (SAMFileHeader header : headers) {
            for (SAMReadGroupRecord readGroup : header.getReadGroups()) {
                if (!idsThatAreAlreadyTaken.add(readGroup.getId())) {
                    throw new SAMException("Input file: " + header + " contains more than one RG with the same id (" + readGroup.getId() + ")");
                }
                readGroupsToProcess.add(new HeaderRecordAndFileHeader<SAMReadGroupRecord>(readGroup, header));
            }
            idsThatAreAlreadyTaken.clear();
        }
        LinkedList<SAMReadGroupRecord> result = new LinkedList<SAMReadGroupRecord>();
        this.recordCounter = 0;
        this.hasReadGroupCollisions = this.mergeHeaderRecords(readGroupsToProcess, READ_GROUP_RECORD_FACTORY, idsThatAreAlreadyTaken, this.samReadGroupIdTranslation, result);
        Collections.sort(result, RECORD_ID_COMPARATOR);
        return result;
    }

    private List<SAMProgramRecord> mergeProgramGroups(Collection<SAMFileHeader> headers) {
        LinkedList<SAMProgramRecord> overallResult = new LinkedList<SAMProgramRecord>();
        HashSet<String> idsThatAreAlreadyTaken = new HashSet<String>();
        List<HeaderRecordAndFileHeader<SAMProgramRecord>> programGroupsLeftToProcess = new LinkedList<HeaderRecordAndFileHeader<SAMProgramRecord>>();
        for (SAMFileHeader header : headers) {
            for (SAMProgramRecord sAMProgramRecord : header.getProgramRecords()) {
                if (!idsThatAreAlreadyTaken.add(sAMProgramRecord.getId())) {
                    throw new SAMException("Input file: " + header + " contains more than one PG with the same id (" + sAMProgramRecord.getId() + ")");
                }
                programGroupsLeftToProcess.add(new HeaderRecordAndFileHeader<SAMProgramRecord>(sAMProgramRecord, header));
            }
            idsThatAreAlreadyTaken.clear();
        }
        this.recordCounter = 0;
        List<HeaderRecordAndFileHeader<SAMProgramRecord>> currentProgramGroups = new LinkedList<HeaderRecordAndFileHeader<SAMProgramRecord>>();
        Iterator programGroupsLeftToProcessIterator = programGroupsLeftToProcess.iterator();
        while (programGroupsLeftToProcessIterator.hasNext()) {
            HeaderRecordAndFileHeader headerRecordAndFileHeader = (HeaderRecordAndFileHeader)programGroupsLeftToProcessIterator.next();
            if (((SAMProgramRecord)headerRecordAndFileHeader.getHeaderRecord()).getAttribute("PP") != null) continue;
            programGroupsLeftToProcessIterator.remove();
            currentProgramGroups.add(headerRecordAndFileHeader);
        }
        while (!currentProgramGroups.isEmpty()) {
            LinkedList currentResult = new LinkedList();
            this.hasProgramGroupCollisions |= this.mergeHeaderRecords(currentProgramGroups, PROGRAM_RECORD_FACTORY, idsThatAreAlreadyTaken, this.samProgramGroupIdTranslation, currentResult);
            overallResult.addAll(currentResult);
            currentProgramGroups = this.translateIds(currentProgramGroups, this.samProgramGroupIdTranslation, false);
            programGroupsLeftToProcess = this.translateIds(programGroupsLeftToProcess, this.samProgramGroupIdTranslation, true);
            LinkedList<HeaderRecordAndFileHeader<SAMProgramRecord>> linkedList = new LinkedList<HeaderRecordAndFileHeader<SAMProgramRecord>>();
            Iterator<HeaderRecordAndFileHeader<SAMProgramRecord>> programGroupsLeftToProcessIterator2 = programGroupsLeftToProcess.iterator();
            block4: while (programGroupsLeftToProcessIterator2.hasNext()) {
                HeaderRecordAndFileHeader<SAMProgramRecord> pairLeftToProcess = programGroupsLeftToProcessIterator2.next();
                String ppIdOfRecordLeftToProcess = pairLeftToProcess.getHeaderRecord().getAttribute("PP");
                for (HeaderRecordAndFileHeader<SAMProgramRecord> justProcessedPair : currentProgramGroups) {
                    String idJustProcessed = justProcessedPair.getHeaderRecord().getId();
                    if (pairLeftToProcess.getFileHeader() != justProcessedPair.getFileHeader() || !ppIdOfRecordLeftToProcess.equals(idJustProcessed)) continue;
                    programGroupsLeftToProcessIterator2.remove();
                    linkedList.add(pairLeftToProcess);
                    continue block4;
                }
            }
            currentProgramGroups = linkedList;
        }
        if (!programGroupsLeftToProcess.isEmpty()) {
            StringBuffer errorMsg = new StringBuffer(String.valueOf(programGroupsLeftToProcess.size()) + " program groups weren't processed. Do their PP ids point to existing PGs? \n");
            for (HeaderRecordAndFileHeader headerRecordAndFileHeader : programGroupsLeftToProcess) {
                SAMProgramRecord record = (SAMProgramRecord)headerRecordAndFileHeader.getHeaderRecord();
                errorMsg.append("@PG ID:" + record.getProgramGroupId() + " PN:" + record.getProgramName() + " PP:" + record.getPreviousProgramGroupId() + "\n");
            }
            throw new SAMException(errorMsg.toString());
        }
        Collections.sort(overallResult, RECORD_ID_COMPARATOR);
        return overallResult;
    }

    private List<HeaderRecordAndFileHeader<SAMProgramRecord>> translateIds(List<HeaderRecordAndFileHeader<SAMProgramRecord>> programGroups, Map<SAMFileHeader, Map<String, String>> idTranslationTable, boolean translatePpIds) {
        LinkedList<HeaderRecordAndFileHeader<SAMProgramRecord>> result = new LinkedList<HeaderRecordAndFileHeader<SAMProgramRecord>>();
        for (HeaderRecordAndFileHeader<SAMProgramRecord> pair : programGroups) {
            SAMProgramRecord record = pair.getHeaderRecord();
            String id = record.getProgramGroupId();
            String ppId = record.getAttribute("PP");
            SAMFileHeader header = pair.getFileHeader();
            Map<String, String> translations = idTranslationTable.get(header);
            SAMProgramRecord translatedRecord = null;
            if (translations != null) {
                boolean needToTranslatePpId;
                String translatedId = translations.get(id);
                String translatedPpId = translatePpIds ? translations.get(ppId) : null;
                boolean needToTranslateId = translatedId != null && !translatedId.equals(id);
                boolean bl = needToTranslatePpId = translatedPpId != null && !translatedPpId.equals(ppId);
                if (needToTranslateId && needToTranslatePpId) {
                    translatedRecord = new SAMProgramRecord(translatedId, record);
                    translatedRecord.setAttribute("PP", translatedPpId);
                } else if (needToTranslateId) {
                    translatedRecord = new SAMProgramRecord(translatedId, record);
                } else if (needToTranslatePpId) {
                    translatedRecord = new SAMProgramRecord(id, record);
                    translatedRecord.setAttribute("PP", translatedPpId);
                }
            }
            if (translatedRecord != null) {
                result.add(new HeaderRecordAndFileHeader<Object>(translatedRecord, header));
                continue;
            }
            result.add(pair);
        }
        return result;
    }

    private <RecordType extends AbstractSAMHeaderRecord> boolean mergeHeaderRecords(List<HeaderRecordAndFileHeader<RecordType>> headerRecords, HeaderRecordFactory<RecordType> headerRecordFactory, HashSet<String> idsThatAreAlreadyTaken, Map<SAMFileHeader, Map<String, String>> idTranslationTable, List<RecordType> result) {
        LinkedHashMap idToRecord = new LinkedHashMap();
        for (HeaderRecordAndFileHeader<RecordType> pair : headerRecords) {
            LinkedList<SAMFileHeader> fileHeaders;
            RecordType record = pair.getHeaderRecord();
            SAMFileHeader header = pair.getFileHeader();
            String recordId = ((AbstractSAMHeaderRecord)record).getId();
            LinkedHashMap<RecordType, LinkedList<SAMFileHeader>> recordsWithSameId = (LinkedHashMap<RecordType, LinkedList<SAMFileHeader>>)idToRecord.get(recordId);
            if (recordsWithSameId == null) {
                recordsWithSameId = new LinkedHashMap<RecordType, LinkedList<SAMFileHeader>>();
                idToRecord.put(recordId, recordsWithSameId);
            }
            if ((fileHeaders = (LinkedList<SAMFileHeader>)recordsWithSameId.get(record)) == null) {
                fileHeaders = new LinkedList<SAMFileHeader>();
                recordsWithSameId.put(record, fileHeaders);
            }
            fileHeaders.add(header);
        }
        boolean hasCollisions = false;
        for (Map.Entry entry : idToRecord.entrySet()) {
            String recordId = (String)entry.getKey();
            Map recordsWithSameId = (Map)entry.getValue();
            for (Map.Entry recordWithUniqueAttr : recordsWithSameId.entrySet()) {
                String newId;
                AbstractSAMHeaderRecord record = (AbstractSAMHeaderRecord)recordWithUniqueAttr.getKey();
                List fileHeaders = (List)recordWithUniqueAttr.getValue();
                if (!idsThatAreAlreadyTaken.contains(recordId)) {
                    newId = recordId;
                    idsThatAreAlreadyTaken.add(recordId);
                    ++this.recordCounter;
                } else {
                    hasCollisions = true;
                    while (idsThatAreAlreadyTaken.contains(newId = String.valueOf(recordId) + "." + SamFileHeaderMerger.positiveFourDigitBase36Str(this.recordCounter++))) {
                    }
                    idsThatAreAlreadyTaken.add(newId);
                }
                for (SAMFileHeader fileHeader : fileHeaders) {
                    Map<String, String> readerTranslationTable = idTranslationTable.get(fileHeader);
                    if (readerTranslationTable == null) {
                        readerTranslationTable = new HashMap<String, String>();
                        idTranslationTable.put(fileHeader, readerTranslationTable);
                    }
                    readerTranslationTable.put(recordId, newId);
                }
                result.add(headerRecordFactory.createRecord(newId, record));
            }
        }
        return hasCollisions;
    }

    public static String positiveFourDigitBase36Str(int leftOver) {
        if (leftOver == 0) {
            return "0";
        }
        StringBuilder builder = new StringBuilder(10);
        while (leftOver > 0) {
            int valueIndex = leftOver % 36;
            builder.append(INT_TO_BASE36[valueIndex]);
            leftOver /= 36;
        }
        return builder.reverse().toString();
    }

    private SAMSequenceDictionary getSequenceDictionary(Collection<SAMFileHeader> headers) {
        SAMSequenceDictionary sequences = null;
        for (SAMFileHeader header : headers) {
            if (sequences == null) {
                sequences = header.getSequenceDictionary();
                continue;
            }
            SAMSequenceDictionary currentSequences = header.getSequenceDictionary();
            SequenceUtil.assertSequenceDictionariesEqual(sequences, currentSequences);
        }
        return sequences;
    }

    private SAMSequenceDictionary mergeSequenceDictionaries(Collection<SAMFileHeader> headers) {
        SAMSequenceDictionary sequences = new SAMSequenceDictionary();
        for (SAMFileHeader header : headers) {
            SAMSequenceDictionary currentSequences = header.getSequenceDictionary();
            sequences = this.mergeSequences(sequences, currentSequences);
        }
        this.createSequenceMapping(headers, sequences);
        return sequences;
    }

    private SAMSequenceDictionary mergeSequences(SAMSequenceDictionary mergeIntoDict, SAMSequenceDictionary mergeFromDict) {
        LinkedList<SAMSequenceRecord> holder = new LinkedList<SAMSequenceRecord>();
        LinkedList<SAMSequenceRecord> resultingDict = new LinkedList<SAMSequenceRecord>();
        for (SAMSequenceRecord sequenceRecord : mergeIntoDict.getSequences()) {
            resultingDict.add(sequenceRecord);
        }
        int prevloc = -1;
        SAMSequenceRecord previouslyMerged = null;
        for (SAMSequenceRecord sequenceRecord : mergeFromDict.getSequences()) {
            int loc = SamFileHeaderMerger.getIndexOfSequenceName(resultingDict, sequenceRecord.getSequenceName());
            if (loc == -1) {
                holder.add(sequenceRecord.clone());
                continue;
            }
            if (prevloc > loc) {
                throw new SAMException("Cannot merge sequence dictionaries because sequence " + sequenceRecord.getSequenceName() + " and " + previouslyMerged.getSequenceName() + " are in different orders in two input sequence dictionaries.");
            }
            resultingDict.addAll(loc, holder);
            prevloc = loc + holder.size();
            previouslyMerged = sequenceRecord;
            holder.clear();
        }
        if (!holder.isEmpty()) {
            resultingDict.addAll(holder);
        }
        return new SAMSequenceDictionary(resultingDict);
    }

    private static int getIndexOfSequenceName(List<SAMSequenceRecord> list, String sequenceName) {
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).getSequenceName().equals(sequenceName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createSequenceMapping(Collection<SAMFileHeader> headers, SAMSequenceDictionary masterDictionary) {
        LinkedList<String> resultingDictStr = new LinkedList<String>();
        for (SAMSequenceRecord r : masterDictionary.getSequences()) {
            resultingDictStr.add(r.getSequenceName());
        }
        for (SAMFileHeader header : headers) {
            HashMap<Integer, Integer> seqMap = new HashMap<Integer, Integer>();
            SAMSequenceDictionary dict = header.getSequenceDictionary();
            for (SAMSequenceRecord rec : dict.getSequences()) {
                seqMap.put(rec.getSequenceIndex(), resultingDictStr.indexOf(rec.getSequenceName()));
            }
            this.samSeqDictionaryIdTranslationViaHeader.put(header, seqMap);
        }
    }

    @Deprecated
    public String getReadGroupId(SamReader reader, String originalReadGroupId) {
        return this.getReadGroupId(reader.getFileHeader(), originalReadGroupId);
    }

    public String getReadGroupId(SAMFileHeader header, String originalReadGroupId) {
        return this.samReadGroupIdTranslation.get(header).get(originalReadGroupId);
    }

    @Deprecated
    public String getProgramGroupId(SamReader reader, String originalProgramGroupId) {
        return this.getProgramGroupId(reader.getFileHeader(), originalProgramGroupId);
    }

    public String getProgramGroupId(SAMFileHeader header, String originalProgramGroupId) {
        return this.samProgramGroupIdTranslation.get(header).get(originalProgramGroupId);
    }

    public boolean hasReadGroupCollisions() {
        return this.hasReadGroupCollisions;
    }

    public boolean hasProgramGroupCollisions() {
        return this.hasProgramGroupCollisions;
    }

    public boolean hasMergedSequenceDictionary() {
        return this.hasMergedSequenceDictionary;
    }

    public SAMFileHeader getMergedHeader() {
        return this.mergedHeader;
    }

    @Deprecated
    public Collection<SamReader> getReaders() {
        return this.readers;
    }

    public Collection<SAMFileHeader> getHeaders() {
        return this.headers;
    }

    @Deprecated
    public Integer getMergedSequenceIndex(SamReader reader, Integer oldReferenceSequenceIndex) {
        return this.getMergedSequenceIndex(reader.getFileHeader(), oldReferenceSequenceIndex);
    }

    public Integer getMergedSequenceIndex(SAMFileHeader header, Integer oldReferenceSequenceIndex) {
        Map<Integer, Integer> mapping = this.samSeqDictionaryIdTranslationViaHeader.get(header);
        if (mapping == null) {
            throw new SAMException("No sequence dictionary mapping available for header: " + header);
        }
        Integer newIndex = mapping.get(oldReferenceSequenceIndex);
        if (newIndex == null) {
            throw new SAMException("No mapping for reference index " + oldReferenceSequenceIndex + " from header: " + header);
        }
        return newIndex;
    }

    private static class HeaderRecordAndFileHeader<RecordType extends AbstractSAMHeaderRecord> {
        private final RecordType headerRecord;
        private final SAMFileHeader samFileHeader;

        public HeaderRecordAndFileHeader(RecordType headerRecord, SAMFileHeader samFileHeader) {
            this.headerRecord = headerRecord;
            this.samFileHeader = samFileHeader;
        }

        public RecordType getHeaderRecord() {
            return this.headerRecord;
        }

        public SAMFileHeader getFileHeader() {
            return this.samFileHeader;
        }
    }

    private static interface HeaderRecordFactory<RecordType extends AbstractSAMHeaderRecord> {
        public RecordType createRecord(String var1, RecordType var2);
    }
}

