/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinList;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SRAIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;

public class SRAIndex
implements BrowseableBAMIndex {
    public static final int SRA_BIN_SIZE = 16384;
    public static final int SRA_CHUNK_SIZE = 50000;
    private static final int SRA_BIN_INDEX_OFFSET = GenomicIndexUtil.LEVEL_STARTS[GenomicIndexUtil.LEVEL_STARTS.length - 1];
    private static final int MAX_FRAGMENT_OVERLAP = 5000;
    private SAMFileHeader header;
    private SRAIterator.RecordRangeInfo recordRangeInfo;

    public SRAIndex(SAMFileHeader header, SRAIterator.RecordRangeInfo recordRangeInfo) {
        this.header = header;
        this.recordRangeInfo = recordRangeInfo;
    }

    @Override
    public int getLevelSize(int levelNumber) {
        if (levelNumber == GenomicIndexUtil.LEVEL_STARTS.length - 1) {
            return 37450 - GenomicIndexUtil.LEVEL_STARTS[levelNumber] - 1;
        }
        return GenomicIndexUtil.LEVEL_STARTS[levelNumber + 1] - GenomicIndexUtil.LEVEL_STARTS[levelNumber];
    }

    @Override
    public int getLevelForBin(Bin bin) {
        if (bin.getBinNumber() < SRA_BIN_INDEX_OFFSET) {
            throw new RuntimeException("SRA only supports bins from the last level");
        }
        return GenomicIndexUtil.LEVEL_STARTS.length - 1;
    }

    @Override
    public int getFirstLocusInBin(Bin bin) {
        if (bin.getBinNumber() < SRA_BIN_INDEX_OFFSET) {
            throw new RuntimeException("SRA only supports bins from the last level");
        }
        return (bin.getBinNumber() - SRA_BIN_INDEX_OFFSET) * 16384 + 1;
    }

    @Override
    public int getLastLocusInBin(Bin bin) {
        if (bin.getBinNumber() < SRA_BIN_INDEX_OFFSET) {
            throw new RuntimeException("SRA only supports bins from the last level");
        }
        return (bin.getBinNumber() - SRA_BIN_INDEX_OFFSET + 1) * 16384;
    }

    @Override
    public BinList getBinsOverlapping(int referenceIndex, int startPos, int endPos) {
        long refLength = this.recordRangeInfo.getReferenceLengthsAligned().get(referenceIndex);
        long refStartPos = startPos - 1;
        long refEndPos = endPos;
        if (refEndPos >= refLength) {
            throw new RuntimeException("refEndPos is larger than reference length");
        }
        int firstBinNumber = (int)refStartPos / 16384;
        int lastBinNumber = (int)(refEndPos - 1L) / 16384;
        int numberOfBins = (int)refLength / 16384 + 1;
        BitSet binBitSet = new BitSet();
        binBitSet.set(0, SRA_BIN_INDEX_OFFSET, false);
        if (firstBinNumber > 0) {
            binBitSet.set(SRA_BIN_INDEX_OFFSET, SRA_BIN_INDEX_OFFSET + firstBinNumber, false);
        }
        binBitSet.set(SRA_BIN_INDEX_OFFSET + firstBinNumber, SRA_BIN_INDEX_OFFSET + lastBinNumber + 1, true);
        if (lastBinNumber + 1 < numberOfBins) {
            binBitSet.set(SRA_BIN_INDEX_OFFSET + lastBinNumber + 1, SRA_BIN_INDEX_OFFSET + numberOfBins, false);
        }
        return new BinList(referenceIndex, binBitSet);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(Bin bin) {
        return new BAMFileSpan(this.getBinChunks(bin));
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int referenceIndex, int startPos, int endPos) {
        BinList binList = this.getBinsOverlapping(referenceIndex, startPos, endPos);
        BAMFileSpan result = new BAMFileSpan();
        HashSet<Chunk> savedChunks = new HashSet<Chunk>();
        for (Bin bin : binList) {
            List<Chunk> chunks = this.getSpanOverlapping(bin).getChunks();
            for (Chunk chunk : chunks) {
                if (savedChunks.contains(chunk)) continue;
                savedChunks.add(chunk);
                result.add(chunk);
            }
        }
        return result;
    }

    @Override
    public long getStartOfLastLinearBin() {
        int numberOfReferences = this.recordRangeInfo.getReferenceLengthsAligned().size();
        long refOffset = this.recordRangeInfo.getReferenceOffsets().get(numberOfReferences - 1);
        long lastChunkNumber = this.recordRangeInfo.getReferenceLengthsAligned().get(numberOfReferences - 1) / 50000L;
        return lastChunkNumber * 50000L + refOffset;
    }

    @Override
    public BAMIndexMetaData getMetaData(int reference) {
        throw new UnsupportedOperationException("Getting of BAM index metadata for SRA is not implemented");
    }

    @Override
    public void close() {
    }

    private List<Chunk> getBinChunks(Bin bin) {
        if (bin.containsChunks()) {
            return bin.getChunkList();
        }
        if (bin.getBinNumber() < SRA_BIN_INDEX_OFFSET) {
            throw new RuntimeException("SRA only supports bins from the last level");
        }
        int binNumber = bin.getBinNumber() - SRA_BIN_INDEX_OFFSET;
        long refOffset = this.recordRangeInfo.getReferenceOffsets().get(bin.getReferenceSequence());
        int firstChunkCorrection = binNumber == 0 ? 0 : -5000;
        long binGlobalOffset = (long)(binNumber * 16384) + refOffset;
        long firstChunkNumber = (binGlobalOffset + (long)firstChunkCorrection) / 50000L;
        long lastChunkNumber = (binGlobalOffset + 16384L - 1L) / 50000L;
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        long chunkNumber = firstChunkNumber;
        while (chunkNumber <= lastChunkNumber) {
            chunks.add(new Chunk(chunkNumber * 50000L, (chunkNumber + 1L) * 50000L));
            ++chunkNumber;
        }
        return chunks;
    }
}

