/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.Murmur3;

public class DuplicateScoringStrategy {
    private static final Murmur3 hasher = new Murmur3(1);

    private static int getSumOfBaseQualities(SAMRecord rec) {
        int score = 0;
        byte[] byArray = rec.getBaseQualities();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b >= 15) {
                score += b;
            }
            ++n2;
        }
        return score;
    }

    public static short computeDuplicateScore(SAMRecord record, ScoringStrategy scoringStrategy) {
        return DuplicateScoringStrategy.computeDuplicateScore(record, scoringStrategy, false);
    }

    public static short computeDuplicateScore(SAMRecord record, ScoringStrategy scoringStrategy, boolean assumeMateCigar) {
        Short storedScore = (Short)record.getTransientAttribute((Object)Attr.DuplicateScore);
        if (storedScore == null) {
            short score = 0;
            switch (scoringStrategy) {
                case SUM_OF_BASE_QUALITIES: {
                    score = (short)(score + (short)Math.min(DuplicateScoringStrategy.getSumOfBaseQualities(record), 16383));
                    break;
                }
                case TOTAL_MAPPED_REFERENCE_LENGTH: {
                    if (!record.getReadUnmappedFlag()) {
                        score = (short)Math.min(record.getCigar().getReferenceLength(), 16383);
                    }
                    if (!assumeMateCigar || !record.getReadPairedFlag() || record.getMateUnmappedFlag()) break;
                    score = (short)(score + (short)Math.min(SAMUtils.getMateCigar(record).getReferenceLength(), 16383));
                    break;
                }
                case RANDOM: {
                    score = (short)(score + (short)(hasher.hashUnencodedChars(record.getReadName()) & 0x3FFF));
                    score = (short)(score - -8192);
                }
            }
            score = (short)(score + (record.getReadFailsVendorQualityCheckFlag() ? -16384 : 0));
            storedScore = score;
            record.setTransientAttribute((Object)Attr.DuplicateScore, storedScore);
        }
        return storedScore;
    }

    public static int compare(SAMRecord rec1, SAMRecord rec2, ScoringStrategy scoringStrategy, boolean assumeMateCigar) {
        if (rec1.getReadPairedFlag() != rec2.getReadPairedFlag()) {
            return rec1.getReadPairedFlag() ? -1 : 1;
        }
        int cmp = DuplicateScoringStrategy.computeDuplicateScore(rec2, scoringStrategy, assumeMateCigar) - DuplicateScoringStrategy.computeDuplicateScore(rec1, scoringStrategy, assumeMateCigar);
        if (cmp == 0) {
            cmp = SAMUtils.getCanonicalRecordName(rec1).compareTo(SAMUtils.getCanonicalRecordName(rec2));
        }
        return cmp;
    }

    public static int compare(SAMRecord rec1, SAMRecord rec2, ScoringStrategy scoringStrategy) {
        return DuplicateScoringStrategy.compare(rec1, rec2, scoringStrategy, false);
    }

    private static enum Attr {
        DuplicateScore;

    }

    public static enum ScoringStrategy {
        SUM_OF_BASE_QUALITIES,
        TOTAL_MAPPED_REFERENCE_LENGTH,
        RANDOM;

    }
}

