/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CRAMCRAIIndexer {
    private final CRAIIndex craiIndex = new CRAIIndex();
    private final GZIPOutputStream os;

    public CRAMCRAIIndexer(OutputStream os, SAMFileHeader samHeader) {
        if (samHeader.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new SAMException("CRAM file be coordinate-sorted for indexing.");
        }
        try {
            this.os = new GZIPOutputStream(new BufferedOutputStream(os));
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error opening CRAI index output stream");
        }
    }

    public void processContainer(Container container) {
        this.craiIndex.processContainer(container);
    }

    public void addEntry(CRAIEntry entry) {
        this.craiIndex.addEntry(entry);
    }

    public void finish() {
        try {
            this.craiIndex.writeIndex(this.os);
            this.os.flush();
            this.os.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error writing CRAI index to output stream");
        }
    }

    public static void writeIndex(SeekableStream cramStream, OutputStream craiStream) {
        try {
            CramHeader cramHeader = CramIO.readCramHeader(cramStream);
            CRAMCRAIIndexer indexer = new CRAMCRAIIndexer(craiStream, cramHeader.getSamFileHeader());
            Version cramVersion = cramHeader.getVersion();
            long offset = cramStream.position();
            Container container = ContainerIO.readContainer(cramVersion, (InputStream)cramStream);
            while (container != null && !container.isEOF()) {
                container.offset = offset;
                indexer.processContainer(container);
                offset = cramStream.position();
                container = ContainerIO.readContainer(cramVersion, (InputStream)cramStream);
            }
            indexer.finish();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error writing CRAI index to output stream");
        }
    }

    public static CRAIIndex readIndex(InputStream is) {
        CRAIIndex craiIndex = new CRAIIndex();
        try (Scanner scanner = null;){
            try {
                scanner = new Scanner(new GZIPInputStream(is));
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    craiIndex.addEntry(new CRAIEntry(line));
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException("Error reading CRAI index from output stream");
            }
        }
        return craiIndex;
    }
}

