/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.BedNode;
import base.BasePlayer.ChromDraw;
import base.BasePlayer.ClusterNode;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.Sample;
import base.BasePlayer.SampleNode;
import base.BasePlayer.Transcript;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VarNode {
    private final int position;
    static MethodLibrary.varSorter varsorter = new MethodLibrary.varSorter();
    private VarNode prev;
    private VarNode next;
    private final byte refBase;
    private ArrayList<Transcript.Exon> exons;
    private ArrayList<Transcript> transcripts;
    private boolean inGene;
    boolean inVarList;
    boolean bedhit;
    Integer clusterId;
    private ArrayList<BedNode> bedHits;
    String rscode;
    ClusterNode clusterNode;
    ArrayList<Map.Entry<String, ArrayList<SampleNode>>> vars = new ArrayList();
    boolean incluster;
    boolean indel;
    boolean found;
    public short phase = (short)-1;
    public String codon;
    boolean controlled;
    boolean annotationOnly = false;
    private Map.Entry<String, ArrayList<SampleNode>> entry;
    public boolean coding = false;

    public VarNode(int position, byte ref, String variation, int coverage, int calls, boolean genotype, Float quality, Float gq, HashMap<String, Float> advquals, String rscode, Sample sample, VarNode prev, VarNode next) {
        this.position = position;
        this.rscode = rscode;
        this.refBase = ref;
        if (variation.length() > 1) {
            this.indel = true;
        }
        if (this.vars.size() == 0) {
            if (sample != null) {
                AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(variation, new ArrayList());
                ((ArrayList)entry.getValue()).add(new SampleNode(coverage, calls, genotype, quality, gq, advquals, sample));
                this.vars.add(entry);
            }
        } else {
            this.found = false;
            for (Map.Entry<String, ArrayList<SampleNode>> entry : this.vars) {
                if (!entry.getKey().equals(variation)) continue;
                entry.getValue().add(new SampleNode(coverage, calls, genotype, quality, gq, advquals, sample));
                this.found = true;
                break;
            }
            if (!this.found) {
                Map.Entry<String, ArrayList<SampleNode>> entry;
                entry = new AbstractMap.SimpleEntry(variation, new ArrayList());
                entry.getValue().add(new SampleNode(coverage, calls, genotype, quality, gq, advquals, sample));
                this.vars.add(entry);
            }
        }
        this.prev = prev;
        this.next = next;
    }

    public void setTranscripts() {
        this.transcripts = new ArrayList();
    }

    public void setExons() {
        this.exons = new ArrayList();
    }

    public void setBedhits() {
        this.bedHits = new ArrayList();
    }

    public void remBedhits() {
        this.bedHits = null;
    }

    public void putNext(VarNode node) {
        this.next = node;
    }

    public void putPrev(VarNode node) {
        this.prev = node;
    }

    public byte getRefBase() {
        return this.refBase;
    }

    public int getPosition() {
        return this.position;
    }

    public VarNode getPrev() {
        return this.prev;
    }

    public VarNode getNextVisible(VarNode node) {
        node = node.getNext();
        while (Main.drawCanvas.hideNodeTotal(node)) {
            if (node == null) break;
            node = node.next;
        }
        return node;
    }

    private VarNode getNextVisibleCluster(VarNode node) {
        while (Main.drawCanvas.hideNodeCluster(node)) {
            if (node == null) break;
            node = node.next;
        }
        return node;
    }

    public String getChrom() {
        if (this.getTranscripts() != null) {
            return this.getTranscripts().get(0).getChrom();
        }
        if (this.getExons() != null) {
            return this.getExons().get(0).getTranscript().getChrom();
        }
        return null;
    }

    public VarNode getNext(VarNode node) {
        if (Main.drawCanvas.hideNodeCluster(this.next)) {
            if (this.next != null) {
                return this.getNextVisibleCluster(this.next.next);
            }
            return null;
        }
        return this.next;
    }

    public VarNode getNext() {
        return this.next;
    }

    public boolean isInGene() {
        return this.inGene;
    }

    public void setInGene() {
        this.inGene = true;
    }

    public void setBedhit(boolean value) {
        this.bedhit = value;
    }

    public boolean isBedhit() {
        return this.bedhit;
    }

    public ArrayList<BedNode> getBedHits() {
        return this.bedHits;
    }

    public void setCodon(String codon) {
        this.codon = ChromDraw.codons.get(codon);
    }

    public void setRscode(String value) {
        this.rscode = value;
    }

    public String isRscode() {
        return this.rscode;
    }

    public String getCodon() {
        return this.codon;
    }

    public List<Transcript.Exon> getExons() {
        return this.exons;
    }

    public List<Transcript> getTranscripts() {
        return this.transcripts;
    }

    public List<SampleNode> getSamples(String variation) {
        for (Map.Entry<String, ArrayList<SampleNode>> entry : this.vars) {
            if (!entry.getKey().equals(variation)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void addSample(String variation, int coverage, int calls, boolean genotype, Float quality, Float gq, HashMap<String, Float> advquals, Sample sample) {
        this.found = false;
        if (variation.length() > 1) {
            this.indel = true;
        }
        for (Map.Entry<String, ArrayList<SampleNode>> entry : this.vars) {
            if (!entry.getKey().equals(variation)) continue;
            entry.getValue().add(new SampleNode(coverage, calls, genotype, quality, gq, advquals, sample));
            this.found = true;
            break;
        }
        if (!this.found) {
            Map.Entry<String, ArrayList<SampleNode>> entry;
            entry = new AbstractMap.SimpleEntry(variation, new ArrayList());
            entry.getValue().add(new SampleNode(coverage, calls, genotype, quality, gq, advquals, sample));
            this.vars.add(entry);
        }
    }

    public void removeNode() {
        if (this.getPrev() != null) {
            this.getPrev().putNext(this.getNext());
        }
        if (this.getNext() != null) {
            this.getNext().putPrev(this.getPrev());
        }
        this.putNext(null);
        this.putPrev(null);
    }

    public void moveSample(Sample sample) {
        try {
            int v = this.vars.size() - 1;
            while (v >= 0) {
                this.entry = this.vars.get(v);
                int i = this.entry.getValue().size() - 1;
                while (i >= 0) {
                    if (this.entry.getValue().get(i).getSample() != null && this.entry.getValue().get(i).getSample().equals(sample)) {
                        Collections.sort((List)this.entry.getValue(), varsorter);
                        break;
                    }
                    --i;
                }
                --v;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeSample(Sample sample) {
        try {
            int v = this.vars.size() - 1;
            while (v >= 0) {
                this.entry = this.vars.get(v);
                int i = this.entry.getValue().size() - 1;
                while (i >= 0) {
                    if (this.entry.getValue().get(i).getSample() != null && this.entry.getValue().get(i).getSample().equals(sample)) {
                        this.entry.getValue().remove(i);
                        if (i > 0 && this.entry.getValue().get(i - 1).getSample().equals(sample)) {
                            int pointer = i - 1;
                            while (this.entry.getValue().get(pointer).getSample().equals(sample)) {
                                this.entry.getValue().remove(pointer);
                                i = --pointer;
                                if (pointer < 0) break;
                            }
                        }
                        if (this.entry.getValue().size() == 0) {
                            this.vars.remove(this.entry);
                        }
                    }
                    --i;
                }
                --v;
            }
            if (this.vars.size() == 0) {
                if (this.getNext() != null) {
                    this.getNext().putPrev(this.getPrev());
                }
                this.getPrev().putNext(this.getNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

