/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.ComboBoxRenderer;
import base.BasePlayer.Draw;
import base.BasePlayer.FileRead;
import base.BasePlayer.Main;
import base.BasePlayer.Sample;
import base.BasePlayer.SampleComboBox;
import base.BasePlayer.SampleNode;
import base.BasePlayer.VarNode;
import base.BasePlayer.VariantHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class SampleDialog
extends JPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    static Boolean loading = false;
    static JFrame frame = new JFrame("Sample data");
    static JLabel samplelabel = new JLabel("Sample name:");
    static JLabel motherlabel = new JLabel("Mother:");
    static JLabel fatherlabel = new JLabel("Father:");
    static JLabel sexlabel = new JLabel("Gender:");
    static JTextField sampleNameField = new JTextField("");
    static JTextField vcfpath = new JTextField("");
    static JTextField bampath = new JTextField("");
    static ComboBoxRenderer comborenderer = new ComboBoxRenderer();
    static Sample sample;
    static Vector<Sample> motherlist;
    static Vector<Sample> fatherlist;
    static Color[] colors;
    static SampleComboBox motherdrop;
    static SampleComboBox fatherdrop;
    static JComboBox<Color> colorBox;
    static JComboBox<String> sexdrop;
    static boolean fromUI;
    static JPanel panel;
    static JCheckBox affected;
    static JCheckBox annotation;
    static JCheckBox intersect;
    private static int annotationpointer;
    ActionListener parentDropActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "comboBoxChanged") {
                if (fromUI) {
                    return;
                }
                if (actionEvent.getSource() == fatherdrop) {
                    SampleComboBox box = (SampleComboBox)actionEvent.getSource();
                    if (SampleDialog.sample.father != null) {
                        SampleDialog.sample.father.children.remove(sample);
                    }
                    SampleDialog.sample.father = (Sample)box.getSelectedItem();
                    if (SampleDialog.sample.father != null) {
                        if (SampleDialog.sample.father.children == null) {
                            SampleDialog.sample.father.children = new ArrayList();
                        }
                        ++SampleDialog.sample.parents;
                        SampleDialog.sample.father.female = false;
                        SampleDialog.sample.father.children.add(sample);
                        SampleDialog.sample.father.familyColor = (Color)colorBox.getSelectedItem();
                        int i = 0;
                        while (i < SampleDialog.sample.father.children.size()) {
                            SampleDialog.sample.father.children.get((int)i).familyColor = (Color)colorBox.getSelectedItem();
                            ++i;
                        }
                    } else {
                        --SampleDialog.sample.parents;
                    }
                } else {
                    SampleComboBox box = (SampleComboBox)actionEvent.getSource();
                    if (SampleDialog.sample.mother != null) {
                        SampleDialog.sample.mother.children.remove(sample);
                    }
                    SampleDialog.sample.mother = (Sample)box.getSelectedItem();
                    if (SampleDialog.sample.mother != null) {
                        ++SampleDialog.sample.parents;
                        if (SampleDialog.sample.mother.children == null) {
                            SampleDialog.sample.mother.children = new ArrayList();
                        }
                        SampleDialog.sample.mother.female = true;
                        SampleDialog.sample.mother.children.add(sample);
                        SampleDialog.sample.mother.familyColor = (Color)colorBox.getSelectedItem();
                        int i = 0;
                        while (i < SampleDialog.sample.mother.children.size()) {
                            SampleDialog.sample.mother.children.get((int)i).familyColor = (Color)colorBox.getSelectedItem();
                            ++i;
                        }
                    } else {
                        --SampleDialog.sample.parents;
                    }
                }
                SampleDialog.this.setPanels();
                SampleDialog.checkFiles();
                Main.drawCanvas.repaint();
            }
        }
    };
    ActionListener colorAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "comboBoxChanged") {
                int i;
                if (fromUI) {
                    return;
                }
                JComboBox color = (JComboBox)actionEvent.getSource();
                if (SampleDialog.sample.father != null) {
                    SampleDialog.sample.father.familyColor = (Color)color.getSelectedItem();
                    i = 0;
                    while (i < SampleDialog.sample.father.children.size()) {
                        SampleDialog.sample.father.children.get((int)i).familyColor = (Color)color.getSelectedItem();
                        ++i;
                    }
                }
                if (SampleDialog.sample.mother != null) {
                    SampleDialog.sample.mother.familyColor = (Color)color.getSelectedItem();
                    i = 0;
                    while (i < SampleDialog.sample.mother.children.size()) {
                        SampleDialog.sample.mother.children.get((int)i).familyColor = (Color)color.getSelectedItem();
                        ++i;
                    }
                }
            }
            Main.drawCanvas.repaint();
        }
    };

    static {
        motherlist = new Vector();
        fatherlist = new Vector();
        colors = new Color[]{new Color(224, 160, 100), new Color(238, 80, 68), new Color(126, 126, 230), new Color(104, 192, 106)};
        fromUI = false;
        panel = new JPanel(new GridLayout(0, 1));
        affected = new JCheckBox("Affected");
        annotation = new JCheckBox("Annotation");
        intersect = new JCheckBox("Intersect");
    }

    static void checkFiles() {
        int affected = 0;
        int i = 0;
        while (i < Main.drawCanvas.sampleList.size()) {
            Sample sample = Main.drawCanvas.sampleList.get(i);
            if (sample.affected.booleanValue()) {
                ++affected;
            }
            if (sample.father != null || sample.mother != null) {
                if (!Main.drawCanvas.sampleList.contains(sample.father)) {
                    sample.father = null;
                }
                if (!Main.drawCanvas.sampleList.contains(sample.mother)) {
                    sample.mother = null;
                }
                sample.parents = sample.mother != null && sample.father != null ? 2 : 1;
            } else {
                sample.parents = 0;
                if (sample.children == null || sample.children.size() == 0) {
                    sample.familyColor = null;
                }
            }
            ++i;
        }
        FileRead.affected = affected;
    }

    void setDropboxes() {
        colorBox = new JComboBox<Color>(colors);
        colorBox.setMaximumRowCount(5);
        colorBox.setPreferredSize(new Dimension(50, 20));
        colorBox.setRenderer(new MyCellRenderer());
        colorBox.addActionListener(this.colorAction);
        String[] sexes = new String[]{"-", "Female", "Male"};
        sexdrop = new JComboBox<String>(sexes);
        sexdrop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "comboBoxChanged") {
                    if (fromUI) {
                        return;
                    }
                    JComboBox box = (JComboBox)e.getSource();
                    SampleDialog.sample.female = box.getSelectedIndex() == 0 ? null : (box.getSelectedIndex() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false));
                }
            }
        });
        if (SampleDialog.sample.female != null) {
            if (SampleDialog.sample.female.booleanValue()) {
                sexdrop.setSelectedIndex(1);
            } else {
                sexdrop.setSelectedIndex(2);
            }
            if (SampleDialog.sample.children != null && SampleDialog.sample.children.size() > 0 && (sample.equals(SampleDialog.sample.children.get((int)0).mother) || sample.equals(SampleDialog.sample.children.get((int)0).father))) {
                sexdrop.setEnabled(false);
            }
        }
        ArrayList<Sample> siblings = this.getSiblings(sample);
        motherlist.clear();
        motherlist.add(null);
        int i = 0;
        while (i < Main.drawCanvas.sampleList.size()) {
            if (!(Main.drawCanvas.sampleList.get(i).equals(sample) || SampleDialog.sample.children != null && SampleDialog.sample.children.contains(Main.drawCanvas.sampleList.get(i)) || SampleDialog.sample.father != null && SampleDialog.sample.father.equals(Main.drawCanvas.sampleList.get(i)) || Main.drawCanvas.sampleList.get((int)i).female != null && !Main.drawCanvas.sampleList.get((int)i).female.booleanValue() || siblings.contains(Main.drawCanvas.sampleList.get(i)) || Main.drawCanvas.sampleList.get((int)i).children != null && Main.drawCanvas.sampleList.get((int)i).children.size() > 0 && SampleDialog.sample.children != null && SampleDialog.sample.children.size() > 0 && Main.drawCanvas.sampleList.get((int)i).children.contains(SampleDialog.sample.children.get(0)))) {
                motherlist.add(Main.drawCanvas.sampleList.get(i));
            }
            ++i;
        }
        motherdrop = new SampleComboBox(motherlist);
        motherdrop.setRenderer(comborenderer);
        if (motherdrop.getActionListeners().length == 0) {
            motherdrop.addActionListener(this.parentDropActionListener);
        }
        if (SampleDialog.sample.mother != null) {
            fromUI = true;
            motherdrop.setSelectedItem(SampleDialog.sample.mother);
            fromUI = false;
        }
        fatherlist.clear();
        fatherlist.add(null);
        i = 0;
        while (i < Main.drawCanvas.sampleList.size()) {
            if (!(Main.drawCanvas.sampleList.get(i).equals(sample) || SampleDialog.sample.children != null && SampleDialog.sample.children.contains(Main.drawCanvas.sampleList.get(i)) || SampleDialog.sample.mother != null && SampleDialog.sample.mother.equals(Main.drawCanvas.sampleList.get(i)) || Main.drawCanvas.sampleList.get((int)i).female != null && Main.drawCanvas.sampleList.get((int)i).female.booleanValue() || siblings.contains(Main.drawCanvas.sampleList.get(i)) || Main.drawCanvas.sampleList.get((int)i).children != null && Main.drawCanvas.sampleList.get((int)i).children.size() > 0 && SampleDialog.sample.children != null && Main.drawCanvas.sampleList.get((int)i).children.size() > 0 && Main.drawCanvas.sampleList.get((int)i).children.contains(SampleDialog.sample.children.get(0)))) {
                fatherlist.add(Main.drawCanvas.sampleList.get(i));
            }
            ++i;
        }
        fatherdrop = new SampleComboBox(fatherlist);
        fatherdrop.setRenderer(comborenderer);
        if (fatherdrop.getActionListeners().length == 0) {
            fatherdrop.addActionListener(this.parentDropActionListener);
        }
        if (SampleDialog.sample.father != null) {
            fromUI = true;
            fatherdrop.setSelectedItem(SampleDialog.sample.father);
            fromUI = false;
        }
    }

    void setPanels() {
        panel.removeAll();
        panel.add(samplelabel);
        panel.add(sampleNameField);
        panel.add(annotation);
        panel.add(sexlabel);
        panel.add(sexdrop);
        panel.add(affected);
        panel.add(motherlabel);
        panel.add(motherdrop);
        panel.add(fatherlabel);
        panel.add(fatherdrop);
        annotationpointer = 0;
        int i = 0;
        while (i < panel.getComponentCount()) {
            if (panel.getComponent(i).equals(annotation)) {
                annotationpointer = i;
                break;
            }
            ++i;
        }
        if (affected.getActionListeners().length == 0) {
            affected.addActionListener(this);
            annotation.addActionListener(this);
            intersect.addActionListener(this);
        }
        if (SampleDialog.sample.children != null && SampleDialog.sample.children.size() > 0) {
            panel.add(new JLabel("Children:"));
            i = 0;
            while (i < SampleDialog.sample.children.size()) {
                if (!Main.drawCanvas.sampleList.contains(SampleDialog.sample.children.get(i))) {
                    SampleDialog.sample.children.remove(i);
                    --i;
                } else {
                    panel.add(new JLabel(SampleDialog.sample.children.get(i).getName()));
                }
                ++i;
            }
        }
        if (annotation.isSelected()) {
            panel.add((Component)intersect, annotationpointer + 1);
        } else {
            panel.remove(intersect);
        }
        ArrayList<Sample> siblings = this.getSiblings(sample);
        if (siblings.size() > 0) {
            panel.add(new JLabel("Siblings:"));
            int i2 = 0;
            while (i2 < siblings.size()) {
                panel.add(new JLabel(siblings.get(i2).getName()));
                ++i2;
            }
        }
        panel.add(colorBox);
        if (sample.getTabixFile() != null) {
            panel.add(new JLabel("VCF path:"));
            vcfpath.setPreferredSize(new Dimension(200, Main.defaultFontSize + 4));
            vcfpath.setText(sample.getTabixFile());
            vcfpath.setCaretPosition(0);
            panel.add(vcfpath);
        }
        if (SampleDialog.sample.samFile != null) {
            panel.add(new JLabel("BAM path:"));
            bampath.setPreferredSize(new Dimension(200, Main.defaultFontSize + 4));
            try {
                bampath.setText(SampleDialog.sample.samFile.getCanonicalPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bampath.setCaretPosition(0);
            panel.add(bampath);
        }
        frame.pack();
        int i3 = 0;
        while (i3 < frame.getContentPane().getComponentCount()) {
            frame.getContentPane().getComponent(i3).setMinimumSize(frame.getContentPane().getComponent(i3).getPreferredSize());
            ++i3;
        }
    }

    public SampleDialog(Sample sample) {
        super(new GridLayout(0, 1));
        try {
            SampleDialog.sample = sample;
            sampleNameField.setText(sample.getName());
            sampleNameField.addKeyListener(this);
            if (sample.affected != null) {
                affected.setSelected(sample.affected);
            }
            annotation.setSelected(sample.annotation);
            intersect.setSelected(sample.intersect);
            if (sample.annotation) {
                this.setComponentsEnabled(true);
            } else {
                this.setComponentsEnabled(false);
            }
            this.setDropboxes();
            SampleDialog.setFonts(Main.menuFont);
            this.setPanels();
            SampleDialog.checkFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    ArrayList<Sample> getSiblings(Sample sample) {
        int i;
        ArrayList<Sample> siblings = new ArrayList<Sample>();
        if (sample.father != null && sample.father.children.size() > 1) {
            i = 0;
            while (i < sample.father.children.size()) {
                if (!sample.father.children.get(i).equals(sample)) {
                    if (!Main.drawCanvas.sampleList.contains(sample.father.children.get(i))) {
                        sample.father.children.remove(i);
                        --i;
                    } else {
                        siblings.add(sample.father.children.get(i));
                    }
                }
                ++i;
            }
        }
        if (sample.mother != null && sample.mother.children.size() > 1) {
            i = 0;
            while (i < sample.mother.children.size()) {
                if (!sample.mother.children.get(i).equals(sample)) {
                    if (!Main.drawCanvas.sampleList.contains(sample.mother.children.get(i))) {
                        sample.mother.children.remove(i);
                        --i;
                    } else if (!siblings.contains(sample.mother.children.get(i))) {
                        siblings.add(sample.mother.children.get(i));
                    }
                }
                ++i;
            }
        }
        return siblings;
    }

    public void createAndShowGUI() {
        frame.setAlwaysOnTop(true);
        this.setOpaque(false);
        frame.setContentPane(panel);
        SampleDialog.setFonts(Main.menuFont);
        frame.pack();
        int ylocation = (int)MouseInfo.getPointerInfo().getLocation().getY();
        if (ylocation + frame.getHeight() > Main.frame.getY() + Main.frame.getHeight()) {
            ylocation = Main.frame.getY() + Main.frame.getHeight() - frame.getHeight() - 10;
        }
        frame.setMinimumSize(new Dimension(200, 300));
        frame.setLocation((int)(Main.frame.getLocation().getX() + (double)Main.sidebarWidth + 10.0), ylocation);
        frame.setVisible(true);
        int i = 0;
        while (i < frame.getContentPane().getComponentCount()) {
            frame.getContentPane().getComponent(i).setMinimumSize(frame.getContentPane().getComponent(i).getPreferredSize());
            ++i;
        }
    }

    static void setFonts(Font menuFont) {
        int i = 0;
        while (i < frame.getContentPane().getComponentCount()) {
            frame.getContentPane().getComponent(i).setFont(menuFont);
            ++i;
        }
        frame.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == affected) {
            SampleDialog.sample.affected = affected.isSelected();
            SampleDialog.checkFiles();
            Main.drawCanvas.repaint();
        } else if (event.getSource() == annotation) {
            SampleDialog.sample.annotation = annotation.isSelected();
            if (SampleDialog.sample.annotation) {
                --Main.varsamples;
                this.setComponentsEnabled(true);
                panel.add((Component)intersect, annotationpointer + 1);
            } else {
                ++Main.varsamples;
                this.setComponentsEnabled(false);
                panel.remove(intersect);
            }
            panel.repaint();
            panel.revalidate();
            frame.pack();
            this.updateVarsamples();
            boolean annotation = false;
            boolean intersect = false;
            int i = Main.drawCanvas.sampleList.size() - 1;
            while (i >= 0) {
                if (Main.drawCanvas.sampleList.get((int)i).annotation && Main.drawCanvas.sampleList.get((int)i).intersect) {
                    annotation = true;
                    intersect = true;
                    break;
                }
                if (Main.drawCanvas.sampleList.get((int)i).annotation) {
                    annotation = true;
                }
                --i;
            }
            if (annotation) {
                SampleDialog.checkAnnotation();
            }
            Main.drawCanvas.intersect = intersect;
            Main.drawCanvas.annotationOn = annotation;
            Draw.updatevars = true;
            Main.drawCanvas.repaint();
        } else if (event.getSource() == intersect) {
            SampleDialog.sample.intersect = intersect.isSelected();
            boolean annotation = false;
            boolean intersect = false;
            int i = Main.drawCanvas.sampleList.size() - 1;
            while (i >= 0) {
                if (Main.drawCanvas.sampleList.get((int)i).annotation && Main.drawCanvas.sampleList.get((int)i).intersect) {
                    annotation = true;
                    intersect = true;
                    break;
                }
                if (Main.drawCanvas.sampleList.get((int)i).annotation) {
                    annotation = true;
                }
                --i;
            }
            Main.drawCanvas.intersect = intersect;
            Main.drawCanvas.annotationOn = annotation;
            Draw.updatevars = true;
            Main.drawCanvas.repaint();
        }
    }

    static void checkAnnotation() {
        VarNode node = FileRead.head.getNext();
        while (node != null) {
            boolean found = false;
            int v = 0;
            while (v < node.vars.size()) {
                Map.Entry<String, ArrayList<SampleNode>> entry = node.vars.get(v);
                int m = 0;
                while (m < entry.getValue().size()) {
                    if (entry.getValue().get(m).getSample() != null && !entry.getValue().get((int)m).getSample().annotation) {
                        found = true;
                        break;
                    }
                    ++m;
                }
                if (found) break;
                ++v;
            }
            node.annotationOnly = !found;
            node = node.getNext();
        }
    }

    void setComponentsEnabled(boolean enabled) {
        if (enabled) {
            int i = annotationpointer + 1;
            while (i < panel.getComponentCount()) {
                panel.getComponent(i).setEnabled(false);
                ++i;
            }
        } else {
            int i = annotationpointer + 1;
            while (i < panel.getComponentCount()) {
                panel.getComponent(i).setEnabled(true);
                ++i;
            }
        }
    }

    void updateVarsamples() {
        VariantHandler.commonSlider.setMaximum(Main.varsamples);
        VariantHandler.geneSlider.setMaximum(Main.varsamples);
        VariantHandler.commonSlider.setUpperValue(Main.varsamples);
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
        sample.setName(String.valueOf(sampleNameField.getText()) + arg0.getKeyChar());
        Main.drawCanvas.repaint();
    }

    class MyCellRenderer
    extends JButton
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        boolean b = false;

        public MyCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public void setBackground(Color bg) {
            if (!this.b) {
                return;
            }
            super.setBackground(bg);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.b = true;
            this.setText(" ");
            this.setBackground((Color)value);
            this.b = false;
            return this;
        }
    }
}

