/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.ReadNode;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.TextCigarCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class SAread {
    ReadNode read;
    int readlength = 0;
    ArrayList<Object[]> reads = new ArrayList();
    static int chrom = 0;
    static int pos = 1;
    static int forward = 2;
    static int relativepos = 3;
    static int relativelength = 4;
    static int SARead = 5;

    public SAread(ReadNode read) {
        try {
            this.read = read;
            String[] SAs = read.SA.split(";");
            String chr = read.split.chrom;
            this.readlength = read.getCigar().getReadLength();
            Cigar cigar = read.getCigar();
            double readpos = 0.0;
            int pos = read.getPosition();
            int length = this.readlength;
            if (!read.getPrimary()) {
                length = read.getCigar().getReadLength();
                if (read.isForward()) {
                    if (cigar.getCigarElement(0).getOperator().compareTo(CigarOperator.HARD_CLIP) == 0) {
                        this.readlength += cigar.getCigarElement(0).getLength();
                    }
                    if (cigar.getCigarElement(cigar.getCigarElements().size() - 1).getOperator().compareTo(CigarOperator.HARD_CLIP) == 0) {
                        this.readlength += cigar.getCigarElement(cigar.getCigarElements().size() - 1).getLength();
                    }
                    readpos = (double)cigar.getCigarElement(0).getLength() / (double)this.readlength;
                } else {
                    if (cigar.getCigarElement(0).getOperator().compareTo(CigarOperator.HARD_CLIP) == 0) {
                        this.readlength += cigar.getCigarElement(0).getLength();
                    }
                    if (cigar.getCigarElement(cigar.getCigarElements().size() - 1).getOperator().compareTo(CigarOperator.HARD_CLIP) == 0) {
                        this.readlength += cigar.getCigarElement(cigar.getCigarElements().size() - 1).getLength();
                        readpos = (double)cigar.getCigarElement(cigar.getCigarElements().size() - 1).getLength() / (double)this.readlength;
                    }
                }
            } else if (read.isForward()) {
                if (cigar.getCigarElement(0).getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                    length -= cigar.getCigarElement(0).getLength();
                    readpos = (double)cigar.getCigarElement(0).getLength() / (double)this.readlength;
                }
                if (cigar.getCigarElement(cigar.getCigarElements().size() - 1).getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                    length -= cigar.getCigarElement(cigar.getCigarElements().size() - 1).getLength();
                }
            } else {
                if (cigar.getCigarElement(0).getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                    length -= cigar.getCigarElement(0).getLength();
                }
                if (cigar.getCigarElement(cigar.getCigarElements().size() - 1).getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                    length -= cigar.getCigarElement(cigar.getCigarElements().size() - 1).getLength();
                    readpos = (double)cigar.getCigarElement(cigar.getCigarElements().size() - 1).getLength() / (double)this.readlength;
                }
            }
            double relativelength = (double)length / (double)this.readlength;
            this.reads.add(this.makeReadList(chr, pos, read.isForward(), readpos, relativelength, read));
            boolean forward = true;
            int i = 0;
            while (i < SAs.length) {
                String[] sa = SAs[i].split(",");
                chr = sa[0];
                pos = Integer.parseInt(sa[1]);
                cigar = TextCigarCodec.decode(sa[3]);
                length = cigar.getReadLength();
                readpos = 0.0;
                if (sa[2].equals("-")) {
                    forward = false;
                    if (cigar.getCigarElement(0).getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                        length -= cigar.getCigarElement(0).getLength();
                    }
                    if (cigar.getCigarElement(cigar.getCigarElements().size() - 1).getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                        length -= cigar.getCigarElement(cigar.getCigarElements().size() - 1).getLength();
                        readpos = (double)cigar.getCigarElement(cigar.getCigarElements().size() - 1).getLength() / (double)this.readlength;
                    }
                } else {
                    forward = true;
                    if (cigar.getCigarElement(0).getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                        length -= cigar.getCigarElement(0).getLength();
                        readpos = (double)cigar.getCigarElement(0).getLength() / (double)this.readlength;
                    }
                    if (cigar.getCigarElement(cigar.getCigarElements().size() - 1).getOperator().compareTo(CigarOperator.SOFT_CLIP) == 0) {
                        length -= cigar.getCigarElement(cigar.getCigarElements().size() - 1).getLength();
                    }
                }
                relativelength = (double)length / (double)this.readlength;
                this.reads.add(this.makeReadList(chr, pos, forward, readpos, relativelength, null));
                ++i;
            }
            readSorter sorter = new readSorter();
            Collections.sort(this.reads, sorter);
            if (read.getMates() != null) {
                int i2 = 0;
                while (i2 < read.getMates().size()) {
                    int r = 0;
                    while (r < this.reads.size()) {
                        if (((Integer)this.reads.get(r)[SAread.pos]).intValue() == read.getMates().get(i2).getPosition()) {
                            this.reads.get((int)r)[SAread.SARead] = read.getMates().get(i2);
                        }
                        ++r;
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Object[] makeReadList(String chr, int position, boolean forward, double startpos, double length, ReadNode read) {
        Object[] readArray = new Object[6];
        readArray[SAread.chrom] = chr;
        readArray[SAread.pos] = position;
        readArray[SAread.forward] = forward;
        readArray[SAread.relativepos] = startpos;
        readArray[SAread.relativelength] = length;
        readArray[SAread.SARead] = read;
        return readArray;
    }

    public static class readSorter
    implements Comparator<Object[]> {
        @Override
        public int compare(Object[] o1, Object[] o2) {
            if ((Double)o1[relativepos] < (Double)o2[relativepos]) {
                return -1;
            }
            if ((Double)o1[relativepos] > (Double)o2[relativepos]) {
                return 1;
            }
            return 0;
        }
    }
}

