/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.ErrorLog;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.Reads;
import base.BasePlayer.Sample;
import base.BasePlayer.SplitClass;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.SAMRecord;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;

public class ReadNode {
    private final int position;
    private final int startoffset;
    private final int matepos;
    private int insertsize;
    private final Integer readWidth;
    private final short quality;
    Rectangle rect;
    private final String readName;
    private final boolean forward;
    private final boolean isDiscordant;
    private final boolean primary;
    private final boolean mateforward;
    private String mateChrom;
    SplitClass split;
    ReadNode prev;
    ReadNode next;
    int yposition;
    ArrayList<ReadNode> mates;
    final String SA;
    private final ArrayList<Map.Entry<Integer, Byte>> mismatches;
    private final Cigar cigar;

    public ReadNode() {
        this.yposition = 0;
        this.primary = true;
        this.position = -1;
        this.rect = null;
        this.readWidth = 0;
        this.readName = null;
        this.quality = 0;
        this.insertsize = 0;
        this.forward = false;
        this.SA = null;
        this.matepos = -1;
        this.mateChrom = null;
        this.mateforward = false;
        this.cigar = null;
        this.isDiscordant = false;
        this.mismatches = null;
        this.startoffset = 0;
    }

    public ReadNode(SAMRecord record, boolean cg, String chrom, Sample sample, SplitClass split, Reads readClass, ArrayList<Map.Entry<Integer, Byte>> mismatches) {
        block11: {
            this.yposition = 0;
            this.rect = new Rectangle();
            this.primary = !record.getSupplementaryAlignmentFlag();
            this.readName = record.getReadName();
            this.quality = (short)record.getMappingQuality();
            this.mismatches = mismatches;
            this.insertsize = record.getInferredInsertSize() == 0 ? record.getReadLength() : record.getInferredInsertSize();
            this.forward = !record.getReadNegativeStrandFlag();
            this.SA = record.getStringAttribute("SA");
            this.isDiscordant = MethodLibrary.isDiscordant(record, cg);
            this.split = split;
            if (record.getCigarString().contains("H") || this.SA != null) {
                this.position = record.getAlignmentStart();
                this.readWidth = record.getAlignmentEnd() - this.position + 1;
                this.startoffset = record.getAlignmentStart() - record.getUnclippedStart();
            } else {
                this.position = record.getUnclippedStart();
                this.readWidth = record.getUnclippedEnd() - this.position + 1;
                this.startoffset = 0;
            }
            if (record.getReadPairedFlag() && !record.getMateUnmappedFlag()) {
                if (!sample.hasMates) {
                    sample.hasMates = true;
                }
                this.mateChrom = record.getMateReferenceName().contains("chr") ? (record.getMateReferenceName().contains("M") ? String.valueOf(record.getMateReferenceName().replace("chr", "")) + "T" : record.getMateReferenceName().replace("chr", "")) : record.getMateReferenceName();
                this.mateforward = !record.getMateNegativeStrandFlag();
                this.matepos = record.getMateAlignmentStart();
                try {
                    if (!this.isDiscordant || sample.getMates() == null || sample.getMates().size() <= 0) break block11;
                    this.split = split;
                    if (sample.getMates().containsKey(record.getReadName())) {
                        this.mates = sample.getMates().get(record.getReadName());
                        this.mates.add(this);
                    }
                }
                catch (Exception e) {
                    ErrorLog.addError(e.getStackTrace());
                    e.printStackTrace();
                }
            } else if (this.SA != null) {
                this.mateChrom = null;
                this.mateforward = false;
                this.matepos = -1;
                if (sample.getMates() != null && sample.getMates().containsKey(record.getReadName())) {
                    this.split = split;
                    this.mates = sample.getMates().get(record.getReadName());
                    this.mates.add(this);
                }
            } else {
                this.mateChrom = null;
                this.mateforward = false;
                this.matepos = -1;
            }
        }
        this.cigar = record.getCigarLength() > 1 ? record.getCigar() : null;
    }

    void setRectBounds(int x, int y, int width, int height) {
        this.rect.setBounds(x, y, width, height);
    }

    Rectangle getRect() {
        return this.rect;
    }

    int getPosition() {
        return this.position;
    }

    int getStartOffset() {
        return this.startoffset;
    }

    int getWidth() {
        return this.readWidth;
    }

    String getName() {
        return this.readName;
    }

    int getMatePos() {
        return this.matepos;
    }

    String getMateChrom() {
        return this.mateChrom;
    }

    int getInsertSize() {
        return this.insertsize;
    }

    boolean isForward() {
        return this.forward;
    }

    boolean isMateForward() {
        return this.mateforward;
    }

    ReadNode getPrev() {
        return this.prev;
    }

    ReadNode getNext() {
        return this.next;
    }

    ArrayList<ReadNode> getMates() {
        return this.mates;
    }

    boolean getPrimary() {
        return this.primary;
    }

    void addMate(ReadNode mate) {
        this.mates.add(mate);
    }

    void setPrev(ReadNode node) {
        this.prev = node;
    }

    void setNext(ReadNode node) {
        this.next = node;
    }

    boolean isDiscordant() {
        return this.isDiscordant;
    }

    Cigar getCigar() {
        return this.cigar;
    }

    ArrayList<Map.Entry<Integer, Byte>> getMismatches() {
        return this.mismatches;
    }

    Short getMappingQuality() {
        return this.quality;
    }
}

