/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

public class FisherExact {
    private static final boolean DEBUG = false;
    private double[] f;
    int maxSize;

    public FisherExact(int maxSize) {
        this.maxSize = maxSize;
        this.f = new double[maxSize + 1];
        this.f[0] = 0.0;
        int i = 1;
        while (i <= this.maxSize) {
            this.f[i] = this.f[i - 1] + Math.log(i);
            ++i;
        }
    }

    public FisherExact(int maxSize, boolean useLookup) {
        this.maxSize = maxSize;
        this.f = new double[maxSize + 1];
        this.f[0] = 0.0;
        int i = 1;
        while (i <= this.maxSize) {
            this.f[i] = this.f[i - 1] + Math.log(i);
            ++i;
        }
        int count = 0;
        double minP = 0.05;
        int i2 = 1;
        while (i2 < maxSize) {
            int j = 1;
            while (j < maxSize) {
                int k = 1;
                while (k < maxSize) {
                    int m = 1;
                    while (m < maxSize) {
                        if (this.getTwoTailedP(i2, j, k, m) < minP) {
                            ++count;
                        }
                        ++m;
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        System.out.printf("MaxSize %d minP: %g  Count: %d %n", maxSize, minP, count);
    }

    public final double getP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = this.f[a + b] + this.f[c + d] + this.f[a + c] + this.f[b + d] - (this.f[a] + this.f[b] + this.f[c] + this.f[d] + this.f[n]);
        return Math.exp(p);
    }

    public final double getCumlativeP(int a, int b, int c, int d) {
        int i;
        int min;
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        if (a * d >= b * c) {
            min = c < b ? c : b;
            i = 0;
            while (i < min) {
                p += this.getP(++a, --b, --c, ++d);
                ++i;
            }
        }
        if (a * d < b * c) {
            min = a < d ? a : d;
            i = 0;
            while (i < min) {
                double pTemp = this.getP(--a, ++b, ++c, --d);
                p += pTemp;
                ++i;
            }
        }
        return p;
    }

    public final double getRightTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = c < b ? c : b;
        int i = 0;
        while (i < min) {
            p += this.getP(++a, --b, --c, ++d);
            ++i;
        }
        return p;
    }

    public final double getRightTailedPQuick(int a, int b, int c, int d, double maxP) {
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = c < b ? c : b;
        int i = 0;
        while (i < min && p < maxP) {
            p += this.getP(++a, --b, --c, ++d);
            ++i;
        }
        return p;
    }

    public final double getLeftTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        p += this.getP(a, b, c, d);
        int min = a < d ? a : d;
        int i = 0;
        while (i < min) {
            double pTemp = this.getP(--a, ++b, ++c, --d);
            p += pTemp;
            ++i;
        }
        return p;
    }

    public final double getTwoTailedP(int a, int b, int c, int d) {
        int n = a + b + c + d;
        if (n > this.maxSize) {
            return Double.NaN;
        }
        double p = 0.0;
        double baseP = this.getP(a, b, c, d);
        int initialA = a;
        int initialB = b;
        int initialC = c;
        int initialD = d;
        p += baseP;
        int min = c < b ? c : b;
        int i = 0;
        while (i < min) {
            double tempP;
            if ((tempP = this.getP(++a, --b, --c, ++d)) <= baseP) {
                p += tempP;
            }
            ++i;
        }
        a = initialA;
        b = initialB;
        c = initialC;
        d = initialD;
        min = a < d ? a : d;
        i = 0;
        while (i < min) {
            double pTemp;
            if ((pTemp = this.getP(--a, ++b, ++c, --d)) <= baseP) {
                p += pTemp;
            }
            ++i;
        }
        return p;
    }

    public static void main(String[] args) {
        FisherExact fe = new FisherExact(2000000);
        System.out.println(fe.getRightTailedP(2, 32, 450, 105760));
    }
}

