/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.BedTrack;
import base.BasePlayer.Draw;
import base.BasePlayer.FileRead;
import base.BasePlayer.Main;
import base.BasePlayer.TabixReaderMod;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ColumnSelector
extends JPanel
implements ActionListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    JFrame frame = new JFrame("Column selector");
    JPanel panel = new JPanel(new GridBagLayout());
    JTable table;
    JLabel info = new JLabel("Select correct columns for values (if TSV-file, select at least chromosome and start values)");
    BedTrack track = null;
    JButton save = new JButton("OK");
    boolean found = false;
    boolean tableSet = false;

    void setWindow() {
        try {
            JFrame.setDefaultLookAndFeelDecorated(false);
            if (Main.ref == null) {
                this.frame.setDefaultCloseOperation(0);
                this.frame.setVisible(true);
            } else {
                this.frame.setDefaultCloseOperation(0);
                this.frame.setVisible(false);
            }
            ColumnSelector newContentPane = this;
            this.frame.setContentPane(newContentPane);
            this.frame.setResizable(true);
            this.frame.setMinimumSize(new Dimension(600, 300));
            this.frame.addComponentListener(this);
            if (this.frame.isVisible()) {
                this.createTable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ColumnSelector() {
        super(new GridBagLayout());
        this.setWindow();
    }

    public ColumnSelector(BedTrack track) {
        super(new GridBagLayout());
        this.track = track;
        this.setWindow();
    }

    void createTable() {
        try {
            this.tableSet = true;
            GZIPInputStream gzip = null;
            BufferedReader reader = null;
            Object[][] data = null;
            if (this.track.file == null) {
                try {
                    int i;
                    String line;
                    SeekableStream stream = SeekableStreamFactory.getInstance().getStreamFor(this.track.url);
                    TabixReaderMod tabixReader = new TabixReaderMod(this.track.url.toString(), this.track.index.toString(), stream);
                    int count = 0;
                    Object[] columns = null;
                    while ((line = tabixReader.readLine()) != null) {
                        if (line.startsWith("#")) continue;
                        String[] split = line.split("\\s+");
                        if (count == 0) {
                            data = new String[11][split.length];
                            columns = new String[split.length];
                            i = 0;
                            while (i < split.length) {
                                data[0][i] = "Select";
                                if (this.track.chromcolumn != null && this.track.chromcolumn == i) {
                                    data[0][i] = "Chromosome";
                                } else if (this.track.startcolumn != null && this.track.startcolumn == i) {
                                    data[0][i] = "Start";
                                } else if (this.track.endcolumn != null && this.track.endcolumn == i) {
                                    data[0][i] = "End";
                                } else if (this.track.namecolumn != null && this.track.namecolumn == i) {
                                    data[0][i] = "Name";
                                } else if (this.track.valuecolumn != null && this.track.valuecolumn == i) {
                                    data[0][i] = "Value";
                                } else if (this.track.strandcolumn != null && this.track.strandcolumn == i) {
                                    data[0][i] = "Strand";
                                } else if (this.track.basecolumn != null && this.track.basecolumn == i) {
                                    data[0][i] = "Base";
                                }
                                ++i;
                            }
                        }
                        i = 0;
                        while (i < split.length) {
                            data[count + 1][i] = split[i];
                            ++i;
                        }
                        if (++count > 9) break;
                    }
                    tabixReader.close();
                    stream.close();
                    i = 0;
                    while (i < columns.length) {
                        columns[i] = "";
                        ++i;
                    }
                    this.panel.setBackground(Draw.sidecolor);
                    this.table = new JTable(data, columns);
                    i = 0;
                    while (i < columns.length) {
                        TableColumn column = this.table.getColumnModel().getColumn(i);
                        JComboBox<String> comboBox = new JComboBox<String>();
                        comboBox.addItem("None");
                        comboBox.addItem("Chromosome");
                        comboBox.addItem("Start");
                        comboBox.addItem("End");
                        comboBox.addItem("Name");
                        comboBox.addItem("Value");
                        comboBox.addItem("Strand");
                        comboBox.addItem("Base");
                        column.setCellEditor(new DefaultCellEditor(comboBox));
                        if (this.track.chromcolumn != null && this.track.chromcolumn == i) {
                            comboBox.setSelectedItem("Chromosome");
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.track.getHead().putNext(null);
                }
            } else {
                int i;
                String line;
                gzip = new GZIPInputStream(new FileInputStream(this.track.file));
                reader = new BufferedReader(new InputStreamReader(gzip));
                int count = 0;
                String[] columns = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    String[] split = line.split("\\s+");
                    if (count == 0) {
                        data = new String[11][split.length];
                        columns = new String[split.length];
                        i = 0;
                        while (i < split.length) {
                            data[0][i] = "Select";
                            if (this.track.chromcolumn != null && this.track.chromcolumn == i) {
                                data[0][i] = "Chromosome";
                            } else if (this.track.startcolumn != null && this.track.startcolumn == i) {
                                data[0][i] = "Start";
                            } else if (this.track.endcolumn != null && this.track.endcolumn == i) {
                                data[0][i] = "End";
                            } else if (this.track.namecolumn != null && this.track.namecolumn == i) {
                                data[0][i] = "Name";
                            } else if (this.track.valuecolumn != null && this.track.valuecolumn == i) {
                                data[0][i] = "Value";
                            } else if (this.track.strandcolumn != null && this.track.strandcolumn == i) {
                                data[0][i] = "Strand";
                            } else if (this.track.basecolumn != null && this.track.basecolumn == i) {
                                data[0][i] = "Base";
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < split.length) {
                        data[count + 1][i] = split[i];
                        ++i;
                    }
                    if (++count > 9) break;
                }
                i = 0;
                while (i < columns.length) {
                    columns[i] = "";
                    ++i;
                }
                reader.close();
                this.panel.setBackground(Draw.sidecolor);
                this.table = new JTable(data, columns);
                i = 0;
                while (i < columns.length) {
                    TableColumn column = this.table.getColumnModel().getColumn(i);
                    JComboBox<String> comboBox = new JComboBox<String>();
                    comboBox.addItem("None");
                    comboBox.addItem("Chromosome");
                    comboBox.addItem("Start");
                    comboBox.addItem("End");
                    comboBox.addItem("Name");
                    comboBox.addItem("Value");
                    comboBox.addItem("Strand");
                    comboBox.addItem("Base");
                    column.setCellEditor(new DefaultCellEditor(comboBox));
                    if (this.track.chromcolumn != null && this.track.chromcolumn == i) {
                        comboBox.setSelectedItem("Chromosome");
                    }
                    ++i;
                }
            }
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            this.table.setRowHeight(0, 30);
            this.panel.add((Component)this.save, c);
            c.gridx = 1;
            this.panel.add(this.info);
            c.gridx = 0;
            this.save.addActionListener(this);
            this.save.setPreferredSize(Main.buttonDimension);
            this.save.setMinimumSize(Main.buttonDimension);
            c = new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0);
            this.table.setAutoResizeMode(4);
            this.table.setVisible(true);
            this.panel.add((Component)this.table, c);
            this.add((Component)this.panel, c);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    if (ColumnSelector.this.track.file.getName().endsWith(".tsv.gz")) {
                        if (ColumnSelector.this.track.chromcolumn == null || ColumnSelector.this.track.startcolumn == null) {
                            ColumnSelector.this.info.setForeground(Color.red);
                            ColumnSelector.this.info.revalidate();
                        } else {
                            ColumnSelector.this.info.setForeground(Color.black);
                            ColumnSelector.this.frame.dispose();
                        }
                    } else {
                        ColumnSelector.this.frame.dispose();
                    }
                }
            });
            this.frame.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setFonts(Font menuFont) {
        int i = 0;
        while (i < this.panel.getComponentCount()) {
            this.panel.getComponent(i).setFont(menuFont);
            ++i;
        }
        if (this.table != null) {
            this.table.getTableHeader().setFont(menuFont);
            this.table.setFont(menuFont);
            this.table.setRowHeight(menuFont.getSize() + 4);
        }
        this.frame.pack();
    }

    public static void main(String[] args) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.save) {
            if (this.track != null) {
                int i = 0;
                while (i < this.table.getColumnCount()) {
                    String column = this.table.getValueAt(0, i).toString();
                    if (column.contains("Chr")) {
                        this.track.chromcolumn = i;
                    } else if (column.contains("Sta")) {
                        this.track.startcolumn = i;
                    } else if (column.contains("End")) {
                        this.track.endcolumn = i;
                    } else if (column.contains("Name")) {
                        this.track.namecolumn = i;
                    } else if (column.contains("Value")) {
                        this.track.valuecolumn = i;
                    } else if (column.contains("Str")) {
                        this.track.strandcolumn = i;
                    } else if (column.contains("Base")) {
                        this.track.basecolumn = i;
                    }
                    ++i;
                }
                if (this.track.chromcolumn != null && this.table.getValueAt(0, this.track.chromcolumn).toString().contains("Non")) {
                    this.track.chromcolumn = null;
                }
                if (this.track.startcolumn != null && this.table.getValueAt(0, this.track.startcolumn).toString().contains("Non")) {
                    this.track.startcolumn = null;
                }
                if (this.track.endcolumn != null && this.table.getValueAt(0, this.track.endcolumn).toString().contains("Non")) {
                    this.track.endcolumn = null;
                }
                if (this.track.namecolumn != null && this.table.getValueAt(0, this.track.namecolumn).toString().contains("Non")) {
                    this.track.namecolumn = null;
                }
                if (this.track.valuecolumn != null && this.table.getValueAt(0, this.track.valuecolumn).toString().contains("Non")) {
                    this.track.valuecolumn = null;
                }
                if (this.track.strandcolumn != null && this.table.getValueAt(0, this.track.strandcolumn).toString().contains("Non")) {
                    this.track.strandcolumn = null;
                }
                if (this.track.basecolumn != null && this.table.getValueAt(0, this.track.basecolumn).toString().contains("Non")) {
                    this.track.basecolumn = null;
                }
            }
            if (this.track.file != null && this.track.file.getName().endsWith(".tsv.gz") || this.track.url != null && this.track.url.toString().toLowerCase().endsWith(".tsv.gz")) {
                if (this.track.chromcolumn == null || this.track.startcolumn == null) {
                    this.info.setForeground(Color.red);
                    this.info.revalidate();
                } else {
                    this.info.setForeground(Color.black);
                    FileRead.setBedTrack(this.track);
                    this.frame.dispose();
                }
            } else {
                FileRead.setBedTrack(this.track);
                this.frame.dispose();
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.frame.setLocation(Main.frame.getLocationOnScreen().x + Main.frame.getWidth() / 2 - this.frame.getWidth() / 2, Main.frame.getLocationOnScreen().y + Main.frame.getHeight() / 6);
        if (!this.tableSet) {
            this.createTable();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

