/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.AminoEntry;
import base.BasePlayer.BedTrack;
import base.BasePlayer.ClusterNode;
import base.BasePlayer.Control;
import base.BasePlayer.ControlFile;
import base.BasePlayer.Draw;
import base.BasePlayer.ErrorLog;
import base.BasePlayer.FileRead;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.Sample;
import base.BasePlayer.SampleNode;
import base.BasePlayer.VarNode;
import base.BasePlayer.VariantHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.io.FilenameUtils;

public class ClusterTable
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    BufferedImage bufImage;
    ListSorter sorter = new ListSorter();
    int rowHeight = 15;
    int geneheaderlength = 0;
    int variants = 0;
    Graphics2D buf;
    String chrom = "";
    StringBuffer bedbuffer = new StringBuffer("");
    int width;
    int height;
    ArrayList<AminoEntry> aminoarray = new ArrayList();
    ArrayList<Sample> samples = new ArrayList();
    int mouseY = 0;
    int mouseX = 0;
    int pressX = 0;
    int pressY = 0;
    final JScrollPane tablescroll;
    ClusterNode hoverNode;
    ClusterNode selectedNode;
    String[] posSplit;
    String[] hoverString;
    int samplecount = 0;
    Enumeration<String> e;
    String base;
    ArrayList<Object[]> geneheader = new ArrayList();
    ArrayList<Object[]> header = new ArrayList();
    private int genemutcount;
    VarNode hoverVar;
    private VarNode selectedVar;
    private int listAdd;
    private String[] selectedString;
    private int pointer;
    int headerHover;
    boolean dot = false;
    Polygon sortTriangle = new Polygon();
    private int hoverSample = -1;
    private int mutcount;
    ArrayList<SampleNode> vararray = new ArrayList();
    SampleNode[] controlarray;
    StringBuffer[] bedarray;
    private Color textcolor;
    private double casefreq;
    VarNode varAdd;
    Map.Entry<String, ArrayList<SampleNode>> entry;
    MethodLibrary.controlsorter ctrlsort = new MethodLibrary.controlsorter();
    private Color linecolor;
    private ClusterNode cluster;
    private int geneHeaderHover;
    private boolean mouseDrag;
    private int resizeColumn;
    private int dragX;
    private int cases;
    private int firstrow;

    ClusterTable(int width, int height, JScrollPane tablescroll) {
        this.width = width;
        this.height = height;
        this.tablescroll = tablescroll;
        Object[] obj = new Object[]{"Sample", 10, (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Mut. count", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Position", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Base change", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Genotype", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Quality", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"rs-code", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        this.geneheaderlength = this.geneheader.size();
        obj = new Object[]{"ClusterId", 10, (int)((double)(width - 10) / 7.0)};
        this.header.add(obj);
        obj = new Object[]{"Mut. count", (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.header.add(obj);
        obj = new Object[]{"Width", (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.header.add(obj);
        obj = new Object[]{"Start position", (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.header.add(obj);
        obj = new Object[]{"Variant freq.", (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.header.add(obj);
        obj = new Object[]{"Flanking genes", (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.header.add(obj);
        this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(1, 1, 2));
        this.buf = (Graphics2D)this.bufImage.getGraphics();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void resizeTable() {
        if (this.bufImage.getWidth() != 1 && this.bufImage.getWidth() < (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2]) {
            this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
            this.buf = (Graphics2D)this.bufImage.getGraphics();
        }
    }

    void resizeTable(int width) {
        this.header.get((int)0)[1] = 0;
        this.header.get((int)0)[2] = (int)((double)width / (double)this.header.size());
        int i = 1;
        while (i < this.header.size()) {
            this.header.get((int)i)[1] = (Integer)this.header.get(i - 1)[1] + (Integer)this.header.get(i - 1)[2];
            this.header.get((int)i)[2] = (int)((double)width / (double)this.header.size());
            ++i;
        }
        this.geneheader.get((int)0)[2] = (width - 10) / this.geneheader.size();
        i = 1;
        while (i < this.geneheader.size()) {
            this.geneheader.get((int)i)[1] = (Integer)this.geneheader.get(i - 1)[1] + (Integer)this.geneheader.get(i - 1)[2];
            this.geneheader.get((int)i)[2] = (width - 10) / this.geneheader.size();
            ++i;
        }
        this.setPreferredSize(new Dimension(width, this.getHeight()));
        this.revalidate();
    }

    void resizeTable(int column, int amount) {
        if (this.headerHover != -1) {
            if ((Integer)this.header.get(column - 1)[2] + amount > 20) {
                this.header.get((int)(column - 1))[2] = (Integer)this.header.get(column - 1)[2] + amount;
                int i = column;
                while (i < this.header.size()) {
                    this.header.get((int)i)[1] = (Integer)this.header.get(i)[1] + amount;
                    ++i;
                }
            }
            if ((Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2] > this.getWidth()) {
                if (this.bufImage.getWidth() != 1 && this.bufImage.getWidth() < (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2]) {
                    this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
                    this.buf = (Graphics2D)this.bufImage.getGraphics();
                }
                this.setPreferredSize(new Dimension((Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2], this.getHeight()));
                this.revalidate();
            }
        } else {
            if ((Integer)this.geneheader.get(column - 1)[2] + amount > 20) {
                this.geneheader.get((int)(column - 1))[2] = (Integer)this.geneheader.get(column - 1)[2] + amount;
                int i = column;
                while (i < this.geneheader.size()) {
                    this.geneheader.get((int)i)[1] = (Integer)this.geneheader.get(i)[1] + amount;
                    ++i;
                }
            }
            if ((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] > this.getWidth()) {
                if (this.bufImage.getWidth() != 1 && this.bufImage.getWidth() < (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2]) {
                    this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
                    this.buf = (Graphics2D)this.bufImage.getGraphics();
                }
                this.setPreferredSize(new Dimension((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], this.getHeight()));
                this.revalidate();
            }
        }
        this.createPolygon();
        this.repaint();
    }

    void addColumnGeneheader(Object column) {
        Object[] obj = new Object[]{column, (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], 100};
        this.geneheader.add(obj);
        if ((Integer)obj[1] + (Integer)obj[2] > this.getWidth()) {
            if (this.bufImage.getWidth() != 1 && this.bufImage.getWidth() < (Integer)obj[1] + (Integer)obj[2]) {
                this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
                this.buf = (Graphics2D)this.bufImage.getGraphics();
            }
            this.setPreferredSize(new Dimension((Integer)obj[1] + (Integer)obj[2], this.getHeight()));
            this.revalidate();
        }
    }

    void addHeaderColumn(Object column) {
        Object[] obj = new Object[]{column, (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2], 100};
        this.header.add(obj);
        if ((Integer)obj[1] + (Integer)obj[2] > this.getWidth() && this.bufImage.getWidth() != 1 && this.bufImage.getWidth() < (Integer)obj[1] + (Integer)obj[2]) {
            this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
            this.buf = (Graphics2D)this.bufImage.getGraphics();
        }
        this.setPreferredSize(new Dimension((Integer)obj[1] + (Integer)obj[2], this.getHeight()));
        this.revalidate();
    }

    void drawScreen(Graphics g) {
        try {
            this.buf.setColor(Color.black);
            this.buf.fillRect(0, 0, this.getWidth(), this.tablescroll.getViewport().getHeight());
            this.genemutcount = 0;
            this.hoverVar = null;
            this.hoverSample = -1;
            this.headerHover = -1;
            this.geneHeaderHover = -1;
            if (!this.mouseDrag) {
                this.resizeColumn = -1;
            }
            if (Main.drawCanvas.clusterNodes != null) {
                this.firstrow = this.tablescroll.getVerticalScrollBar().getValue() / this.rowHeight - 1 - Main.drawCanvas.clusterNodes.size();
                if (this.firstrow < 0) {
                    this.firstrow = 0;
                }
                int i = 0;
                while (i < Main.drawCanvas.clusterNodes.size()) {
                    block108: {
                        this.dot = false;
                        if ((i + 1 + this.samplecount + Main.drawCanvas.clusterNodes.size()) * this.rowHeight >= this.tablescroll.getVerticalScrollBar().getValue()) {
                            if (i * this.rowHeight > this.tablescroll.getVerticalScrollBar().getValue() + this.tablescroll.getViewport().getHeight()) break;
                            if (this.mouseY >= this.rowHeight * (i + this.genemutcount + 1) && this.mouseY < this.rowHeight * (i + this.genemutcount + 2)) {
                                this.hoverNode = Main.drawCanvas.clusterNodes.get(i);
                            }
                            try {
                                this.buf.setColor(Color.darkGray);
                                this.buf.drawLine(4, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                this.buf.setColor(this.linecolor);
                                this.cluster = Main.drawCanvas.clusterNodes.get(i);
                                if (this.cluster.varnodes.get(0).getTranscripts() != null) {
                                    if (!this.chrom.equals(this.cluster.varnodes.get(0).getTranscripts().get(0).getChrom())) {
                                        this.chrom = this.cluster.varnodes.get(0).getTranscripts().get(0).getChrom();
                                    }
                                } else if (!this.chrom.equals(this.cluster.varnodes.get((int)0).getExons().get((int)0).transcript.getChrom())) {
                                    this.chrom = this.cluster.varnodes.get((int)0).getExons().get((int)0).transcript.getChrom();
                                }
                                int c = 0;
                                while (c < this.header.size()) {
                                    if (Main.drawCanvas.clusterNodes.get(i).equals(this.hoverNode) || Main.drawCanvas.clusterNodes.get(i).equals(this.selectedNode)) {
                                        this.buf.setColor(Color.yellow);
                                    } else {
                                        this.buf.setColor(Color.white);
                                    }
                                    if (c == 0) {
                                        this.buf.drawString("" + this.cluster.ID, (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    } else if (c == 1) {
                                        this.buf.drawString("" + this.cluster.nodecount, (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    } else if (c == 2) {
                                        this.buf.drawString("" + this.cluster.width, (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    } else if (c == 3) {
                                        this.buf.drawString(String.valueOf(this.chrom) + ":" + MethodLibrary.formatNumber(this.cluster.varnodes.get(0).getPosition()), (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    } else if (c == 4) {
                                        this.buf.drawString("" + MethodLibrary.round((double)this.cluster.nodecount / (double)this.cluster.width, 4), (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    } else if (c == 5) {
                                        if (this.cluster.varnodes.get(0).getExons() != null) {
                                            if (this.cluster.varnodes.get((int)0).coding) {
                                                this.buf.setColor(Color.red);
                                                this.buf.drawString(String.valueOf(this.cluster.varnodes.get(0).getExons().get(0).getTranscript().getGenename()) + " (Coding)", (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            } else {
                                                this.buf.setColor(Color.lightGray);
                                                this.buf.drawString(String.valueOf(this.cluster.varnodes.get(0).getExons().get(0).getTranscript().getGenename()) + " (UTR)", (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            }
                                        } else if (this.cluster.varnodes.get(0).isInGene()) {
                                            this.buf.setColor(Color.lightGray);
                                            this.buf.drawString(String.valueOf(this.cluster.varnodes.get(0).getTranscripts().get(0).getGenename()) + " (Intronic)", (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        } else {
                                            this.buf.setColor(Color.gray);
                                            if (!this.cluster.varnodes.get(0).getTranscripts().get(0).equals(this.cluster.varnodes.get(0).getTranscripts().get(1))) {
                                                this.buf.drawString(String.valueOf(this.cluster.varnodes.get(0).getTranscripts().get(0).getGenename()) + " ... " + this.cluster.varnodes.get(0).getTranscripts().get(1).getGenename(), (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            } else if (this.cluster.varnodes.get(0).getTranscripts().get(0).getEnd() > this.cluster.varnodes.get(0).getPosition()) {
                                                this.buf.drawString(" ... " + this.cluster.varnodes.get(0).getTranscripts().get(0).getGenename(), (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            } else {
                                                this.buf.drawString(String.valueOf(this.cluster.varnodes.get(0).getTranscripts().get(0).getGenename()) + " ... ", (Integer)this.header.get(c)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            }
                                        }
                                    } else if (c == 6 && this.cluster.varnodes.get(0).getBedHits() != null) {
                                        this.bedarray = MethodLibrary.makeTrackArray(this.cluster.varnodes.get(0), null, true);
                                        int b = 0;
                                        while (b < this.bedarray.length) {
                                            this.buf.setColor(Color.black);
                                            if (b == this.bedarray.length - 1) {
                                                this.buf.fillRect((Integer)this.header.get(c + b)[1] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth() - (Integer)this.header.get(c + b)[1], this.rowHeight - 1);
                                            } else {
                                                this.buf.fillRect((Integer)this.header.get(c + b)[1] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.header.get(c + b)[2], this.rowHeight - 1);
                                            }
                                            this.buf.setColor(Color.white);
                                            if (this.bedarray[b] != null) {
                                                this.buf.drawString(this.bedarray[b].toString(), (Integer)this.header.get(c + b)[1] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            }
                                            ++b;
                                        }
                                    }
                                    if (c < this.header.size() - 1 - Main.bedCanvas.bedTrack.size()) {
                                        this.buf.setColor(Color.black);
                                        this.buf.fillRect((Integer)this.header.get(c + 1)[1] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.header.get(c + 1)[2], this.rowHeight - 1);
                                    }
                                    ++c;
                                }
                                this.buf.setColor(Color.darkGray);
                                this.buf.drawLine(3, this.rowHeight + 3, 3, this.rowHeight * (i + this.genemutcount + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                int r = 0;
                                while (r < this.header.size()) {
                                    this.buf.drawLine((Integer)this.header.get(r)[1], this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.header.get(r)[1], this.rowHeight * (i + this.genemutcount + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                    ++r;
                                }
                                if (this.selectedNode == null || !this.selectedNode.equals(this.cluster)) break block108;
                                this.hoverSample = -1;
                                this.genemutcount = this.aminoarray.size() + 1;
                                this.listAdd = 1;
                                this.buf.drawLine(20, this.rowHeight * (i + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                this.drawGeneheader(this.rowHeight * (i + this.listAdd + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                int s = 0;
                                while (s < this.aminoarray.size()) {
                                    int v;
                                    this.buf.setColor(Color.darkGray);
                                    this.buf.drawLine(21, this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                    if (this.mouseY >= this.rowHeight * (i + s + this.listAdd + 2) && this.mouseY < this.rowHeight * (i + s + this.listAdd + 3)) {
                                        this.hoverNode = null;
                                        this.hoverVar = this.aminoarray.get(s).getNode();
                                        this.hoverString = this.aminoarray.get(s).getRow();
                                        this.buf.setColor(Color.white);
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                                this.hoverSample = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getSample().getIndex();
                                                break;
                                            }
                                            ++v;
                                        }
                                    } else if (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("nonsense")) {
                                        this.buf.setColor(Color.red);
                                    } else if (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("missense")) {
                                        this.buf.setColor(Color.yellow);
                                    } else if (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("synonymous")) {
                                        this.buf.setColor(Color.green);
                                    } else if (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("UTR")) {
                                        this.buf.setColor(Color.lightGray);
                                    } else {
                                        this.buf.setColor(Color.gray);
                                    }
                                    if (!this.aminoarray.get(s).getRow()[1].equals("1")) {
                                        this.buf.drawString("Multiple", 24, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    } else {
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                                this.buf.drawString(this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getSample().getName(), 24, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                break;
                                            }
                                            ++v;
                                        }
                                    }
                                    this.textcolor = this.hoverVar != null && this.hoverString.equals(this.aminoarray.get(s).getRow()) ? Color.white : (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("nonsense") ? Color.red : (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("missense") ? Color.yellow : (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("synonymous") ? Color.green : (this.aminoarray.get(s).getRow()[3].contains("UTR") ? Color.lightGray : Color.gray))));
                                    int h = 1;
                                    while (h < 4) {
                                        this.buf.setColor(Color.black);
                                        this.buf.fillRect((Integer)this.geneheader.get(h)[1] + 10, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(h)[2], this.rowHeight - 1);
                                        this.buf.setColor(this.textcolor);
                                        this.buf.drawString(this.aminoarray.get(s).getRow()[h], (Integer)this.geneheader.get(h)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        ++h;
                                    }
                                    if (this.aminoarray.get(s).getRow()[1].equals("1")) {
                                        this.buf.setColor(Color.black);
                                        this.buf.fillRect((Integer)this.geneheader.get(4)[1] + 10, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                        this.buf.setColor(this.textcolor);
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                                if (this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).isHomozygous()) {
                                                    this.buf.drawString("Hom (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCoverage() + ")", (Integer)this.geneheader.get(4)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    if (Control.controlData.controlsOn) {
                                                        this.cases = 2;
                                                        this.casefreq = 2.0 / (double)(Main.varsamples * 2);
                                                    }
                                                } else {
                                                    this.buf.drawString("Het (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCoverage() + ")", (Integer)this.geneheader.get(4)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    if (Control.controlData.controlsOn) {
                                                        this.cases = 1;
                                                        this.casefreq = 1.0 / (double)(Main.varsamples * 2);
                                                    }
                                                }
                                                this.buf.setColor(Color.black);
                                                this.buf.fillRect((Integer)this.geneheader.get(5)[1] + 1, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                this.buf.setColor(this.textcolor);
                                                this.buf.drawString("" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getQuality(), (Integer)this.geneheader.get(5)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            }
                                            ++v;
                                        }
                                    }
                                    if (Control.controlData.controlsOn) {
                                        this.cases = 0;
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                                this.cases = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).isHomozygous() ? (this.cases += Integer.parseInt(this.aminoarray.get(s).getRow()[1]) * 2) : (this.cases += Integer.parseInt(this.aminoarray.get(s).getRow()[1]));
                                            }
                                            ++v;
                                        }
                                        this.casefreq = (double)this.cases / (double)(Main.varsamples * 2);
                                    }
                                    this.buf.setColor(this.textcolor);
                                    this.buf.drawString(this.aminoarray.get(s).getRow()[4], (Integer)this.geneheader.get(6)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    if (Control.controlData.controlsOn) {
                                        this.buf.setColor(this.textcolor);
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                                int e;
                                                this.vararray = this.aminoarray.get((int)s).getNode().vars.get(v).getValue();
                                                this.controlarray = new SampleNode[Control.controlData.fileArray.size()];
                                                if (this.vararray.get((int)(this.vararray.size() - 1)).alleles != null) {
                                                    e = this.vararray.size() - 1;
                                                    while (e > 0) {
                                                        if (this.vararray.get((int)e).alleles == null) break;
                                                        this.controlarray[this.vararray.get((int)e).getControlSample().getIndex()] = this.vararray.get(e);
                                                        --e;
                                                    }
                                                }
                                                e = 0;
                                                while (e < this.controlarray.length) {
                                                    if (Control.controlData.fileArray.get((int)e).controlOn) {
                                                        if (this.controlarray[e] == null) {
                                                            this.buf.setColor(Color.black);
                                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                            this.buf.setColor(this.textcolor);
                                                            this.buf.drawString("0", (Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                            this.buf.setColor(Color.black);
                                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                            this.buf.setColor(this.textcolor);
                                                            this.buf.drawString("-", (Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                        } else {
                                                            this.buf.setColor(Color.black);
                                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                            this.buf.setColor(this.textcolor);
                                                            this.buf.drawString("" + MethodLibrary.round((double)this.controlarray[e].alleles.intValue() / (double)this.controlarray[e].allelenumber.intValue(), 2), (Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                            this.buf.setColor(Color.black);
                                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                            this.buf.setColor(this.textcolor);
                                                            this.buf.drawString(MethodLibrary.round(this.casefreq / ((double)this.controlarray[e].alleles.intValue() / (double)this.controlarray[e].allelenumber.intValue()), 2) + " (p=" + MethodLibrary.round(VariantHandler.table.fe.getRightTailedP(this.cases, Main.varsamples * 2 - this.cases, this.controlarray[e].alleles, this.controlarray[e].allelenumber - this.controlarray[e].alleles), 2) + ")", (Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                        }
                                                    } else {
                                                        this.buf.setColor(Color.black);
                                                        this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                        this.buf.setColor(Color.darkGray);
                                                        this.buf.drawString("Apply controls", (Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                        this.buf.setColor(Color.black);
                                                        this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                        this.buf.setColor(Color.darkGray);
                                                        this.buf.drawString("-", (Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    }
                                                    ++e;
                                                }
                                            }
                                            ++v;
                                        }
                                    } else {
                                        this.buf.setColor(Color.darkGray);
                                        int e = this.geneheaderlength;
                                        while (e < this.geneheader.size()) {
                                            if (this.geneheader.get(e)[0] instanceof ControlFile) {
                                                this.buf.drawString("Apply controls", (Integer)this.geneheader.get(e)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            }
                                            ++e;
                                        }
                                        this.buf.setColor(Color.lightGray);
                                    }
                                    this.vararray = null;
                                    if (Main.bedCanvas.bedOn) {
                                        int a = 0;
                                        while (a < this.aminoarray.size()) {
                                            this.bedarray = MethodLibrary.makeTrackArray(this.aminoarray.get(a).getNode(), this.aminoarray.get(a).getRow()[5], true);
                                            if (this.bedarray != null) {
                                                int b = 0;
                                                while (b < this.bedarray.length) {
                                                    this.buf.setColor(Color.black);
                                                    if (b == this.bedarray.length - 1) {
                                                        this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + b)[1] + 12, this.rowHeight * (i + a + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth() - (Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + b)[1], this.rowHeight - 1);
                                                    } else {
                                                        this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + b)[1] + 12, this.rowHeight * (i + a + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + b)[2], this.rowHeight - 1);
                                                    }
                                                    this.buf.setColor(Color.white);
                                                    if (this.bedarray[b] != null) {
                                                        this.buf.drawString(this.bedarray[b].toString(), (Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + b)[1] + 14, this.rowHeight * (i + a + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    }
                                                    ++b;
                                                }
                                            }
                                            ++a;
                                        }
                                    }
                                    this.buf.setColor(Color.darkGray);
                                    int j = 0;
                                    while (j < this.geneheader.size()) {
                                        this.buf.drawLine((Integer)this.geneheader.get(j)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(j)[1] + 11, this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                        ++j;
                                    }
                                    if (this.selectedVar != null && this.selectedString.equals(this.aminoarray.get(s).getRow()) && Integer.parseInt(this.selectedString[1]) > 1) {
                                        this.pointer = 0;
                                        v = 0;
                                        while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.selectedString[5])) {
                                                int l = 0;
                                                while (l < this.aminoarray.get((int)s).getNode().vars.get(v).getValue().size()) {
                                                    if (this.aminoarray.get((int)s).getNode().vars.get((int)v).getValue().get((int)l).alleles != null) break;
                                                    if (this.mouseY > this.rowHeight * (i + s + this.pointer + 4) && this.mouseY < this.rowHeight * (i + s + this.pointer + 5)) {
                                                        this.textcolor = Color.white;
                                                        this.hoverVar = this.aminoarray.get(s).getNode();
                                                        this.hoverString = this.aminoarray.get(s).getRow();
                                                        this.hoverSample = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getSample().getIndex();
                                                    } else {
                                                        this.textcolor = Color.lightGray;
                                                    }
                                                    this.buf.setColor(this.textcolor);
                                                    this.buf.drawString(this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getSample().getName(), 30, this.rowHeight * (i + s + this.pointer + 4) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    ++this.pointer;
                                                    this.buf.setColor(Color.black);
                                                    this.buf.fillRect((Integer)this.geneheader.get(4)[1] + 10, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                    this.buf.setColor(this.textcolor);
                                                    if (this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).isHomozygous()) {
                                                        this.buf.drawString("Hom (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCoverage() + ")", (Integer)this.geneheader.get(4)[1] + 14, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    } else {
                                                        this.buf.drawString("Het (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCoverage() + ")", (Integer)this.geneheader.get(4)[1] + 14, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    }
                                                    this.buf.setColor(Color.black);
                                                    this.buf.fillRect((Integer)this.geneheader.get(5)[1] + 10, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                    this.buf.setColor(this.textcolor);
                                                    this.buf.drawString("" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getQuality(), (Integer)this.geneheader.get(5)[1] + 14, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    this.buf.setColor(Color.darkGray);
                                                    int j2 = 4;
                                                    while (j2 < 7) {
                                                        this.buf.drawLine((Integer)this.geneheader.get(j2)[1] + 11, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue(), (Integer)this.geneheader.get(j2)[1] + 11, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight + 2);
                                                        ++j2;
                                                    }
                                                    ++l;
                                                }
                                            }
                                            ++v;
                                        }
                                        this.listAdd = Integer.parseInt(this.selectedString[1]) + 1;
                                        this.genemutcount = this.aminoarray.size() + this.listAdd;
                                        this.buf.setColor(Color.darkGray);
                                        this.buf.drawLine(21, this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                    }
                                    ++s;
                                }
                            }
                            catch (Exception e) {
                                ErrorLog.addError(e.getStackTrace());
                                e.printStackTrace();
                            }
                        }
                    }
                    ++i;
                }
                this.buf.setColor(Color.darkGray);
                this.buf.drawLine(4, this.rowHeight * (Main.drawCanvas.clusterNodes.size() + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (Main.drawCanvas.clusterNodes.size() + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
            }
            this.drawHeader();
            if (this.headerHover == -1 && this.geneHeaderHover == -1) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (this.resizeColumn == -1) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
            g.drawImage(this.bufImage, 0, this.tablescroll.getVerticalScrollBar().getValue(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void drawHeader() {
        int i = 0;
        while (i < this.header.size()) {
            this.buf.setColor(Color.darkGray);
            this.buf.fillRect((Integer)this.header.get(i)[1], 0, (Integer)this.header.get(i)[2] + 1, this.rowHeight);
            if (this.mouseY - this.tablescroll.getVerticalScrollBar().getValue() <= this.rowHeight) {
                if (this.mouseX >= (Integer)this.header.get(i)[1] && this.mouseX <= (Integer)this.header.get(i)[1] + (Integer)this.header.get(i)[2]) {
                    this.headerHover = i;
                    this.buf.setColor(Color.yellow);
                } else if (this.mouseX >= (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2]) {
                    this.headerHover = this.header.size();
                    this.buf.setColor(Color.white);
                } else {
                    this.buf.setColor(Color.white);
                }
            } else {
                this.buf.setColor(Color.white);
            }
            if (!this.mouseDrag && this.headerHover > -1 && i > 0 && i < this.header.size() && this.mouseX > (Integer)this.header.get(i)[1] - 5 && this.mouseX < (Integer)this.header.get(i)[1] + 5) {
                this.resizeColumn = i;
            }
            if (this.header.get(i)[0] instanceof String) {
                this.buf.drawString((String)this.header.get(i)[0], (Integer)this.header.get(i)[1] + 4, this.rowHeight - 2);
            } else if (this.header.get(i)[0] instanceof BedTrack) {
                BedTrack track = (BedTrack)this.header.get(i)[0];
                if (track.file != null) {
                    this.buf.drawString(track.file.getName(), (Integer)this.header.get(i)[1] + 4, this.rowHeight - 2);
                } else {
                    this.buf.drawString(FilenameUtils.getName(track.url.getFile()), (Integer)this.header.get(i)[1] + 4, this.rowHeight - 2);
                }
                Object var2_2 = null;
            }
            this.buf.setColor(Color.black);
            this.buf.drawLine((Integer)this.header.get(i)[1], 0, (Integer)this.header.get(i)[1], this.rowHeight);
            if (this.sorter.index > -1) {
                if (this.sorter.ascending) {
                    this.buf.setColor(Color.white);
                    this.buf.fillPolygon(this.sortTriangle);
                } else {
                    this.buf.setColor(Color.white);
                    this.buf.fillPolygon(this.sortTriangle);
                }
            }
            ++i;
        }
        this.buf.setColor(Color.darkGray);
        this.buf.fillRect((Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2] + 2, 0, this.width, this.rowHeight);
        this.buf.setColor(Color.black);
        this.buf.drawLine((Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2] + 1, 0, (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2] + 1, this.rowHeight);
        if (!this.mouseDrag && this.headerHover > -1 && this.resizeColumn == -1 && this.mouseX > (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2] - 5 && this.mouseX < (Integer)this.header.get(this.header.size() - 1)[1] + (Integer)this.header.get(this.header.size() - 1)[2] + 5) {
            this.resizeColumn = this.header.size();
        }
    }

    void drawGeneheader(int y) {
        int i = 0;
        while (i < this.geneheader.size()) {
            this.buf.setColor(Color.darkGray);
            this.buf.fillRect((Integer)this.geneheader.get(i)[1] + 10, y, (Integer)this.geneheader.get(i)[2], this.rowHeight);
            if (this.mouseY - this.tablescroll.getVerticalScrollBar().getValue() <= y + this.rowHeight && this.mouseY - this.tablescroll.getVerticalScrollBar().getValue() >= y) {
                if (this.mouseX >= (Integer)this.geneheader.get(i)[1] + 10 && this.mouseX <= (Integer)this.geneheader.get(i)[1] + (Integer)this.geneheader.get(i)[2] + 10) {
                    this.geneHeaderHover = i;
                    this.buf.setColor(Color.yellow);
                } else if (this.mouseX >= (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 10) {
                    this.geneHeaderHover = this.geneheader.size();
                    this.buf.setColor(Color.white);
                } else {
                    this.buf.setColor(Color.white);
                }
            } else {
                this.buf.setColor(Color.white);
            }
            if (!this.mouseDrag && this.geneHeaderHover > -1 && i > 0 && i < this.geneheader.size() && this.mouseX > (Integer)this.geneheader.get(i)[1] + 5 && this.mouseX < (Integer)this.geneheader.get(i)[1] + 15 && this.resizeColumn != i) {
                this.resizeColumn = i;
            }
            if (this.geneheader.get(i)[0] instanceof String) {
                this.buf.drawString((String)this.geneheader.get(i)[0], (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
            } else if (this.geneheader.get(i)[0] instanceof ControlFile) {
                ControlFile ctrlfile = (ControlFile)this.geneheader.get(i)[0];
                this.buf.drawString("AF: " + ctrlfile.getName(), (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
                ctrlfile = null;
            } else {
                BedTrack track = (BedTrack)this.geneheader.get(i)[0];
                if (track.file != null) {
                    this.buf.drawString(track.file.getName(), (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
                } else {
                    this.buf.drawString(track.url.getFile().toString(), (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
                }
                Object var3_3 = null;
            }
            this.buf.setColor(Color.black);
            this.buf.drawLine((Integer)this.geneheader.get(i)[1] + 10, y, (Integer)this.geneheader.get(i)[1] + 10, y + this.rowHeight);
            ++i;
        }
        if (!this.mouseDrag && this.geneHeaderHover > -1 && this.resizeColumn == -1 && this.mouseX > (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] - 5 && this.mouseX < (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 15) {
            this.resizeColumn = this.geneheader.size();
        }
        this.buf.setColor(Color.darkGray);
        this.buf.fillRect((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 11, y, this.width, this.rowHeight);
        this.buf.setColor(Color.black);
        this.buf.drawLine((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 10, y, (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 10, y + this.rowHeight);
    }

    void clear() {
        this.samples.clear();
        Main.drawCanvas.clusterNodes.clear();
        this.varAdd = null;
        this.hoverNode = null;
        this.selectedNode = null;
        this.entry = null;
        this.vararray.clear();
        this.hoverVar = null;
        this.selectedVar = null;
    }

    int getTableSize() {
        if (Main.drawCanvas.clusterNodes == null) {
            return 0;
        }
        return Main.drawCanvas.clusterNodes.size();
    }

    void createPolygon() {
        if (this.sorter.index > this.header.size() - 1) {
            return;
        }
        if (this.sorter.ascending) {
            int[] x = new int[]{(Integer)this.header.get(this.sorter.index)[1] + (Integer)this.header.get(this.sorter.index)[2] - 15, (Integer)this.header.get(this.sorter.index)[1] + (Integer)this.header.get(this.sorter.index)[2] - 10, (Integer)this.header.get(this.sorter.index)[1] + (Integer)this.header.get(this.sorter.index)[2] - 5};
            int[] y = new int[]{12, 4, 12};
            int n = 3;
            this.sortTriangle = new Polygon(x, y, n);
        } else {
            int[] x = new int[]{(Integer)this.header.get(this.sorter.index)[1] + (Integer)this.header.get(this.sorter.index)[2] - 15, (Integer)this.header.get(this.sorter.index)[1] + (Integer)this.header.get(this.sorter.index)[2] - 10, (Integer)this.header.get(this.sorter.index)[1] + (Integer)this.header.get(this.sorter.index)[2] - 5};
            int[] y = new int[]{4, 12, 4};
            int n = 3;
            this.sortTriangle = new Polygon(x, y, n);
        }
    }

    @Override
    public void paint(Graphics g) {
        try {
            this.drawScreen(g);
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        switch (event.getModifiers()) {
            case 16: {
                if (!this.isEnabled() || this.headerHover != -1) break;
                if (event.getClickCount() == 2) {
                    FileRead.novars = true;
                    if (this.hoverSample > -1) {
                        Main.drawCanvas.drawVariables.visiblestart = (short)this.hoverSample;
                        Main.drawCanvas.drawVariables.visiblesamples = 1;
                        Main.drawCanvas.resizeCanvas(Main.drawScroll.getViewport().getWidth(), (int)((double)Main.samples * Main.drawCanvas.drawVariables.sampleHeight));
                        Draw.setScrollbar((int)((double)this.hoverSample * Main.drawCanvas.drawVariables.sampleHeight));
                    }
                    FileRead.search = true;
                    if (this.hoverVar != null) {
                        VarNode searchHead = this.hoverVar;
                        while (searchHead.getPrev() != null) {
                            if (searchHead.getPrev().getPosition() == 0) {
                                searchHead.getPrev().putNext(searchHead);
                            }
                            searchHead = searchHead.getPrev();
                        }
                        FileRead.head = searchHead;
                        searchHead = null;
                        Main.drawCanvas.current = this.hoverVar;
                        if (this.hoverVar.getExons() != null) {
                            Main.drawCanvas.gotoPos(this.hoverVar.getExons().get(0).getTranscript().getChrom(), this.hoverVar.getPosition() + 1 - 50, this.hoverVar.getPosition() + 1 + 50);
                            break;
                        }
                        if (this.hoverVar.getTranscripts() == null) break;
                        Main.drawCanvas.gotoPos(this.hoverVar.getTranscripts().get(0).getChrom(), this.hoverVar.getPosition() + 1 - 50, this.hoverVar.getPosition() + 1 + 50);
                        break;
                    }
                    if (this.hoverNode == null) break;
                    VarNode searchHead = this.hoverNode.varnodes.get(0);
                    if (this.hoverNode.varnodes.get(0).getTranscripts() != null) {
                        if (!this.chrom.equals(this.hoverNode.varnodes.get(0).getTranscripts().get(0).getChrom())) {
                            this.chrom = this.hoverNode.varnodes.get(0).getTranscripts().get(0).getChrom();
                        }
                    } else if (!this.chrom.equals(this.hoverNode.varnodes.get((int)0).getExons().get((int)0).transcript.getChrom())) {
                        this.chrom = this.hoverNode.varnodes.get((int)0).getExons().get((int)0).transcript.getChrom();
                    }
                    while (searchHead.getPrev() != null) {
                        if (searchHead.getPrev().getPosition() == 0) {
                            searchHead.getPrev().putNext(searchHead);
                        }
                        searchHead = searchHead.getPrev();
                    }
                    FileRead.head = searchHead;
                    searchHead = null;
                    Main.drawCanvas.current = this.hoverNode.varnodes.get(0);
                    Main.drawCanvas.gotoPos(this.chrom, this.hoverNode.varnodes.get(0).getPosition(), this.hoverNode.varnodes.get(0).getPosition() + this.hoverNode.width);
                    break;
                }
                if (event.getClickCount() != 1) break;
                if (!(this.hoverVar == null || this.selectedVar != null && this.selectedVar.equals(this.hoverVar))) {
                    this.selectedVar = this.hoverVar;
                    this.selectedString = this.hoverString;
                    if (this.selectedVar.isRscode() != null) {
                        this.hoverString[4] = this.selectedVar.rscode;
                    }
                    this.repaint();
                    this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount + Integer.parseInt(this.selectedString[1])) * this.rowHeight));
                    this.revalidate();
                    break;
                }
                if (this.hoverVar != null && this.selectedVar.equals(this.hoverVar)) {
                    if (this.hoverSample != -1) break;
                    this.selectedVar = null;
                    this.repaint();
                    this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount) * this.rowHeight));
                    this.revalidate();
                    break;
                }
                if (this.hoverVar != null && this.selectedNode != null && this.hoverNode.equals(this.selectedNode)) {
                    this.selectedString = this.hoverString;
                    this.samplecount = 0;
                    this.repaint();
                    break;
                }
                if (this.hoverSample != -1 || this.hoverNode == null) break;
                if (this.selectedNode != null && this.selectedNode.equals(this.hoverNode)) {
                    this.selectedString = null;
                    this.selectedNode = null;
                    this.hoverVar = null;
                    this.selectedVar = null;
                    this.aminoarray.clear();
                    this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2) * this.rowHeight + 10));
                    this.revalidate();
                    this.repaint();
                    break;
                }
                this.selectedNode = this.hoverNode;
                this.selectedString = this.hoverString;
                this.samplecount = this.selectedNode.varnodes.size();
                this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount) * this.rowHeight + 10));
                this.revalidate();
                this.getAminos(this.selectedNode);
                this.repaint();
                break;
            }
            case 4: {
                this.selectedNode = null;
                this.selectedVar = null;
                this.repaint();
            }
        }
    }

    void getAminos(ClusterNode transcript) {
        try {
            this.aminoarray.clear();
            VarNode varnode = null;
            int t = 0;
            while (t < transcript.varnodes.size()) {
                if (!Main.drawCanvas.hideNode(transcript.varnodes.get(t))) {
                    varnode = transcript.varnodes.get(t);
                    int v = 0;
                    while (v < varnode.vars.size()) {
                        this.entry = varnode.vars.get(v);
                        this.mutcount = 0;
                        if (!Main.drawCanvas.hideNodeVar(varnode, this.entry)) {
                            int m = 0;
                            while (m < this.entry.getValue().size()) {
                                if (this.entry.getValue().get((int)m).alleles != null) break;
                                if (!Main.drawCanvas.hideVar(this.entry.getValue().get(m), this.entry.getKey().length() > 1)) {
                                    ++this.mutcount;
                                } else {
                                    this.entry.getValue().remove(m);
                                    --m;
                                }
                                ++m;
                            }
                            if (this.mutcount != 0) {
                                if (varnode.getTranscripts() != null) {
                                    if (!this.chrom.equals(varnode.getTranscripts().get(0).getChrom())) {
                                        this.chrom = varnode.getTranscripts().get(0).getChrom();
                                    }
                                } else if (!this.chrom.equals(varnode.getExons().get((int)0).transcript.getChrom())) {
                                    this.chrom = varnode.getExons().get((int)0).transcript.getChrom();
                                }
                                this.base = this.entry.getKey();
                                String[] addrow = new String[]{"" + transcript.ID, "" + this.mutcount, String.valueOf(this.chrom) + ":" + MethodLibrary.formatNumber(varnode.getPosition() + 1), this.base.length() == 1 ? Main.getBase.get(varnode.getRefBase()) + ">" + this.base : this.base, varnode.isRscode() != null ? varnode.rscode : "N/A", this.base};
                                AminoEntry aminoentry = new AminoEntry(addrow, varnode);
                                this.aminoarray.add(aminoentry);
                            }
                        }
                        ++v;
                    }
                }
                ++t;
            }
            varnode = null;
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        switch (event.getModifiers()) {
            case 16: {
                if (!this.isEnabled()) break;
                this.dragX = event.getX();
                if (this.headerHover > -1 && this.resizeColumn == -1) {
                    this.sorter.ascending = !this.sorter.ascending;
                    this.sorter.index = this.headerHover;
                    Collections.sort(Main.drawCanvas.clusterNodes, this.sorter);
                    this.createPolygon();
                    this.repaint();
                }
                if (this.hoverNode == null && this.hoverVar == null) break;
                Main.chromDraw.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.mouseDrag = false;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.mouseDrag = true;
        if (this.resizeColumn > 0) {
            this.resizeTable(this.resizeColumn, event.getX() - this.dragX);
            this.dragX = event.getX();
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.mouseY = event.getY();
        this.mouseX = event.getX();
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.tablescroll.getVerticalScrollBar().setValue(this.tablescroll.getVerticalScrollBar().getValue() - 16);
        } else {
            this.tablescroll.getVerticalScrollBar().setValue(this.tablescroll.getVerticalScrollBar().getValue() + 16);
        }
        this.repaint();
    }

    public static class ListSorter
    implements Comparator<ClusterNode> {
        public int index;
        boolean ascending = true;

        @Override
        public int compare(ClusterNode o1, ClusterNode o2) {
            if (this.index < 3) {
                int f2;
                int f1;
                if (this.index == 0) {
                    f1 = o1.ID;
                    f2 = o2.ID;
                } else if (this.index == 1) {
                    f1 = o1.nodecount;
                    f2 = o2.nodecount;
                } else {
                    f1 = o1.width;
                    f2 = o2.width;
                }
                if (f1 < f2) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (f1 > f2) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (this.index == 3) {
                String chrom1 = o1.varnodes.get(0).getExons() != null ? o1.varnodes.get(0).getExons().get(0).getTranscript().getChrom() : o1.varnodes.get(0).getTranscripts().get(0).getChrom();
                String chrom2 = o2.varnodes.get(0).getExons() != null ? o2.varnodes.get(0).getExons().get(0).getTranscript().getChrom() : o2.varnodes.get(0).getTranscripts().get(0).getChrom();
                if (Main.chromIndex.get(chrom1)[0] + (long)o1.varnodes.get(0).getPosition() < Main.chromIndex.get(chrom2)[0] + (long)o2.varnodes.get(0).getPosition()) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (Main.chromIndex.get(chrom1)[0] + (long)o1.varnodes.get(0).getPosition() > Main.chromIndex.get(chrom2)[0] + (long)o2.varnodes.get(0).getPosition()) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (this.index == 4) {
                double f1 = (double)o1.nodecount / (double)o1.width;
                double f2 = (double)o2.nodecount / (double)o2.width;
                if (f1 < f2) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (f1 > f2) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            return 0;
        }
    }
}

