/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.BedCanvas;
import base.BasePlayer.Draw;
import base.BasePlayer.ErrorLog;
import base.BasePlayer.Loader;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.ReferenceSeq;
import base.BasePlayer.SampleNode;
import base.BasePlayer.Settings;
import base.BasePlayer.SplitClass;
import base.BasePlayer.Transcript;
import base.BasePlayer.VarNode;
import base.BasePlayer.VariantHandler;
import htsjdk.tribble.readers.TabixReader;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JPanel;

public class ChromDraw
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    int queryStart = 0;
    int queryEnd = 0;
    int memoryUsage = 0;
    Color[] colorPalette = new Color[11];
    VarNode varnode = null;
    VarNode vardraw;
    String s;
    String startPhaseCodon;
    String endPhaseCodon;
    int chromScrollvalue = 0;
    int cytoHeight = 15;
    int exonInfoWidth;
    int aminoNro;
    int codonStartPos;
    int lastAmino;
    Runtime instance = Runtime.getRuntime();
    int mouseY = 0;
    int pressY = 0;
    int maxGeneLevel = 0;
    SplitClass splitClass = null;
    int middle = 0;
    int baselevel;
    int toMegabytes = 0x100000;
    int exonFetchStart = 0;
    int exonFetchEnd = 0;
    static Font seqFont = new Font("SansSerif", 1, Main.defaultFontSize);
    int transIndex = 0;
    int isoformIndex = 0;
    byte[] seqresult;
    int startPixel = 0;
    int areaWidth = 0;
    static ArrayList<String[]> bandVector = new ArrayList();
    String resString;
    String zoomtext;
    Transcript.Exon selectedExon = null;
    static HashMap<String, Integer> chromPos;
    ArrayList<Double> gerpList = new ArrayList();
    BufferedImage chromImage;
    BufferedImage splitCytoImage;
    Graphics2D chromImageBuffer;
    BufferedImage selectImage;
    Graphics2D selectImageBuffer;
    boolean zoomDrag = false;
    boolean foundlevel = false;
    boolean nameDraw = false;
    static final Color exonBarColor;
    static final Color forwardExon;
    static final Color reverseExon;
    static final Color seqpaint;
    static final Color highlight;
    ArrayList<Integer> geneLevelMatrix = new ArrayList();
    StringBuffer seqBuffer;
    RandomAccessFile chromo;
    public int zoompostemp;
    BufferedImage cytoImage;
    Graphics2D cytoImageBuffer;
    Rectangle mouseRect = new Rectangle();
    public int mouseX;
    private int bandwidth;
    private int Xpos;
    private String[] color;
    private String[] exonString = new String[8];
    static Color lightGray;
    private int level;
    private int screenPos;
    private int geneStartPos;
    private int geneEndPos;
    private int levelEndPos;
    private String gene;
    public String splitChrom = "";
    static Hashtable<String, String> aminoacids;
    static Hashtable<String, String> codons;
    static float[] dash;
    static TabixReader exonReader;
    ArrayList<String> exonRemove = new ArrayList();
    private int exonwidth;
    private int genewidth;
    private Rectangle2D textWidth;
    int exonDrawY = 20;
    boolean lineZoomer;
    private int phase;
    private String base;
    private BufferedImage tempImage;
    private Transcript transcript;
    private Transcript.Exon exon;
    private boolean found;
    private int aminopos;
    boolean updateExons = false;
    private int mutScreenPos;
    static Color backTransparent;
    private int baselength;
    private Transcript transcriptSelect;
    private Color varColor = new Color(100, 100, 100, 30);
    private Color gray = new Color(100, 100, 100, 30);
    private boolean seqDrag;
    long timer;
    String message;
    private int mutcount;
    private Map.Entry<String, ArrayList<SampleNode>> entry;
    private int prevExonEnd;
    private char[] array;
    private int nextExonStart;
    private boolean foundexon;
    private int foundexonindex;
    private Transcript.Exon clickedExon;
    private short foundcursor;
    double bounds = 0.0;
    private SplitClass clickedSplit = null;
    private int seqstart;
    private int seqend;
    private int prepixel;

    static {
        exonBarColor = new Color(20, 100, 20);
        forwardExon = new Color(50, 200, 100, 30);
        reverseExon = new Color(255, 50, 50, 30);
        seqpaint = new Color(100, 200, 200, 150);
        highlight = new Color(110, 110, 90, 35);
        lightGray = new Color(230, 230, 230, 100);
        aminoacids = new Hashtable();
        codons = new Hashtable();
        dash = new float[]{5.0f};
        backTransparent = new Color(255, 255, 250, 255);
    }

    ChromDraw(int width, int height) {
        this.chromImage = MethodLibrary.toCompatibleImage(new BufferedImage((int)Main.screenSize.getWidth(), (int)Main.screenSize.getHeight(), 2));
        this.chromImageBuffer = (Graphics2D)this.chromImage.getGraphics();
        this.selectImage = MethodLibrary.toCompatibleImage(new BufferedImage((int)Main.screenSize.getWidth(), (int)Main.screenSize.getHeight(), 2));
        this.selectImageBuffer = (Graphics2D)this.selectImage.getGraphics();
        this.selectImageBuffer.setRenderingHints(Draw.rh);
        this.selectImageBuffer.setFont(Draw.defaultFont);
        this.chromImageBuffer.setFont(Draw.defaultFont);
        this.bounds = this.chromImageBuffer.getFontMetrics().getStringBounds("K", this.chromImageBuffer).getWidth();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.colorPalette[10] = new Color(255, 60, 60);
        this.colorPalette[9] = new Color(255, 100, 100);
        this.colorPalette[8] = new Color(255, 140, 140);
        this.colorPalette[7] = new Color(255, 180, 180);
        this.colorPalette[6] = new Color(255, 220, 220);
        this.colorPalette[5] = new Color(255, 255, 255);
        this.colorPalette[4] = new Color(220, 220, 255);
        this.colorPalette[3] = new Color(180, 180, 255);
        this.colorPalette[2] = new Color(140, 140, 255);
        this.colorPalette[1] = new Color(100, 100, 255);
        this.colorPalette[0] = new Color(80, 80, 255);
        aminoacids.put("ATT", "Ile");
        aminoacids.put("ATC", "Ile");
        aminoacids.put("ATA", "Ile");
        aminoacids.put("CTT", "Leu");
        aminoacids.put("CTC", "Leu");
        aminoacids.put("CTA", "Leu");
        aminoacids.put("CTG", "Leu");
        aminoacids.put("TTA", "Leu");
        aminoacids.put("TTG", "Leu");
        aminoacids.put("GTT", "Val");
        aminoacids.put("GTC", "Val");
        aminoacids.put("GTA", "Val");
        aminoacids.put("GTG", "Val");
        aminoacids.put("TTT", "Phe");
        aminoacids.put("TTC", "Phe");
        aminoacids.put("ATG", "Met");
        aminoacids.put("TGT", "Cys");
        aminoacids.put("TGC", "Cys");
        aminoacids.put("GCT", "Ala");
        aminoacids.put("GCC", "Ala");
        aminoacids.put("GCA", "Ala");
        aminoacids.put("GCG", "Ala");
        aminoacids.put("GGT", "Gly");
        aminoacids.put("GGC", "Gly");
        aminoacids.put("GGA", "Gly");
        aminoacids.put("GGG", "Gly");
        aminoacids.put("CCT", "Pro");
        aminoacids.put("CCC", "Pro");
        aminoacids.put("CCA", "Pro");
        aminoacids.put("CCG", "Pro");
        aminoacids.put("ACT", "Thr");
        aminoacids.put("ACC", "Thr");
        aminoacids.put("ACA", "Thr");
        aminoacids.put("ACG", "Thr");
        aminoacids.put("TCT", "Ser");
        aminoacids.put("TCC", "Ser");
        aminoacids.put("TCA", "Ser");
        aminoacids.put("TCG", "Ser");
        aminoacids.put("AGT", "Ser");
        aminoacids.put("AGC", "Ser");
        aminoacids.put("TAT", "Tyr");
        aminoacids.put("TAC", "Tyr");
        aminoacids.put("TGG", "Trp");
        aminoacids.put("CAA", "Gln");
        aminoacids.put("CAG", "Gln");
        aminoacids.put("AAT", "Asn");
        aminoacids.put("AAC", "Asn");
        aminoacids.put("CAT", "His");
        aminoacids.put("CAC", "His");
        aminoacids.put("GAA", "Glu");
        aminoacids.put("GAG", "Glu");
        aminoacids.put("GAT", "Asp");
        aminoacids.put("GAC", "Asp");
        aminoacids.put("AAA", "Lys");
        aminoacids.put("AAG", "Lys");
        aminoacids.put("CGT", "Arg");
        aminoacids.put("CGC", "Arg");
        aminoacids.put("CGA", "Arg");
        aminoacids.put("CGG", "Arg");
        aminoacids.put("AGA", "Arg");
        aminoacids.put("AGG", "Arg");
        aminoacids.put("TAA", "Stop");
        aminoacids.put("TAG", "Stop");
        aminoacids.put("TGA", "Stop");
        codons.put("ATT", "ATT");
        codons.put("ATC", "ATC");
        codons.put("ATA", "ATA");
        codons.put("CTT", "CTT");
        codons.put("CTC", "CTC");
        codons.put("CTA", "CTA");
        codons.put("CTG", "CTG");
        codons.put("TTA", "TTA");
        codons.put("TTG", "TTG");
        codons.put("GTT", "GTT");
        codons.put("GTC", "GTC");
        codons.put("GTA", "GTA");
        codons.put("GTG", "GTG");
        codons.put("TTT", "TTT");
        codons.put("TTC", "TTC");
        codons.put("ATG", "ATG");
        codons.put("TGT", "TGT");
        codons.put("TGC", "TGC");
        codons.put("GCT", "GCT");
        codons.put("GCC", "GCC");
        codons.put("GCA", "GCA");
        codons.put("GCG", "GCG");
        codons.put("GGT", "GGT");
        codons.put("GGC", "GGC");
        codons.put("GGA", "GGA");
        codons.put("GGG", "GGG");
        codons.put("CCT", "CCT");
        codons.put("CCC", "CCC");
        codons.put("CCA", "CCA");
        codons.put("CCG", "CCG");
        codons.put("ACT", "ACT");
        codons.put("ACC", "ACC");
        codons.put("ACA", "ACA");
        codons.put("ACG", "ACG");
        codons.put("TCT", "TCT");
        codons.put("TCC", "TCC");
        codons.put("TCA", "TCA");
        codons.put("TCG", "TCG");
        codons.put("AGT", "AGT");
        codons.put("AGC", "AGC");
        codons.put("TAT", "TAT");
        codons.put("TAC", "TAC");
        codons.put("TGG", "TGG");
        codons.put("CAA", "CAA");
        codons.put("CAG", "CAG");
        codons.put("AAT", "AAT");
        codons.put("AAC", "AAC");
        codons.put("CAT", "CAT");
        codons.put("CAC", "CAC");
        codons.put("GAA", "GAA");
        codons.put("GAG", "GAG");
        codons.put("GAT", "GAT");
        codons.put("GAC", "GAC");
        codons.put("AAA", "AAA");
        codons.put("AAG", "AAG");
        codons.put("CGT", "CGT");
        codons.put("CGC", "CGC");
        codons.put("CGA", "CGA");
        codons.put("CGG", "CGG");
        codons.put("AGA", "AGA");
        codons.put("AGG", "AGG");
        codons.put("TAA", "TAA");
        codons.put("TAG", "TAG");
        codons.put("TGA", "TGA");
    }

    void getDrawSeq(SplitClass split) {
        if (!ReferenceSeq.wait) {
            if (split.getReference() == null) {
                this.seqstart = (int)split.start - (int)split.viewLength < 0 ? 0 : (int)split.start - (int)split.viewLength;
                this.seqend = (int)split.end + (int)split.viewLength > split.chromEnd ? split.chromEnd : (int)split.end + (int)split.viewLength;
                split.setReference(new ReferenceSeq(split.chrom, this.seqstart, this.seqend, Main.referenceFile));
            } else if (split.getReference().getStartPos() > 1 && (double)split.getReference().getStartPos() > split.start - 200.0) {
                this.seqstart = split.getReference().getStartPos() - (int)split.viewLength < 1 ? 1 : split.getReference().getStartPos() - (int)split.viewLength;
                split.getReference().appendToStart(this.seqstart);
            } else if ((double)split.getReference().getEndPos() < split.end + 200.0) {
                this.seqend = split.getReference().getEndPos() + (int)split.viewLength > split.chromEnd ? split.chromEnd : split.getReference().getEndPos() + (int)split.viewLength + 200;
                split.getReference().append(this.seqend);
            }
        }
    }

    void getReadSeq(SplitClass split) {
        if (!ReferenceSeq.wait) {
            if (split.getReadReference() == null) {
                this.seqstart = (int)split.start - (int)split.viewLength < 0 ? 0 : (int)split.start - (int)split.viewLength;
                this.seqend = (int)split.end + (int)split.viewLength > split.chromEnd ? split.chromEnd : (int)split.end + (int)split.viewLength;
                split.setReadReference(new ReferenceSeq(split.chrom, this.seqstart, this.seqend, Main.referenceFile));
            } else if (split.getReadReference().getStartPos() > 1 && (double)split.getReadReference().getStartPos() > split.start - 200.0) {
                this.seqstart = split.getReadReference().getStartPos() - (int)split.viewLength < 1 ? 1 : split.getReadReference().getStartPos() - (int)split.viewLength;
                split.getReadReference().appendToStart(this.seqstart);
            } else if ((double)split.getReadReference().getEndPos() < split.end + 200.0) {
                this.seqend = split.getReadReference().getEndPos() + (int)split.viewLength > split.chromEnd ? split.chromEnd : split.getReadReference().getEndPos() + (int)split.viewLength + 200;
                split.getReadReference().append(this.seqend);
            }
        }
    }

    void drawSeq(SplitClass split) {
        if (split.viewLength <= (double)Settings.readDrawDistance && split.viewLength > 10.0) {
            split.getExonImageBuffer().setColor(Color.black);
            if (split.getReference() == null || split.getReference().getSeq() == null) {
                return;
            }
            if (Main.noreadthread) {
                return;
            }
            this.chromScrollvalue = Main.chromScroll.getVerticalScrollBar().getValue();
            split.getExonImageBuffer().fillRect(0, Main.chromScroll.getViewport().getHeight() - (Main.defaultFontSize * 2 + 11) + this.chromScrollvalue, this.getWidth(), Main.defaultFontSize + 12);
            int i = Math.max(0, (int)(split.start - (double)split.getReference().getStartPos() - 1.0));
            while (i < split.getReference().getSeq().length) {
                try {
                    if (!((double)(split.getReference().getStartPos() + i) < split.start - 1.0)) {
                        if ((double)(split.getReference().getStartPos() + i) > split.end - 1.0) break;
                        if (split.getReference().getSeq()[i] == 65) {
                            split.getExonImageBuffer().setColor(Color.green);
                        } else if (split.getReference().getSeq()[i] == 67) {
                            split.getExonImageBuffer().setColor(Color.cyan);
                        } else if (split.getReference().getSeq()[i] == 71) {
                            split.getExonImageBuffer().setColor(Color.orange);
                        } else if (split.getReference().getSeq()[i] == 84) {
                            split.getExonImageBuffer().setColor(Color.red);
                        } else {
                            split.getExonImageBuffer().setColor(Color.gray);
                        }
                        split.getExonImageBuffer().setFont(seqFont);
                        if ((double)split.getExonImageBuffer().getFontMetrics().stringWidth("T") < split.pixel) {
                            split.getExonImageBuffer().drawString(Main.getBase.get(split.getReference().getSeq()[i]), (int)(((double)(split.getReference().getStartPos() + i + 1) - split.start) * split.pixel) + (int)(split.pixel / 3.0), Main.chromScroll.getViewport().getHeight() - (Main.defaultFontSize + 11) + this.chromScrollvalue);
                        } else if (split.pixel < 1.0) {
                            split.getExonImageBuffer().fillRect((int)(((double)(split.getReference().getStartPos() + i) - split.start) * split.pixel), Main.chromScroll.getViewport().getHeight() - (Main.defaultFontSize * 2 + 9) + this.chromScrollvalue, 1, Main.defaultFontSize * 2 + 10);
                        } else {
                            split.getExonImageBuffer().fillRect((int)(((double)(split.getReference().getStartPos() + i) - split.start) * split.pixel), Main.chromScroll.getViewport().getHeight() - (Main.defaultFontSize * 2 + 9) + this.chromScrollvalue, (int)split.pixel, Main.defaultFontSize * 2 + 10);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(split.chrom);
                    ErrorLog.addError(e.getStackTrace());
                    e.printStackTrace();
                }
                ++i;
            }
            split.getExonImageBuffer().setColor(Color.black);
            split.getExonImageBuffer().setStroke(Draw.dashed);
            split.getExonImageBuffer().drawLine(Main.drawCanvas.getDrawWidth() / 2, 0, Main.drawCanvas.getDrawWidth() / 2, Main.chromScroll.getViewport().getHeight());
            split.getExonImageBuffer().drawLine((int)((double)(Main.drawCanvas.getDrawWidth() / 2) + split.pixel), 0, (int)((double)(Main.drawCanvas.getDrawWidth() / 2) + split.pixel), Main.chromScroll.getViewport().getHeight());
            split.getExonImageBuffer().setStroke(Draw.basicStroke);
            split.getExonImageBuffer().drawString(MethodLibrary.formatNumber(this.getPosition((int)((double)Main.drawCanvas.getDrawWidth() / 2.0 + split.pixel / 2.0), split)), (int)((double)(Main.drawCanvas.getDrawWidth() / 2) + split.pixel) + 4, Main.chromScroll.getViewport().getHeight() - Main.defaultFontSize * 3);
        } else {
            split.nullRef();
        }
    }

    public int getPosition(int pixel, SplitClass split) {
        return (int)(split.start + (double)pixel / split.pixel);
    }

    void drawSideBar() {
        if (this.memoryUsage > (int)((this.instance.totalMemory() - this.instance.freeMemory()) / (long)this.toMegabytes)) {
            if (this.instance.maxMemory() / (long)this.toMegabytes < 600L) {
                if ((this.instance.maxMemory() - (this.instance.totalMemory() - this.instance.freeMemory())) / (long)this.toMegabytes < 100L) {
                    System.gc();
                    if ((this.instance.maxMemory() - (this.instance.totalMemory() - this.instance.freeMemory())) / (long)this.toMegabytes < 100L) {
                        Main.drawCanvas.clearReads();
                        if ((this.instance.maxMemory() - (this.instance.totalMemory() - this.instance.freeMemory())) / (long)this.toMegabytes < 100L) {
                            Loader.memory = true;
                        }
                    }
                }
            } else if (this.instance.maxMemory() / (long)this.toMegabytes < 1300L) {
                if ((this.instance.maxMemory() - (this.instance.totalMemory() - this.instance.freeMemory())) / (long)this.toMegabytes < 200L) {
                    System.gc();
                    if ((this.instance.maxMemory() - (this.instance.totalMemory() - this.instance.freeMemory())) / (long)this.toMegabytes < 200L) {
                        Main.drawCanvas.clearReads();
                        if ((this.instance.maxMemory() - (this.instance.totalMemory() - this.instance.freeMemory())) / (long)this.toMegabytes < 200L) {
                            Loader.memory = true;
                        }
                    }
                }
            } else if ((this.instance.maxMemory() - (this.instance.totalMemory() - this.instance.freeMemory())) / (long)this.toMegabytes < 300L) {
                System.gc();
                if ((this.instance.maxMemory() - (this.instance.totalMemory() - this.instance.freeMemory())) / (long)this.toMegabytes < 300L) {
                    Main.drawCanvas.clearReads();
                    if ((this.instance.maxMemory() - (this.instance.totalMemory() - this.instance.freeMemory())) / (long)this.toMegabytes < 300L) {
                        Loader.memory = true;
                    }
                }
            }
        }
        this.memoryUsage = (int)((this.instance.totalMemory() - this.instance.freeMemory()) / (long)this.toMegabytes);
        if ((double)(this.instance.totalMemory() - this.instance.freeMemory()) / (double)this.instance.maxMemory() > 0.8) {
            Main.memLabel.setForeground(Color.red);
        } else {
            Main.memLabel.setForeground(Color.black);
        }
        Main.memLabel.setText(this.memoryUsage + " / " + this.instance.maxMemory() / (long)this.toMegabytes + "MB (" + (int)(MethodLibrary.round((double)(this.instance.totalMemory() - this.instance.freeMemory()) / (double)this.instance.maxMemory(), 2) * 100.0) + "%) ");
    }

    void drawCyto(SplitClass split) {
        if (split.getCytoImage() == null) {
            split.setCytoImage(this.createBands(split));
        }
        this.chromImageBuffer.setColor(backTransparent);
        this.chromImageBuffer.fillRect(split.chromOffset, 0, Main.drawCanvas.getDrawWidth() + 1, this.cytoHeight);
        this.chromImageBuffer.drawImage(split.getCytoImage(), split.chromOffset, 2, Main.drawCanvas.getDrawWidth() + 1, this.cytoHeight - 4, null);
        this.chromImageBuffer.setColor(Color.red);
        this.chromImageBuffer.setStroke(Draw.doubleStroke);
        this.startPixel = (int)((double)Main.drawCanvas.getDrawWidth() * (split.start / (double)split.chromEnd)) + split.chromOffset;
        this.areaWidth = (int)((double)Main.drawCanvas.getDrawWidth() * split.viewLength / (double)split.chromEnd) - 3;
        if (this.areaWidth < 1) {
            this.areaWidth = 1;
        }
        this.chromImageBuffer.drawRect(this.startPixel + 1, 1, this.areaWidth, this.cytoHeight - 2);
        this.chromImageBuffer.setColor(Color.black);
        if (split.getChromBands() == null) {
            return;
        }
        int i = split.getChromBands().size() - 1;
        while (i >= 0) {
            try {
                if ((double)(Integer.parseInt(split.getChromBands().get(i)[2]) - Integer.parseInt(split.getChromBands().get(i)[1])) * ((double)Main.drawCanvas.getDrawWidth() / (double)split.chromEnd) > this.bounds * (double)split.getChromBands().get(i)[3].length()) {
                    if (split.getChromBands().get(i)[4].contains(",0,") || split.getChromBands().get(i)[4].equals("gpos100")) {
                        if (this.chromImageBuffer.getColor() != Color.white) {
                            this.chromImageBuffer.setColor(Color.white);
                        }
                        this.chromImageBuffer.drawString(split.getChromBands().get(i)[3], (int)((double)Integer.parseInt(split.getChromBands().get(i)[1]) * ((double)Main.drawCanvas.getDrawWidth() / (double)split.chromEnd)) + split.chromOffset + 1, Main.defaultFontSize + 2);
                        this.chromImageBuffer.setColor(Color.black);
                    } else if (!split.getChromBands().get(i)[3].matches("\\w11(.1)?")) {
                        this.chromImageBuffer.drawString(split.getChromBands().get(i)[3], (int)((double)Integer.parseInt(split.getChromBands().get(i)[1]) * ((double)Main.drawCanvas.getDrawWidth() / (double)split.chromEnd)) + split.chromOffset + 1, Main.defaultFontSize + 2);
                    }
                }
                if (!Main.drawCanvas.loading && this.mouseY < this.cytoHeight && this.mouseY > 0 && this.mouseX - split.chromOffset > (int)((double)Integer.parseInt(split.getChromBands().get(i)[1]) * ((double)Main.drawCanvas.getDrawWidth() / (double)split.chromEnd)) && this.mouseX - split.chromOffset <= (int)((double)Integer.parseInt(split.getChromBands().get(i)[2]) * ((double)Main.drawCanvas.getDrawWidth() / (double)split.chromEnd))) {
                    this.chromImageBuffer.setColor(Color.black);
                    this.chromImageBuffer.fillRect(this.mouseX + 18, 0, (int)(this.bounds * (double)split.getChromBands().get(i)[3].length() + 4.0), this.cytoHeight);
                    this.chromImageBuffer.setColor(Color.white);
                    this.chromImageBuffer.drawString(split.getChromBands().get(i)[3], this.mouseX + 20, Main.defaultFontSize + 2);
                    this.chromImageBuffer.setColor(Color.black);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            --i;
        }
        if (this.mouseY <= this.cytoHeight && this.getCursor().getType() != 2) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    void drawZoom() {
        if (this.lineZoomer) {
            this.chromImageBuffer.setColor(Color.black);
            this.chromImageBuffer.setStroke(Draw.dashed);
            this.chromImageBuffer.drawLine(Main.drawCanvas.pressX, this.pressY, this.mouseX, this.mouseY);
            this.chromImageBuffer.setStroke(Draw.basicStroke);
        } else if (this.zoomDrag) {
            if (this.mouseY <= this.cytoHeight) {
                this.chromImageBuffer.setColor(Draw.zoomColor);
                this.chromImageBuffer.fillRect(Main.drawCanvas.pressX, 0, this.mouseX - Main.drawCanvas.pressX, this.cytoHeight);
                return;
            }
            if (this.mouseX - Main.drawCanvas.pressX >= 0) {
                this.chromImageBuffer.setColor(Color.white);
                this.chromImageBuffer.drawRect(Main.drawCanvas.pressX, 0, this.mouseX - Main.drawCanvas.pressX, this.getHeight());
                this.chromImageBuffer.setColor(Color.black);
                if (Main.drawCanvas.getDrawWidth() - this.mouseX > 200) {
                    this.chromImageBuffer.drawString(MethodLibrary.formatNumber((int)((double)(this.mouseX - Main.drawCanvas.pressX) / Main.drawCanvas.selectedSplit.pixel)) + "bp", Main.drawCanvas.pressX + (this.mouseX - Main.drawCanvas.pressX) + 4, this.mouseY - 35);
                    this.chromImageBuffer.drawString("Right click to cancel zoom", Main.drawCanvas.pressX + (this.mouseX - Main.drawCanvas.pressX) + 4, this.mouseY - 6);
                } else {
                    this.zoomtext = MethodLibrary.formatNumber((int)((double)(this.mouseX - Main.drawCanvas.pressX) / Main.drawCanvas.selectedSplit.pixel)) + "bp";
                    this.textWidth = this.chromImageBuffer.getFontMetrics().getStringBounds(this.zoomtext, this.chromImageBuffer);
                    this.zoompostemp = (int)((double)(Main.drawCanvas.pressX + (this.mouseX - Main.drawCanvas.pressX)) - this.textWidth.getWidth());
                    this.chromImageBuffer.drawString(this.zoomtext, this.zoompostemp, this.mouseY - 35);
                    this.textWidth = this.chromImageBuffer.getFontMetrics().getStringBounds("Right click to cancel zoom", this.chromImageBuffer);
                    this.zoompostemp = (int)((double)(Main.drawCanvas.pressX + (this.mouseX - Main.drawCanvas.pressX)) - this.textWidth.getWidth()) - 6;
                    this.chromImageBuffer.drawString("Right click to cancel zoom", this.zoompostemp, this.mouseY - 6);
                }
                this.chromImageBuffer.setColor(Draw.zoomColor);
                this.chromImageBuffer.fillRect(Main.drawCanvas.pressX, 0, this.mouseX - Main.drawCanvas.pressX, this.getHeight());
            } else {
                this.lineZoomer = true;
                Main.drawCanvas.lineZoomer = true;
                this.zoomDrag = false;
            }
            this.chromImageBuffer.setStroke(Draw.basicStroke);
        }
    }

    void drawScreen(Graphics g) {
        this.drawSideBar();
        this.drawCyto(Main.drawCanvas.selectedSplit);
        if (this.clickedExon != null) {
            this.drawClickedExon(this.clickedSplit);
        }
        this.drawExons(Main.drawCanvas.selectedSplit);
        int s = 0;
        while (s < Main.drawCanvas.splits.size()) {
            if (Main.drawCanvas.splits.get(s).getExonImage() != null) {
                this.chromImageBuffer.drawImage((Image)Main.drawCanvas.splits.get(s).getExonImage(), Main.drawCanvas.splits.get((int)s).chromOffset, this.cytoHeight, null);
                if (Main.ref != null) {
                    if (s > 0) {
                        this.chromImageBuffer.drawString("chr" + Main.drawCanvas.splits.get((int)s).chrom, Main.drawCanvas.splits.get((int)s).chromOffset + 4, this.cytoHeight + Main.defaultFontSize + 2 + Main.defaultFontSize / 2);
                    }
                } else {
                    if (this.chromImageBuffer.getFont().getSize() != Main.chromScroll.getViewport().getHeight() / 2) {
                        this.chromImageBuffer.setFont(new Font("SansSerif", 1, Main.chromScroll.getViewport().getHeight() / 2));
                        this.chromImageBuffer.setColor(new Color(245, 245, 245));
                        this.textWidth = this.chromImageBuffer.getFontMetrics().getStringBounds("Welcome to BasePlayer", this.chromImageBuffer);
                    }
                    this.chromImageBuffer.drawString("Welcome to BasePlayer", (int)((double)(Main.chromScroll.getViewport().getWidth() / 2) - this.textWidth.getWidth() / 2.0), (int)((double)Main.chromScroll.getViewport().getHeight() - (double)this.chromImageBuffer.getFont().getSize() * 0.5));
                    this.chromImageBuffer.setFont(Main.menuFont);
                }
                if (s > 0) {
                    this.chromImageBuffer.setColor(Color.gray);
                    this.chromImageBuffer.fillRect(Main.drawCanvas.splits.get((int)s).chromOffset - 3, 0, 5, this.getHeight());
                    this.chromImageBuffer.setColor(Color.lightGray);
                    this.chromImageBuffer.fillRect(Main.drawCanvas.splits.get((int)s).chromOffset - 1, 0, 2, this.getHeight());
                }
            }
            ++s;
        }
        this.chromImageBuffer.drawImage((Image)this.selectImage, Main.drawCanvas.selectedSplit.chromOffset, this.cytoHeight, null);
        if (VariantHandler.table != null && VariantHandler.table.hoverVar != null && VariantHandler.table.hoverVar.getExons() != null && VariantHandler.table.hoverVar.getExons().get(0).getTranscript().getChrom().equals(Main.chromosomeDropdown.getSelectedItem().toString())) {
            this.chromImageBuffer.setColor(Color.white);
            this.chromImageBuffer.fillRect((int)(((double)(VariantHandler.table.hoverVar.getPosition() + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel) - 2, 17, 4, this.getHeight());
            this.chromImageBuffer.setColor(Color.black);
            this.chromImageBuffer.drawLine((int)(((double)(VariantHandler.table.hoverVar.getPosition() + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), 17, (int)(((double)(VariantHandler.table.hoverVar.getPosition() + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
        }
        if (VariantHandler.table != null && VariantHandler.table.hoverNode != null && VariantHandler.table.hoverNode.getChrom().equals(Main.chromosomeDropdown.getSelectedItem().toString()) && (double)VariantHandler.table.hoverNode.getStart() > Main.drawCanvas.splits.get((int)0).start - 1.0 && (double)VariantHandler.table.hoverNode.getStart() < Main.drawCanvas.splits.get((int)0).end) {
            this.chromImageBuffer.setColor(Color.white);
            this.chromImageBuffer.fillRect((int)(((double)(VariantHandler.table.hoverNode.getStart() + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel) - 2, 17, 4, this.getHeight());
            this.chromImageBuffer.setColor(Color.black);
            this.chromImageBuffer.drawLine((int)(((double)(VariantHandler.table.hoverNode.getStart() + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), 17, (int)(((double)(VariantHandler.table.hoverNode.getStart() + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
        }
        if (this.timer > 0L) {
            this.chromImageBuffer.setColor(Color.red);
            if (System.currentTimeMillis() - this.timer >= 3000L) {
                Main.updatePositions((int)Main.drawCanvas.splits.get((int)0).start, (int)Main.drawCanvas.splits.get((int)0).end);
                this.timer = 0L;
            }
        }
        if (Main.searchChrom.equals(Main.drawCanvas.splits.get((int)0).chrom)) {
            this.drawSearchInterval();
        }
        if (this.seqDrag && this.mouseX - Main.drawCanvas.pressX > 0) {
            this.chromImageBuffer.setColor(seqpaint);
            this.chromImageBuffer.fillRect(Main.drawCanvas.pressX, Main.chromScroll.getViewport().getHeight() - Main.defaultFontSize, this.mouseX - Main.drawCanvas.pressX, Main.defaultFontSize * 2 + 10);
            this.chromImageBuffer.setColor(Color.black);
        }
        s = 1;
        while (s < Main.drawCanvas.splits.size()) {
            this.chromImageBuffer.setColor(Color.white);
            this.chromImageBuffer.fillRect(Main.drawCanvas.splits.get((int)s).chromOffset + 2, this.cytoHeight + 2 + Main.defaultFontSize / 2, this.chromImageBuffer.getFontMetrics().stringWidth("chr" + Main.drawCanvas.splits.get((int)s).chrom) + 4, Main.defaultFontSize + 4);
            this.chromImageBuffer.setColor(Color.black);
            this.chromImageBuffer.drawString("chr" + Main.drawCanvas.splits.get((int)s).chrom, Main.drawCanvas.splits.get((int)s).chromOffset + 4, this.cytoHeight + Main.defaultFontSize + 2 + Main.defaultFontSize / 2);
            ++s;
        }
        this.drawZoom();
        g.drawImage(this.chromImage, 0, 0, null);
    }

    void drawSearchInterval() {
        if (Main.searchStart > 0 && Main.searchEnd < 1) {
            if ((double)Main.searchStart > Main.drawCanvas.splits.get((int)0).start && (double)Main.searchStart < Main.drawCanvas.splits.get((int)0).end) {
                this.chromImageBuffer.setColor(Color.black);
                this.chromImageBuffer.drawLine((int)(((double)Main.searchStart - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.cytoHeight, (int)(((double)Main.searchStart - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
                this.chromImageBuffer.drawLine((int)(((double)(Main.searchStart + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.cytoHeight, (int)(((double)(Main.searchStart + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
                this.chromImageBuffer.setColor(highlight);
                this.chromImageBuffer.fillRect((int)(((double)Main.searchStart - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.cytoHeight, (int)Main.drawCanvas.splits.get((int)0).pixel, this.getHeight());
            }
        } else if (Main.searchStart > 0 && Main.searchEnd > 0) {
            this.chromImageBuffer.setColor(Color.black);
            if ((double)Main.searchStart > Main.drawCanvas.splits.get((int)0).start && (double)Main.searchEnd < Main.drawCanvas.splits.get((int)0).end) {
                this.chromImageBuffer.drawLine((int)(((double)Main.searchStart - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.cytoHeight, (int)(((double)Main.searchStart - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
                this.chromImageBuffer.drawLine((int)(((double)(Main.searchEnd + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.cytoHeight, (int)(((double)(Main.searchEnd + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
                this.chromImageBuffer.setColor(highlight);
                this.chromImageBuffer.fillRect((int)(((double)Main.searchStart - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.cytoHeight, (int)((double)(Main.searchEnd + 1 - Main.searchStart) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
            } else if ((double)Main.searchStart > Main.drawCanvas.splits.get((int)0).start && (double)Main.searchStart < Main.drawCanvas.splits.get((int)0).end && (double)Main.searchEnd > Main.drawCanvas.splits.get((int)0).end) {
                this.chromImageBuffer.drawLine((int)(((double)Main.searchStart - Main.drawCanvas.splits.get((int)0).start + 1.0) * Main.drawCanvas.splits.get((int)0).pixel), this.cytoHeight, (int)(((double)Main.searchStart - Main.drawCanvas.splits.get((int)0).start + 1.0) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
                this.chromImageBuffer.setColor(highlight);
                this.chromImageBuffer.fillRect((int)(((double)Main.searchStart - Main.drawCanvas.splits.get((int)0).start + 1.0) * Main.drawCanvas.splits.get((int)0).pixel), this.cytoHeight, (int)((Main.drawCanvas.splits.get((int)0).end - (double)Main.searchStart) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
            } else if ((double)Main.searchStart < Main.drawCanvas.splits.get((int)0).start && (double)Main.searchEnd < Main.drawCanvas.splits.get((int)0).end && (double)Main.searchEnd > Main.drawCanvas.splits.get((int)0).start) {
                this.chromImageBuffer.drawLine((int)(((double)(Main.searchEnd + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.cytoHeight, (int)(((double)(Main.searchEnd + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
                this.chromImageBuffer.setColor(highlight);
                this.chromImageBuffer.fillRect(0, this.cytoHeight, (int)(((double)(Main.searchEnd + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
            } else if ((double)Main.searchStart < Main.drawCanvas.splits.get((int)0).start && (double)Main.searchEnd > Main.drawCanvas.splits.get((int)0).end) {
                this.chromImageBuffer.setColor(highlight);
                this.chromImageBuffer.fillRect(0, this.cytoHeight, (int)(Main.drawCanvas.splits.get((int)0).viewLength * Main.drawCanvas.splits.get((int)0).pixel), this.getHeight());
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        try {
            this.drawScreen(g);
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
        }
    }

    public StringBuffer getSeq(String chrom, int start, int end, RandomAccessFile seqchrom) {
        block14: {
            try {
                if (chrom != null) break block14;
                return null;
            }
            catch (Exception e) {
                ErrorLog.addError(e.getStackTrace());
                e.printStackTrace();
                return new StringBuffer();
            }
        }
        if (start < 0) {
            start = 0;
            if ((long)end > Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[1]) {
                end = Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[1].intValue();
            }
        }
        this.seqresult = new byte[end - start + 1 + (end - start) / (Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[2].intValue() - 1)];
        if (this.seqresult.length == 0 || this.seqresult.length > 200000) {
            return new StringBuffer();
        }
        this.seqBuffer = new StringBuffer();
        try {
            try {
                seqchrom.seek(Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[0] + (long)start + (long)(start / Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[2].intValue()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            seqchrom.readFully(this.seqresult);
            if (this.seqresult[0] == 10) {
                seqchrom.seek(Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[0] + (long)(start - 1) + (long)(start / Main.chromIndex.get(String.valueOf(Main.refchrom) + chrom)[2].intValue()));
                seqchrom.readFully(this.seqresult);
            }
            int i = 0;
            while (i < this.seqresult.length) {
                if (this.seqresult[i] != 10) {
                    this.seqBuffer.append((char)this.seqresult[i]);
                }
                if (this.seqBuffer.length() < end - start) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.seqBuffer;
    }

    static int[] makeLine(String[] split) {
        if (split.length > 16) {
            int[] temp = new int[]{Integer.parseInt(split[8]), Integer.parseInt(split[9]), Integer.parseInt(split[12]), Integer.parseInt(split[13]), Integer.parseInt(split[14]), Integer.parseInt(split[15]), Integer.parseInt(split[16]), Integer.parseInt(split[17].trim()), Integer.parseInt(split[6]), Integer.parseInt(split[7])};
            return temp;
        }
        int[] temp = new int[]{Integer.parseInt(split[8]), Integer.parseInt(split[9]), Integer.parseInt(split[12]), Integer.parseInt(split[13]), Integer.parseInt(split[14]), Integer.parseInt(split[15].trim()), Integer.parseInt(split[6]), Integer.parseInt(split[7])};
        return temp;
    }

    void drawExons(SplitClass split) {
        block100: {
            try {
                if (this.updateExons) {
                    this.exonDrawY = this.bounds * 3.0 > split.pixel * 3.0 ? Main.defaultFontSize + 10 : Main.defaultFontSize * 2 + 10;
                    try {
                        split.getExonImageBuffer().setColor(backTransparent);
                        split.getExonImageBuffer().fillRect(0, 0, Main.drawCanvas.getDrawWidth() + 1, this.getHeight());
                        this.level = 1;
                        split.getExonImageBuffer().setFont(Draw.defaultFont);
                        if (split.viewLength <= (double)Settings.readDrawDistance && split.viewLength > 10.0) {
                            try {
                                this.getDrawSeq(split);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (split.getGenes() != null && split.getGenes().size() > 0) {
                            if (split.transStart > split.getGenes().size() - 1) {
                                split.transStart = 0;
                            }
                            if (split.getGenes().get(split.transStart) != null && split.getGenes().get(split.transStart).getEnd() + 100000 < (int)split.start && split.transStart < split.getGenes().size() - 2 && split.getGenes().get(split.transStart + 1).getEnd() + 100000 < (int)split.start) {
                                while (split.getGenes().get(split.transStart) != null && split.getGenes().get(split.transStart).getEnd() + 100000 < (int)split.start) {
                                    ++split.transStart;
                                    if (split.transStart <= split.getGenes().size() - 1) {
                                        continue;
                                    }
                                    break;
                                }
                            } else if (split.getGenes().get(split.transStart) != null && split.getGenes().get(split.transStart).getEnd() + 100000 > (int)split.start) {
                                while (split.transStart > 0 && split.getGenes().get(split.transStart).getEnd() + 100000 > (int)split.start) {
                                    --split.transStart;
                                }
                            }
                            int g = split.transStart;
                            while (g < split.getGenes().size()) {
                                if (g >= 0) {
                                    int i = 0;
                                    while (i < split.getGenes().get(g).getTranscripts().size()) {
                                        this.transcript = split.getGenes().get(g).getTranscripts().get(i);
                                        if (this.transcript.getGene().showIsoforms() || this.transcript.equals(split.getGenes().get(g).getLongest())) {
                                            if (this.transcript.getStart() > (int)split.end) break;
                                            this.geneStartPos = (int)(((double)(this.transcript.getStart() + 1) - split.start) * split.pixel);
                                            this.geneEndPos = (int)(((double)this.transcript.getEnd() - split.start) * split.pixel);
                                            this.genewidth = (int)((double)(this.transcript.getEnd() - this.transcript.getStart()) * split.pixel);
                                            if (this.genewidth < 2 && split.viewLength > 1.0E7) {
                                                if (this.transcript.getStrand()) {
                                                    split.getExonImageBuffer().setColor(exonBarColor);
                                                } else {
                                                    split.getExonImageBuffer().setColor(Color.RED);
                                                }
                                                split.getExonImageBuffer().drawLine(this.geneStartPos, Main.defaultFontSize / 2, this.geneStartPos, 2);
                                            } else {
                                                this.gene = this.transcript.getGenename();
                                                this.textWidth = split.getExonImageBuffer().getFontMetrics().getStringBounds(this.gene, split.getExonImageBuffer());
                                                this.levelEndPos = (double)this.geneEndPos < (double)this.geneStartPos + this.textWidth.getWidth() ? (int)((double)this.geneStartPos + this.textWidth.getWidth()) + 5 : this.geneEndPos + 5;
                                                if (this.geneLevelMatrix.isEmpty()) {
                                                    this.geneLevelMatrix.add(this.levelEndPos);
                                                    this.level = 1;
                                                } else {
                                                    this.foundlevel = false;
                                                    int c = 0;
                                                    while (c < this.geneLevelMatrix.size()) {
                                                        if (this.geneLevelMatrix.get(c) < this.geneStartPos) {
                                                            this.level = c + 1;
                                                            this.foundlevel = true;
                                                            this.geneLevelMatrix.set(c, this.levelEndPos);
                                                            break;
                                                        }
                                                        ++c;
                                                    }
                                                    if (!this.foundlevel) {
                                                        this.geneLevelMatrix.add(this.levelEndPos);
                                                        this.level = this.geneLevelMatrix.size();
                                                    }
                                                }
                                                this.transcript.ypos = this.exonDrawY * this.level + 2;
                                                if (this.genewidth > 2) {
                                                    split.getExonImageBuffer().setColor(Color.black);
                                                    if (this.geneEndPos - this.geneStartPos > 0) {
                                                        split.getExonImageBuffer().drawLine(this.geneStartPos, this.transcript.ypos + this.exonDrawY / 4, this.geneEndPos, this.transcript.ypos + this.exonDrawY / 4);
                                                    }
                                                }
                                                this.nameDraw = false;
                                                int e = 0;
                                                while (e < this.transcript.getExons().length) {
                                                    try {
                                                        if (e > this.transcript.getExons().length - 1) break;
                                                        this.exon = this.transcript.getExons()[e];
                                                    }
                                                    catch (Exception ex) {
                                                        ex.printStackTrace();
                                                    }
                                                    if (!((double)this.exon.getEnd() < split.start)) {
                                                        if ((double)this.exon.getStart() > split.end) break;
                                                        this.screenPos = (int)(((double)(this.exon.getStart() + 1) - split.start) * split.pixel);
                                                        this.exonwidth = (int)((double)(this.exon.getEnd() - this.exon.getStart()) * split.pixel) + 1;
                                                        this.exon.getRectangle().setBounds(this.screenPos, this.transcript.ypos, this.exonwidth, this.exonDrawY / 2);
                                                        if (this.exonwidth < 1) {
                                                            this.exonwidth = 1;
                                                        }
                                                        split.getExonImageBuffer().setColor(Color.black);
                                                        if (!this.nameDraw && this.screenPos >= 0) {
                                                            split.getExonImageBuffer().drawString(this.gene, this.screenPos, this.transcript.ypos - 1);
                                                            this.nameDraw = true;
                                                        }
                                                        if (this.transcript.getStrand()) {
                                                            split.getExonImageBuffer().setColor(exonBarColor);
                                                        } else {
                                                            split.getExonImageBuffer().setColor(Color.RED);
                                                        }
                                                        if (this.exon.getStartPhase() == -1) {
                                                            split.getExonImageBuffer().setColor(Color.lightGray);
                                                        }
                                                        split.getExonImageBuffer().fillRect(this.screenPos, this.transcript.ypos, this.exonwidth, this.exonDrawY / 2);
                                                        this.exonwidth = (int)((double)(this.transcript.getCodingStart() - this.exon.getStart()) * split.pixel) + 1;
                                                        if (this.exon.getEnd() > this.transcript.getCodingEnd() && this.exon.getStart() < this.transcript.getCodingEnd() && this.exon.getEnd() > this.transcript.getCodingStart() && this.exon.getStart() < this.transcript.getCodingStart()) {
                                                            split.getExonImageBuffer().setColor(Color.lightGray);
                                                            this.exonwidth = (int)((double)(this.transcript.getCodingStart() - this.exon.getStart()) * split.pixel) + 1;
                                                            split.getExonImageBuffer().fillRect(this.screenPos, this.transcript.ypos, this.exonwidth, this.exonDrawY / 2);
                                                            this.screenPos = (int)(((double)(this.transcript.getCodingEnd() + 1) - split.start) * split.pixel) + 1;
                                                            this.exonwidth = (int)((double)(this.exon.getEnd() - this.transcript.getCodingEnd()) * split.pixel) + 1;
                                                            split.getExonImageBuffer().fillRect(this.screenPos, this.transcript.ypos, this.exonwidth, this.exonDrawY / 2);
                                                        } else if (this.exon.getStart() < this.transcript.getCodingStart() && this.exon.getEnd() > this.transcript.getCodingStart()) {
                                                            split.getExonImageBuffer().setColor(Color.lightGray);
                                                            this.exonwidth = (int)((double)(this.transcript.getCodingStart() - this.exon.getStart()) * split.pixel) + 1;
                                                            split.getExonImageBuffer().fillRect(this.screenPos, this.transcript.ypos, this.exonwidth, this.exonDrawY / 2);
                                                        } else if (this.exon.getStart() < this.transcript.getCodingEnd() && this.exon.getEnd() > this.transcript.getCodingEnd()) {
                                                            split.getExonImageBuffer().setColor(Color.lightGray);
                                                            this.exonwidth = (int)((double)(this.exon.getEnd() - this.transcript.getCodingEnd()) * split.pixel) + 1;
                                                            this.screenPos = (int)(((double)(this.transcript.getCodingEnd() + 1) - split.start) * split.pixel) + 1;
                                                            split.getExonImageBuffer().fillRect(this.screenPos, this.transcript.ypos, this.exonwidth, this.exonDrawY / 2);
                                                        }
                                                        if (split.viewLength < 200.0) {
                                                            if (split.getReference() == null) break;
                                                            if (this.transcript.getStrand()) {
                                                                if (split.end > (double)this.transcript.getCodingStart().intValue() && split.start < (double)this.transcript.getCodingEnd().intValue() && this.exon.getStartPhase() != -1) {
                                                                    if (this.exon.getEnd() > this.transcript.getCodingStart() && this.exon.getStart() < this.transcript.getCodingStart()) {
                                                                        this.aminoNro = this.exon.getFirstAmino();
                                                                        int codon = this.transcript.getCodingStart();
                                                                        while (codon < this.exon.getEnd() - this.exon.getEndPhase()) {
                                                                            if (codon >= this.transcript.getCodingEnd() || codon - split.getReference().getStartPos() + 3 > split.getReference().getSeq().length - 1) break;
                                                                            if (codon - split.getReference().getStartPos() >= 0) {
                                                                                this.codonStartPos = (int)(((double)(codon + 1) - split.start) * split.pixel);
                                                                                split.getExonImageBuffer().setColor(Color.white);
                                                                                split.getExonImageBuffer().drawLine(this.codonStartPos, this.transcript.ypos, this.codonStartPos, this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                                if (this.bounds * 3.0 < split.pixel * 3.0) {
                                                                                    split.getExonImageBuffer().drawString(MethodLibrary.getAminoAcid(new String(Arrays.copyOfRange(split.getReference().getSeq(), codon - split.getReference().getStartPos(), codon - split.getReference().getStartPos() + 3))), this.codonStartPos + 1, this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                                    if (this.bounds * 3.0 < split.pixel * 1.5) {
                                                                                        split.getExonImageBuffer().drawString("" + this.aminoNro, this.codonStartPos + (int)(3.0 * split.pixel) / 2, this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                                    }
                                                                                }
                                                                                ++this.aminoNro;
                                                                            }
                                                                            codon += 3;
                                                                        }
                                                                        split.getExonImageBuffer().drawLine((int)(((double)(this.exon.getEnd() - this.exon.getEndPhase() + 1) - split.start) * split.pixel), this.transcript.ypos, (int)(((double)(this.exon.getEnd() - this.exon.getEndPhase() + 1) - split.start) * split.pixel), this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                    } else {
                                                                        this.aminoNro = this.exon.getFirstAmino();
                                                                        int codon = this.exon.getStart() + this.exon.getStartPhase();
                                                                        while (codon < this.exon.getEnd() - this.exon.getEndPhase()) {
                                                                            if (codon >= this.transcript.getCodingEnd() || (double)codon > split.end) break;
                                                                            this.codonStartPos = (int)(((double)(codon + 1) - split.start) * split.pixel);
                                                                            split.getExonImageBuffer().setColor(Color.white);
                                                                            split.getExonImageBuffer().drawLine(this.codonStartPos, this.transcript.ypos, this.codonStartPos, this.transcript.ypos + (this.exonDrawY / 2 - 2));
                                                                            try {
                                                                                if (this.bounds * 3.0 < split.pixel * 3.0) {
                                                                                    if (codon - split.getReference().getStartPos() > 0) {
                                                                                        split.getExonImageBuffer().drawString(MethodLibrary.getAminoAcid(new String(Arrays.copyOfRange(split.getReference().getSeq(), codon - split.getReference().getStartPos(), codon - split.getReference().getStartPos() + 3))), this.codonStartPos + 1, this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                                    }
                                                                                    if (this.bounds * 3.0 < split.pixel * 1.5) {
                                                                                        split.getExonImageBuffer().drawString("" + this.aminoNro, this.codonStartPos + (int)(3.0 * split.pixel) / 2, this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                                    }
                                                                                }
                                                                            }
                                                                            catch (Exception ex) {
                                                                                ex.printStackTrace();
                                                                            }
                                                                            ++this.aminoNro;
                                                                            codon += 3;
                                                                        }
                                                                        split.getExonImageBuffer().drawLine((int)(((double)(this.exon.getEnd() - this.exon.getEndPhase() + 1) - split.start) * split.pixel), this.transcript.ypos, (int)(((double)(this.exon.getEnd() - this.exon.getEndPhase() + 1) - split.start) * split.pixel), this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                    }
                                                                }
                                                            } else if (split.end > (double)this.transcript.getCodingStart().intValue() && split.start < (double)this.transcript.getCodingEnd().intValue() && this.exon.getStartPhase() != -1) {
                                                                if (this.exon.getEnd() > this.transcript.getCodingEnd() && this.exon.getStart() < this.transcript.getCodingEnd()) {
                                                                    this.aminoNro = 1;
                                                                    int codon = this.transcript.getCodingEnd();
                                                                    while (codon - 3 >= this.exon.getStart()) {
                                                                        if (codon < this.transcript.getCodingStart() + 1) break;
                                                                        if (codon - 3 - split.getReference().getStartPos() >= 0 && codon - split.getReference().getStartPos() <= split.getReference().getSeq().length - 1) {
                                                                            this.codonStartPos = (int)(((double)(codon - 2) - split.start) * split.pixel);
                                                                            split.getExonImageBuffer().setColor(Color.white);
                                                                            split.getExonImageBuffer().drawLine(this.codonStartPos, this.transcript.ypos, this.codonStartPos, this.transcript.ypos + (this.exonDrawY / 2 - 2));
                                                                            if (this.bounds * 3.0 < split.pixel * 3.0) {
                                                                                split.getExonImageBuffer().drawString(MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(Arrays.copyOfRange(split.getReference().getSeq(), codon - 3 - split.getReference().getStartPos(), codon - split.getReference().getStartPos())))), this.codonStartPos + 1, this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                                if (this.bounds * 3.0 < split.pixel * 1.5) {
                                                                                    split.getExonImageBuffer().drawString("" + this.aminoNro, this.codonStartPos + (int)(3.0 * split.pixel) / 2, this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                                }
                                                                            }
                                                                            ++this.aminoNro;
                                                                        }
                                                                        codon -= 3;
                                                                    }
                                                                    split.getExonImageBuffer().drawLine((int)(((double)(this.exon.getEnd() + 1 - this.exon.getStartPhase()) - split.start) * split.pixel), this.transcript.ypos, (int)(((double)(this.exon.getEnd() + 1 - this.exon.getStartPhase()) - split.start) * split.pixel), this.transcript.ypos + this.exonDrawY);
                                                                } else {
                                                                    this.aminoNro = this.exon.getFirstAmino();
                                                                    if (split.getReference() != null) {
                                                                        int codon = this.exon.getEnd() - this.exon.getStartPhase();
                                                                        while (codon - 3 >= this.exon.getStart()) {
                                                                            if (codon - 3 < this.transcript.getCodingStart()) break;
                                                                            this.codonStartPos = (int)(((double)(codon - 2) - split.start) * split.pixel);
                                                                            split.getExonImageBuffer().setColor(Color.white);
                                                                            split.getExonImageBuffer().drawLine(this.codonStartPos, this.transcript.ypos, this.codonStartPos, this.transcript.ypos + this.exonDrawY / 2);
                                                                            try {
                                                                                if ((double)codon > split.start && (double)codon < split.end && this.bounds * 3.0 < split.pixel * 3.0) {
                                                                                    split.getExonImageBuffer().drawString(MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(Arrays.copyOfRange(split.getReference().getSeq(), codon - 3 - split.getReference().getStartPos(), codon - split.getReference().getStartPos())))), this.codonStartPos + 1, this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                                    if (this.bounds * 3.0 < split.pixel * 1.5) {
                                                                                        split.getExonImageBuffer().drawString("" + this.aminoNro, this.codonStartPos + (int)(3.0 * split.pixel) / 2, this.transcript.ypos + this.exonDrawY / 2 - 2);
                                                                                    }
                                                                                }
                                                                            }
                                                                            catch (Exception ex) {
                                                                                ex.printStackTrace();
                                                                            }
                                                                            ++this.aminoNro;
                                                                            codon -= 3;
                                                                        }
                                                                        split.getExonImageBuffer().drawLine((int)(((double)(this.exon.getEnd() + 1 - this.exon.getStartPhase()) - split.start) * split.pixel), this.transcript.ypos, (int)(((double)(this.exon.getEnd() + 1 - this.exon.getStartPhase()) - split.start) * split.pixel), this.transcript.ypos + this.exonDrawY / 2);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    ++e;
                                                }
                                            }
                                        }
                                        ++i;
                                    }
                                }
                                ++g;
                            }
                            if (split.equals(Main.drawCanvas.splits.get(0))) {
                                this.drawMutations(this.exonDrawY * this.level + 2);
                            }
                            this.setPreferredSize(new Dimension(Main.drawScroll.getViewport().getWidth(), (this.geneLevelMatrix.size() + 1) * this.exonDrawY));
                            this.revalidate();
                            this.geneLevelMatrix.clear();
                            this.updateExons = false;
                        }
                        if (Main.referenceFile != null && !Draw.variantcalculator) {
                            this.drawSeq(split);
                        }
                        break block100;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block100;
                }
                this.selectImageBuffer.setComposite(Main.drawCanvas.composite);
                this.selectImageBuffer.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.selectImageBuffer.setComposite(split.getBackupe());
                if (Main.drawCanvas.loading) {
                    return;
                }
                if (split.transStart > split.getGenes().size() - 1) {
                    split.transStart = 0;
                }
                int g = split.transStart;
                while (g < split.getGenes().size()) {
                    int i = 0;
                    while (i < split.getGenes().get(g).getTranscripts().size()) {
                        this.transcriptSelect = split.getGenes().get(g).getTranscripts().get(i);
                        if (this.transcriptSelect.getGene().showIsoforms() || this.transcriptSelect.equals(split.getGenes().get(g).getLongest())) {
                            if (this.transcriptSelect.getStart() > (int)split.end) break;
                            if (this.transcriptSelect == null || this.transcriptSelect.getEnd() + 100000 >= (int)split.start) {
                                if (this.transcriptSelect.getStart() > (int)split.end) break;
                                if (!((double)(this.transcriptSelect.getEnd() - this.transcriptSelect.getStart()) * split.pixel < 2.0) || !(split.viewLength > 1.0E7)) {
                                    int e = 0;
                                    while (e < this.transcriptSelect.getExons().length) {
                                        this.exon = this.transcriptSelect.getExons()[e];
                                        if (!((double)this.exon.getEnd() < split.start)) {
                                            if ((double)this.exon.getStart() > split.end) break;
                                            if (this.selectedExon == null && this.exon.getRectangle().intersects(this.mouseRect)) {
                                                this.selectedExon = this.exon;
                                                this.transIndex = i;
                                            }
                                            if (this.selectedExon != null && this.exon == this.selectedExon) {
                                                this.screenPos = (int)(((double)(this.exon.getStart() + 1) - split.start) * split.pixel);
                                                this.exonwidth = (int)((double)(this.exon.getEnd() - this.exon.getStart()) * split.pixel) + 1;
                                                this.transcript.ypos = (int)this.selectedExon.getRectangle().getY();
                                                this.selectImageBuffer.setColor(Color.red);
                                                this.selectImageBuffer.drawRect(this.screenPos - 1, this.transcript.ypos - 1, this.exonwidth + 1, this.exonDrawY / 2 + 1);
                                                if (split.viewLength < 200.0 && (this.exon.getStartPhase() > 0 || this.exon.getEndPhase() > 0)) {
                                                    this.selectImageBuffer.setColor(Color.black);
                                                    if (this.transcriptSelect.getStrand()) {
                                                        if (this.exon.getStartPhase() > 0) {
                                                            this.selectImageBuffer.drawString(String.valueOf(this.startPhaseCodon) + " " + (this.exon.getFirstAmino() - 1), (int)((double)this.screenPos - (double)(3 - this.exon.getStartPhase()) * split.pixel), this.transcript.ypos + this.exonDrawY);
                                                        }
                                                        if (this.exon.getEndPhase() > 0) {
                                                            this.lastAmino = this.exon.getFirstAmino() == 1 ? (this.exon.getEnd() - this.transcriptSelect.getCodingStart()) / 3 + 1 : this.exon.getFirstAmino() + (this.exon.getEnd() - (this.exon.getStart() + this.exon.getStartPhase())) / 3;
                                                        }
                                                    } else {
                                                        if (this.exon.getStartPhase() > 0) {
                                                            this.selectImageBuffer.drawString(String.valueOf(this.startPhaseCodon) + " " + (this.exon.getFirstAmino() - 1), (int)(((double)(this.exon.getEnd() + 1) - split.start) * split.pixel) + 4, this.transcript.ypos + this.exonDrawY / 2 + 4);
                                                        }
                                                        if (this.exon.getEndPhase() > 0) {
                                                            this.lastAmino = this.exon.getFirstAmino() == 1 ? (this.transcriptSelect.getCodingEnd() - this.exon.getStart()) / 3 + 1 : this.exon.getFirstAmino() + (this.exon.getEnd() - (this.exon.getStart() + this.exon.getStartPhase())) / 3;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        ++e;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    ++g;
                }
                if (this.selectedExon != null && !this.selectedExon.equals(this.clickedExon)) {
                    if (this.getCursor().getType() != 12) {
                        this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    this.screenPos = this.mouseRect.x;
                    this.transcript.ypos = (int)this.selectedExon.getRectangle().getY();
                    this.exonString[0] = "Exon " + this.selectedExon.getNro();
                    this.exonString[1] = this.selectedExon.getTranscript().getGene().getStrand() ? String.valueOf(this.selectedExon.transcript.getGenename()) + " (forward strand)" : String.valueOf(this.selectedExon.transcript.getGenename()) + " (reverse strand)";
                    this.exonString[2] = this.selectedExon.transcript.getENSG();
                    this.exonString[3] = this.selectedExon.transcript.getENST();
                    this.exonString[4] = this.selectedExon.transcript.getBiotype();
                    this.exonString[5] = this.selectedExon.transcript.getUniprot();
                    this.exonString[6] = this.selectedExon.transcript.getDescription().length() < 50 ? this.selectedExon.transcript.getDescription() : String.valueOf(this.selectedExon.transcript.getDescription().substring(0, 50)) + "...";
                    this.exonString[7] = this.selectedExon.transcript.getGene().getTranscripts().size() > 1 ? (this.selectedExon != null && this.selectedExon.transcript.getGene().showIsoforms() ? "Right click to collapse isoforms." : "Right click to expand all isoforms.") : "";
                    this.exonInfoWidth = Main.drawCanvas.splits.get(0).getExonImageBuffer().getFontMetrics().stringWidth(this.exonString[this.maxWidth(this.exonString)]) + 2;
                    this.selectImageBuffer.setColor(Color.white);
                    this.selectImageBuffer.fillRect(this.screenPos, this.transcript.ypos + this.exonDrawY, this.exonInfoWidth, (int)(this.textWidth.getHeight() * (double)this.exonString.length) + 2);
                    this.selectImageBuffer.setColor(Color.black);
                    this.selectImageBuffer.drawRect(this.screenPos - 1, this.transcript.ypos + this.exonDrawY - 1, this.exonInfoWidth + 2, (int)(this.textWidth.getHeight() * (double)this.exonString.length) + 4);
                    int i = 0;
                    while (i < this.exonString.length) {
                        this.selectImageBuffer.drawString(this.exonString[i], this.screenPos + 2, (int)((double)(this.transcript.ypos + this.exonDrawY) + this.textWidth.getHeight() * (double)(i + 1)));
                        ++i;
                    }
                }
                if (this.selectedExon != null && !this.selectedExon.getRectangle().intersects(this.mouseRect) && this.mouseY > this.cytoHeight) {
                    this.selectedExon = null;
                    if (this.getCursor().getType() != 0) {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    void drawClickedExon(SplitClass split) {
        if (this.clickedExon != null) {
            this.screenPos = (int)this.clickedExon.getRectangle().getX();
            if (this.screenPos < 12) {
                this.screenPos = 12;
            }
            this.transcript.ypos = (int)this.clickedExon.getRectangle().getY();
            this.exonString[0] = "Exon " + this.clickedExon.getNro();
            this.exonString[1] = this.clickedExon.transcript.getGenename();
            this.exonString[2] = this.clickedExon.transcript.getENSG().contains("ENS") ? String.valueOf(this.clickedExon.transcript.getENSG()) + " (view in Ensembl)" : (this.clickedExon.transcript.getENSG().startsWith("GeneID") ? String.valueOf(this.clickedExon.transcript.getENSG()) + " (view in RefSeq)" : this.clickedExon.transcript.getENSG());
            if (this.clickedExon.transcript.getENST().contains("ENS")) {
                this.exonString[3] = String.valueOf(this.clickedExon.transcript.getENST()) + " (view in Ensembl)";
            }
            this.exonString[4] = this.clickedExon.transcript.getBiotype();
            this.exonString[5] = "View in GeneCards";
            this.exonString[6] = this.clickedExon.transcript.getDescription();
            this.exonString[7] = this.clickedExon.transcript.getGene().getTranscripts().size() > 1 ? (this.clickedExon != null && this.clickedExon.transcript.getGene().showIsoforms() ? "Right click to collapse isoforms." : "Right click to expand all isoforms.") : "";
            this.exonInfoWidth = split.getExonImageBuffer().getFontMetrics().stringWidth(this.exonString[this.maxWidth(this.exonString)]) + 2;
            split.getExonImageBuffer().setColor(Color.white);
            split.getExonImageBuffer().fillRect(this.screenPos, this.transcript.ypos + this.exonDrawY, this.exonInfoWidth, (int)(this.textWidth.getHeight() * (double)this.exonString.length) + 2);
            split.getExonImageBuffer().setColor(Color.black);
            split.getExonImageBuffer().drawRect(this.screenPos - 1, this.transcript.ypos + this.exonDrawY - 1, this.exonInfoWidth + 2, (int)(this.textWidth.getHeight() * (double)this.exonString.length) + 4);
            this.foundcursor = (short)-1;
            int i = 0;
            while (i < this.exonString.length - 1) {
                if (this.mouseRect.getX() > (double)this.screenPos && this.mouseRect.getX() < (double)(this.screenPos + this.exonInfoWidth)) {
                    if (i < 6 && this.mouseRect.getY() > (double)((int)((double)(this.transcript.ypos + this.exonDrawY) + this.textWidth.getHeight() * (double)i)) && this.mouseRect.getY() < (double)((int)((double)(this.transcript.ypos + this.exonDrawY) + this.textWidth.getHeight() * (double)(i + 1)))) {
                        split.getExonImageBuffer().setFont(Main.menuFontBold);
                        this.foundcursor = (short)i;
                        if (this.getCursor().getType() != 12) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                        }
                    } else {
                        split.getExonImageBuffer().setFont(Draw.defaultFont);
                    }
                } else {
                    split.getExonImageBuffer().setFont(Draw.defaultFont);
                }
                if (split.getExonImageBuffer().getFont().equals(seqFont)) {
                    if (i == 0) {
                        split.getExonImageBuffer().drawString(String.valueOf(this.exonString[i]) + "  (zoom to exon)", this.screenPos + 2, (int)((double)(this.transcript.ypos + this.exonDrawY) + this.textWidth.getHeight() * (double)(i + 1)));
                    } else if (i == 1) {
                        split.getExonImageBuffer().drawString(String.valueOf(this.exonString[i]) + "  (zoom to gene)", this.screenPos + 2, (int)((double)(this.transcript.ypos + this.exonDrawY) + this.textWidth.getHeight() * (double)(i + 1)));
                    } else if (i == 2 || i == 3) {
                        split.getExonImageBuffer().drawString(this.exonString[i], this.screenPos + 2, (int)((double)(this.transcript.ypos + this.exonDrawY) + this.textWidth.getHeight() * (double)(i + 1)));
                    } else if (i >= 4) {
                        split.getExonImageBuffer().drawString(this.exonString[i], this.screenPos + 2, (int)((double)(this.transcript.ypos + this.exonDrawY) + this.textWidth.getHeight() * (double)(i + 1)));
                    }
                } else {
                    split.getExonImageBuffer().drawString(this.exonString[i], this.screenPos + 2, (int)((double)(this.transcript.ypos + this.exonDrawY) + this.textWidth.getHeight() * (double)(i + 1)));
                }
                ++i;
            }
            if (this.foundcursor < 0 && this.selectedExon == null && this.mouseY > this.cytoHeight && this.mouseY < Main.chromScroll.getViewport().getHeight() - 15) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    void drawMutations(int ylevel, Transcript trans) {
        try {
            if (this.varnode != null && Main.drawCanvas.selectedSplit.viewLength < 1000000.0) {
                this.vardraw = this.varnode;
                Main.drawCanvas.splits.get(0).getExonImageBuffer().setColor(this.varColor);
                while (this.vardraw != null && (double)this.vardraw.getPosition() < Main.drawCanvas.splits.get((int)0).end + 1.0) {
                    if (Main.drawCanvas.hideNode(this.vardraw)) {
                        this.vardraw = this.vardraw.getNext();
                        continue;
                    }
                    this.found = false;
                    if (this.vardraw.getPrev().getPosition() - this.vardraw.getPosition() != -1) {
                        this.baselevel = 1;
                    }
                    int j = 0;
                    while (j < this.vardraw.vars.size()) {
                        this.entry = this.vardraw.vars.get(j);
                        if (!Main.drawCanvas.hideNodeVar(this.vardraw, this.entry)) {
                            int i = 0;
                            while (i < this.entry.getValue().size()) {
                                if (!Main.drawCanvas.hideVar(this.entry.getValue().get(i), this.entry.getKey().length() > 1)) {
                                    this.found = true;
                                    break;
                                }
                                ++i;
                            }
                            if (this.found) {
                                this.mutScreenPos = this.vardraw.indel && this.entry.getKey().length() > 1 ? (int)(((double)(this.vardraw.getPosition() + 2) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel) : (int)(((double)(this.vardraw.getPosition() + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel);
                                if (this.vardraw.getExons().size() > 0) {
                                    this.foundexon = false;
                                    i = 0;
                                    while (i < this.vardraw.getExons().size()) {
                                        if (!this.vardraw.getExons().get(i).getTranscript().equals(trans)) {
                                            return;
                                        }
                                        if (this.vardraw.indel && this.entry.getKey().length() > 1) {
                                            if (this.vardraw.getPosition() + 1 > this.vardraw.getExons().get(i).getTranscript().getCodingStart() && this.vardraw.getPosition() + 1 < this.vardraw.getExons().get(i).getTranscript().getCodingEnd() && this.vardraw.getPosition() + 1 >= this.vardraw.getExons().get(i).getStart() - 2 && this.vardraw.getPosition() + 1 < this.vardraw.getExons().get(i).getEnd() + 2) {
                                                this.foundexon = true;
                                                this.foundexonindex = i;
                                                break;
                                            }
                                        } else if (this.vardraw.getPosition() >= this.vardraw.getExons().get(i).getTranscript().getCodingStart() && this.vardraw.getPosition() < this.vardraw.getExons().get(i).getTranscript().getCodingEnd()) {
                                            this.foundexon = true;
                                            this.foundexonindex = i;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (this.foundexon) {
                                        Main.drawCanvas.splits.get(0).getExonImageBuffer().setColor(reverseExon);
                                    } else {
                                        Main.drawCanvas.splits.get(0).getExonImageBuffer().setColor(this.varColor);
                                    }
                                    Main.drawCanvas.splits.get(0).getExonImageBuffer().fillRect(this.mutScreenPos, 0, (int)Main.drawCanvas.splits.get((int)0).pixel + 1, this.getHeight());
                                    Main.drawCanvas.splits.get(0).getExonImageBuffer().setColor(this.varColor);
                                } else {
                                    Main.drawCanvas.splits.get(0).getExonImageBuffer().fillRect(this.mutScreenPos, 0, (int)Main.drawCanvas.splits.get((int)0).pixel + 1, this.getHeight());
                                }
                                if (Main.drawCanvas.splits.get((int)0).viewLength < 200.0 && this.vardraw.getExons().size() > 0 && trans != null && this.vardraw.getExons().get((int)0).transcript.equals(trans)) {
                                    this.mutcount = 0;
                                    int m = 0;
                                    while (m < this.entry.getValue().size()) {
                                        if (!Main.drawCanvas.hideVar(this.entry.getValue().get(m), this.entry.getKey().length() > 1)) {
                                            ++this.mutcount;
                                        }
                                        ++m;
                                    }
                                    if (this.mutcount == 0) break;
                                    this.base = this.entry.getKey();
                                    Main.drawCanvas.splits.get(0).getExonImageBuffer().setFont(seqFont);
                                    Main.drawCanvas.splits.get(0).getExonImageBuffer().setColor(Color.black);
                                    Main.drawCanvas.splits.get(0).getExonImageBuffer().drawString(String.valueOf(this.mutcount) + " " + this.getAminoChange(this.vardraw, this.base, this.vardraw.getExons().get(this.foundexonindex)), this.mutScreenPos, ylevel + (Main.defaultFontSize * 2 + 8) * this.baselevel);
                                    Main.drawCanvas.splits.get(0).getExonImageBuffer().setColor(this.varColor);
                                    ++this.baselevel;
                                }
                                Main.drawCanvas.splits.get(0).getExonImageBuffer().setFont(Draw.defaultFont);
                            }
                        }
                        ++j;
                    }
                    if (this.vardraw == null) continue;
                    this.vardraw = this.vardraw.getNext();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Main.drawCanvas.splits.get(0).getExonImageBuffer().setFont(Draw.defaultFont);
    }

    void drawMutations(int ylevel) {
        try {
            if (this.varnode != null && Main.drawCanvas.selectedSplit.viewLength < 1000000.0) {
                VarNode vardraw = this.varnode;
                while (vardraw != null && (double)vardraw.getPosition() < Main.drawCanvas.splits.get((int)0).end + 1.0) {
                    if (Main.drawCanvas.hideNode(vardraw)) {
                        vardraw = vardraw.getNext();
                        continue;
                    }
                    this.found = false;
                    this.baselevel = 0;
                    if (vardraw.vars == null) {
                        System.out.println("vardraw vars == null (drawMutations)" + vardraw.getPosition());
                        continue;
                    }
                    int j = 0;
                    while (j < vardraw.vars.size()) {
                        this.entry = vardraw.vars.get(j);
                        if (!Main.drawCanvas.hideNodeVar(vardraw, this.entry)) {
                            this.mutcount = 0;
                            int i = 0;
                            while (i < this.entry.getValue().size()) {
                                if (!Main.drawCanvas.hideVar(this.entry.getValue().get(i), this.entry.getKey().length() > 1)) {
                                    ++this.mutcount;
                                }
                                ++i;
                            }
                            if (this.mutcount != 0) {
                                ++this.baselevel;
                                this.base = this.entry.getKey();
                                this.mutScreenPos = vardraw.indel && this.entry.getKey().length() > 1 ? (int)(((double)(vardraw.getPosition() + 2) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel) : (int)(((double)(vardraw.getPosition() + 1) - Main.drawCanvas.splits.get((int)0).start) * Main.drawCanvas.splits.get((int)0).pixel);
                                if (this.prepixel != this.mutScreenPos) {
                                    this.prepixel = this.mutScreenPos;
                                    if (vardraw.coding) {
                                        if (this.base.length() > 1) {
                                            if (!this.varColor.equals(forwardExon)) {
                                                this.varColor = forwardExon;
                                            }
                                        } else if (!this.varColor.equals(reverseExon)) {
                                            this.varColor = reverseExon;
                                        }
                                        if (!Main.drawCanvas.splits.get(0).getExonImageBuffer().getColor().equals(this.varColor)) {
                                            Main.drawCanvas.splits.get(0).getExonImageBuffer().setColor(this.varColor);
                                        }
                                        Main.drawCanvas.splits.get(0).getExonImageBuffer().fillRect(this.mutScreenPos, 0, (int)Main.drawCanvas.splits.get((int)0).pixel + 1, this.getHeight());
                                    } else {
                                        if (!this.varColor.equals(this.gray)) {
                                            this.varColor = this.gray;
                                        }
                                        if (!Main.drawCanvas.splits.get(0).getExonImageBuffer().getColor().equals(this.varColor)) {
                                            Main.drawCanvas.splits.get(0).getExonImageBuffer().setColor(this.varColor);
                                        }
                                        Main.drawCanvas.splits.get(0).getExonImageBuffer().fillRect(this.mutScreenPos, 0, (int)Main.drawCanvas.splits.get((int)0).pixel + 1, this.getHeight());
                                        if (Main.drawCanvas.splits.get((int)0).viewLength < 200.0) {
                                            Main.drawCanvas.splits.get(0).getExonImageBuffer().setFont(seqFont);
                                            Main.drawCanvas.splits.get(0).getExonImageBuffer().setColor(Color.black);
                                            if (this.base.length() > 1) {
                                                Main.drawCanvas.splits.get(0).getExonImageBuffer().drawString(String.valueOf(this.mutcount) + " " + this.base, this.mutScreenPos, 27 * this.baselevel);
                                            } else {
                                                Main.drawCanvas.splits.get(0).getExonImageBuffer().drawString(String.valueOf(this.mutcount) + " " + Main.getBase.get(vardraw.getRefBase()) + "->" + this.base, this.mutScreenPos, 27 * this.baselevel);
                                            }
                                            Main.drawCanvas.splits.get(0).getExonImageBuffer().setFont(Draw.defaultFont);
                                        }
                                    }
                                    if (Main.drawCanvas.splits.get((int)0).viewLength < 200.0 && vardraw.getExons() != null) {
                                        Main.drawCanvas.splits.get(0).getExonImageBuffer().setFont(seqFont);
                                        Main.drawCanvas.splits.get(0).getExonImageBuffer().setColor(Color.black);
                                        i = 0;
                                        while (i < vardraw.getExons().size()) {
                                            if (vardraw.getExons().get(i).getTranscript().getGene().showIsoforms()) {
                                                Main.drawCanvas.splits.get(0).getExonImageBuffer().drawString(String.valueOf(this.mutcount) + " " + this.getChange(vardraw, this.base, vardraw.getExons().get(i)), this.mutScreenPos, vardraw.getExons().get((int)i).getTranscript().ypos + this.exonDrawY * this.baselevel);
                                            } else if (vardraw.getExons().get(i).getTranscript().equals(vardraw.getExons().get(i).getTranscript().getGene().getLongest())) {
                                                Main.drawCanvas.splits.get(0).getExonImageBuffer().drawString(String.valueOf(this.mutcount) + " " + this.getChange(vardraw, this.base, vardraw.getExons().get(i)), this.mutScreenPos, vardraw.getExons().get((int)i).getTranscript().ypos + this.exonDrawY * this.baselevel);
                                            }
                                            ++i;
                                        }
                                    }
                                    Main.drawCanvas.splits.get(0).getExonImageBuffer().setFont(Draw.defaultFont);
                                }
                            }
                        }
                        ++j;
                    }
                    if (vardraw == null) continue;
                    vardraw = vardraw.getNext();
                }
                vardraw = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Main.drawCanvas.splits.get(0).getExonImageBuffer().setFont(Draw.defaultFont);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getChange(VarNode node, String base, Transcript.Exon exon) {
        try {
            this.aminopos = 0;
            if (exon == null) {
                return "";
            }
            if (base.length() > 1) {
                this.aminopos = exon.getTranscript().getStrand() ? (exon.getFirstAmino() == 1 ? (node.getPosition() + 1 - exon.getTranscript().getCodingStart()) / 3 + 1 : (node.getPosition() + 1 - (exon.getStart() + exon.getStartPhase())) / 3 + exon.getFirstAmino()) : (exon.getFirstAmino() == 1 ? (exon.getTranscript().getCodingEnd() - (node.getPosition() + 1)) / 3 + 1 : (exon.getEnd() - exon.getStartPhase() - 1 - (node.getPosition() + 1)) / 3 + exon.getFirstAmino());
                this.baselength = base.substring(3).matches("\\d+") ? Integer.parseInt(base.substring(3)) : base.substring(3).length();
                if (node.getPosition() + 1 < exon.getTranscript().getCodingStart() || node.getPosition() + 1 > exon.getTranscript().getCodingEnd()) {
                    return String.valueOf(base) + " (UTR)";
                }
                if (node.getPosition() + 1 > exon.getEnd()) {
                    if (node.getPosition() + 2 - exon.getEnd() > 2) {
                        return "";
                    }
                    return "spl" + (node.getPosition() + 2 - exon.getEnd()) + "-" + base;
                }
                if (node.getPosition() + 1 < exon.getStart()) {
                    if (base.contains("ins")) {
                        return "spl" + (exon.getStart() - (node.getPosition() + 1)) + "-" + base;
                    }
                    if ((node.getPosition() + 1 + this.baselength - exon.getStart()) % 3 == 0) {
                        return "spl-" + base + "-if";
                    }
                    return "spl-" + base + "-fs";
                }
                if (base.contains("del") && node.getPosition() + 1 + this.baselength >= exon.getEnd()) {
                    if ((this.baselength - (node.getPosition() + 1 + this.baselength - exon.getEnd())) % 3 == 0) {
                        return "if-spl-" + base;
                    }
                    return "fs-spl-" + base;
                }
                if (this.baselength % 3 == 0) {
                    return "if-" + base;
                }
                return "fs-" + base;
            }
            if (node.getPosition() < exon.getTranscript().getCodingStart() || node.getPosition() >= exon.getTranscript().getCodingEnd()) {
                if (node.getPosition() >= exon.getEnd()) {
                    return "spl" + (node.getPosition() + 1 - exon.getEnd()) + " (UTR)";
                }
                if (node.getPosition() < exon.getStart()) {
                    return "spl" + (exon.getStart() - node.getPosition()) + " (UTR)";
                }
                return String.valueOf(base) + " (UTR)";
            }
            if (node.getPosition() >= exon.getEnd()) {
                return "spl" + (node.getPosition() + 1 - exon.getEnd());
            }
            if (node.getPosition() < exon.getStart()) {
                return "spl" + (exon.getStart() - node.getPosition());
            }
            if (exon.getTranscript().getStrand()) {
                if (exon.getFirstAmino() == 1) {
                    this.phase = (node.getPosition() - exon.getTranscript().getCodingStart()) % 3;
                    this.aminopos = (node.getPosition() - exon.getTranscript().getCodingStart()) / 3 + 1;
                } else {
                    this.phase = (node.getPosition() - (exon.getStart() + exon.getStartPhase())) % 3;
                    this.aminopos = (node.getPosition() - (exon.getStart() + exon.getStartPhase())) / 3 + exon.getFirstAmino();
                }
                if (this.phase < 0 || exon.getEnd() - node.getPosition() <= exon.getEndPhase()) {
                    if (exon.getEnd() - node.getPosition() <= exon.getEndPhase()) {
                        if (this.phase == 1) {
                            if (node.getCodon() == null) {
                                this.nextExonStart = exon.getTranscript().getExons()[exon.getNro()].getStart();
                                node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 2, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.nextExonStart, this.nextExonStart + 1, Main.referenceFile))));
                            }
                            this.array = node.getCodon().toCharArray();
                            this.array[this.phase] = base.charAt(0);
                            return MethodLibrary.getAminoAcid(new String(this.array));
                        }
                        if (exon.getEndPhase() == 2) {
                            if (node.getCodon() == null) {
                                this.nextExonStart = exon.getTranscript().getExons()[exon.getNro()].getStart();
                                node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 2, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.nextExonStart, this.nextExonStart + 1, Main.referenceFile))));
                            }
                            this.array = node.getCodon().toCharArray();
                            this.array[this.phase] = base.charAt(0);
                            return MethodLibrary.getAminoAcid(new String(this.array));
                        }
                        if (node.getCodon() == null) {
                            this.nextExonStart = exon.getTranscript().getExons()[exon.getNro()].getStart();
                            node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 1, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.nextExonStart, this.nextExonStart + 2, Main.referenceFile))));
                        }
                        this.array = node.getCodon().toCharArray();
                        this.array[this.phase] = base.charAt(0);
                        return MethodLibrary.getAminoAcid(new String(this.array));
                    }
                    if (this.phase == -2) {
                        this.phase = 1;
                        if (node.getCodon() == null) {
                            this.prevExonEnd = exon.getTranscript().getExons()[exon.getNro() - 2].getEnd();
                            node.setCodon(new String(this.getSeq(node.getChrom(), this.prevExonEnd - 1, this.prevExonEnd, Main.referenceFile).append(this.getSeq(node.getChrom(), exon.getStart(), exon.getStart() + 2, Main.referenceFile))));
                        }
                        this.array = node.getCodon().toCharArray();
                        this.array[this.phase] = base.charAt(0);
                        return MethodLibrary.getAminoAcid(new String(this.array));
                    }
                    this.phase = 2;
                    if (node.getPosition() == exon.getStart()) {
                        if (node.getCodon() == null) {
                            this.prevExonEnd = exon.getTranscript().getExons()[exon.getNro() - 2].getEnd();
                            node.setCodon(new String(this.getSeq(node.getChrom(), this.prevExonEnd - 2, this.prevExonEnd, Main.referenceFile).append(this.getSeq(node.getChrom(), exon.getStart(), exon.getStart() + 1, Main.referenceFile))));
                        }
                        this.array = node.getCodon().toCharArray();
                        this.array[this.phase] = base.charAt(0);
                        return MethodLibrary.getAminoAcid(new String(this.array));
                    }
                    if (node.getCodon() == null) {
                        this.prevExonEnd = exon.getTranscript().getExons()[exon.getNro() - 2].getEnd();
                        node.setCodon(new String(this.getSeq(node.getChrom(), this.prevExonEnd - 1, this.prevExonEnd, Main.referenceFile).append(this.getSeq(node.getChrom(), exon.getStart(), exon.getStart() + 2, Main.referenceFile))));
                    }
                    this.array = node.getCodon().toCharArray();
                    this.array[this.phase] = base.charAt(0);
                    return MethodLibrary.getAminoAcid(new String(this.array));
                }
                if (node.getCodon() == null) {
                    node.setCodon(new String(this.getSeq(exon.getTranscript().getChrom(), node.getPosition() - this.phase, node.getPosition() - this.phase + 3, Main.referenceFile)));
                }
                this.array = node.getCodon().toCharArray();
                this.array[this.phase] = base.charAt(0);
                return MethodLibrary.getAminoAcid(new String(this.array));
            }
            if (exon.getFirstAmino() == 1) {
                this.phase = (exon.getTranscript().getCodingEnd() - node.getPosition()) % 3;
                this.aminopos = (exon.getTranscript().getCodingEnd() - (node.getPosition() + 1)) / 3 + 1;
            } else {
                this.phase = (exon.getEnd() - exon.getStartPhase() - node.getPosition()) % 3;
                this.aminopos = (exon.getEnd() - exon.getStartPhase() - 1 - node.getPosition()) / 3 + exon.getFirstAmino();
            }
            if (this.phase > 0) {
                this.phase = 3 - this.phase;
            }
            if (this.phase < 0 || this.phase == 0 && exon.getEnd() - node.getPosition() < 3 || node.getPosition() - exon.getStart() < exon.getEndPhase()) {
                if (node.getPosition() - exon.getStart() < exon.getEndPhase()) {
                    if (exon.getEndPhase() == 1) {
                        if (node.getCodon() == null) {
                            this.prevExonEnd = exon.getTranscript().getExons()[exon.getTranscript().getExons().length - exon.getNro() - 1].getEnd();
                            node.setCodon(new String(this.getSeq(node.getChrom(), this.prevExonEnd - 2, this.prevExonEnd, Main.referenceFile).append(this.getSeq(node.getChrom(), exon.getStart(), exon.getStart() + 1, Main.referenceFile))));
                        }
                        this.array = node.getCodon().toCharArray();
                        this.array[this.phase] = base.charAt(0);
                        return MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
                    }
                    if (node.getCodon() == null) {
                        if (exon.getTranscript().getExons().length - exon.getNro() - 1 < 0) {
                            return "";
                        }
                        this.prevExonEnd = exon.getTranscript().getExons()[exon.getTranscript().getExons().length - exon.getNro() - 1].getEnd();
                        node.setCodon(new String(this.getSeq(node.getChrom(), this.prevExonEnd - 1, this.prevExonEnd, Main.referenceFile).append(this.getSeq(node.getChrom(), exon.getStart(), exon.getStart() + 2, Main.referenceFile))));
                    }
                    this.array = node.getCodon().toCharArray();
                    this.array[this.phase] = base.charAt(0);
                    return MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
                }
                if (this.phase == -1) {
                    this.phase = 1;
                    if (node.getCodon() == null) {
                        this.prevExonEnd = exon.getTranscript().getExons()[exon.getTranscript().getExons().length - exon.getNro() + 1].getStart();
                        node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 2, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.prevExonEnd, this.prevExonEnd + 1, Main.referenceFile))));
                    }
                    this.array = node.getCodon().toCharArray();
                    this.array[this.phase] = base.charAt(0);
                    return MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
                }
                if (exon.getEnd() - node.getPosition() == 2) {
                    if (node.getCodon() == null) {
                        this.prevExonEnd = exon.getTranscript().getExons()[exon.getTranscript().getExons().length - exon.getNro() + 1].getStart();
                        node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 2, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.prevExonEnd, this.prevExonEnd + 1, Main.referenceFile))));
                    }
                    this.array = node.getCodon().toCharArray();
                    this.array[this.phase] = base.charAt(0);
                    return MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
                }
                if (node.getCodon() == null) {
                    this.prevExonEnd = exon.getTranscript().getExons()[exon.getTranscript().getExons().length - exon.getNro() + 1].getStart();
                    node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 1, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.prevExonEnd, this.prevExonEnd + 2, Main.referenceFile))));
                }
                this.array = node.getCodon().toCharArray();
                this.array[this.phase] = base.charAt(0);
                return MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
            }
            if (node.getCodon() == null) {
                node.setCodon(new String(this.getSeq(exon.getTranscript().getChrom(), node.getPosition() - this.phase, node.getPosition() - this.phase + 3, Main.referenceFile)));
            }
            this.array = node.getCodon().toCharArray();
            this.array[this.phase] = base.charAt(0);
            return MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getAminoChange(VarNode node, String base, Transcript.Exon exon) {
        try {
            this.aminopos = 0;
            if (exon == null) {
                return "";
            }
            if (base.length() > 1) {
                this.aminopos = exon.getTranscript().getStrand() ? (exon.getFirstAmino() == 1 ? (node.getPosition() + 1 - exon.getTranscript().getCodingStart()) / 3 + 1 : (node.getPosition() + 1 - (exon.getStart() + exon.getStartPhase())) / 3 + exon.getFirstAmino()) : (exon.getFirstAmino() == 1 ? (exon.getTranscript().getCodingEnd() - (node.getPosition() + 1)) / 3 + 1 : (exon.getEnd() - exon.getStartPhase() - 1 - (node.getPosition() + 1)) / 3 + exon.getFirstAmino());
                this.baselength = base.substring(3).matches("\\d+") ? Integer.parseInt(base.substring(3)) : base.substring(3).length();
                if (node.getPosition() + 1 < exon.getTranscript().getCodingStart() || node.getPosition() + 1 > exon.getTranscript().getCodingEnd()) {
                    return String.valueOf(base) + " (UTR)";
                }
                if (node.getPosition() + 1 > exon.getEnd()) {
                    if (node.getPosition() + 2 - exon.getEnd() > 2) {
                        return "";
                    }
                    return "spl" + (node.getPosition() + 2 - exon.getEnd()) + "-" + base;
                }
                if (node.getPosition() + 1 < exon.getStart()) {
                    if (base.contains("ins")) {
                        return "spl" + (exon.getStart() - (node.getPosition() + 1)) + "-" + base;
                    }
                    if ((node.getPosition() + 1 + this.baselength - exon.getStart()) % 3 == 0) {
                        return "spl-" + base + "-if";
                    }
                    return "spl-" + base + "-fs";
                }
                if (base.contains("del") && node.getPosition() + 1 + this.baselength >= exon.getEnd()) {
                    if ((this.baselength - (node.getPosition() + 1 + this.baselength - exon.getEnd())) % 3 == 0) {
                        return String.valueOf(this.aminopos) + "-if-spl-" + base;
                    }
                    return String.valueOf(this.aminopos) + "-fs-spl-" + base;
                }
                if (this.baselength % 3 == 0) {
                    return String.valueOf(this.aminopos) + "-if-" + base;
                }
                return String.valueOf(this.aminopos) + "-fs-" + base;
            }
            if (node.getPosition() < exon.getTranscript().getCodingStart() || node.getPosition() >= exon.getTranscript().getCodingEnd()) {
                if (node.getPosition() >= exon.getEnd()) {
                    return "spl" + (node.getPosition() + 1 - exon.getEnd()) + " (UTR)";
                }
                if (node.getPosition() < exon.getStart()) {
                    return "spl" + (exon.getStart() - node.getPosition()) + " (UTR)";
                }
                return String.valueOf(base) + " (UTR)";
            }
            if (node.getPosition() >= exon.getEnd()) {
                return "spl" + (node.getPosition() + 1 - exon.getEnd());
            }
            if (node.getPosition() < exon.getStart()) {
                return "spl" + (exon.getStart() - node.getPosition());
            }
            if (exon.getTranscript().getStrand()) {
                if (exon.getFirstAmino() == 1) {
                    this.phase = (node.getPosition() - exon.getTranscript().getCodingStart()) % 3;
                    this.aminopos = (node.getPosition() - exon.getTranscript().getCodingStart()) / 3 + 1;
                } else {
                    this.phase = (node.getPosition() - (exon.getStart() + exon.getStartPhase())) % 3;
                    this.aminopos = (node.getPosition() - (exon.getStart() + exon.getStartPhase())) / 3 + exon.getFirstAmino();
                }
                if (this.phase < 0 || exon.getEnd() - node.getPosition() <= exon.getEndPhase()) {
                    if (exon.getNro() >= exon.getTranscript().getExons().length) {
                        return "";
                    }
                    if (exon.getEnd() - node.getPosition() <= exon.getEndPhase()) {
                        if (this.phase == 1) {
                            if (node.getCodon() == null || node.phase != 1) {
                                node.phase = 1;
                                this.nextExonStart = exon.getTranscript().getExons()[exon.getNro()].getStart();
                                node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 2, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.nextExonStart, this.nextExonStart + 1, Main.referenceFile))));
                            }
                            this.array = node.getCodon().toCharArray();
                            this.array[this.phase] = base.charAt(0);
                            return String.valueOf(MethodLibrary.getAminoAcid(node.getCodon())) + this.aminopos + MethodLibrary.getAminoAcid(new String(this.array));
                        }
                        if (exon.getEndPhase() == 2) {
                            if (node.getCodon() == null || node.phase != 2) {
                                node.phase = (short)2;
                                this.nextExonStart = exon.getTranscript().getExons()[exon.getNro()].getStart();
                                node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 2, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.nextExonStart, this.nextExonStart + 1, Main.referenceFile))));
                            }
                            this.array = node.getCodon().toCharArray();
                            this.array[this.phase] = base.charAt(0);
                            return String.valueOf(MethodLibrary.getAminoAcid(node.getCodon())) + this.aminopos + MethodLibrary.getAminoAcid(new String(this.array));
                        }
                        if (node.getCodon() == null || node.phase != 0) {
                            node.phase = 0;
                            this.nextExonStart = exon.getTranscript().getExons()[exon.getNro()].getStart();
                            node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 1, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.nextExonStart, this.nextExonStart + 2, Main.referenceFile))));
                        }
                        this.array = node.getCodon().toCharArray();
                        this.array[this.phase] = base.charAt(0);
                        return String.valueOf(MethodLibrary.getAminoAcid(node.getCodon())) + this.aminopos + MethodLibrary.getAminoAcid(new String(this.array));
                    }
                    if (this.phase == -2) {
                        this.phase = 1;
                        if (node.getCodon() == null || node.phase != -2) {
                            node.phase = (short)-2;
                            this.prevExonEnd = exon.getTranscript().getExons()[exon.getNro() - 2].getEnd();
                            node.setCodon(new String(this.getSeq(node.getChrom(), this.prevExonEnd - 1, this.prevExonEnd, Main.referenceFile).append(this.getSeq(node.getChrom(), exon.getStart(), exon.getStart() + 2, Main.referenceFile))));
                        }
                        this.array = node.getCodon().toCharArray();
                        this.array[this.phase] = base.charAt(0);
                        return String.valueOf(MethodLibrary.getAminoAcid(node.getCodon())) + (this.aminopos - 1) + MethodLibrary.getAminoAcid(new String(this.array));
                    }
                    this.phase = 2;
                    if (node.getPosition() == exon.getStart()) {
                        if (node.getCodon() == null || node.phase != 2) {
                            node.phase = (short)2;
                            this.prevExonEnd = exon.getTranscript().getExons()[exon.getNro() - 2].getEnd();
                            node.setCodon(new String(this.getSeq(node.getChrom(), this.prevExonEnd - 2, this.prevExonEnd, Main.referenceFile).append(this.getSeq(node.getChrom(), exon.getStart(), exon.getStart() + 1, Main.referenceFile))));
                        }
                        this.array = node.getCodon().toCharArray();
                        this.array[this.phase] = base.charAt(0);
                        return String.valueOf(MethodLibrary.getAminoAcid(node.getCodon())) + (this.aminopos - 1) + MethodLibrary.getAminoAcid(new String(this.array));
                    }
                    if (node.getCodon() == null || node.phase != 0) {
                        node.phase = 0;
                        this.prevExonEnd = exon.getTranscript().getExons()[exon.getNro() - 2].getEnd();
                        node.setCodon(new String(this.getSeq(node.getChrom(), this.prevExonEnd - 1, this.prevExonEnd, Main.referenceFile).append(this.getSeq(node.getChrom(), exon.getStart(), exon.getStart() + 2, Main.referenceFile))));
                    }
                    this.array = node.getCodon().toCharArray();
                    this.array[this.phase] = base.charAt(0);
                    return String.valueOf(MethodLibrary.getAminoAcid(node.getCodon())) + (this.aminopos - 1) + MethodLibrary.getAminoAcid(new String(this.array));
                }
                if (node.getCodon() == null || node.phase != this.phase) {
                    node.phase = (short)this.phase;
                    node.setCodon(new String(this.getSeq(exon.getTranscript().getChrom(), node.getPosition() - this.phase, node.getPosition() - this.phase + 3, Main.referenceFile)));
                }
                this.array = node.getCodon().toCharArray();
                this.array[this.phase] = base.charAt(0);
                return String.valueOf(MethodLibrary.getAminoAcid(node.getCodon())) + this.aminopos + MethodLibrary.getAminoAcid(new String(this.array));
            }
            if (exon.getFirstAmino() == 1) {
                this.phase = (exon.getTranscript().getCodingEnd() - node.getPosition()) % 3;
                this.aminopos = (exon.getTranscript().getCodingEnd() - (node.getPosition() + 1)) / 3 + 1;
            } else {
                this.phase = (exon.getEnd() - exon.getStartPhase() - node.getPosition()) % 3;
                this.aminopos = (exon.getEnd() - exon.getStartPhase() - 1 - node.getPosition()) / 3 + exon.getFirstAmino();
            }
            if (this.phase > 0) {
                this.phase = 3 - this.phase;
            }
            if (this.phase < 0 || this.phase == 0 && exon.getEnd() - node.getPosition() < 3 || node.getPosition() - exon.getStart() < exon.getEndPhase()) {
                if (node.getPosition() - exon.getStart() < exon.getEndPhase()) {
                    if (exon.getEndPhase() == 1) {
                        if (node.getCodon() == null || node.phase != 1) {
                            node.phase = 1;
                            if (exon.getTranscript().getExons().length - exon.getNro() - 1 < 0) {
                                return "";
                            }
                            this.prevExonEnd = exon.getTranscript().getExons()[exon.getTranscript().getExons().length - exon.getNro() - 1].getEnd();
                            node.setCodon(new String(this.getSeq(node.getChrom(), this.prevExonEnd - 2, this.prevExonEnd, Main.referenceFile).append(this.getSeq(node.getChrom(), exon.getStart(), exon.getStart() + 1, Main.referenceFile))));
                        }
                        this.array = node.getCodon().toCharArray();
                        this.array[this.phase] = base.charAt(0);
                        return String.valueOf(MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(node.getCodon()))) + this.aminopos + MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
                    }
                    if (node.getCodon() == null || node.phase != 2) {
                        if (exon.getTranscript().getExons().length - exon.getNro() - 1 < 0) {
                            return "";
                        }
                        node.phase = (short)2;
                        try {
                            this.prevExonEnd = exon.getTranscript().getExons()[exon.getTranscript().getExons().length - exon.getNro() - 1].getEnd();
                        }
                        catch (Exception e) {
                            System.out.println(exon.getTranscript().getGenename());
                            e.printStackTrace();
                        }
                        node.setCodon(new String(this.getSeq(node.getChrom(), this.prevExonEnd - 1, this.prevExonEnd, Main.referenceFile).append(this.getSeq(node.getChrom(), exon.getStart(), exon.getStart() + 2, Main.referenceFile))));
                    }
                    this.array = node.getCodon().toCharArray();
                    this.array[this.phase] = base.charAt(0);
                    return String.valueOf(MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(node.getCodon()))) + this.aminopos + MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
                }
                if (this.phase == -1) {
                    this.phase = 1;
                    if (node.getCodon() == null || node.phase != -1) {
                        node.phase = (short)-1;
                        this.prevExonEnd = exon.getTranscript().getExons()[exon.getTranscript().getExons().length - exon.getNro() + 1].getStart();
                        node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 2, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.prevExonEnd, this.prevExonEnd + 1, Main.referenceFile))));
                    }
                    this.array = node.getCodon().toCharArray();
                    this.array[this.phase] = base.charAt(0);
                    return String.valueOf(MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(node.getCodon()))) + (this.aminopos + 1) + MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
                }
                if (exon.getEnd() - node.getPosition() == 2) {
                    if (node.getCodon() == null || node.phase != -2) {
                        node.phase = (short)-2;
                        this.prevExonEnd = exon.getTranscript().getExons()[exon.getTranscript().getExons().length - exon.getNro() + 1].getStart();
                        node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 2, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.prevExonEnd, this.prevExonEnd + 1, Main.referenceFile))));
                    }
                    this.array = node.getCodon().toCharArray();
                    this.array[this.phase] = base.charAt(0);
                    return String.valueOf(MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(node.getCodon()))) + (this.aminopos + 1) + MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
                }
                if (node.getCodon() == null || node.phase != -1) {
                    node.phase = (short)-1;
                    this.prevExonEnd = exon.getTranscript().getExons()[exon.getTranscript().getExons().length - exon.getNro() + 1].getStart();
                    node.setCodon(new String(this.getSeq(node.getChrom(), exon.getEnd() - 1, exon.getEnd(), Main.referenceFile).append(this.getSeq(node.getChrom(), this.prevExonEnd, this.prevExonEnd + 2, Main.referenceFile))));
                }
                this.array = node.getCodon().toCharArray();
                this.array[this.phase] = base.charAt(0);
                return String.valueOf(MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(node.getCodon()))) + (this.aminopos + 1) + MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
            }
            if (node.getCodon() == null || node.phase != this.phase) {
                node.phase = (short)this.phase;
                node.setCodon(new String(this.getSeq(exon.getTranscript().getChrom(), node.getPosition() - this.phase, node.getPosition() - this.phase + 3, Main.referenceFile)));
            }
            this.array = node.getCodon().toCharArray();
            this.array[this.phase] = base.charAt(0);
            return String.valueOf(MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(node.getCodon()))) + this.aminopos + MethodLibrary.getAminoAcid(MethodLibrary.reverseComplement(new String(this.array)));
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
            return "";
        }
    }

    int maxWidth(String[] list) {
        int max = 0;
        int index = 0;
        int i = 0;
        while (i < list.length) {
            if (list[i].length() > max) {
                max = list[i].length();
                index = i;
            }
            ++i;
        }
        return index;
    }

    int getMousePos(int mousex) {
        return (int)(Main.drawCanvas.selectedSplit.start + (double)(mousex - Main.drawCanvas.selectedSplit.chromOffset) / Main.drawCanvas.selectedSplit.pixel);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        switch (event.getModifiers()) {
            case 16: {
                this.mouseX = event.getX();
                this.mouseY = event.getY();
                if (!this.seqDrag && (this.mouseY < Main.chromScroll.getViewport().getHeight() - this.cytoHeight || Main.drawCanvas.selectedSplit.viewLength > (double)Settings.readDrawDistance)) {
                    if (Main.drawCanvas.lineZoomer) {
                        if (Main.drawCanvas.selectedSplit.start > 1.0 || Main.drawCanvas.selectedSplit.end < (double)Main.drawCanvas.selectedSplit.chromEnd) {
                            Main.drawCanvas.gotoPos(Main.drawCanvas.selectedSplit.start - (double)(Main.drawCanvas.tempDrag - this.mouseX) / Main.drawCanvas.selectedSplit.pixel * 2.0, Main.drawCanvas.selectedSplit.end + (double)(Main.drawCanvas.tempDrag - this.mouseX) / Main.drawCanvas.selectedSplit.pixel * 2.0);
                        }
                        Main.drawCanvas.tempDrag = this.mouseX;
                        this.updateExons = true;
                        this.repaint();
                        Draw.updatevars = true;
                        Main.drawCanvas.repaint();
                        break;
                    }
                    this.zoomDrag = true;
                    this.repaint();
                    return;
                }
                this.seqDrag = true;
                this.repaint();
                return;
            }
            case 4: {
                if ((int)Main.drawCanvas.selectedSplit.start == 1 && (int)Main.drawCanvas.selectedSplit.end == Main.drawCanvas.selectedSplit.chromEnd) break;
                Main.drawCanvas.mouseDrag = true;
                Main.drawCanvas.moveX = event.getX();
                Main.drawCanvas.drag(Main.drawCanvas.moveX);
                break;
            }
            case 17: {
                if ((int)Main.drawCanvas.selectedSplit.start == 1 && (int)Main.drawCanvas.selectedSplit.end == Main.drawCanvas.selectedSplit.chromEnd) break;
                Main.drawCanvas.mouseDrag = true;
                Main.drawCanvas.moveX = event.getX();
                Main.drawCanvas.drag(Main.drawCanvas.moveX);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        if (this.mouseX / Main.drawCanvas.getDrawWidth() > -1 && this.mouseX / Main.drawCanvas.getDrawWidth() < Main.drawCanvas.splits.size() && Main.drawCanvas.selectedSplit != Main.drawCanvas.splits.get(this.mouseX / Main.drawCanvas.getDrawWidth())) {
            Main.drawCanvas.selectedSplit = Main.drawCanvas.splits.get(this.mouseX / Main.drawCanvas.getDrawWidth());
            if (Main.drawCanvas.selectedSplit == null) {
                Main.drawCanvas.selectedSplit = Main.drawCanvas.splits.get(0);
            }
        }
        if (event.getY() > Main.chromScroll.getViewport().getHeight() - 15 && Main.drawCanvas.selectedSplit.viewLength < (double)Settings.readDrawDistance) {
            if (this.getCursor().getType() != 2) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            }
        } else if (this.getCursor().getType() == 2 && this.getCursor().getType() != 0 && this.mouseY > this.cytoHeight) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.mouseRect.setBounds(event.getX() - Main.drawCanvas.selectedSplit.chromOffset, event.getY() - this.cytoHeight, 2, 2);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        switch (event.getModifiers()) {
            case 16: {
                if (this.clickedExon == null || this.foundcursor <= -1) break;
                if (this.foundcursor == 0) {
                    Main.drawCanvas.clearReads();
                    Main.drawCanvas.gotoPos(this.clickedExon.getStart() + 1, this.clickedExon.getEnd() + 1);
                } else if (this.foundcursor == 1) {
                    Main.drawCanvas.clearReads();
                    Main.drawCanvas.gotoPos(this.clickedExon.transcript.getStart() + 1, this.clickedExon.transcript.getEnd() + 1);
                } else if (this.foundcursor == 2) {
                    if (this.exonString[2].contains("ENS")) {
                        Main.gotoURL("http://ensembl.org/Multi/Search/Results?q=" + this.exonString[2].substring(this.exonString[2].indexOf("ENS")).split(" ")[0]);
                    } else {
                        Main.gotoURL("http://www.ncbi.nlm.nih.gov/gene/?term=" + this.exonString[2].split(":")[1].split(",")[0].split(" ")[0]);
                    }
                } else if (this.foundcursor == 3) {
                    if (this.exonString[3].contains("ENS")) {
                        Main.gotoURL("http://ensembl.org/Multi/Search/Results?q=" + this.exonString[3].substring(this.exonString[3].indexOf("ENS")).split(" ")[0]);
                    }
                } else if (this.foundcursor == 5) {
                    Main.gotoURL("http://www.genecards.org/cgi-bin/carddisp.pl?gene=" + this.exonString[1]);
                }
                this.updateExons = true;
                this.repaint();
                Draw.updateReads = true;
                Draw.updatevars = true;
                Main.drawCanvas.repaint();
                break;
            }
            case 4: {
                if (this.selectedExon != null && this.selectedExon.transcript.getGene().getTranscripts().size() > 1 && !this.selectedExon.transcript.getGene().showIsoforms()) {
                    this.selectedExon.transcript.getGene().setShowIsoforms(true);
                    this.updateExons = true;
                    this.repaint();
                    break;
                }
                if (this.selectedExon != null && this.selectedExon.transcript.getGene().getTranscripts().size() > 1 && this.selectedExon.transcript.getGene().showIsoforms()) {
                    this.selectedExon.transcript.getGene().setShowIsoforms(false);
                    this.updateExons = true;
                    this.repaint();
                    break;
                }
                String copy = String.valueOf(Main.drawCanvas.selectedSplit.chrom) + ":" + this.getPosition(this.mouseX - Main.drawCanvas.selectedSplit.chromOffset, Main.drawCanvas.selectedSplit);
                StringSelection stringSelection = new StringSelection(copy);
                Main.putMessage("Position " + copy + " copied to clipboard.");
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.pressY = event.getY();
        switch (event.getModifiers()) {
            case 16: {
                Main.drawCanvas.pressX = event.getX();
                if (this.selectedExon == null) break;
                this.clickedSplit = Main.drawCanvas.selectedSplit;
                this.clickedExon = this.selectedExon;
                this.repaint();
                break;
            }
            case 4: {
                Main.drawCanvas.pressX = event.getX();
                this.clickedExon = null;
                this.zoomDrag = false;
                this.updateExons = true;
                this.repaint();
            }
        }
        Main.drawCanvas.tempDrag = Main.drawCanvas.pressX;
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (this.seqDrag) {
            this.seqDrag = false;
            if (this.mouseX - Main.drawCanvas.pressX > 0) {
                String myString = new String(Arrays.copyOfRange(Main.drawCanvas.selectedSplit.getReference().getSeq(), this.getMousePos(Main.drawCanvas.pressX) - 1 - Main.drawCanvas.selectedSplit.getReference().getStartPos(), this.getMousePos(this.mouseX) - 1 - Main.drawCanvas.selectedSplit.getReference().getStartPos() + 1));
                StringSelection stringSelection = new StringSelection(myString);
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
                Main.putMessage("Sequence copied to clipboard.");
                this.timer = System.currentTimeMillis();
            }
            this.repaint();
        }
        Main.drawCanvas.lineZoomer = false;
        this.lineZoomer = false;
        if (Main.drawCanvas.mouseDrag) {
            Main.drawCanvas.mouseDrag = false;
        }
        if (this.zoomDrag) {
            if (this.mouseY <= this.cytoHeight) {
                if (this.mouseX - Main.drawCanvas.pressX > 0) {
                    Main.drawCanvas.gotoPos((double)(Main.drawCanvas.pressX - Main.drawCanvas.selectedSplit.chromOffset) / ((double)Main.drawCanvas.getDrawWidth() / (double)chromPos.get(String.valueOf(Main.refchrom) + Main.drawCanvas.selectedSplit.chrom).intValue()), (double)(this.mouseX - Main.drawCanvas.selectedSplit.chromOffset) / ((double)Main.drawCanvas.getDrawWidth() / (double)chromPos.get(String.valueOf(Main.refchrom) + Main.drawCanvas.selectedSplit.chrom).intValue()));
                }
            } else if (this.mouseX - Main.drawCanvas.pressX > 0) {
                Main.drawCanvas.gotoPos(Main.drawCanvas.selectedSplit.start + (double)(Main.drawCanvas.pressX - Main.drawCanvas.selectedSplit.chromOffset) / Main.drawCanvas.selectedSplit.pixel, Main.drawCanvas.selectedSplit.start + (double)(this.mouseX - Main.drawCanvas.selectedSplit.chromOffset) / Main.drawCanvas.selectedSplit.pixel);
            }
            this.zoomDrag = false;
            this.updateExons = true;
            Draw.updatevars = true;
        }
        if (Main.bedCanvas.bedTrack.size() > 0) {
            BedCanvas.bedFeatureFetcher fetch = Main.bedCanvas.new BedCanvas.bedFeatureFetcher();
            fetch.execute();
        }
        Main.bedCanvas.repaint();
        Main.drawCanvas.repaint();
        this.repaint();
    }

    String[] getGposColor(String gpos) {
        String[] color = new String[3];
        if (gpos.equals("gneg")) {
            color[0] = "255";
            color[1] = "255";
            color[2] = "255";
            return color;
        }
        if (gpos.equals("gpos50")) {
            color[0] = "200";
            color[1] = "200";
            color[2] = "200";
            return color;
        }
        if (gpos.equals("gpos100")) {
            color[0] = "0";
            color[1] = "0";
            color[2] = "0";
            return color;
        }
        if (gpos.equals("gpos75")) {
            color[0] = "130";
            color[1] = "130";
            color[2] = "130";
            return color;
        }
        if (gpos.equals("gpos66")) {
            color[0] = "160";
            color[1] = "160";
            color[2] = "160";
            return color;
        }
        if (gpos.equals("gpos33")) {
            color[0] = "210";
            color[1] = "210";
            color[2] = "210";
            return color;
        }
        if (gpos.equals("gpos25")) {
            color[0] = "200";
            color[1] = "200";
            color[2] = "200";
            return color;
        }
        if (gpos.equals("gvar")) {
            color[0] = "220";
            color[1] = "220";
            color[2] = "220";
            return color;
        }
        if (gpos.equals("acen")) {
            color[0] = "217";
            color[1] = "47";
            color[2] = "39";
            return color;
        }
        if (gpos.equals("stalk")) {
            color[0] = "100";
            color[1] = "127";
            color[2] = "164";
            return color;
        }
        if (gpos.equals("gpos")) {
            color[0] = "0";
            color[1] = "0";
            color[2] = "0";
            return color;
        }
        return color;
    }

    Polygon makeTriangle(int x, int y, int width, int height, boolean right) {
        int[] xs = new int[3];
        int[] ys = new int[3];
        if (right) {
            Point p1 = new Point(x, y);
            Point p2 = new Point(x, y + height);
            Point p3 = new Point(x + width, (int)((double)y + (double)height / 2.0));
            xs[0] = p1.x;
            xs[1] = p2.x;
            xs[2] = p3.x;
            ys[0] = p1.y;
            ys[1] = p2.y;
            ys[2] = p3.y;
        } else {
            Point p1 = new Point(x, y);
            Point p2 = new Point(x, y + height);
            Point p3 = new Point(x - width, (int)((double)y + (double)height / 2.0));
            xs[0] = p1.x;
            xs[1] = p2.x;
            xs[2] = p3.x;
            ys[0] = p1.y;
            ys[1] = p2.y;
            ys[2] = p3.y;
        }
        return new Polygon(xs, ys, xs.length);
    }

    public BufferedImage createBands(SplitClass split) {
        try {
            int height = this.cytoHeight - 4;
            this.tempImage = MethodLibrary.toCompatibleImage(new BufferedImage(Main.drawCanvas.getDrawWidth(), height, 1));
            this.cytoImageBuffer = (Graphics2D)this.tempImage.getGraphics();
            this.cytoImageBuffer.setRenderingHints(Draw.rh);
            if (bandVector.size() == 0) {
                this.cytoImageBuffer.setColor(backTransparent);
                this.cytoImageBuffer.fillRect(0, 0, Main.drawCanvas.getDrawWidth(), height);
                this.cytoImageBuffer.setStroke(Draw.strongStroke);
                this.cytoImageBuffer.setColor(Color.white);
                this.cytoImageBuffer.drawRoundRect(6, 8, Main.drawCanvas.getDrawWidth() - 14, 1, 20, 20);
                this.cytoImageBuffer.setColor(Color.lightGray);
                this.cytoImageBuffer.drawRoundRect(6, 2, Main.drawCanvas.getDrawWidth() - 14, height - 5, 20, 20);
                this.cytoImageBuffer.setColor(Color.gray);
                this.cytoImageBuffer.drawRoundRect(4, 0, Main.drawCanvas.getDrawWidth() - 10, height - 1, 20, 20);
            } else {
                ArrayList<String[]> chromBands = new ArrayList<String[]>();
                int first = 0;
                int second = 0;
                boolean firstdraw = true;
                int i = 0;
                while (i < bandVector.size()) {
                    if (!bandVector.get(i)[0].equals(split.chrom) && !bandVector.get(i)[0].equals("chr" + split.chrom)) {
                        if (!firstdraw) {
                            this.cytoImageBuffer.setColor(backTransparent);
                            this.cytoImageBuffer.fillRect(Main.drawCanvas.getDrawWidth() - 8, 0, 10, height);
                            break;
                        }
                    } else {
                        chromBands.add(bandVector.get(i));
                        this.bandwidth = (int)((double)(Integer.parseInt(bandVector.get(i)[2]) - Integer.parseInt(bandVector.get(i)[1])) * ((double)Main.drawCanvas.getDrawWidth() / (double)chromPos.get(String.valueOf(Main.refchrom) + split.chrom).intValue()));
                        if (firstdraw) {
                            this.cytoImageBuffer.setColor(backTransparent);
                            this.cytoImageBuffer.fillRect(0, 0, 6, height);
                            this.Xpos = (int)((double)Integer.parseInt(bandVector.get(i)[1]) * ((double)Main.drawCanvas.getDrawWidth() / (double)chromPos.get(split.chrom).intValue())) + 6;
                            firstdraw = false;
                        } else {
                            this.Xpos = (int)((double)Integer.parseInt(bandVector.get(i)[1]) * ((double)Main.drawCanvas.getDrawWidth() / (double)chromPos.get(split.chrom).intValue())) + 1;
                        }
                        this.color = bandVector.get(i)[4].contains(",") ? bandVector.get(i)[4].split(",") : this.getGposColor(bandVector.get(i)[4]);
                        if (this.color == null || this.color.length < 3) break;
                        if (bandVector.get(i)[3].contains("p11") && Integer.parseInt(this.color[0]) > 200 && Integer.parseInt(this.color[1]) < 100) {
                            first = i;
                        } else if (bandVector.get(i)[3].contains("q11") && Integer.parseInt(this.color[0]) > 200 && Integer.parseInt(this.color[1]) < 100) {
                            second = i;
                        } else {
                            this.cytoImageBuffer.setColor(new Color(Integer.parseInt(this.color[0]), Integer.parseInt(this.color[1]), Integer.parseInt(this.color[2])));
                            this.cytoImageBuffer.fillRect(this.Xpos, 0, this.bandwidth, height);
                            if (this.color[0].equals("0")) {
                                this.cytoImageBuffer.setColor(Color.white);
                            } else {
                                this.cytoImageBuffer.setColor(Color.black);
                            }
                        }
                    }
                    ++i;
                }
                if (chromBands.size() > 0) {
                    this.cytoImageBuffer.setColor(new Color(255, 255, 255, 120));
                    this.cytoImageBuffer.fillRect(0, 4, Main.drawCanvas.getDrawWidth(), height - 10);
                    this.cytoImageBuffer.setColor(new Color(0, 0, 0, 100));
                    this.cytoImageBuffer.setStroke(Draw.strongStroke);
                    this.cytoImageBuffer.drawRoundRect(4, 0, Main.drawCanvas.getDrawWidth() - 10, height - 1, 20, 20);
                    if (bandVector.size() > 0) {
                        this.bandwidth = (int)((double)(Integer.parseInt(bandVector.get(first)[2]) - Integer.parseInt(bandVector.get(first)[1])) * ((double)Main.drawCanvas.getDrawWidth() / (double)chromPos.get(String.valueOf(Main.refchrom) + split.chrom).intValue()));
                        this.Xpos = (int)((double)Integer.parseInt(bandVector.get(first)[1]) * ((double)Main.drawCanvas.getDrawWidth() / (double)chromPos.get(split.chrom).intValue())) + 1;
                        this.cytoImageBuffer.setColor(backTransparent);
                        this.cytoImageBuffer.fillRect(this.Xpos, 0, this.bandwidth + 2, height);
                        this.color = bandVector.get(first)[4].contains(",") ? bandVector.get(first)[4].split(",") : this.getGposColor(bandVector.get(first)[4]);
                        this.cytoImageBuffer.setColor(new Color(Integer.parseInt(this.color[0]), Integer.parseInt(this.color[1]), Integer.parseInt(this.color[2])));
                        this.cytoImageBuffer.fillPolygon(this.makeTriangle(this.Xpos, 0, this.bandwidth, height, true));
                        this.bandwidth = (int)((double)(Integer.parseInt(bandVector.get(second)[2]) - Integer.parseInt(bandVector.get(second)[1])) * ((double)Main.drawCanvas.getDrawWidth() / (double)chromPos.get(String.valueOf(Main.refchrom) + split.chrom).intValue()));
                        this.Xpos = (int)((double)Integer.parseInt(bandVector.get(second)[1]) * ((double)Main.drawCanvas.getDrawWidth() / (double)chromPos.get(split.chrom).intValue())) + 1;
                        this.cytoImageBuffer.setColor(backTransparent);
                        this.cytoImageBuffer.fillRect(this.Xpos, 0, this.bandwidth, height);
                        this.cytoImageBuffer.setColor(new Color(Integer.parseInt(this.color[0]), Integer.parseInt(this.color[1]), Integer.parseInt(this.color[2])));
                        this.cytoImageBuffer.fillPolygon(this.makeTriangle(this.Xpos + this.bandwidth, 0, this.bandwidth, height, false));
                    }
                    split.setChromBands(chromBands);
                } else {
                    this.cytoImageBuffer.setColor(backTransparent);
                    this.cytoImageBuffer.fillRect(0, 0, Main.drawCanvas.getDrawWidth(), height);
                    this.cytoImageBuffer.setStroke(Draw.strongStroke);
                    this.cytoImageBuffer.setColor(Color.white);
                    this.cytoImageBuffer.drawRoundRect(6, 8, Main.drawCanvas.getDrawWidth() - 14, 1, 20, 20);
                    this.cytoImageBuffer.setColor(Color.lightGray);
                    this.cytoImageBuffer.drawRoundRect(6, 2, Main.drawCanvas.getDrawWidth() - 14, height - 5, 20, 20);
                    this.cytoImageBuffer.setColor(Color.gray);
                    this.cytoImageBuffer.drawRoundRect(4, 0, Main.drawCanvas.getDrawWidth() - 10, height - 1, 20, 20);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.tempImage;
    }
}

