/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.AminoEntry;
import base.BasePlayer.BedTrack;
import base.BasePlayer.Control;
import base.BasePlayer.ControlFile;
import base.BasePlayer.Draw;
import base.BasePlayer.ErrorLog;
import base.BasePlayer.FileRead;
import base.BasePlayer.FisherExact;
import base.BasePlayer.Gene;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import base.BasePlayer.SampleNode;
import base.BasePlayer.VarNode;
import base.BasePlayer.VariantHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.io.FilenameUtils;

public class AminoTable
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    BufferedImage bufImage;
    ListSorter sorter = new ListSorter();
    int rowHeight = 15;
    int geneheaderlength = 0;
    Graphics2D buf;
    StringBuffer mutcountbuffer = new StringBuffer("");
    int width;
    int height;
    ArrayList<AminoEntry> aminoarray = new ArrayList();
    ArrayList<Gene> genearray = new ArrayList();
    int mouseY = 0;
    int mouseX = 0;
    int pressX = 0;
    int pressY = 0;
    int dragX = 0;
    FisherExact fe = new FisherExact(2000000);
    StringBuffer[] bedarray;
    final JScrollPane tablescroll;
    Gene hoverNode;
    Gene selectedNode;
    String[] posSplit;
    String[] hoverString;
    int samplecount = 0;
    Enumeration<String> e;
    String base;
    FontMetrics fm;
    ArrayList<Object[]> geneheader = new ArrayList();
    String[] header = new String[]{"Gene", "Mut. count", "Gene position", "Description"};
    int[][] headerlengths = new int[this.header.length][2];
    int variants = 0;
    private int genemutcount;
    VarNode hoverVar;
    private VarNode selectedVar;
    private int listAdd;
    private String[] selectedString;
    private int pointer;
    int headerHover = -1;
    boolean dot = false;
    Polygon sortTriangle = new Polygon();
    private int hoverSample = -1;
    private int mutcount;
    ArrayList<SampleNode> vararray = new ArrayList();
    SampleNode[] controlarray;
    private Color textcolor;
    private double casefreq;
    private int textWidth = 0;
    MethodLibrary.controlsorter ctrlsort = new MethodLibrary.controlsorter();
    private int cases;
    private int resizeColumn;
    private boolean mouseDrag = false;
    private int geneHeaderHover = -1;
    private int firstrow;
    private SampleNode hoverSampleNode;
    private String hoverBase;

    AminoTable(int width, int height, JScrollPane tablescroll) {
        this.width = width;
        this.height = height;
        this.tablescroll = tablescroll;
        Object[] obj = new Object[]{"Sample", 10, (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Mut. count", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Position", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Base change", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Effect in isoforms", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Genotype", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"Quality", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        obj = new Object[]{"rs-code", (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], (int)((double)(width - 10) / 7.0)};
        this.geneheader.add(obj);
        this.geneheaderlength = this.geneheader.size();
        this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(width, height, 2));
        this.buf = (Graphics2D)this.bufImage.getGraphics();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.fm = this.buf.getFontMetrics();
        this.headerlengths[0][0] = 0;
        this.headerlengths[0][1] = (int)(0.15 * (double)width);
        this.headerlengths[1][0] = this.headerlengths[0][1] + this.headerlengths[0][0];
        this.headerlengths[1][1] = (int)(0.15 * (double)width);
        this.headerlengths[2][0] = this.headerlengths[1][1] + this.headerlengths[1][0];
        this.headerlengths[2][1] = (int)(0.2 * (double)width);
        this.headerlengths[3][0] = this.headerlengths[2][1] + this.headerlengths[2][0];
        this.headerlengths[3][1] = (int)(0.5 * (double)width);
        this.addMouseWheelListener(this);
    }

    void resizeTable(int width) {
        this.headerlengths[0][0] = 0;
        this.headerlengths[0][1] = (int)((double)width / (double)this.headerlengths.length);
        int i = 1;
        while (i < this.headerlengths.length) {
            this.headerlengths[i][0] = this.headerlengths[i - 1][1] + this.headerlengths[i - 1][0];
            this.headerlengths[i][1] = (int)((double)width / (double)this.headerlengths.length);
            ++i;
        }
        this.geneheader.get((int)0)[2] = (width - 10) / this.geneheader.size();
        i = 1;
        while (i < this.geneheader.size()) {
            this.geneheader.get((int)i)[1] = (Integer)this.geneheader.get(i - 1)[1] + (Integer)this.geneheader.get(i - 1)[2];
            this.geneheader.get((int)i)[2] = (width - 10) / this.geneheader.size();
            ++i;
        }
        this.setPreferredSize(new Dimension(width, this.getHeight()));
        this.revalidate();
    }

    void resizeTable() {
        if (this.bufImage.getWidth() < this.headerlengths[this.headerlengths.length - 1][0] + this.headerlengths[this.headerlengths.length - 1][1]) {
            this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
            this.buf = (Graphics2D)this.bufImage.getGraphics();
            this.buf.setFont(Main.menuFont);
        }
    }

    void resizeTable(int column, int amount) {
        if (this.headerHover != -1) {
            if (this.headerlengths[column - 1][1] + amount > 20) {
                int[] nArray = this.headerlengths[column - 1];
                nArray[1] = nArray[1] + amount;
                int i = column;
                while (i < this.headerlengths.length) {
                    int[] nArray2 = this.headerlengths[i];
                    nArray2[0] = nArray2[0] + amount;
                    ++i;
                }
            }
            if (this.headerlengths[this.headerlengths.length - 1][0] + this.headerlengths[this.headerlengths.length - 1][1] > this.getWidth()) {
                if (this.bufImage.getWidth() < this.headerlengths[this.headerlengths.length - 1][0] + this.headerlengths[this.headerlengths.length - 1][1]) {
                    this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
                    this.buf = (Graphics2D)this.bufImage.getGraphics();
                    this.buf.setFont(Main.menuFont);
                }
                this.setPreferredSize(new Dimension(this.headerlengths[this.headerlengths.length - 1][0] + this.headerlengths[this.headerlengths.length - 1][1], this.getHeight()));
                this.revalidate();
            }
        } else {
            if ((Integer)this.geneheader.get(column - 1)[2] + amount > 20) {
                this.geneheader.get((int)(column - 1))[2] = (Integer)this.geneheader.get(column - 1)[2] + amount;
                int i = column;
                while (i < this.geneheader.size()) {
                    this.geneheader.get((int)i)[1] = (Integer)this.geneheader.get(i)[1] + amount;
                    ++i;
                }
            }
            if ((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] > this.getWidth()) {
                if (this.bufImage.getWidth() < (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2]) {
                    this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
                    this.buf = (Graphics2D)this.bufImage.getGraphics();
                    this.buf.setFont(Main.menuFont);
                }
                this.setPreferredSize(new Dimension((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2], this.getHeight()));
                this.revalidate();
            }
        }
        this.createPolygon();
        this.repaint();
    }

    void drawScreen(Graphics g) {
        if (!this.isEnabled()) {
            return;
        }
        this.buf.setColor(Color.black);
        this.buf.fillRect(0, 0, VariantHandler.tableScroll.getViewport().getWidth(), this.tablescroll.getViewport().getHeight());
        if (VariantHandler.writetofile.isSelected()) {
            this.buf.setColor(Color.white);
            if (FileRead.output != null && Main.drawCanvas.loading && Draw.variantcalculator) {
                this.buf.drawString("Writing results to " + FileRead.outputName, 10, 20);
            } else {
                this.buf.drawString("Press annotate to write results straight to file", 10, 20);
            }
            g.drawImage(this.bufImage, 0, this.tablescroll.getVerticalScrollBar().getValue(), null);
            return;
        }
        this.genemutcount = 0;
        this.hoverVar = null;
        this.hoverSample = -1;
        this.headerHover = -1;
        this.geneHeaderHover = -1;
        if (!this.mouseDrag) {
            this.resizeColumn = -1;
        }
        this.firstrow = this.tablescroll.getVerticalScrollBar().getValue() / this.rowHeight - this.samplecount - this.listAdd - this.aminoarray.size();
        if (this.firstrow < 0) {
            this.firstrow = 0;
        }
        int i = 0;
        while (i < this.genearray.size()) {
            this.dot = false;
            if ((i + 1 + this.samplecount + this.aminoarray.size() + this.listAdd) * this.rowHeight >= this.tablescroll.getVerticalScrollBar().getValue()) {
                if (i * this.rowHeight > this.tablescroll.getVerticalScrollBar().getValue() + this.tablescroll.getViewport().getHeight()) break;
                if (this.mouseY >= this.rowHeight * (i + this.genemutcount + 1) && this.mouseY < this.rowHeight * (i + this.genemutcount + 2)) {
                    this.hoverNode = this.genearray.get(i);
                }
                try {
                    this.buf.setColor(Color.darkGray);
                    this.buf.drawLine(4, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                    if (this.genearray.get(i).equals(this.hoverNode) || this.genearray.get(i).equals(this.selectedNode)) {
                        this.buf.setColor(Color.yellow);
                    } else {
                        this.buf.setColor(Color.white);
                    }
                    this.textWidth = (int)this.fm.getStringBounds(i + 1 + ".  " + this.genearray.get(i).getName(), this.buf).getWidth();
                    if (this.genearray.get((int)i).intergenic) {
                        if (this.genearray.get((int)i).varnodes.get(0).getTranscripts() == null) {
                            this.buf.drawString(String.valueOf(i + 1) + ".  " + this.genearray.get(i).getName(), 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        } else if (this.genearray.get((int)i).varnodes.get(0).getTranscripts().size() == 2) {
                            this.buf.drawString(String.valueOf(i + 1) + ".  " + this.genearray.get(i).getName() + " ... " + this.genearray.get((int)i).varnodes.get(0).getTranscripts().get(1).getGenename(), 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        } else if (this.genearray.get((int)i).varnodes.get(0).getPosition() < this.genearray.get(i).getStart()) {
                            this.buf.drawString(String.valueOf(i + 1) + ".  " + " ... " + this.genearray.get(i).getName(), 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        } else {
                            this.buf.drawString(String.valueOf(i + 1) + ".  " + this.genearray.get(i).getName() + " ... ", 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        }
                    } else {
                        this.buf.drawString(String.valueOf(i + 1) + ".  " + this.genearray.get(i).getName(), 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                    }
                    this.buf.setColor(Color.black);
                    this.buf.fillRect(this.headerlengths[1][0] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.headerlengths[1][1], this.rowHeight - 1);
                    if (this.genearray.get(i).equals(this.hoverNode) || this.genearray.get(i).equals(this.selectedNode)) {
                        this.buf.setColor(Color.yellow);
                    } else {
                        this.buf.setColor(Color.white);
                    }
                    this.mutcountbuffer = new StringBuffer(this.genearray.get((int)i).mutations + " (");
                    this.buf.drawString(this.mutcountbuffer.toString(), this.headerlengths[1][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                    if (this.genearray.get((int)i).nonsense > 0) {
                        this.buf.setColor(Color.red);
                        this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                        this.buf.drawString("" + this.genearray.get((int)i).nonsense, this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        this.mutcountbuffer.append(this.genearray.get((int)i).nonsense);
                        this.dot = true;
                    }
                    if (this.genearray.get((int)i).missense > 0) {
                        if (this.dot) {
                            this.buf.setColor(Color.white);
                            this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                            this.buf.drawString(", ", this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                            this.mutcountbuffer.append(", ");
                        }
                        this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                        this.buf.setColor(Color.yellow);
                        this.buf.drawString("" + this.genearray.get((int)i).missense, this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        this.mutcountbuffer.append(this.genearray.get((int)i).missense);
                        this.dot = true;
                    }
                    if (this.genearray.get((int)i).synonymous > 0) {
                        if (this.dot) {
                            this.buf.setColor(Color.white);
                            this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                            this.buf.drawString(", ", this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                            this.mutcountbuffer.append(", ");
                        }
                        this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                        this.buf.setColor(Color.green);
                        this.buf.drawString("" + this.genearray.get((int)i).synonymous, this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        this.mutcountbuffer.append(this.genearray.get((int)i).synonymous);
                        this.dot = true;
                    }
                    if (this.genearray.get((int)i).utr > 0) {
                        if (this.dot) {
                            this.buf.setColor(Color.white);
                            this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                            this.buf.drawString(", ", this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                            this.mutcountbuffer.append(", ");
                        }
                        this.buf.setColor(Color.lightGray);
                        this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                        this.buf.drawString("" + this.genearray.get((int)i).utr, this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        this.mutcountbuffer.append(this.genearray.get((int)i).utr);
                        this.dot = true;
                    }
                    if (this.genearray.get((int)i).intronic > 0) {
                        if (this.dot) {
                            this.buf.setColor(Color.white);
                            this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                            this.buf.drawString(", ", this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                            this.mutcountbuffer.append(", ");
                        }
                        this.buf.setColor(Color.gray);
                        this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                        this.buf.drawString("" + this.genearray.get((int)i).intronic, this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        this.mutcountbuffer.append(this.genearray.get((int)i).intronic);
                        this.dot = true;
                    }
                    if (this.genearray.get((int)i).intergenic) {
                        this.buf.setColor(Color.gray);
                        this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                        this.buf.drawString("" + this.genearray.get((int)i).mutations, this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        this.mutcountbuffer.append("" + this.genearray.get((int)i).mutations);
                    }
                    this.buf.setColor(Color.white);
                    this.textWidth = (int)this.fm.getStringBounds(this.mutcountbuffer.toString(), this.buf).getWidth();
                    this.buf.drawString(") ", this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                    this.buf.setColor(Color.gray);
                    this.textWidth = (int)this.fm.getStringBounds(String.valueOf(this.mutcountbuffer.toString()) + ") ", this.buf).getWidth();
                    if (this.genearray.get((int)i).samples.size() == 1) {
                        this.buf.drawString(" 1 sample", this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                    } else {
                        this.buf.drawString(" " + this.genearray.get((int)i).samples.size() + " samples", this.headerlengths[1][0] + 5 + this.textWidth, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                    }
                    this.buf.setColor(Color.black);
                    this.buf.fillRect(this.headerlengths[2][0] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                    if (this.genearray.get(i).equals(this.hoverNode) || this.genearray.get(i).equals(this.selectedNode)) {
                        this.buf.setColor(Color.yellow);
                    } else {
                        this.buf.setColor(Color.white);
                    }
                    if (this.genearray.get((int)i).intergenic) {
                        if (this.genearray.get((int)i).varnodes.get(0).getTranscripts() == null) {
                            this.buf.drawString(this.genearray.get(i).getChrom(), this.headerlengths[2][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        } else if (this.genearray.get((int)i).varnodes.get(0).getTranscripts().size() == 2) {
                            this.buf.drawString(String.valueOf(this.genearray.get(i).getChrom()) + ":" + MethodLibrary.formatNumber(this.genearray.get(i).getEnd()) + "-" + MethodLibrary.formatNumber(this.genearray.get((int)i).varnodes.get(0).getTranscripts().get(1).getStart()), this.headerlengths[2][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        } else if (this.genearray.get((int)i).varnodes.get(0).getPosition() < this.genearray.get(i).getStart()) {
                            this.buf.drawString(String.valueOf(this.genearray.get(i).getChrom()) + ":1-" + MethodLibrary.formatNumber(this.genearray.get((int)i).varnodes.get(0).getTranscripts().get(1).getStart()), this.headerlengths[2][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        } else {
                            this.buf.drawString(String.valueOf(this.genearray.get(i).getChrom()) + ":" + MethodLibrary.formatNumber(this.genearray.get(i).getEnd()) + "-end", this.headerlengths[2][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        }
                    } else {
                        this.buf.drawString(String.valueOf(this.genearray.get(i).getChrom()) + ":" + MethodLibrary.formatNumber(this.genearray.get(i).getStart()) + "-" + MethodLibrary.formatNumber(this.genearray.get(i).getEnd()), this.headerlengths[2][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                    }
                    this.buf.setColor(Color.black);
                    this.buf.fillRect(this.headerlengths[3][0] + 1, this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                    if (this.genearray.get(i).equals(this.hoverNode) || this.genearray.get(i).equals(this.selectedNode)) {
                        this.buf.setColor(Color.yellow);
                    } else {
                        this.buf.setColor(Color.white);
                    }
                    if (this.genearray.get((int)i).intergenic) {
                        if (this.genearray.get((int)i).varnodes.get(0).getTranscripts() == null) {
                            this.buf.drawString("-", this.headerlengths[3][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        } else if (this.genearray.get((int)i).varnodes.get(0).getTranscripts().size() == 2) {
                            this.buf.drawString(String.valueOf(this.genearray.get(i).getDescription()) + ";" + this.genearray.get((int)i).varnodes.get(0).getTranscripts().get(1).getGene().getDescription(), this.headerlengths[3][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                        }
                    } else {
                        this.buf.drawString(this.genearray.get(i).getDescription(), this.headerlengths[3][0] + 5, this.rowHeight * (i + 1 + this.genemutcount) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                    }
                    this.buf.setColor(Color.darkGray);
                    this.buf.drawLine(3, this.rowHeight + 3, 3, this.rowHeight * (i + this.genemutcount + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                    int r = 0;
                    while (r < this.headerlengths.length) {
                        this.buf.drawLine(this.headerlengths[r][0], this.rowHeight * (i + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.headerlengths[r][0], this.rowHeight * (i + this.genemutcount + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                        ++r;
                    }
                    if (this.selectedNode != null && this.selectedNode.equals(this.genearray.get(i))) {
                        this.hoverSample = -1;
                        this.genemutcount = this.aminoarray.size() + 1;
                        this.listAdd = 1;
                        this.drawGeneheader(this.rowHeight * (i + this.listAdd + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                        int s = 0;
                        while (s < this.aminoarray.size()) {
                            int v;
                            this.buf.setColor(Color.darkGray);
                            this.buf.drawLine(21, this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                            this.textcolor = MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("nonsense") ? Color.red : (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("missense") ? Color.yellow : (MethodLibrary.aminoEffect(this.aminoarray.get(s).getRow()[3]).equals("synonymous") ? Color.green : (this.aminoarray.get(s).getRow()[3].contains("UTR") ? Color.lightGray : Color.gray)));
                            this.buf.setColor(this.textcolor);
                            if (this.mouseY >= this.rowHeight * (i + s + this.listAdd + 2) && this.mouseY < this.rowHeight * (i + s + this.listAdd + 3)) {
                                this.hoverNode = null;
                                this.hoverVar = this.aminoarray.get(s).getNode();
                                this.hoverString = this.aminoarray.get(s).getRow();
                                this.buf.setColor(Color.white);
                                this.hoverSample = -1;
                                if (this.aminoarray.get(s).getRow()[1].equals("1")) {
                                    v = 0;
                                    while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                        if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                            this.hoverSample = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getSample().getIndex();
                                            this.hoverSampleNode = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0);
                                            this.hoverBase = this.aminoarray.get(s).getRow()[5];
                                            break;
                                        }
                                        ++v;
                                    }
                                }
                            }
                            if (!this.aminoarray.get(s).getRow()[1].equals("1")) {
                                this.buf.drawString("Multiple", 24, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                            } else {
                                v = 0;
                                while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                    if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                        this.buf.drawString(this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getSample().getName(), 24, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        break;
                                    }
                                    ++v;
                                }
                            }
                            if (this.hoverVar != null && this.hoverString.equals(this.aminoarray.get(s).getRow())) {
                                this.textcolor = Color.white;
                            }
                            int h = 1;
                            while (h < 4) {
                                this.buf.setColor(Color.black);
                                this.buf.fillRect((Integer)this.geneheader.get(h)[1] + 10, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(h)[2], this.rowHeight - 1);
                                this.buf.setColor(this.textcolor);
                                if (h == 3) {
                                    if (this.aminoarray.get(s).getRow()[5].length() == 1) {
                                        this.buf.drawString(String.valueOf(Main.getBase.get(this.aminoarray.get(s).getNode().getRefBase())) + ">" + this.aminoarray.get(s).getRow()[5], (Integer)this.geneheader.get(h)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    } else {
                                        this.buf.drawString(this.aminoarray.get(s).getRow()[5], (Integer)this.geneheader.get(h)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    }
                                    this.buf.setColor(Color.black);
                                    this.buf.fillRect((Integer)this.geneheader.get(4)[1] + 10, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(4)[2], this.rowHeight - 1);
                                    this.buf.setColor(this.textcolor);
                                    this.buf.drawString(this.aminoarray.get(s).getRow()[h], (Integer)this.geneheader.get(4)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                } else {
                                    this.buf.drawString(this.aminoarray.get(s).getRow()[h], (Integer)this.geneheader.get(h)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                }
                                ++h;
                            }
                            if (this.aminoarray.get(s).getRow()[1].equals("1")) {
                                this.buf.setColor(Color.black);
                                this.buf.fillRect((Integer)this.geneheader.get(5)[1] + 10, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(5)[2], this.rowHeight - 1);
                                this.buf.setColor(this.textcolor);
                                v = 0;
                                while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                    if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                        if (this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).isHomozygous()) {
                                            this.buf.drawString("Hom (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCoverage() + ")", (Integer)this.geneheader.get(5)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            if (Control.controlData.controlsOn) {
                                                this.cases = 2;
                                                this.casefreq = 2.0 / (double)(Main.varsamples * 2 - 2);
                                            }
                                        } else {
                                            this.buf.drawString("Het (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getCoverage() + ")", (Integer)this.geneheader.get(5)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            if (Control.controlData.controlsOn) {
                                                this.cases = 1;
                                                this.casefreq = 1.0 / (double)(Main.varsamples * 2 - 1);
                                            }
                                        }
                                        this.buf.setColor(Color.black);
                                        this.buf.fillRect((Integer)this.geneheader.get(6)[1] + 10, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                        this.buf.setColor(this.textcolor);
                                        this.buf.drawString("" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(0).getQuality(), (Integer)this.geneheader.get(6)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    }
                                    ++v;
                                }
                            } else {
                                this.buf.setColor(Color.black);
                                this.buf.fillRect((Integer)this.geneheader.get(5)[1] + 10, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                if (Control.controlData.controlsOn) {
                                    this.cases = 0;
                                    v = 0;
                                    while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                        if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                            int j = 0;
                                            while (j < this.aminoarray.get((int)s).getNode().vars.get(v).getValue().size()) {
                                                if (this.aminoarray.get((int)s).getNode().vars.get((int)v).getValue().get((int)j).alleles == null) {
                                                    this.cases = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(j).isHomozygous() ? (this.cases += 2) : ++this.cases;
                                                }
                                                ++j;
                                            }
                                        }
                                        ++v;
                                    }
                                    this.casefreq = (double)this.cases / (double)(Main.varsamples * 2 - this.cases);
                                }
                            }
                            this.buf.setColor(this.textcolor);
                            this.buf.drawString(this.aminoarray.get(s).getRow()[4], (Integer)this.geneheader.get(7)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                            if (Control.controlData.controlsOn) {
                                this.buf.setColor(this.textcolor);
                                v = 0;
                                while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                    if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.aminoarray.get(s).getRow()[5])) {
                                        int e;
                                        this.vararray = this.aminoarray.get((int)s).getNode().vars.get(v).getValue();
                                        this.controlarray = new SampleNode[Control.controlData.fileArray.size()];
                                        if (this.vararray.get((int)(this.vararray.size() - 1)).alleles != null) {
                                            e = this.vararray.size() - 1;
                                            while (e > 0) {
                                                if (this.vararray.get((int)e).alleles == null) break;
                                                this.controlarray[this.vararray.get((int)e).getControlSample().getIndex()] = this.vararray.get(e);
                                                --e;
                                            }
                                        }
                                        e = 0;
                                        while (e < this.controlarray.length) {
                                            if (Control.controlData.fileArray.get((int)e).controlOn) {
                                                if (this.controlarray[e] == null) {
                                                    this.buf.setColor(Color.black);
                                                    this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                    this.buf.setColor(this.textcolor);
                                                    this.buf.drawString("0", (Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    this.buf.setColor(Color.black);
                                                    this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                    this.buf.setColor(this.textcolor);
                                                    this.buf.drawString("-", (Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                } else {
                                                    this.buf.setColor(Color.black);
                                                    this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                    this.buf.setColor(this.textcolor);
                                                    this.buf.drawString("" + MethodLibrary.round((double)this.controlarray[e].alleles.intValue() / (double)this.controlarray[e].allelenumber.intValue(), 5), (Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                    this.buf.setColor(Color.black);
                                                    this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                    this.buf.setColor(this.textcolor);
                                                    this.buf.drawString(MethodLibrary.round(this.casefreq / ((double)this.controlarray[e].alleles.intValue() / (double)(this.controlarray[e].allelenumber - this.controlarray[e].alleles)), 2) + " (p=" + MethodLibrary.round(this.fe.getRightTailedP(this.cases, Main.varsamples * 2 - this.cases, this.controlarray[e].alleles, this.controlarray[e].allelenumber - this.controlarray[e].alleles), 2) + ")", (Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                }
                                            } else {
                                                this.buf.setColor(Color.black);
                                                this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                this.buf.setColor(Color.darkGray);
                                                this.buf.drawString("Apply controls", (Integer)this.geneheader.get(this.geneheaderlength + e * 2)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                this.buf.setColor(Color.black);
                                                this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                this.buf.setColor(Color.darkGray);
                                                this.buf.drawString("-", (Integer)this.geneheader.get(this.geneheaderlength + e * 2 + 1)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                            }
                                            ++e;
                                        }
                                    }
                                    ++v;
                                }
                            } else {
                                this.buf.setColor(Color.darkGray);
                                int e = this.geneheaderlength;
                                while (e < this.geneheader.size()) {
                                    if (this.geneheader.get(e)[0] instanceof ControlFile) {
                                        this.buf.drawString("Apply controls", (Integer)this.geneheader.get(e)[1] + 14, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                    }
                                    ++e;
                                }
                                this.buf.setColor(Color.lightGray);
                            }
                            this.vararray = null;
                            int a = 0;
                            while (a < this.aminoarray.size()) {
                                this.bedarray = MethodLibrary.makeTrackArray(this.aminoarray.get(a).getNode(), this.aminoarray.get(a).getRow()[5], true);
                                if (this.bedarray != null) {
                                    int b = 0;
                                    while (b < this.bedarray.length) {
                                        this.buf.setColor(Color.black);
                                        if (b == this.bedarray.length - 1) {
                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + b)[1] + 12, this.rowHeight * (i + a + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth() - (Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + b)[1], this.rowHeight - 1);
                                        } else {
                                            this.buf.fillRect((Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + b)[1] + 12, this.rowHeight * (i + a + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + b)[2], this.rowHeight - 1);
                                        }
                                        this.buf.setColor(Color.white);
                                        if (this.bedarray[b] != null) {
                                            this.buf.drawString(this.bedarray[b].toString(), (Integer)this.geneheader.get(this.geneheaderlength + Control.controlData.fileArray.size() * 2 + b)[1] + 14, this.rowHeight * (i + a + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                        }
                                        ++b;
                                    }
                                }
                                ++a;
                            }
                            this.buf.setColor(Color.darkGray);
                            int j = 0;
                            while (j < this.geneheader.size()) {
                                this.buf.drawLine((Integer)this.geneheader.get(j)[1] + 11, this.rowHeight * (i + s + this.listAdd + 2) - this.tablescroll.getVerticalScrollBar().getValue() + 4, (Integer)this.geneheader.get(j)[1] + 11, this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                                ++j;
                            }
                            if (this.selectedVar != null && this.selectedString.equals(this.aminoarray.get(s).getRow()) && Integer.parseInt(this.selectedString[1]) > 1) {
                                this.pointer = 0;
                                v = 0;
                                while (v < this.aminoarray.get((int)s).getNode().vars.size()) {
                                    if (this.aminoarray.get((int)s).getNode().vars.get(v).getKey().equals(this.selectedString[5])) {
                                        int l = 0;
                                        while (l < this.aminoarray.get((int)s).getNode().vars.get(v).getValue().size()) {
                                            if (this.aminoarray.get((int)s).getNode().vars.get((int)v).getValue().get((int)l).alleles != null) break;
                                            if (!this.aminoarray.get((int)s).getNode().vars.get((int)v).getValue().get((int)l).getSample().annotation) {
                                                if (this.mouseY > this.rowHeight * (i + s + this.pointer + 4) && this.mouseY < this.rowHeight * (i + s + this.pointer + 5)) {
                                                    this.textcolor = Color.white;
                                                    this.hoverVar = this.aminoarray.get(s).getNode();
                                                    this.hoverString = this.aminoarray.get(s).getRow();
                                                    this.hoverSample = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getSample().getIndex();
                                                    this.hoverSampleNode = this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l);
                                                    this.hoverBase = this.aminoarray.get(s).getRow()[5];
                                                } else {
                                                    this.textcolor = Color.lightGray;
                                                }
                                                this.buf.setColor(this.textcolor);
                                                this.buf.drawString(this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getSample().getName(), 30, this.rowHeight * (i + s + this.pointer + 4) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                ++this.pointer;
                                                this.buf.setColor(Color.black);
                                                this.buf.fillRect((Integer)this.geneheader.get(5)[1] + 10, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                this.buf.setColor(this.textcolor);
                                                if (this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).isHomozygous()) {
                                                    this.buf.drawString("Hom (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCoverage() + ")", (Integer)this.geneheader.get(5)[1] + 14, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                } else {
                                                    this.buf.drawString("Het (" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCalls() + "/" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getCoverage() + ")", (Integer)this.geneheader.get(5)[1] + 14, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                }
                                                this.buf.setColor(Color.black);
                                                this.buf.fillRect((Integer)this.geneheader.get(6)[1] + 10, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 4, this.getWidth(), this.rowHeight - 1);
                                                this.buf.setColor(this.textcolor);
                                                this.buf.drawString("" + this.aminoarray.get((int)s).getNode().vars.get(v).getValue().get(l).getQuality(), (Integer)this.geneheader.get(6)[1] + 14, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight);
                                                this.buf.setColor(Color.darkGray);
                                                int j2 = 5;
                                                while (j2 < 7) {
                                                    this.buf.drawLine((Integer)this.geneheader.get(j2)[1] + 11, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue(), (Integer)this.geneheader.get(j2)[1] + 11, this.rowHeight * (i + s + this.pointer + 3) - this.tablescroll.getVerticalScrollBar().getValue() + this.rowHeight + 2);
                                                    ++j2;
                                                }
                                            }
                                            ++l;
                                        }
                                    }
                                    ++v;
                                }
                                this.listAdd = Integer.parseInt(this.selectedString[1]) + 1;
                                this.genemutcount = this.aminoarray.size() + this.listAdd;
                                this.buf.setColor(Color.darkGray);
                                this.buf.drawLine(21, this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (i + s + this.listAdd + 3) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
                            }
                            ++s;
                        }
                    }
                }
                catch (Exception e) {
                    ErrorLog.addError(e.getStackTrace());
                    e.printStackTrace();
                }
            }
            ++i;
        }
        this.buf.setColor(Color.darkGray);
        this.buf.drawLine(4, this.rowHeight * (this.genearray.size() + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3, this.getWidth(), this.rowHeight * (this.genearray.size() + this.genemutcount + 1) - this.tablescroll.getVerticalScrollBar().getValue() + 3);
        this.drawHeader();
        if (this.headerHover == -1 && this.geneHeaderHover == -1) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (this.resizeColumn == -1) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(11));
        }
        g.drawImage(this.bufImage, 0, this.tablescroll.getVerticalScrollBar().getValue(), null);
    }

    void addRowGeneheader(Object column) {
        Object[] obj = new Object[3];
        if (Main.bedCanvas.bedTrack.size() == 0 || column instanceof BedTrack) {
            obj[0] = column;
            obj[1] = (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2];
            obj[2] = 100;
            this.geneheader.add(obj);
        }
        if ((Integer)obj[1] + (Integer)obj[2] > this.getWidth()) {
            if (this.bufImage.getWidth() < (Integer)obj[1] + (Integer)obj[2]) {
                this.bufImage = MethodLibrary.toCompatibleImage(new BufferedImage(this.width * 2, this.height, 2));
                this.buf = (Graphics2D)this.bufImage.getGraphics();
            }
            this.setPreferredSize(new Dimension((Integer)obj[1] + (Integer)obj[2], this.getHeight()));
            this.revalidate();
        }
    }

    void drawHeader() {
        int i = 0;
        while (i < this.header.length) {
            this.buf.setColor(Color.darkGray);
            this.buf.fillRect(this.headerlengths[i][0], 0, this.headerlengths[i][1] + 1, this.rowHeight);
            if (this.mouseY - this.tablescroll.getVerticalScrollBar().getValue() <= this.rowHeight) {
                if (this.mouseX >= this.headerlengths[i][0] && this.mouseX <= this.headerlengths[i][0] + this.headerlengths[i][1]) {
                    this.headerHover = i;
                    this.buf.setColor(Color.yellow);
                } else if (this.mouseX >= this.headerlengths[this.headerlengths.length - 1][0] + this.headerlengths[this.headerlengths.length - 1][1]) {
                    this.headerHover = this.headerlengths.length;
                    this.buf.setColor(Color.white);
                } else {
                    this.buf.setColor(Color.white);
                }
            } else {
                this.buf.setColor(Color.white);
            }
            if (!this.mouseDrag && this.headerHover > -1 && i > 0 && i < this.header.length && this.mouseX > this.headerlengths[i][0] - 5 && this.mouseX < this.headerlengths[i][0] + 5) {
                this.resizeColumn = i;
            }
            this.buf.drawString(this.header[i], this.headerlengths[i][0] + 4, this.rowHeight - 2);
            this.buf.setColor(Color.black);
            this.buf.drawLine(this.headerlengths[i][0], 0, this.headerlengths[i][0], this.rowHeight);
            if (this.sorter.index > -1) {
                if (this.sorter.ascending) {
                    this.buf.setColor(Color.white);
                    this.buf.fillPolygon(this.sortTriangle);
                } else {
                    this.buf.setColor(Color.white);
                    this.buf.fillPolygon(this.sortTriangle);
                }
            }
            ++i;
        }
        this.buf.setColor(Color.darkGray);
        this.buf.fillRect(this.headerlengths[this.header.length - 1][0] + this.headerlengths[this.header.length - 1][1] + 2, 0, this.width, this.rowHeight);
        this.buf.setColor(Color.black);
        this.buf.drawLine(this.headerlengths[this.header.length - 1][0] + this.headerlengths[this.header.length - 1][1] + 1, 0, this.headerlengths[this.header.length - 1][0] + this.headerlengths[this.header.length - 1][1] + 1, this.rowHeight);
        if (!this.mouseDrag && this.headerHover > -1 && this.resizeColumn == -1 && this.mouseX > this.headerlengths[this.header.length - 1][0] + this.headerlengths[this.header.length - 1][1] - 5 && this.mouseX < this.headerlengths[this.header.length - 1][0] + this.headerlengths[this.header.length - 1][1] + 5) {
            this.resizeColumn = this.header.length;
        }
    }

    void drawGeneheader(int y) {
        int i = 0;
        while (i < this.geneheader.size()) {
            this.buf.setColor(Color.darkGray);
            this.buf.fillRect((Integer)this.geneheader.get(i)[1] + 10, y, (Integer)this.geneheader.get(i)[2], this.rowHeight);
            if (this.mouseY - this.tablescroll.getVerticalScrollBar().getValue() <= y + this.rowHeight && this.mouseY - this.tablescroll.getVerticalScrollBar().getValue() >= y) {
                if (this.mouseX >= (Integer)this.geneheader.get(i)[1] + 10 && this.mouseX <= (Integer)this.geneheader.get(i)[1] + (Integer)this.geneheader.get(i)[2] + 10) {
                    this.geneHeaderHover = i;
                    this.buf.setColor(Color.yellow);
                } else if (this.mouseX >= (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 10) {
                    this.geneHeaderHover = this.geneheader.size();
                    this.buf.setColor(Color.white);
                } else {
                    this.buf.setColor(Color.white);
                }
            } else {
                this.buf.setColor(Color.white);
            }
            if (!this.mouseDrag && this.geneHeaderHover > -1 && i > 0 && i < this.geneheader.size() && this.mouseX > (Integer)this.geneheader.get(i)[1] + 5 && this.mouseX < (Integer)this.geneheader.get(i)[1] + 15 && this.resizeColumn != i) {
                this.resizeColumn = i;
            }
            if (this.geneheader.get(i)[0] instanceof String) {
                this.buf.drawString((String)this.geneheader.get(i)[0], (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
            } else if (this.geneheader.get(i)[0] instanceof ControlFile) {
                ControlFile ctrlfile = (ControlFile)this.geneheader.get(i)[0];
                this.buf.drawString("AF: " + ctrlfile.getName(), (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
                ctrlfile = null;
            } else {
                BedTrack track = (BedTrack)this.geneheader.get(i)[0];
                if (track.file != null) {
                    this.buf.drawString(track.file.getName(), (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
                } else {
                    this.buf.drawString(FilenameUtils.getName(track.url.getFile()), (Integer)this.geneheader.get(i)[1] + 14, y + this.rowHeight - 3);
                }
                Object var3_3 = null;
            }
            this.buf.setColor(Color.black);
            this.buf.drawLine((Integer)this.geneheader.get(i)[1] + 10, y, (Integer)this.geneheader.get(i)[1] + 10, y + this.rowHeight);
            ++i;
        }
        if (!this.mouseDrag && this.geneHeaderHover > -1 && this.resizeColumn == -1 && this.mouseX > (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] - 5 && this.mouseX < (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 15) {
            this.resizeColumn = this.geneheader.size();
        }
        this.buf.setColor(Color.darkGray);
        this.buf.fillRect((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 11, y, this.width, this.rowHeight);
        this.buf.setColor(Color.black);
        this.buf.drawLine((Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 10, y, (Integer)this.geneheader.get(this.geneheader.size() - 1)[1] + (Integer)this.geneheader.get(this.geneheader.size() - 1)[2] + 10, y + this.rowHeight);
    }

    void addEntry(Gene entry) {
        this.genearray.add(entry);
    }

    void clear() {
        this.genearray.clear();
        this.aminoarray.clear();
        this.controlarray = null;
        this.hoverNode = null;
        this.selectedNode = null;
        this.hoverVar = null;
        this.selectedVar = null;
    }

    int getTableSize() {
        if (this.genearray == null) {
            return 0;
        }
        return this.genearray.size();
    }

    @Override
    public void paint(Graphics g) {
        try {
            this.drawScreen(g);
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        switch (event.getModifiers()) {
            case 16: {
                if (!this.isEnabled() || this.headerHover != -1) break;
                if (event.getClickCount() == 2) {
                    if (Draw.variantcalculator) {
                        return;
                    }
                    FileRead.novars = true;
                    if (this.hoverSample > -1) {
                        Main.drawCanvas.drawVariables.visiblestart = (short)this.hoverSample;
                        Main.drawCanvas.drawVariables.visiblesamples = 1;
                        Main.drawCanvas.resizeCanvas(Main.drawScroll.getViewport().getWidth(), (int)((double)Main.samples * Main.drawCanvas.drawVariables.sampleHeight));
                        Draw.setScrollbar((int)((double)this.hoverSample * Main.drawCanvas.drawVariables.sampleHeight));
                    } else {
                        Main.drawCanvas.drawVariables.visiblestart = 0;
                        Main.drawCanvas.drawVariables.visiblesamples = (short)Main.samples;
                        Main.drawCanvas.resizeCanvas(Main.drawScroll.getViewport().getWidth(), (int)((double)Main.samples * Main.drawCanvas.drawVariables.sampleHeight));
                        Draw.setScrollbar(0);
                    }
                    if (this.hoverVar != null) {
                        FileRead.search = true;
                        VarNode searchHead = this.hoverVar;
                        while (searchHead.getPrev() != null) {
                            if (searchHead.getPrev().getChrom() == null || !searchHead.getPrev().getChrom().equals(this.hoverVar.getChrom())) {
                                if (searchHead.getPrev().getNext() == null) {
                                    searchHead.getPrev().putNext(searchHead);
                                }
                                FileRead.head = searchHead.getPrev();
                                break;
                            }
                            searchHead = searchHead.getPrev();
                        }
                        searchHead = null;
                        Main.drawCanvas.current = this.hoverVar;
                        if (this.hoverVar.getExons() != null) {
                            Main.drawCanvas.gotoPos(this.hoverVar.getChrom(), this.hoverVar.getPosition() + 1 - 50, this.hoverVar.getPosition() + 1 + 50);
                        } else if (this.hoverVar.getTranscripts().size() > 0) {
                            Main.drawCanvas.gotoPos(this.hoverVar.getChrom(), this.hoverVar.getPosition() + 1 - 50, this.hoverVar.getPosition() + 1 + 50);
                        }
                    } else if (this.hoverNode != null) {
                        FileRead.search = true;
                        if (this.hoverNode.varnodes.get(0).getTranscripts() != null && this.hoverNode.varnodes.get(0).getTranscripts().size() == 2) {
                            Main.drawCanvas.gotoPos(this.hoverNode.getChrom(), this.hoverNode.getEnd(), this.hoverNode.varnodes.get(0).getTranscripts().get(1).getGene().getStart());
                        } else {
                            VarNode searchHead = this.hoverNode.varnodes.get(0);
                            while (searchHead.getPrev() != null) {
                                if (searchHead.getPrev().getChrom() == null || !searchHead.getPrev().getChrom().equals(searchHead.getChrom())) {
                                    FileRead.head = searchHead.getPrev();
                                    break;
                                }
                                searchHead = searchHead.getPrev();
                            }
                            searchHead = null;
                            Main.drawCanvas.current = this.hoverNode.varnodes.get(0);
                            Main.drawCanvas.gotoPos(this.hoverNode.getChrom(), this.hoverNode.getStart(), this.hoverNode.getEnd());
                        }
                    }
                    Main.chromDraw.updateExons = true;
                    Main.chromDraw.repaint();
                    break;
                }
                if (event.getClickCount() != 1) break;
                if (!(this.hoverVar == null || this.selectedVar != null && this.selectedVar.equals(this.hoverVar))) {
                    this.selectedVar = this.hoverVar;
                    this.selectedString = this.hoverString;
                    if (this.selectedVar.isRscode() != null) {
                        this.hoverString[4] = this.selectedVar.rscode;
                    }
                    this.repaint();
                    this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount + Integer.parseInt(this.selectedString[1])) * this.rowHeight));
                    this.revalidate();
                    break;
                }
                if (this.hoverVar != null && this.selectedVar.equals(this.hoverVar)) {
                    if (this.hoverSample == -1) {
                        this.selectedVar = null;
                        this.repaint();
                        this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount) * this.rowHeight));
                        this.revalidate();
                        break;
                    }
                    if (this.hoverSampleNode == null) break;
                    MethodLibrary.showVariantMenu(this, this.hoverVar, this.hoverSampleNode, this.mouseX + Main.defaultFontSize * 2, this.mouseY, this.hoverBase);
                    break;
                }
                if (this.hoverVar != null && this.selectedNode != null && this.hoverNode.equals(this.selectedNode)) {
                    this.selectedString = this.hoverString;
                    this.samplecount = 0;
                    this.repaint();
                    break;
                }
                if (this.hoverSample != -1 || this.hoverNode == null) break;
                if (this.selectedNode != null && this.selectedNode.equals(this.hoverNode)) {
                    this.selectedString = null;
                    this.selectedNode = null;
                    this.hoverVar = null;
                    this.selectedVar = null;
                    this.aminoarray.clear();
                    this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2) * this.rowHeight));
                    this.revalidate();
                    this.repaint();
                    break;
                }
                this.selectedNode = this.hoverNode;
                this.selectedString = this.hoverString;
                this.samplecount = this.selectedNode.varnodes.size();
                if (VariantHandler.tabs.getSelectedIndex() == 0) {
                    this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount) * this.rowHeight));
                    this.revalidate();
                    this.getAminos(this.selectedNode);
                    this.repaint();
                    break;
                }
                this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2 + this.samplecount) * this.rowHeight));
                this.revalidate();
                this.getAminos(this.selectedNode);
                this.repaint();
                break;
            }
            case 4: {
                this.selectedString = null;
                this.selectedNode = null;
                this.hoverVar = null;
                this.selectedVar = null;
                this.aminoarray.clear();
                this.setPreferredSize(new Dimension(this.getWidth(), (this.getTableSize() + 2) * this.rowHeight));
                this.revalidate();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    void createPolygon() {
        if (this.sorter.index > this.headerlengths.length - 1) {
            return;
        }
        if (this.sorter.ascending) {
            int[] x = new int[]{this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 15, this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 10, this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 5};
            int[] y = new int[]{12, 4, 12};
            int n = 3;
            this.sortTriangle = new Polygon(x, y, n);
        } else {
            int[] x = new int[]{this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 15, this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 10, this.headerlengths[this.sorter.index][0] + this.headerlengths[this.sorter.index][1] - 5};
            int[] y = new int[]{4, 12, 4};
            int n = 3;
            this.sortTriangle = new Polygon(x, y, n);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        switch (event.getModifiers()) {
            case 16: {
                if (!this.isEnabled()) break;
                this.dragX = event.getX();
                if (this.headerHover > -1) {
                    if (this.resizeColumn == -1) {
                        this.sorter.ascending = !this.sorter.ascending;
                        this.sorter.index = this.headerHover;
                        Collections.sort(this.genearray, this.sorter);
                        this.createPolygon();
                    }
                    this.repaint();
                }
                if (this.hoverNode == null && this.hoverVar == null) break;
                Main.chromDraw.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.mouseDrag = false;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.mouseDrag = true;
        if (this.resizeColumn > 0) {
            this.resizeTable(this.resizeColumn, event.getX() - this.dragX);
            this.dragX = event.getX();
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.mouseY = event.getY();
        this.mouseX = event.getX();
        this.repaint();
    }

    void getAminos(Gene gene) {
        try {
            this.aminoarray.clear();
            VarNode varnode = null;
            int t = 0;
            while (t < gene.varnodes.size()) {
                Map.Entry<String, ArrayList<SampleNode>> entry;
                int v;
                varnode = gene.varnodes.get(t);
                if (gene.intergenic) {
                    v = 0;
                    while (v < varnode.vars.size()) {
                        entry = varnode.vars.get(v);
                        this.mutcount = 0;
                        int m = 0;
                        while (m < entry.getValue().size()) {
                            if (entry.getValue().get((int)m).alleles != null) break;
                            if (entry.getValue().get((int)m).getSample().annotation) {
                                entry.getValue().remove(m);
                                --m;
                            } else if (!Main.drawCanvas.hideVar(entry.getValue().get(m), entry.getKey().length() > 1) && !entry.getValue().get((int)m).getSample().annotation) {
                                if (!(VariantHandler.none.isSelected() || entry.getValue().get((int)m).inheritance || entry.getValue().get(m).getSample().equals(Main.drawCanvas.selectedSample))) {
                                    entry.getValue().remove(m);
                                    --m;
                                } else if (VariantHandler.onlyselected.isSelected() && !entry.getValue().get(m).getSample().equals(Main.drawCanvas.selectedSample)) {
                                    entry.getValue().remove(m);
                                    --m;
                                } else {
                                    ++this.mutcount;
                                }
                            } else {
                                entry.getValue().remove(m);
                                --m;
                            }
                            ++m;
                        }
                        if (this.mutcount != 0) {
                            this.base = entry.getKey();
                            String[] addrow = new String[]{varnode.getTranscripts() == null ? gene.getName() : (varnode.getTranscripts().size() == 2 ? String.valueOf(gene.getName()) + " ... " + varnode.getTranscripts().get(1).getGenename() : (varnode.getPosition() < gene.getStart() ? "... " + varnode.getTranscripts().get(1).getGenename() : String.valueOf(gene.getName()) + " ...")), "" + this.mutcount, String.valueOf(gene.getChrom()) + ":" + MethodLibrary.formatNumber(varnode.getPosition() + 1), "Intergenic", varnode.isRscode() != null ? varnode.rscode : "N/A", this.base, "Intergenic", "Intergenic", "Intergenic"};
                            AminoEntry aminoentry = new AminoEntry(addrow, varnode);
                            this.aminoarray.add(aminoentry);
                        }
                        ++v;
                    }
                } else if (varnode.getExons() != null) {
                    if (varnode.coding || VariantHandler.utr.isSelected()) {
                        v = 0;
                        while (v < varnode.vars.size()) {
                            entry = varnode.vars.get(v);
                            this.mutcount = 0;
                            int m = 0;
                            while (m < entry.getValue().size()) {
                                if (entry.getValue().get((int)m).alleles == null && !entry.getValue().get((int)m).getSample().annotation) {
                                    if (!VariantHandler.none.isSelected() && !entry.getValue().get((int)m).inheritance) {
                                        entry.getValue().remove(m);
                                        --m;
                                    } else if (!Main.drawCanvas.hideVar(entry.getValue().get(m), entry.getKey().length() > 1)) {
                                        if (VariantHandler.onlyselected.isSelected() && !entry.getValue().get(m).getSample().equals(Main.drawCanvas.selectedSample)) {
                                            entry.getValue().remove(m);
                                            --m;
                                        } else {
                                            ++this.mutcount;
                                        }
                                    } else {
                                        entry.getValue().remove(m);
                                        --m;
                                    }
                                }
                                ++m;
                            }
                            if (this.mutcount != 0) {
                                this.base = entry.getKey();
                                String[] addrow = new String[9];
                                StringBuffer aminos = new StringBuffer("");
                                StringBuffer transcripts = new StringBuffer("");
                                StringBuffer exons = new StringBuffer("");
                                StringBuffer biotypes = new StringBuffer("");
                                addrow[0] = gene.getName();
                                addrow[1] = "" + this.mutcount;
                                addrow[2] = String.valueOf(gene.getChrom()) + ":" + MethodLibrary.formatNumber(varnode.getPosition() + 1);
                                int exon = 0;
                                while (exon < varnode.getExons().size()) {
                                    String aminochange;
                                    if (varnode.getExons().get(exon).getTranscript().getGene().equals(gene) && (!(aminochange = Main.chromDraw.getAminoChange(varnode, this.base, varnode.getExons().get(exon))).contains("UTR") || VariantHandler.utr.isSelected()) && !(!VariantHandler.nonsense.isSelected() ? VariantHandler.synonymous.isSelected() && MethodLibrary.aminoEffect(aminochange).contains("synonymous") : !MethodLibrary.aminoEffect(aminochange).contains("nonsense"))) {
                                        if (aminos.length() == 0) {
                                            aminos.append(aminochange);
                                            transcripts.append(varnode.getExons().get(exon).getTranscript().getENST());
                                            biotypes.append(varnode.getExons().get(exon).getTranscript().getBiotype());
                                            exons.append(varnode.getExons().get(exon).getNro());
                                        } else {
                                            aminos.append(";" + aminochange);
                                            transcripts.append(";" + varnode.getExons().get(exon).getTranscript().getENST());
                                            biotypes.append(";" + varnode.getExons().get(exon).getTranscript().getBiotype());
                                            exons.append(";" + varnode.getExons().get(exon).getNro());
                                        }
                                    }
                                    ++exon;
                                }
                                addrow[3] = aminos.toString();
                                addrow[4] = varnode.isRscode() != null ? varnode.rscode : "N/A";
                                addrow[5] = this.base;
                                addrow[6] = transcripts.toString();
                                addrow[7] = biotypes.toString();
                                addrow[8] = exons.toString();
                                AminoEntry aminoentry = new AminoEntry(addrow, varnode);
                                this.aminoarray.add(aminoentry);
                            }
                            ++v;
                        }
                    }
                } else if (VariantHandler.intronic.isSelected() && varnode.isInGene() && varnode.getTranscripts() != null && varnode.getExons() == null) {
                    v = 0;
                    while (v < varnode.vars.size()) {
                        entry = varnode.vars.get(v);
                        this.base = entry.getKey();
                        this.mutcount = 0;
                        int m = 0;
                        while (m < entry.getValue().size()) {
                            if (entry.getValue().get((int)m).alleles != null) break;
                            if (entry.getValue().get((int)m).getSample().annotation) {
                                entry.getValue().remove(m);
                                --m;
                            } else if (!Main.drawCanvas.hideVar(entry.getValue().get(m), entry.getKey().length() > 1)) {
                                if (VariantHandler.onlyselected.isSelected() && !entry.getValue().get(m).getSample().equals(Main.drawCanvas.selectedSample)) {
                                    entry.getValue().remove(m);
                                    --m;
                                } else {
                                    ++this.mutcount;
                                }
                            } else {
                                entry.getValue().remove(m);
                                --m;
                            }
                            ++m;
                        }
                        if (this.mutcount != 0) {
                            StringBuffer transcripts = new StringBuffer("");
                            StringBuffer biotypes = new StringBuffer("");
                            String[] addrow = new String[9];
                            addrow[0] = gene.getName();
                            addrow[1] = "" + this.mutcount;
                            addrow[2] = String.valueOf(gene.getChrom()) + ":" + MethodLibrary.formatNumber(varnode.getPosition() + 1);
                            addrow[3] = String.valueOf(Main.getBase.get(varnode.getRefBase())) + "->" + this.base + " (intronic)";
                            addrow[4] = varnode.isRscode() != null ? varnode.rscode : "N/A";
                            addrow[5] = this.base;
                            int trans = 0;
                            while (trans < varnode.getTranscripts().size()) {
                                if (varnode.getTranscripts().get(trans).getGene().equals(gene)) {
                                    if (transcripts.length() == 0) {
                                        transcripts.append(varnode.getTranscripts().get(trans).getENST());
                                        biotypes.append(varnode.getTranscripts().get(trans).getBiotype());
                                    } else {
                                        transcripts.append(";" + varnode.getTranscripts().get(trans).getENST());
                                        biotypes.append(";" + varnode.getTranscripts().get(trans).getBiotype());
                                    }
                                }
                                ++trans;
                            }
                            addrow[4] = varnode.isRscode() != null ? varnode.rscode : "N/A";
                            addrow[5] = this.base;
                            addrow[6] = transcripts.toString();
                            addrow[7] = biotypes.toString();
                            addrow[8] = "Intronic";
                            AminoEntry aminoentry = new AminoEntry(addrow, varnode);
                            this.aminoarray.add(aminoentry);
                        }
                        ++v;
                    }
                }
                ++t;
            }
            varnode = null;
        }
        catch (Exception e) {
            ErrorLog.addError(e.getStackTrace());
            e.printStackTrace();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.tablescroll.getVerticalScrollBar().setValue(this.tablescroll.getVerticalScrollBar().getValue() - 16);
        } else {
            this.tablescroll.getVerticalScrollBar().setValue(this.tablescroll.getVerticalScrollBar().getValue() + 16);
        }
    }

    public static class ListSorter
    implements Comparator<Gene> {
        public int index;
        boolean ascending = true;

        @Override
        public int compare(Gene o1, Gene o2) {
            if (this.index == 0) {
                String f2;
                String f1 = o1.getName();
                if (f1.compareTo(f2 = o2.getName()) < 0) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (f1.compareTo(f2) > 0) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (this.index == 1) {
                int f1 = o1.mutations;
                int f2 = o2.mutations;
                if (f1 < f2) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (f1 > f2) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (this.index == 2) {
                if (Main.chromIndex.get(o1.getChrom())[0] + (long)o1.getStart() < Main.chromIndex.get(o2.getChrom())[0] + (long)o2.getStart()) {
                    if (this.ascending) {
                        return -1;
                    }
                    return 1;
                }
                if (Main.chromIndex.get(o1.getChrom())[0] + (long)o1.getStart() > Main.chromIndex.get(o2.getChrom())[0] + (long)o2.getStart()) {
                    if (this.ascending) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            return 0;
        }
    }
}

