/*
 * Decompiled with CFR 0.152.
 */
package base.BasePlayer;

import base.BasePlayer.ChromDraw;
import base.BasePlayer.Draw;
import base.BasePlayer.FileRead;
import base.BasePlayer.Main;
import base.BasePlayer.MethodLibrary;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class AddGenome
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    static JFrame frame = null;
    static boolean annotation = false;
    static Color green = new Color(150, 255, 150);
    JLabel genomeFileText;
    JLabel annotationFileText;
    static JPopupMenu menu = new JPopupMenu();
    static JTextArea area = new JTextArea();
    static JScrollPane menuscroll = new JScrollPane();
    static JTextField genomeName;
    static JLabel sizeError;
    JButton openRef;
    JButton openAnno;
    JButton add;
    JButton checkUpdates;
    static JButton download;
    static JButton remove;
    static JButton getLinks;
    static JButton checkEnsembl;
    static int longestName;
    static String userDir;
    File genomeFile;
    File annotationFile;
    static boolean ensemblfetch;
    static boolean downloading;
    static HashMap<String, URL[]> genomeHash;
    static ArrayList<String> removables;
    static Object[] headers;
    static Object[] remheaders;
    static String[][] data;
    static String[][] remdata;
    static HashMap<String, Integer[]> sizeHash;
    static JPanel panel;
    static DefaultMutableTreeNode root;
    static JScrollPane treescroll;
    static JTextField genomedirectory;
    static JTree tree;
    static DefaultMutableTreeNode selectedNode;
    static DefaultTreeModel treemodel;
    static ArrayList<String> organisms;
    static JScrollPane remscroll;
    static DefaultTableModel model;
    static DefaultTableModel remmodel;
    static JTable genometable;
    static JTable remtable;
    static ArrayList<String[]> news;

    static {
        sizeError = new JLabel("Not enough space on storage.");
        longestName = 0;
        userDir = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent().replace("%20", " ");
        ensemblfetch = false;
        downloading = false;
        genomeHash = new HashMap();
        removables = new ArrayList();
        headers = new Object[]{"Ensembl genomes", "Size (MB)"};
        remheaders = new Object[]{"Installed genomes"};
        data = new String[0][];
        remdata = new String[0][];
        sizeHash = new HashMap();
        panel = new JPanel(new GridBagLayout());
        root = new DefaultMutableTreeNode("Genomes");
        genomedirectory = new JTextField();
        selectedNode = null;
        organisms = new ArrayList();
        model = new DefaultTableModel(data, headers){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        remmodel = new DefaultTableModel(remdata, remheaders){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        genometable = new JTable(model);
        remtable = new JTable(remmodel);
        news = new ArrayList();
    }

    static void checkGenomes() {
        File checkdir = Main.genomeDir;
        root.removeAllChildren();
        int counter = 0;
        int i = model.getRowCount() - 1;
        while (i >= 0) {
            model.removeRow(i);
            --i;
        }
        i = remmodel.getRowCount() - 1;
        while (i >= 0) {
            remmodel.removeRow(i);
            --i;
        }
        removables.clear();
        int currentlen = 0;
        int length = 0;
        if (checkdir == null) {
            try {
                checkdir = new File(String.valueOf(userDir) + "/genomes");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File[] addDir = checkdir.listFiles();
        int f = 0;
        while (f < addDir.length) {
            try {
                if (addDir[f].isDirectory()) {
                    currentlen = genometable.getFontMetrics(genometable.getFont()).stringWidth(addDir[f].getName());
                    if (currentlen > length) {
                        length = currentlen;
                    }
                    removables.add(addDir[f].getName());
                    File checkAnnodir = new File(checkdir + "/" + addDir[f].getName() + "/annotation/");
                    File[] annodir = checkAnnodir.listFiles();
                    DefaultMutableTreeNode genome = new DefaultMutableTreeNode(addDir[f].getName());
                    root.add(genome);
                    if (annodir == null) {
                        ++counter;
                        genome.add(new DefaultMutableTreeNode("Add new annotation..."));
                    } else {
                        counter += annodir.length + 3;
                        int a = 0;
                        while (a < annodir.length) {
                            currentlen = genometable.getFontMetrics(genometable.getFont()).stringWidth(annodir[a].getName());
                            if (currentlen > length) {
                                length = currentlen;
                            }
                            genome.add(new DefaultMutableTreeNode(annodir[a].getName()));
                            ++a;
                        }
                        genome.add(new DefaultMutableTreeNode("Add new annotation..."));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++f;
        }
        if (counter == 0) {
            counter = 1;
            length = genometable.getFontMetrics(genometable.getFont()).stringWidth("Add new annotation...");
        }
        ++counter;
        root.add(new DefaultMutableTreeNode("Add new reference..."));
        genometable.setAutoResizeMode(3);
        int i2 = 0;
        while (i2 < organisms.size()) {
            if (!removables.contains(organisms.get(i2))) {
                Object[] row = new Object[]{organisms.get(i2), "" + sizeHash.get(organisms.get(i2))[0] / 0x100000};
                model.addRow(row);
                currentlen = genometable.getFontMetrics(genometable.getFont()).stringWidth(organisms.get(i2));
                if (currentlen > length) {
                    length = currentlen;
                }
            }
            ++i2;
        }
        longestName = length;
        if (genometable.getRowCount() > 15) {
            genometable.setPreferredScrollableViewportSize(new Dimension(longestName + 20 + Main.defaultFontSize * 8, genometable.getRowHeight() * 15));
            genometable.setMinimumSize(new Dimension(longestName + 20, genometable.getRowHeight() * 15));
        } else {
            genometable.setPreferredScrollableViewportSize(new Dimension(longestName + 20 + Main.defaultFontSize * 8, genometable.getRowHeight() * (genometable.getRowCount() + 1)));
            genometable.setMinimumSize(new Dimension(longestName + 20, genometable.getRowHeight() * (genometable.getRowCount() + 1)));
        }
        if (remtable.getRowCount() > 15) {
            remtable.setPreferredScrollableViewportSize(new Dimension(longestName + 20 + Main.defaultFontSize * 8, remtable.getRowHeight() * 15));
        } else {
            remtable.setPreferredScrollableViewportSize(new Dimension(longestName + 20 + Main.defaultFontSize * 8, remtable.getRowHeight() * (remtable.getRowCount() + 1)));
        }
        genometable.getColumnModel().getColumn(0).setPreferredWidth(longestName + 10);
        genometable.getColumnModel().getColumn(0).setMinWidth(longestName + 10);
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        model.reload();
        int rowheight = tree.getRowHeight();
        if (rowheight < 1) {
            rowheight = Main.defaultFontSize + 4;
        }
        treescroll.setPreferredSize(new Dimension(longestName + 20 + Main.defaultFontSize * 8, counter * rowheight));
        treescroll.setMinimumSize(new Dimension(longestName + 20 + Main.defaultFontSize * 8, counter * rowheight));
        remscroll.setPreferredSize(new Dimension(longestName + 20 + Main.defaultFontSize * 8, counter * rowheight));
        remscroll.setMinimumSize(new Dimension(longestName + 20 + Main.defaultFontSize * 8, counter * rowheight));
        tree.expandPath(new TreePath(root));
        AddGenome.setFonts(Main.menuFont);
    }

    public static void setFonts(Font menuFont) {
        if (menuFont == null) {
            menuFont = new Font("SansSerif", 1, Main.defaultFontSize);
        }
        int i = 0;
        while (i < panel.getComponentCount()) {
            panel.getComponent(i).setFont(menuFont);
            ++i;
        }
        genometable.getTableHeader().setFont(menuFont);
        genometable.setFont(menuFont);
        genometable.setRowHeight(menuFont.getSize() + 2);
        tree.setFont(menuFont);
        tree.setRowHeight(menuFont.getSize() + 2);
        frame.pack();
    }

    public AddGenome() {
        super(new BorderLayout());
        AddGenome.makeGenomes();
        tree = new JTree(root);
        tree.getSelectionModel().setSelectionMode(4);
        sizeError.setForeground(Draw.redColor);
        sizeError.setVisible(true);
        treemodel = (DefaultTreeModel)tree.getModel();
        remscroll = new JScrollPane(remtable);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;
            private Icon collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
            private Icon expandedIcon = UIManager.getIcon("Tree.expandedIcon");
            private Icon addIcon = UIManager.getIcon("Tree.closedIcon");

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                if (!isLeaf) {
                    if (expanded) {
                        this.setIcon(this.expandedIcon);
                    } else {
                        this.setIcon(this.collapsedIcon);
                    }
                } else if (((DefaultMutableTreeNode)value).getUserObject().toString().equals("Annotations")) {
                    this.setIcon(null);
                } else if (((DefaultMutableTreeNode)value).getUserObject().toString().startsWith("Add new")) {
                    this.setIcon(this.addIcon);
                } else {
                    this.setIcon(null);
                }
                return c;
            }
        });
        tree.addMouseListener(this);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    selectedNode = node;
                    if (node.isLeaf()) {
                        AddGenome.this.checkUpdates.setEnabled(false);
                    } else {
                        AddGenome.this.checkUpdates.setEnabled(true);
                    }
                    if (node.toString().startsWith("Add new") || node.toString().equals("Annotations")) {
                        remove.setEnabled(false);
                    } else {
                        remove.setEnabled(true);
                    }
                    genometable.clearSelection();
                    download.setEnabled(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        tree.setToggleClickCount(1);
        tree.setRootVisible(false);
        treescroll = new JScrollPane(tree);
        AddGenome.checkGenomes();
        this.genomeFileText = new JLabel("Select reference fasta-file");
        this.annotationFileText = new JLabel("Select annotation gff3-file");
        genomeName = new JTextField("Give name of the genome");
        this.openRef = new JButton("Browse");
        this.openAnno = new JButton("Browse");
        this.add = new JButton("Add");
        download = new JButton("Download");
        checkEnsembl = new JButton("Ensembl fetch");
        checkEnsembl.setMinimumSize(Main.buttonDimension);
        checkEnsembl.addActionListener(this);
        getLinks = new JButton("Get file links.");
        remove = new JButton("Remove");
        this.checkUpdates = new JButton("Check updates");
        download.setEnabled(false);
        getLinks.setEnabled(false);
        getLinks.addActionListener(this);
        remove.setEnabled(false);
        download.addActionListener(this);
        remove.addActionListener(this);
        panel.setBackground(Draw.sidecolor);
        this.checkUpdates.addActionListener(this);
        this.setBackground(Draw.sidecolor);
        frame.getContentPane().setBackground(Draw.sidecolor);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 4, 2, 4);
        c.gridwidth = 2;
        genometable.setSelectionMode(0);
        genometable.setShowGrid(false);
        remtable.setSelectionMode(0);
        remtable.setShowGrid(false);
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().setBackground(Color.white);
        scroll.getViewport().add(genometable);
        remscroll.getViewport().setBackground(Color.white);
        genometable.addMouseListener(this);
        remtable.addMouseListener(this);
        c.anchor = 18;
        panel.add((Component)new JLabel("Download genome reference and annotation"), c);
        ++c.gridx;
        c.anchor = 12;
        panel.add((Component)checkEnsembl, c);
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)scroll, c);
        ++c.gridy;
        c.fill = 0;
        panel.add((Component)download, c);
        c.gridx = 1;
        panel.add((Component)sizeError, c);
        c.gridx = 1;
        panel.add((Component)getLinks, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        panel.add((Component)new JLabel("Add/Remove installed genomes manually"), c);
        ++c.gridy;
        panel.add((Component)treescroll, c);
        ++c.gridy;
        c.fill = 0;
        c.gridwidth = 1;
        remove.setMinimumSize(Main.buttonDimension);
        panel.add((Component)remove, c);
        c.gridx = 1;
        panel.add((Component)this.checkUpdates, c);
        this.checkUpdates.setMinimumSize(Main.buttonDimension);
        this.checkUpdates.setEnabled(false);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        try {
            if (Main.genomeDir != null) {
                genomedirectory.setText(Main.genomeDir.getCanonicalPath());
            }
            genomedirectory.setEditable(false);
            genomedirectory.setBackground(Color.white);
            genomedirectory.setForeground(Color.black);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        panel.add((Component)new JLabel("Genome directory:"), c);
        ++c.gridy;
        panel.add((Component)genomedirectory, c);
        this.add((Component)panel, "North");
        if (Main.drawCanvas != null) {
            AddGenome.setFonts(Main.menuFont);
        }
    }

    static void updateEnsemblList() {
        try {
            menu = new JPopupMenu();
            area = new JTextArea();
            menuscroll = new JScrollPane();
            area.setFont(Main.menuFont);
            menu.add(menuscroll);
            menu.setPreferredSize(new Dimension(300, 200));
            area.revalidate();
            menuscroll.getViewport().add(area);
            menu.pack();
            menu.show(treescroll, 0, 0);
            FTPClient f = new FTPClient();
            news = new ArrayList();
            area.append("Connecting to Ensembl...\n");
            f.connect("ftp.ensembl.org");
            f.enterLocalPassiveMode();
            f.login("anonymous", "");
            area.append("Connected.\n");
            FTPFile[] files = f.listFiles("pub");
            String releasedir = "";
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory() && files[i].getName().contains("release")) {
                    releasedir = files[i].getName();
                }
                ++i;
            }
            files = f.listFiles("pub/" + releasedir + "/fasta/");
            String releasenro = releasedir.substring(releasedir.indexOf("-") + 1);
            area.append("Searching for new genomes");
            i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    FTPFile[] fastafiles = f.listFiles("pub/" + releasedir + "/fasta/" + files[i].getName() + "/dna/");
                    String[] urls = new String[5];
                    int j = 0;
                    while (j < fastafiles.length) {
                        if (fastafiles[j].getName().contains(".dna.toplevel.")) {
                            String reply;
                            urls[0] = "ftp://ftp.ensembl.org/pub/" + releasedir + "/fasta/" + files[i].getName() + "/dna/" + fastafiles[j].getName();
                            String filePath = "/pub/" + releasedir + "/fasta/" + files[i].getName() + "/dna/" + fastafiles[j].getName();
                            f.sendCommand("SIZE", filePath);
                            urls[1] = reply = f.getReplyString().split("\\s+")[1];
                            break;
                        }
                        ++j;
                    }
                    if (urls[0] != null) {
                        FTPFile[] annofiles = f.listFiles("pub/" + releasedir + "/gff3/" + files[i].getName());
                        int j2 = 0;
                        while (j2 < annofiles.length) {
                            if (annofiles[j2].getName().contains("." + releasenro + ".gff3.gz")) {
                                String reply;
                                urls[2] = "ftp://ftp.ensembl.org/pub/" + releasedir + "/gff3/" + files[i].getName() + "/" + annofiles[j2].getName();
                                String filePath = "/pub/" + releasedir + "/gff3/" + files[i].getName() + "/" + annofiles[j2].getName();
                                f.sendCommand("SIZE", filePath);
                                urls[3] = reply = f.getReplyString().split("\\s+")[1];
                                break;
                            }
                            ++j2;
                        }
                        if (urls[2] != null) {
                            if (files[i].getName().contains("homo_sapiens")) {
                                urls[4] = "http://hgdownload.cse.ucsc.edu/goldenPath/hg19/database/cytoBand.txt.gz";
                            } else if (files[i].getName().contains("mus_musculus")) {
                                urls[4] = "http://hgdownload.cse.ucsc.edu/goldenPath/mm10/database/cytoBand.txt.gz";
                            }
                            String name = urls[0].substring(urls[0].lastIndexOf("/") + 1, urls[0].indexOf(".dna."));
                            if (genomeHash.containsKey(name) || removables.contains(name)) {
                                area.append(".");
                            } else {
                                URL[] newurls;
                                area.append("\nNew genome " + name + " added.\n");
                                area.setCaretPosition(area.getText().length());
                                area.revalidate();
                                organisms.add(name);
                                news.add(urls);
                                if (urls[4] != null) {
                                    newurls = new URL[]{new URL(urls[0]), new URL(urls[2]), new URL(urls[4])};
                                    genomeHash.put(name, newurls);
                                } else {
                                    newurls = new URL[]{new URL(urls[0]), new URL(urls[2])};
                                    genomeHash.put(name, newurls);
                                }
                                Integer[] sizes = new Integer[]{Integer.parseInt(urls[1]), Integer.parseInt(urls[3])};
                                sizeHash.put(name, sizes);
                            }
                        }
                    }
                }
                ++i;
            }
            AddGenome.checkGenomes();
            if (news.size() > 0) {
                try {
                    FileWriter fw = new FileWriter(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/ensembl_fetched.txt");
                    BufferedWriter bw = new BufferedWriter(fw);
                    int i2 = 0;
                    while (i2 < news.size()) {
                        int j = 0;
                        while (j < news.get(i2).length) {
                            if (news.get(i2)[j] == null) break;
                            if (j > 0) {
                                bw.write("\t");
                            }
                            bw.write(news.get(i2)[j]);
                            ++j;
                        }
                        bw.write("\n");
                        ++i2;
                    }
                    bw.close();
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            Main.showError(e.getMessage(), "Error");
            e.printStackTrace();
        }
    }

    static void makeGenomes() {
        try {
            Integer[] sizes;
            URL[] urls;
            String name;
            String[] split;
            String line;
            BufferedReader reader;
            FileReader freader = null;
            File file = new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/ensembl.txt");
            if (file.exists()) {
                freader = new FileReader(file);
                reader = new BufferedReader(freader);
                while ((line = reader.readLine()) != null) {
                    split = line.split("\t");
                    name = split[0].substring(split[0].lastIndexOf("/") + 1, split[0].indexOf(".dna."));
                    organisms.add(name);
                    if (split[0].contains("GRCh38")) {
                        split[0] = split[0].replace("toplevel", "primary_assembly");
                    }
                    if (split[2].contains("update")) {
                        split[2] = split[2].replace("update", "release-82");
                    }
                    if (split.length == 5) {
                        urls = new URL[]{new URL(split[0]), new URL(split[2]), new URL(split[4])};
                        genomeHash.put(name, urls);
                    } else {
                        urls = new URL[]{new URL(split[0]), new URL(split[2])};
                        genomeHash.put(name, urls);
                    }
                    sizes = new Integer[]{Integer.parseInt(split[1]), Integer.parseInt(split[3])};
                    sizeHash.put(name, sizes);
                }
                freader.close();
                reader.close();
            }
            if ((file = new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/ensembl_fetched.txt")).exists()) {
                freader = new FileReader(file);
                reader = new BufferedReader(freader);
                while ((line = reader.readLine()) != null) {
                    split = line.split("\t");
                    name = split[0].substring(split[0].lastIndexOf("/") + 1, split[0].indexOf(".dna."));
                    organisms.add(name);
                    if (split[0].contains("GRCh38")) {
                        split[0] = split[0].replace("toplevel", "primary_assembly");
                    }
                    if (split.length == 5) {
                        urls = new URL[]{new URL(split[0]), new URL(split[2]), new URL(split[4])};
                        genomeHash.put(name, urls);
                    } else {
                        urls = new URL[]{new URL(split[0]), new URL(split[2])};
                        genomeHash.put(name, urls);
                    }
                    sizes = new Integer[]{Integer.parseInt(split[1]), Integer.parseInt(split[3])};
                    sizeHash.put(name, sizes);
                }
                freader.close();
                reader.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static String downloadAnnotation(URL fileurl, String genome) {
        File annotationFile = null;
        try {
            String annotationUrl = fileurl.getFile();
            String targetDir = String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genome + "/annotation/";
            File dir = new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genome);
            File[] files = dir.listFiles();
            String genomestring = "";
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().endsWith(".fa") || files[i].getName().endsWith(".fasta")) {
                    genomestring = files[i].getCanonicalPath();
                    break;
                }
                ++i;
            }
            if (Main.drawCanvas != null) {
                Main.drawCanvas.loadingtext = "Downloading " + fileurl.getHost() + "/" + annotationUrl;
            } else {
                System.out.println("Downloading " + annotationUrl);
            }
            String filetest = Main.downloadFile(fileurl, targetDir, sizeHash.get(genome)[1]);
            annotationFile = new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genome + "/annotation/" + filetest + "/" + filetest);
            String genomedir = String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genome + "/";
            File annofile = new File(String.valueOf(genomedir) + "annotation/" + filetest + "/" + annotationFile.getName().substring(0, annotationFile.getName().indexOf(".gff")) + ".bed.gz");
            AddGenome.parseGFF(annotationFile, annofile, genome, genomestring);
            annotationFile.delete();
            Main.addAnnotationFile(genome, annofile);
            AddGenome.checkGenomes();
        }
        catch (Exception e) {
            e.printStackTrace();
            annotationFile.delete();
        }
        return "";
    }

    static SAMSequenceDictionary ReadDict(File fastafile) {
        SAMSequenceDictionary dict = new SAMSequenceDictionary();
        try {
            String line;
            BufferedReader reader = null;
            reader = fastafile.getName().endsWith(".gz") ? new BufferedReader(new FileReader(String.valueOf(fastafile.getCanonicalPath().substring(0, fastafile.getCanonicalPath().lastIndexOf(".gz"))) + ".fai")) : new BufferedReader(new FileReader(String.valueOf(fastafile.getCanonicalPath()) + ".fai"));
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\t");
                SAMSequenceRecord record = new SAMSequenceRecord(split[0], Integer.parseInt(split[1]));
                dict.addSequence(record);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dict;
    }

    static SAMSequenceDictionary ReadDictChr(File fastafile) {
        SAMSequenceDictionary dict = new SAMSequenceDictionary();
        try {
            String line;
            BufferedReader reader = null;
            reader = fastafile.getName().endsWith(".gz") ? new BufferedReader(new FileReader(String.valueOf(fastafile.getCanonicalPath().substring(0, fastafile.getCanonicalPath().lastIndexOf(".gz"))) + ".fai")) : new BufferedReader(new FileReader(String.valueOf(fastafile.getCanonicalPath()) + ".fai"));
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\t");
                if (!split[0].startsWith("chr")) {
                    split[0] = "chr" + split[0];
                }
                SAMSequenceRecord record = new SAMSequenceRecord(split[0], Integer.parseInt(split[1]));
                dict.addSequence(record);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dict;
    }

    static void parseGFF(File gffFile, File outfile, String genome, String genomeFile) {
        try {
            SAMSequenceDictionary dict = AddGenome.ReadDict(new File(genomeFile));
            if (gffFile.getName().contains(".gff")) {
                FileRead.readGFF(gffFile, outfile.getCanonicalPath(), dict);
            } else {
                FileRead.readGTF(gffFile, outfile.getCanonicalPath(), dict);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void indexFasta(File fastafile, String targetDir) {
        try {
            String line;
            BufferedReader reader;
            ArrayList<String[]> faiList = new ArrayList<String[]>();
            Boolean zip = false;
            GZIPInputStream gzip = null;
            BufferedWriter fastaWriter = null;
            BufferedWriter indexWriter = null;
            if (fastafile.getName().endsWith(".gz")) {
                zip = true;
                gzip = new GZIPInputStream(new FileInputStream(fastafile));
                reader = new BufferedReader(new InputStreamReader(gzip));
                if (!new File(String.valueOf(targetDir) + fastafile.getName().substring(0, fastafile.getName().indexOf(".gz"))).exists()) {
                    fastaWriter = new BufferedWriter(new FileWriter(String.valueOf(targetDir) + fastafile.getName().substring(0, fastafile.getName().indexOf(".gz"))));
                }
                if (!new File(String.valueOf(targetDir) + fastafile.getName().substring(0, fastafile.getName().indexOf(".gz")) + ".fai").exists()) {
                    indexWriter = new BufferedWriter(new FileWriter(String.valueOf(targetDir) + fastafile.getName().substring(0, fastafile.getName().indexOf(".gz")) + ".fai"));
                }
            } else {
                reader = new BufferedReader(new FileReader(fastafile));
                if (!new File(String.valueOf(targetDir) + "/" + fastafile.getName()).exists()) {
                    fastaWriter = new BufferedWriter(new FileWriter(String.valueOf(targetDir) + fastafile.getName()));
                }
                if (!new File(String.valueOf(targetDir) + "/" + fastafile.getName() + ".fai").exists()) {
                    indexWriter = new BufferedWriter(new FileWriter(String.valueOf(targetDir) + fastafile.getName() + ".fai"));
                }
            }
            long counter = 0L;
            long chromlength = 0L;
            long pointer = 0L;
            Main.drawCanvas.loadbarAll = 0;
            while ((line = reader.readLine()) != null) {
                if (!Main.drawCanvas.loading) break;
                if (fastaWriter != null) {
                    fastaWriter.write(String.valueOf(line) + "\n");
                }
                counter += (long)(line.length() + 1);
                if (line.startsWith(">")) {
                    if (faiList.size() > 0) {
                        ((String[])faiList.get((int)(faiList.size() - 1)))[1] = "" + chromlength;
                    }
                    String[] row = new String[5];
                    faiList.add(row);
                    String[] split = line.split("\\s+");
                    pointer = counter;
                    row[0] = split[0].substring(1);
                    row[2] = "" + pointer;
                    line = reader.readLine();
                    if (fastaWriter != null) {
                        fastaWriter.write(String.valueOf(line) + "\n");
                    }
                    chromlength = line.length();
                    row[3] = "" + line.length();
                    row[4] = "" + (line.length() + 1);
                    counter += (long)(line.length() + 1);
                    continue;
                }
                chromlength += (long)line.length();
            }
            ((String[])faiList.get((int)(faiList.size() - 1)))[1] = "" + chromlength;
            if (fastaWriter != null) {
                fastaWriter.close();
            }
            reader.close();
            if (zip.booleanValue()) {
                gzip.close();
            }
            if (indexWriter != null) {
                int i = 0;
                while (i < faiList.size()) {
                    int j = 0;
                    while (j < 4) {
                        indexWriter.write(String.valueOf(((String[])faiList.get(i))[j]) + "\t");
                        ++j;
                    }
                    indexWriter.write(String.valueOf(((String[])faiList.get(i))[4]) + "\n");
                    ++i;
                }
                indexWriter.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void createAndShowGUI() {
        frame = new JFrame("Add new genome");
        if (Main.drawCanvas != null) {
            frame.setDefaultCloseOperation(2);
            frame.setVisible(false);
        } else {
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        }
        frame.setResizable(true);
        frame.setTitle("Genome select");
        AddGenome newContentPane = new AddGenome();
        frame.setContentPane(newContentPane);
        frame.pack();
        sizeError.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddGenome.createAndShowGUI();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        block60: {
            if (event.getSource() == download) {
                if (!downloading) {
                    downloading = true;
                    AddGenome.downloadGenome(genometable.getValueAt(genometable.getSelectedRow(), 0).toString());
                    downloading = false;
                }
            } else if (event.getSource() == getLinks) {
                URL[] urls = genomeHash.get(genometable.getValueAt(genometable.getSelectedRow(), 0).toString());
                JPopupMenu menu = new JPopupMenu();
                JTextArea area = new JTextArea();
                JScrollPane menuscroll = new JScrollPane();
                area.setFont(Main.menuFont);
                menu.add(menuscroll);
                menu.setPreferredSize(new Dimension(menu.getFontMetrics(Main.menuFont).stringWidth(urls[0].toString()) + Main.defaultFontSize * 10, menu.getFontMetrics(Main.menuFont).getHeight() * 4));
                area.setLineWrap(true);
                area.setWrapStyleWord(true);
                int i = 0;
                while (i < urls.length) {
                    area.append(String.valueOf(urls[i].toString()) + "\n");
                    ++i;
                }
                area.setCaretPosition(0);
                area.revalidate();
                menuscroll.getViewport().add(area);
                menu.pack();
                menu.show(this, 0, 0);
            } else if (event.getSource() == checkEnsembl) {
                if (ensemblfetch) {
                    menu.show(treescroll, 0, 0);
                } else {
                    EnsemblFetch fetcher = new EnsemblFetch();
                    fetcher.execute();
                }
            } else if (event.getSource() == this.checkUpdates) {
                URL testfile = null;
                try {
                    String ref = selectedNode.toString();
                    if (genomeHash.get(ref) != null) {
                        String result;
                        ArrayList<String> testfiles = new ArrayList<String>();
                        if (Main.drawCanvas != null) {
                            int i = 0;
                            while (i < Main.genomehash.get(ref).size()) {
                                testfiles.add(Main.genomehash.get(ref).get(i).getName().replace(".bed.gz", ""));
                                ++i;
                            }
                        }
                        if ((result = Main.checkFile(testfile = genomeHash.get(ref)[1], testfiles)).length() == 0) {
                            Main.showError("You have newest annotation file.", "Note");
                        } else {
                            int n = JOptionPane.showConfirmDialog(Main.drawCanvas, "New annotation file found: " + result + "\nDownload it now?", "Note", 0);
                            if (n == 0) {
                                URL fileurl = new URL(String.valueOf(testfile.getProtocol()) + "://" + testfile.getHost() + testfile.getPath().substring(0, testfile.getPath().lastIndexOf("/") + 1) + result);
                                OutputRunner runner2 = new OutputRunner(fileurl, ref);
                                runner2.downloadAnnotation = true;
                                runner2.execute();
                            }
                        }
                        break block60;
                    }
                    Main.showError("This genome is not from Ensembl list, could not check for updates.", "Note", genometable);
                }
                catch (Exception e) {
                    Main.showError("Cannot connect to " + testfile.getHost() + ".\nTry again later.", "Error");
                    e.printStackTrace();
                }
            } else if (event.getSource() == remove) {
                if (!selectedNode.isLeaf()) {
                    String removeref = selectedNode.toString();
                    try {
                        int i;
                        if (Main.drawCanvas != null && removeref.equals(Main.refDropdown.getSelectedItem().toString())) {
                            Main.referenceFile.close();
                            if (ChromDraw.exonReader != null) {
                                ChromDraw.exonReader.close();
                            }
                        }
                        if (Main.genomehash.containsKey(removeref)) {
                            i = Main.genomehash.get(removeref).size() - 1;
                            while (i >= 0) {
                                Main.genomehash.get(removeref).remove(i);
                                --i;
                            }
                            Main.genomehash.remove(removeref);
                        }
                        if (Main.drawCanvas != null) {
                            Main.refModel.removeElement(removeref);
                            Main.refDropdown.removeItem(removeref);
                            Main.refDropdown.revalidate();
                        }
                        i = 0;
                        while (i < Main.genome.getItemCount()) {
                            if (Main.genome.getItem(i).getName() != null && Main.genome.getItem(i).getName().equals(removeref)) {
                                Main.genome.remove(Main.genome.getItem(i));
                                break;
                            }
                            ++i;
                        }
                        FileUtils.deleteDirectory(new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + removeref));
                        AddGenome.checkGenomes();
                        Main.setAnnotationDrop("");
                        if (Main.genomehash.size() == 0) {
                            Main.refDropdown.setSelectedIndex(0);
                            Main.setChromDrop("-1");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            Main.showError("Could not delete genome folder.\nYou can do it manually by deleting folder " + Main.genomeDir.getCanonicalPath() + "/" + removeref, "Note");
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    try {
                        if (Main.drawCanvas != null && ChromDraw.exonReader != null) {
                            ChromDraw.exonReader.close();
                        }
                        Main.removeAnnotationFile(selectedNode.getParent().toString(), selectedNode.toString());
                        FileUtils.deleteDirectory(new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + selectedNode.getParent().toString() + "/annotation/" + selectedNode.toString()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            Main.showError("Could not delete genome folder.\nYou can do it manually by deleting folder " + Main.genomeDir.getCanonicalPath() + "/" + selectedNode.getParent().toString() + "/annotation/" + selectedNode.toString(), "Note");
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    treemodel.removeNodeFromParent(selectedNode);
                }
            } else if (event.getSource() == this.add) {
                if (this.genomeFile == null) {
                    if (new File(this.genomeFileText.getText()).exists()) {
                        this.genomeFile = new File(this.genomeFileText.getText());
                    } else {
                        this.genomeFileText.setText("Select reference genome fasta-file.");
                        this.genomeFileText.setForeground(Color.red);
                        return;
                    }
                }
                if (this.genomeFileText.getText().length() == 0 || this.genomeFileText.getText().startsWith("Select reference")) {
                    this.genomeFileText.setText("Select reference genome fasta-file.");
                    this.genomeFileText.setForeground(Color.red);
                    this.genomeFileText.revalidate();
                } else {
                    OutputRunner runner3 = new OutputRunner(this.genomeFile.getName().replace(".fasta", "").replace(".gz", ""), this.genomeFile, this.annotationFile);
                    runner3.execute();
                }
            } else if (event.getSource() == this.openRef) {
                try {
                    int returnVal;
                    JFileChooser chooser = new JFileChooser(Main.downloadDir);
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileSelectionMode(0);
                    chooser.setAcceptAllFileFilterUsed(false);
                    MyFilterFasta fastaFilter = new MyFilterFasta();
                    chooser.addChoosableFileFilter(fastaFilter);
                    chooser.setDialogTitle("Select reference fasta-file");
                    if (Main.screenSize != null) {
                        chooser.setPreferredSize(new Dimension((int)Main.screenSize.getWidth() / 3, (int)Main.screenSize.getHeight() / 3));
                    }
                    if ((returnVal = chooser.showOpenDialog(this.getParent())) == 0) {
                        this.genomeFile = chooser.getSelectedFile();
                        Main.downloadDir = this.genomeFile.getParent();
                        Main.writeToConfig("DownloadDir=" + this.genomeFile.getParent());
                        this.genomeFileText.setText(this.genomeFile.getName());
                        this.genomeFileText.revalidate();
                        frame.pack();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (event.getSource() == this.openAnno) {
                try {
                    int returnVal;
                    JFileChooser chooser = new JFileChooser(Main.downloadDir);
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setFileSelectionMode(0);
                    chooser.setAcceptAllFileFilterUsed(false);
                    MyFilterGFF gffFilter = new MyFilterGFF();
                    chooser.addChoosableFileFilter(gffFilter);
                    chooser.setDialogTitle("Select annotation gff3-file");
                    if (Main.screenSize != null) {
                        chooser.setPreferredSize(new Dimension((int)Main.screenSize.getWidth() / 3, (int)Main.screenSize.getHeight() / 3));
                    }
                    if ((returnVal = chooser.showOpenDialog(this.getParent())) == 0) {
                        if (this.genomeFile == null) {
                            this.genomeFile = Main.fastahash.get(Main.hoverGenome);
                        }
                        this.annotationFile = chooser.getSelectedFile();
                        Main.downloadDir = this.annotationFile.getParent();
                        Main.writeToConfig("DownloadDir=" + this.annotationFile.getParent());
                        OutputRunner runner4 = new OutputRunner(this.genomeFile.getName().replace(".fasta", "").replace(".gz", ""), this.genomeFile, this.annotationFile);
                        runner4.execute();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == tree) {
            if (selectedNode != null && selectedNode.toString().contains("Add new refe")) {
                try {
                    FileDialog fs = new FileDialog((Frame)frame, "Select reference fasta-file", 0);
                    fs.setDirectory(Main.downloadDir);
                    fs.setVisible(true);
                    String filename = fs.getFile();
                    fs.setFile("*.fasta;*.fa");
                    fs.setFilenameFilter(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.toLowerCase().contains(".fasta") || name.toLowerCase().contains(".fa");
                        }
                    });
                    if (filename != null) {
                        File addfile = new File(String.valueOf(fs.getDirectory()) + "/" + filename);
                        if (addfile.exists()) {
                            this.genomeFile = addfile;
                            Main.downloadDir = this.genomeFile.getParent();
                            Main.writeToConfig("DownloadDir=" + this.genomeFile.getParent());
                            OutputRunner runner2 = new OutputRunner(this.genomeFile.getName().replace(".fasta", "").replace(".fa", "").replace(".gz", ""), this.genomeFile, null);
                            runner2.createGenome = true;
                            runner2.execute();
                        } else {
                            Main.showError("File does not exists.", "Error", frame);
                        }
                    }
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (selectedNode != null && selectedNode.isLeaf() && selectedNode.toString().contains("Add new anno")) {
                try {
                    FileDialog fs = new FileDialog((Frame)frame, "Select annotation gff3/gtf-file", 0);
                    fs.setDirectory(Main.downloadDir);
                    fs.setVisible(true);
                    String filename = fs.getFile();
                    fs.setFile("*.gff3;*.gtf");
                    fs.setFilenameFilter(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.toLowerCase().contains(".gff3") || name.toLowerCase().contains(".gtf");
                        }
                    });
                    if (filename != null) {
                        File addfile = new File(String.valueOf(fs.getDirectory()) + "/" + filename);
                        if (addfile.exists()) {
                            this.annotationFile = addfile;
                            Main.downloadDir = this.annotationFile.getParent();
                            Main.writeToConfig("DownloadDir=" + this.annotationFile.getParent());
                            OutputRunner runner3 = new OutputRunner(selectedNode.getParent().toString(), null, this.annotationFile);
                            runner3.createGenome = true;
                            runner3.execute();
                        } else {
                            Main.showError("File does not exists.", "Error", frame);
                        }
                    }
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (e.getSource() == genometable) {
            if (new File(".").getFreeSpace() / 0x100000L < (long)(sizeHash.get(genometable.getValueAt(genometable.getSelectedRow(), 0))[0] / 0x100000)) {
                sizeError.setVisible(true);
                download.setEnabled(false);
                getLinks.setEnabled(false);
            } else {
                sizeError.setVisible(false);
                download.setEnabled(true);
                getLinks.setEnabled(true);
            }
            tree.clearSelection();
            remove.setEnabled(false);
            this.checkUpdates.setEnabled(false);
        }
    }

    static void downloadGenome(String urls) {
        block14: {
            try {
                URL fastafile = genomeHash.get(urls)[0];
                String targetDir = "";
                File test = new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/test");
                if (test.mkdir()) {
                    if (test.getFreeSpace() / 0x100000L < 4768L) {
                        Main.showError("Sorry, you need more than 5GB of disk space.\nThis drive has " + test.getFreeSpace() / 0x100000L / 1000L + "GB.", "Note");
                        test.delete();
                        return;
                    }
                    test.delete();
                    targetDir = String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + urls + "/";
                    File fasta = new File(String.valueOf(targetDir) + FilenameUtils.getName(fastafile.getFile()));
                    URL gfffile = genomeHash.get(urls)[1];
                    targetDir = String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + urls + "/annotation/" + FilenameUtils.getName(gfffile.getFile()) + "/";
                    File gff = new File(String.valueOf(targetDir) + FilenameUtils.getName(gfffile.getFile()));
                    OutputRunner genomeadd = new OutputRunner(urls, fasta, gff, urls);
                    genomeadd.createGenome = true;
                    genomeadd.execute();
                    break block14;
                }
                try {
                    File outfile;
                    block15: {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setAcceptAllFileFilterUsed(false);
                        chooser.setFileSelectionMode(1);
                        chooser.setDialogTitle("Select a local directory for genome files...");
                        outfile = null;
                        while (true) {
                            int returnVal;
                            if ((returnVal = chooser.showSaveDialog(panel)) == 0) {
                                outfile = chooser.getSelectedFile();
                                File genomedir = new File(String.valueOf(outfile.getCanonicalPath()) + "/genomes");
                                if (new File(String.valueOf(outfile.getCanonicalPath()) + "/genomes").mkdir()) {
                                    if (fastafile.getFile().contains("GRCh38")) {
                                        if (outfile.getFreeSpace() / 0x100000L < 190734L) {
                                            Main.showError("Please, select local drive with more than 60GB of disk space.\nGRCh38 FASTA file is ~50GB uncompressed.\nThis drive has " + outfile.getFreeSpace() / 0x100000L / 1000L + "GB.", "Note");
                                            genomedir.delete();
                                            continue;
                                        }
                                    } else if (outfile.getFreeSpace() / 0x100000L < 4768L) {
                                        Main.showError("Please, select local drive with more than 5GB of disk space.\nThis drive has " + outfile.getFreeSpace() / 0x100000L / 1000L + "GB.", "Note");
                                        genomedir.delete();
                                        continue;
                                    }
                                    break block15;
                                }
                                Main.showError("No writing permissions for this directory. \nPlease, select new directory for genomes.", "Error");
                                continue;
                            }
                            if (returnVal == 1) break;
                        }
                        outfile = null;
                        downloading = false;
                    }
                    if (outfile != null) {
                        Main.genomeDir = new File(String.valueOf(outfile.getCanonicalPath()) + "/genomes");
                        genomedirectory.setText(Main.genomeDir.getCanonicalPath());
                        Main.writeToConfig("genomeDir=" + Main.genomeDir.getCanonicalPath());
                        targetDir = String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + urls + "/";
                        File fasta = new File(String.valueOf(targetDir) + FilenameUtils.getName(fastafile.getFile()));
                        URL gfffile = genomeHash.get(urls)[1];
                        targetDir = String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + urls + "/annotation/" + FilenameUtils.getName(gfffile.getFile()) + "/";
                        File gff = new File(String.valueOf(targetDir) + FilenameUtils.getName(gfffile.getFile()));
                        OutputRunner genomeadd = new OutputRunner(urls, fasta, gff, urls);
                        genomeadd.createGenome = true;
                        genomeadd.execute();
                    }
                    downloading = false;
                }
                catch (Exception ex) {
                    downloading = false;
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                downloading = false;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static class EnsemblFetch
    extends SwingWorker<String, Object> {
        @Override
        protected String doInBackground() throws Exception {
            ensemblfetch = true;
            AddGenome.updateEnsemblList();
            ensemblfetch = false;
            return null;
        }
    }

    static class MyFilterFasta
    extends FileFilter {
        MyFilterFasta() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (file.getName().endsWith(".fa")) {
                return true;
            }
            if (file.getName().endsWith(".fa.gz")) {
                return true;
            }
            if (file.getName().endsWith(".fasta")) {
                return true;
            }
            return file.getName().endsWith(".fasta.gz");
        }

        @Override
        public String getDescription() {
            return "*.fa, *.fasta";
        }
    }

    static class MyFilterGFF
    extends FileFilter {
        MyFilterGFF() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (file.getName().endsWith(".gff3")) {
                return true;
            }
            if (file.getName().endsWith(".gff3.gz")) {
                return true;
            }
            if (file.getName().endsWith(".gtf.gz")) {
                return true;
            }
            return file.getName().endsWith(".gtf");
        }

        @Override
        public String getDescription() {
            return "*.gff3, *.gff3.gz";
        }
    }

    public static class OutputRunner
    extends SwingWorker<String, Object> {
        File genomefile;
        File annotationFile;
        String genomeName;
        String ref;
        URL annofile;
        Boolean createGenome = false;
        Boolean downloadAnnotation = false;

        public OutputRunner(String genomeName, File genomefile, File annotationFile) {
            this.genomefile = genomefile;
            this.genomeName = genomeName;
            this.annotationFile = annotationFile;
        }

        public OutputRunner(String genomeName, File genomefile, File annotationFile, String ref) {
            this.genomefile = genomefile;
            this.genomeName = genomeName;
            this.annotationFile = annotationFile;
            this.ref = ref;
        }

        public OutputRunner(URL annotationFile, String ref) {
            this.annofile = annotationFile;
            this.ref = ref;
        }

        @Override
        protected String doInBackground() {
            frame.setState(1);
            try {
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.ready("all");
                    Main.drawCanvas.loading("Processing files...");
                }
                if (this.createGenome.booleanValue()) {
                    this.createGenome(this.genomeName, this.genomefile, this.annotationFile);
                    this.createGenome = false;
                } else if (this.downloadAnnotation.booleanValue()) {
                    AddGenome.downloadAnnotation(this.annofile, this.ref);
                }
                if (Main.drawCanvas != null) {
                    Main.drawCanvas.ready("Processing files...");
                }
            }
            catch (Exception e) {
                frame.setState(0);
                e.printStackTrace();
            }
            frame.setState(0);
            return "";
        }

        void createGenome(String genomeName, File genomeFile, File annotationFile) {
            block53: {
                try {
                    File annofile = null;
                    if (Main.drawCanvas != null) {
                        Main.drawCanvas.splits.get(0).getGenes().clear();
                    }
                    Boolean ok = false;
                    String annotationUrl = "";
                    File fastatest = new File("test");
                    if (this.ref != null) {
                        String filetest;
                        String targetDir = "";
                        URL[] urlList = genomeHash.get(this.ref);
                        URL fastafile = urlList[0];
                        File f = Main.genomeDir;
                        if (f.canWrite()) {
                            targetDir = String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + this.ref + "/";
                        } else {
                            Main.showError("no access", "Error");
                        }
                        fastatest = new File(String.valueOf(targetDir) + FilenameUtils.getName(fastafile.getFile()).substring(0, FilenameUtils.getName(fastafile.getFile()).indexOf(".gz")));
                        if (!new File(targetDir).exists()) {
                            File fasta = new File(String.valueOf(targetDir) + FilenameUtils.getName(fastafile.getFile()));
                            File target = new File(targetDir);
                            target.mkdir();
                            if (!fasta.exists() && !fastatest.exists()) {
                                if (Main.drawCanvas != null) {
                                    Main.drawCanvas.loadingtext = "Downloading " + genomeName;
                                } else {
                                    System.out.println("Downloading " + genomeName);
                                }
                                String test = Main.downloadFile(fastafile, targetDir, sizeHash.get(this.ref)[0]);
                                if (test == null) {
                                    target.delete();
                                    return;
                                }
                            }
                        }
                        annotationUrl = annotationFile.getName();
                        URL gfffile = urlList[1];
                        targetDir = String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + this.ref + "/annotation/";
                        if (Main.drawCanvas != null) {
                            Main.drawCanvas.loadingtext = "Downloading " + gfffile.getFile();
                        }
                        if ((filetest = Main.downloadFile(gfffile, targetDir, sizeHash.get(this.ref)[1])) == null) {
                            return;
                        }
                        if (!filetest.equals(FilenameUtils.getName(gfffile.getFile()))) {
                            annotationUrl = filetest;
                            annotationFile = new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + this.ref + "/annotation/" + filetest + "/" + filetest);
                        }
                        if (Main.drawCanvas != null) {
                            Main.drawCanvas.loadingtext = "Downloading " + filetest;
                        } else {
                            System.out.println("Downloading " + filetest);
                        }
                        if (urlList.length == 3) {
                            URL bandFile = urlList[2];
                            targetDir = String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + this.ref + "/";
                            Main.downloadFile(bandFile, targetDir, 0);
                            File infile = new File(String.valueOf(targetDir) + FilenameUtils.getName(bandFile.getFile()));
                            File outfile = new File(String.valueOf(targetDir) + "bands.txt");
                            MethodLibrary.unzip(infile, outfile);
                        }
                    }
                    ok = this.ref == null ? (!new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName + "/").exists() ? Boolean.valueOf(new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName + "/").mkdir()) : Boolean.valueOf(true)) : Boolean.valueOf(true);
                    if (ok.booleanValue()) {
                        String genomedir = String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName + "/";
                        if (genomeFile != null && !fastatest.exists()) {
                            if (Main.drawCanvas != null) {
                                Main.drawCanvas.loadingtext = "Unpacking and indexing: " + genomeName;
                            } else {
                                System.out.println("Unpacking and indexing: " + genomeName);
                            }
                            AddGenome.indexFasta(genomeFile, genomedir);
                            Main.addGenomeFile(genomeName);
                        }
                        if (annotationFile != null) {
                            if (Main.drawCanvas != null) {
                                Main.drawCanvas.loadingtext = "Unpacking and indexing: " + annotationFile.getName();
                            } else {
                                System.out.println("Unpacking and indexing: " + annotationFile.getName());
                            }
                            ok = this.ref == null ? (annotationFile.getName().indexOf(".gff") > -1 ? Boolean.valueOf(new File(String.valueOf(genomedir) + "annotation/" + annotationFile.getName().substring(0, annotationFile.getName().indexOf(".gff")) + "/").mkdirs()) : Boolean.valueOf(new File(String.valueOf(genomedir) + "annotation/" + annotationFile.getName().substring(0, annotationFile.getName().indexOf(".gtf")) + "/").mkdirs())) : Boolean.valueOf(true);
                            annofile = this.ref != null ? new File(String.valueOf(genomedir) + "annotation/" + annotationUrl + "/" + annotationFile.getName().substring(0, annotationFile.getName().indexOf(".gff")) + ".bed.gz") : (annotationFile.getName().indexOf(".gff") > -1 ? new File(String.valueOf(genomedir) + "annotation/" + annotationFile.getName().substring(0, annotationFile.getName().indexOf(".gff")) + "/" + annotationFile.getName().substring(0, annotationFile.getName().indexOf(".gff")) + ".bed.gz") : new File(String.valueOf(genomedir) + "annotation/" + annotationFile.getName().substring(0, annotationFile.getName().indexOf(".gtf")) + "/" + annotationFile.getName().substring(0, annotationFile.getName().indexOf(".gtf")) + ".bed.gz"));
                            if (ok.booleanValue()) {
                                if (genomeFile == null) {
                                    File dir = new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName);
                                    File[] files = dir.listFiles();
                                    int i = 0;
                                    while (i < files.length) {
                                        if (files[i].getName().endsWith(".fa") || files[i].getName().endsWith(".fasta")) {
                                            genomeFile = files[i].getCanonicalFile();
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                                if (Main.drawCanvas != null) {
                                    Main.drawCanvas.loadingtext = "Unpacking and indexing: " + annotationFile.getName();
                                } else {
                                    System.out.println("Unpacking and indexing: " + annotationFile.getName());
                                }
                                AddGenome.parseGFF(annotationFile, annofile, genomeName, String.valueOf(genomedir) + genomeFile.getName());
                                Main.drawCanvas.ready("all");
                                Main.addAnnotationFile(genomeName, annofile);
                            } else {
                                Main.addAnnotationFile(genomeName, annofile);
                            }
                        }
                        if (this.ref != null) {
                            genomeFile.delete();
                            annotationFile.delete();
                        }
                        Main.defaultGenome = genomeName;
                        if (genomeName.length() > Main.reflength) {
                            Main.reflength = genomeName.length();
                            Main.refDropdown.setPopupWidth(Main.reflength * Main.letterlength);
                        }
                        Main.defaultAnnotation = annofile != null ? annofile.getName() : "";
                        if (Main.drawCanvas != null) {
                            Main.setChromDrop(genomeName);
                            Main.getBands();
                            Main.geneDropdown.setSelectedItem(Main.defaultAnnotation);
                            Main.geneDropdown.revalidate();
                            Main.getExons();
                            Main.chromosomeDropdown.setSelectedIndex(0);
                            downloading = false;
                        } else {
                            System.out.println("Genome ready: " + genomeName + " : " + Main.defaultAnnotation);
                        }
                        DefaultMutableTreeNode newref = null;
                        if (genomeFile != null) {
                            DefaultMutableTreeNode last = (DefaultMutableTreeNode)root.getLastChild();
                            root.remove(last);
                            newref = new DefaultMutableTreeNode(genomeName);
                            newref.add(new DefaultMutableTreeNode("Add new annotation..."));
                            root.add(newref);
                            root.add(last);
                            treemodel.reload(root);
                        }
                        if (annofile != null) {
                            DefaultMutableTreeNode parent = null;
                            if (newref == null) {
                                parent = (DefaultMutableTreeNode)selectedNode.getParent();
                                DefaultMutableTreeNode last = (DefaultMutableTreeNode)parent.getLastChild();
                                parent.remove(last);
                                parent.add(new DefaultMutableTreeNode(annotationFile.getName().substring(0, annotationFile.getName().indexOf(".gff"))));
                                parent.add(last);
                                treemodel.reload(parent);
                            } else {
                                parent = newref;
                                AddGenome.checkGenomes();
                            }
                        }
                    }
                    int i = 0;
                    while (i < root.getChildCount()) {
                        if (root.getChildAt(i).toString().equals(genomeName)) {
                            tree.setSelectionRow(i);
                            tree.expandRow(i);
                            break block53;
                        }
                        ++i;
                    }
                    break block53;
                }
                catch (Exception e) {
                    try {
                        if (new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName).listFiles() == null) {
                            FileUtils.deleteDirectory(new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName));
                        } else {
                            File[] files = new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName).listFiles();
                            int faifound = -1;
                            int i = 0;
                            while (i < files.length) {
                                if (files[i].getName().endsWith(".fai")) {
                                    faifound = i;
                                    break;
                                }
                                ++i;
                            }
                            if (faifound > -1) {
                                if (files[faifound].length() == 0L) {
                                    FileUtils.deleteDirectory(new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName));
                                }
                            } else {
                                FileUtils.deleteDirectory(new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName));
                            }
                            if ((files = new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName + "/annotation/").listFiles()) != null) {
                                i = 0;
                                while (i < files.length) {
                                    if (files[i].isDirectory() && files[i].listFiles() != null && files[i].listFiles().length < 2) {
                                        FileUtils.deleteDirectory(new File(String.valueOf(Main.genomeDir.getCanonicalPath()) + "/" + genomeName + "/annotation/" + files[i].getName()));
                                    }
                                    ++i;
                                }
                            }
                        }
                        downloading = false;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                downloading = false;
                e.printStackTrace();
                Main.showError(e.getMessage(), "Error");
            }
        }
    }
}

