/*
 * Decompiled with CFR 0.152.
 */
package base.BBfile;

import base.BBfile.RPChromosomeRegion;
import base.BBfile.RPTreeChildNodeItem;
import base.BBfile.RPTreeNode;
import base.BBfile.RPTreeNodeItem;
import java.util.ArrayList;

public class RPTreeChildNode
implements RPTreeNode {
    private RPChromosomeRegion chromosomeBounds;
    private ArrayList<RPTreeChildNodeItem> childItems = new ArrayList();

    @Override
    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    @Override
    public int compareRegions(RPChromosomeRegion chromosomeRegion) {
        int value = this.chromosomeBounds.compareRegions(chromosomeRegion);
        return value;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getItemCount() {
        return this.childItems.size();
    }

    @Override
    public RPTreeNodeItem getItem(int index) {
        if (index < 0 || index >= this.childItems.size()) {
            return null;
        }
        RPTreeChildNodeItem item = this.childItems.get(index);
        return item;
    }

    @Override
    public boolean insertItem(RPTreeNodeItem item) {
        RPTreeChildNodeItem newItem = (RPTreeChildNodeItem)item;
        this.childItems.add(newItem);
        this.chromosomeBounds = this.chromosomeBounds == null ? new RPChromosomeRegion(newItem.getChromosomeBounds()) : this.chromosomeBounds.getExtremes(newItem.getChromosomeBounds());
        return true;
    }

    @Override
    public boolean deleteItem(int index) {
        int itemCount = this.getItemCount();
        if (index < 0 || index >= itemCount) {
            return false;
        }
        this.childItems.remove(index);
        return true;
    }

    @Override
    public void printItems() {
        int item = 0;
        while (item < this.childItems.size()) {
            this.childItems.get(item).print();
            ++item;
        }
    }
}

